/*
 * Decompiled with CFR 0.152.
 */
package com.sas.storage.olap.export;

import com.sas.codepolicy.SASScope;
import com.sas.storage.jdbc.export.RelationalExportInterface;
import com.sas.storage.olap.AxisInterface;
import com.sas.storage.olap.OLAPException;
import com.sas.storage.olap.OLAPUtil;
import com.sas.storage.olap.ResultSetInterface;
import com.sas.storage.olap.ResultSetMetadataInterface;
import com.sas.storage.olap.TupleElementInterface;
import com.sas.storage.olap.TupleElementType;
import com.sas.storage.olap.TupleInterface;
import com.sas.storage.olap.export.Util;
import com.sas.util.UncheckedException;
import com.sas.util.transforms.ObjectToStringTransform;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.Locale;

@SASScope(value="ALL")
public class OLAPExporter {
    private static String line = null;
    private static AxisInterface columnAxis = null;
    private static AxisInterface rowAxis = null;
    private static AxisInterface chaptersAxis = null;
    private static AxisInterface pagesAxis = null;
    private static AxisInterface sectionsAxis = null;
    private static AxisInterface slicersAxis = null;
    private static int startRow = 0;
    private static int nRows = -1;
    private static boolean isRawData = false;
    private static boolean repeatLabels = true;
    private static String[] levelUniqueNamesForRows;
    private static String[] lastNonBlankRowLabels;
    private static String[] currentFullRowLabels;

    public static void writeToStream(ResultSetInterface model, OutputStream stream, RelationalExportInterface exporter) {
        OLAPExporter.writeToStream(model, stream, exporter, startRow, nRows, isRawData, repeatLabels);
    }

    public static void writeToStream(ResultSetInterface model, Writer writer, RelationalExportInterface exporter) {
        OLAPExporter.writeToStream(model, writer, exporter, startRow, nRows, isRawData, repeatLabels);
    }

    public static void writeToStream(ResultSetInterface model, OutputStream stream, RelationalExportInterface exporter, int startRow, int nRows, boolean isRawData, boolean repeatLabels) {
        OLAPExporter.writeToStream(model, new PrintWriter(stream, true), exporter, startRow, nRows, isRawData, repeatLabels);
    }

    public static void writeToStream(ResultSetInterface model, Writer writer, RelationalExportInterface exporter, int startRow, int nRows, boolean isRawData, boolean repeatLabels) {
        OLAPExporter.writeToStream(model, writer, exporter, startRow, nRows, isRawData, repeatLabels, null);
    }

    public static void writeToStream(ResultSetInterface model, Writer writer, RelationalExportInterface exporter, int startRow, int nRows, boolean isRawData, boolean repeatLabels, Locale locale) {
        OLAPExporter.writeToStream(model, writer, exporter, startRow, nRows, isRawData, repeatLabels, locale, null, null);
    }

    public static void writeToStream(ResultSetInterface model, Writer writer, RelationalExportInterface exporter, int startRow, int nRows, boolean isRawData, boolean repeatLabels, Locale locale, String[] headers, String[] footers) {
        try {
            writer.write(exporter.getFileHeader());
            if (headers != null) {
                for (int i = 0; i < headers.length; ++i) {
                    writer.write(exporter.getLine(headers[i], null));
                }
            }
            ResultSetMetadataInterface metadata = null;
            AxisInterface[] axis = null;
            try {
                metadata = model.getResultSetMetadata();
                axis = metadata.getAxes(0, -1);
            }
            catch (OLAPException oLAPException) {
                // empty catch block
            }
            OLAPExporter.writeColumnHeaders(axis, writer, exporter, repeatLabels);
            OLAPExporter.writeRows(metadata, model, writer, exporter, startRow, nRows, isRawData, repeatLabels, locale);
            OLAPExporter.resetAxisVars();
            if (footers != null) {
                for (int i = 0; i < footers.length; ++i) {
                    writer.write(exporter.getLine(footers[i], null));
                }
            }
            writer.write(exporter.getFileTrailer());
            writer.flush();
        }
        catch (Exception e) {
            throw new UncheckedException((Throwable)e, null);
        }
    }

    private static void writeColumnHeaders(AxisInterface[] axis, Writer writer, RelationalExportInterface exporter, boolean repeatLabels) {
        OLAPExporter.getAxis(axis);
        int rowDepth = 0;
        int nColumnsInAcross = 0;
        if (columnAxis != null && rowAxis == null) {
            try {
                nColumnsInAcross = columnAxis.getTupleCount();
            }
            catch (OLAPException oLAPException) {
                // empty catch block
            }
            rowDepth = 1;
            int nColumns = rowDepth + nColumnsInAcross;
            Object[] rowValues = new Object[nColumns];
            String[] headers = null;
            OLAPExporter.writeColumnAxisHeaders(nColumns, rowDepth, nColumnsInAcross, rowValues, headers, writer, exporter, repeatLabels);
        } else if (columnAxis != null && rowAxis != null) {
            int w;
            try {
                rowDepth = rowAxis.getAxisHeaders().length;
                nColumnsInAcross = columnAxis.getTupleCount();
            }
            catch (OLAPException nColumns) {
                // empty catch block
            }
            int nColumns = rowDepth + nColumnsInAcross;
            Object[] rowValues = new Object[nColumns];
            String[] headers = null;
            OLAPExporter.writeColumnAxisHeaders(nColumns, rowDepth, nColumnsInAcross, rowValues, headers, writer, exporter, repeatLabels);
            try {
                headers = rowAxis.getAxisHeaders();
            }
            catch (OLAPException oLAPException) {
                // empty catch block
            }
            for (w = 0; w < rowDepth && w < headers.length; ++w) {
                rowValues[w] = headers[w];
            }
            for (w = rowDepth; w < nColumns; ++w) {
                rowValues[w] = "";
            }
            int measureElementIndex = Util.INVALID_MEASURE_ELEMENT_INDEX;
            try {
                measureElementIndex = Util.getMeasureElementIndex(rowAxis.getTuple(0).getElements(0, -1));
            }
            catch (OLAPException e) {
                throw new UncheckedException((Throwable)e, null);
            }
            if (measureElementIndex != Util.INVALID_MEASURE_ELEMENT_INDEX) {
                rowValues[measureElementIndex] = "";
            }
            line = exporter.getColumnHeaderLine(rowValues);
            try {
                writer.write(line);
            }
            catch (Exception e) {
                throw new UncheckedException((Throwable)e, null);
            }
        }
    }

    private static void writeColumnAxisHeaders(int nColumns, int rowDepth, int nColumnsInAcross, Object[] rowValues, String[] headers, Writer writer, RelationalExportInterface exporter, boolean repeatLabels) {
        int axis0Depth = 0;
        TupleInterface[] tuples = null;
        String[] uniqueLevelNames = null;
        int measureElementIndex = Util.INVALID_MEASURE_ELEMENT_INDEX;
        try {
            headers = columnAxis.getAxisHeaders();
            axis0Depth = columnAxis.getAxisHeaders().length;
            tuples = columnAxis.getTuples(0, -1);
            uniqueLevelNames = columnAxis.getUniqueLevelNames();
            measureElementIndex = Util.getMeasureElementIndex(columnAxis.getTuple(0).getElements(0, -1));
        }
        catch (OLAPException oLAPException) {
            // empty catch block
        }
        for (int i = 0; i < axis0Depth && i < headers.length; ++i) {
            int columnCounter = 0;
            int q = 0;
            while (q < rowDepth) {
                rowValues[columnCounter] = q + 1 < rowDepth || i == measureElementIndex ? "" : headers[i];
                ++q;
                ++columnCounter;
            }
            TupleElementInterface[] elements = null;
            Object prevTupleElements = null;
            boolean span = false;
            boolean spanDepth = false;
            TupleElementType tupleElementType = null;
            int q2 = 0;
            while (q2 < nColumnsInAcross) {
                try {
                    elements = tuples[q2].getElements(0, -1);
                    boolean found = false;
                    for (int j = 0; j < elements.length; ++j) {
                        tupleElementType = elements[j].getType();
                        if (!uniqueLevelNames[i].equals(elements[j].getUniqueLevelName()) && (tupleElementType != TupleElementType.TOTAL || i != 0) && (tupleElementType != TupleElementType.SUBTOTAL || i != 0)) continue;
                        String label = elements[j].getLabel();
                        if (label != null) {
                            label = label.trim();
                        }
                        if (!repeatLabels) {
                            if (elements[j].getMinimumCoordinate() == q2) {
                                rowValues[columnCounter] = label;
                            }
                        } else {
                            rowValues[columnCounter] = label;
                        }
                        found = true;
                        break;
                    }
                    if (!found) {
                        rowValues[columnCounter] = "";
                    }
                }
                catch (OLAPException oLAPException) {
                    // empty catch block
                }
                ++q2;
                ++columnCounter;
            }
            line = exporter.getColumnHeaderLine(rowValues);
            try {
                writer.write(line);
                continue;
            }
            catch (Exception e) {
                throw new UncheckedException((Throwable)e, null);
            }
        }
    }

    private static void writeRows(ResultSetMetadataInterface metadata, ResultSetInterface model, Writer writer, RelationalExportInterface exporter, int startRow, int nRows, boolean isRawData, boolean repeatLabels, Locale locale) {
        AxisInterface[] axis = null;
        try {
            axis = metadata.getAxes(0, -1);
        }
        catch (OLAPException oLAPException) {
            // empty catch block
        }
        OLAPExporter.getAxis(axis);
        TupleInterface[] tuples = null;
        int rowDepth = 0;
        int nColumnsInAcross = 0;
        if (columnAxis != null && rowAxis == null) {
            try {
                rowDepth = 1;
                nColumnsInAcross = columnAxis.getTupleCount();
            }
            catch (OLAPException oLAPException) {
                // empty catch block
            }
            int nColumns = rowDepth + nColumnsInAcross;
            Object[] rowValues = new Object[nColumns];
            OLAPExporter.writeRow(metadata, model, writer, exporter, 0, nColumnsInAcross, rowValues, isRawData, locale);
        } else if (columnAxis != null && rowAxis != null) {
            try {
                rowDepth = rowAxis.getAxisHeaders().length;
                nColumnsInAcross = columnAxis.getTupleCount();
            }
            catch (OLAPException nColumns) {
                // empty catch block
            }
            int nColumns = rowDepth + nColumnsInAcross;
            Object[] rowValues = new Object[nColumns];
            try {
                tuples = rowAxis.getTuples(0, -1);
            }
            catch (OLAPException oLAPException) {
                // empty catch block
            }
            int[] boundaries = OLAPExporter.getBoundaries(startRow, nRows, tuples.length);
            OLAPExporter.createLevelUniqueNamesList(rowDepth, tuples);
            for (int i = boundaries[0]; i <= boundaries[1]; ++i) {
                OLAPExporter.writeRow(metadata, model, writer, exporter, i, rowDepth, nColumnsInAcross, tuples, rowValues, isRawData, repeatLabels, locale);
            }
        }
    }

    private static void writeRow(ResultSetMetadataInterface metadata, ResultSetInterface model, Writer writer, RelationalExportInterface exporter, int i, int nColumnsInAcross, Object[] rowValues, boolean isRawData, Locale locale) {
        int columnCounter = 0;
        rowValues[0] = "";
        ++columnCounter;
        long cellOrdinal = 0L;
        int[] tupleCoordinates = new int[3];
        int w = 0;
        while (w < nColumnsInAcross) {
            OLAPExporter.getDataCellValues(metadata, model, tupleCoordinates, cellOrdinal, w, i, columnCounter, rowValues, isRawData, locale);
            ++w;
            ++columnCounter;
        }
        line = exporter.getColumnHeaderLine(rowValues);
        try {
            writer.write(line);
        }
        catch (Exception e) {
            throw new UncheckedException((Throwable)e, null);
        }
    }

    private static void writeRow(ResultSetMetadataInterface metadata, ResultSetInterface model, Writer writer, RelationalExportInterface exporter, int i, int rowDepth, int nColumnsInAcross, TupleInterface[] tuples, Object[] rowValues, boolean isRawData, boolean repeatLabels, Locale locale) {
        TupleElementInterface[] elements = null;
        try {
            elements = tuples[i].getElements(0, -1);
        }
        catch (OLAPException oLAPException) {
            // empty catch block
        }
        int columnCounter = 0;
        int q = 0;
        while (q < rowDepth) {
            rowValues[columnCounter] = OLAPExporter.getRowLabelForColumn(elements, q, repeatLabels);
            ++q;
            ++columnCounter;
        }
        long cellOrdinal = 0L;
        int[] tupleCoordinates = new int[3];
        int w = 0;
        while (w < nColumnsInAcross) {
            OLAPExporter.getDataCellValues(metadata, model, tupleCoordinates, cellOrdinal, w, i, columnCounter, rowValues, isRawData, locale);
            ++w;
            ++columnCounter;
        }
        line = exporter.getColumnHeaderLine(rowValues);
        try {
            writer.write(line);
        }
        catch (Exception e) {
            throw new UncheckedException((Throwable)e, null);
        }
    }

    private static void getDataCellValues(ResultSetMetadataInterface metadata, ResultSetInterface model, int[] tupleCoordinates, long cellOrdinal, int w, int i, int columnCounter, Object[] rowValues, boolean isRawData, Locale locale) {
        tupleCoordinates[0] = w;
        tupleCoordinates[1] = i;
        tupleCoordinates[2] = 0;
        try {
            cellOrdinal = OLAPUtil.calculateCellOrdinal(metadata, tupleCoordinates);
        }
        catch (OLAPException oLAPException) {
            // empty catch block
        }
        Object cell = null;
        if (isRawData) {
            try {
                ObjectToStringTransform objectTransform = null;
                objectTransform = locale != null ? new ObjectToStringTransform(locale) : ObjectToStringTransform.defaultInstance;
                cell = model.getCells(cellOrdinal, cellOrdinal)[0];
                rowValues[columnCounter] = objectTransform.transform(cell);
            }
            catch (OLAPException oLAPException) {}
        } else {
            try {
                rowValues[columnCounter] = cell = model.getFormattedCells(cellOrdinal, cellOrdinal)[0];
            }
            catch (OLAPException oLAPException) {
                // empty catch block
            }
        }
        cell = null;
        rowValues[columnCounter] = rowValues[columnCounter].toString().trim();
    }

    private static void createLevelUniqueNamesList(int rowDepth, TupleInterface[] tuples) {
        if (rowDepth > 0 && tuples != null) {
            try {
                levelUniqueNamesForRows = tuples[0].getAxis().getUniqueLevelNames();
            }
            catch (OLAPException oLAPException) {
                // empty catch block
            }
            lastNonBlankRowLabels = new String[rowDepth];
            currentFullRowLabels = new String[rowDepth];
            for (int i = 0; i < rowDepth; ++i) {
                OLAPExporter.currentFullRowLabels[i] = "";
                OLAPExporter.lastNonBlankRowLabels[i] = "";
            }
        }
    }

    private static String getRowLabelForColumn(TupleElementInterface[] elements, int q, boolean repeatLabels) {
        String rowLabel = "";
        if (elements != null && q >= 0) {
            int nElements = elements.length;
            String uniqueLevelName = null;
            TupleElementInterface tupleElement = null;
            for (int i = 0; i < nElements; ++i) {
                tupleElement = elements[i];
                uniqueLevelName = null;
                try {
                    uniqueLevelName = tupleElement.getUniqueLevelName();
                }
                catch (OLAPException oLAPException) {
                    // empty catch block
                }
                if (uniqueLevelName == null) continue;
                TupleElementType tupleElementType = null;
                try {
                    tupleElementType = tupleElement.getType();
                }
                catch (OLAPException e1) {
                    throw new UncheckedException((Throwable)e1, null);
                }
                if (!uniqueLevelName.equals(levelUniqueNamesForRows[q]) && (tupleElementType != TupleElementType.TOTAL || q != 0) && (tupleElementType != TupleElementType.SUBTOTAL || q != 0)) continue;
                rowLabel = "";
                try {
                    rowLabel = tupleElement.getLabel();
                    if (rowLabel == null) break;
                    rowLabel = rowLabel.trim();
                }
                catch (OLAPException oLAPException) {}
                break;
            }
            OLAPExporter.currentFullRowLabels[q] = rowLabel;
            if (!repeatLabels && !rowLabel.equalsIgnoreCase("") && OLAPExporter.isRepeatedRowLabel(rowLabel, q)) {
                rowLabel = "";
            }
            if (!rowLabel.equalsIgnoreCase("") && !OLAPExporter.isRepeatedRowLabel(rowLabel, q)) {
                OLAPExporter.updateLastNonBlankRowLabels(rowLabel, q);
            }
        }
        return rowLabel;
    }

    private static boolean isRepeatedRowLabel(String rowLabel, int q) {
        String lastNonBlankRowLabel;
        boolean isRepeatedRowLabel = false;
        if (rowLabel != null && q >= 0 && (lastNonBlankRowLabel = lastNonBlankRowLabels[q]) != null && lastNonBlankRowLabel.equals(rowLabel)) {
            isRepeatedRowLabel = true;
            for (int i = q - 1; i >= 0; --i) {
                if (lastNonBlankRowLabels[i].equals(currentFullRowLabels[i])) continue;
                isRepeatedRowLabel = false;
                break;
            }
        }
        return isRepeatedRowLabel;
    }

    private static void updateLastNonBlankRowLabels(String rowLabel, int q) {
        int nLabels;
        if (rowLabel != null && q >= 0 && q < (nLabels = lastNonBlankRowLabels.length)) {
            OLAPExporter.lastNonBlankRowLabels[q] = rowLabel;
            for (int i = q + 1; i < nLabels; ++i) {
                OLAPExporter.lastNonBlankRowLabels[i] = "";
            }
        }
    }

    private static int[] getBoundaries(int startRow, int nRows, int nTuples) {
        int first = startRow > 0 && startRow < nTuples ? startRow : 0;
        int last = nRows > 0 && first + nRows <= nTuples ? first + nRows - 1 : nTuples - 1;
        int[] boundaries = new int[]{first, last};
        return boundaries;
    }

    private static void getAxis(AxisInterface[] axis) {
        OLAPExporter.resetAxisVars();
        if (axis != null) {
            int nAxis = axis.length;
            try {
                block10: for (int a = 0; a < nAxis; ++a) {
                    switch (axis[a].getAxisNumber()) {
                        case 0: {
                            columnAxis = axis[a];
                            continue block10;
                        }
                        case 4: {
                            chaptersAxis = axis[a];
                            continue block10;
                        }
                        case 2: {
                            pagesAxis = axis[a];
                            continue block10;
                        }
                        case 1: {
                            rowAxis = axis[a];
                            continue block10;
                        }
                        case 3: {
                            sectionsAxis = axis[a];
                            continue block10;
                        }
                        case -1: {
                            slicersAxis = axis[a];
                        }
                    }
                }
            }
            catch (OLAPException oLAPException) {
                // empty catch block
            }
        }
    }

    private static void resetAxisVars() {
        columnAxis = null;
        rowAxis = null;
        chaptersAxis = null;
        pagesAxis = null;
        sectionsAxis = null;
        slicersAxis = null;
    }
}

