/*
 * Decompiled with CFR 0.152.
 */
package com.sas.storage.olap.embedded;

import com.sas.codepolicy.SASScope;
import com.sas.storage.olap.AxisInterface;
import com.sas.storage.olap.OLAPException;
import com.sas.storage.olap.TupleElementInterface;
import com.sas.storage.olap.TupleInterface;
import com.sas.storage.olap.embedded.Axis;
import com.sas.storage.olap.embedded.RB;
import com.sas.storage.olap.embedded.TupleElement;
import java.util.ArrayList;

@SASScope(value="ALL")
public class Tuple
implements TupleInterface {
    @SASScope
    public static final String RB_KEY = "Tuple.";
    private int tupleIndex;
    private AxisInterface axis;
    private ArrayList tupleElements = new ArrayList(3);
    private int elementCount;

    public Tuple() throws OLAPException {
        this(null);
    }

    public Tuple(TupleElementInterface[] tupleElements) throws OLAPException {
        int i;
        if (tupleElements != null) {
            for (i = 0; i < tupleElements.length; ++i) {
                this.addElement(-1, tupleElements[i]);
            }
        }
        this.tupleIndex = -1;
        this.elementCount = i;
    }

    @Override
    public int getTupleIndex() throws OLAPException {
        return this.tupleIndex;
    }

    @SASScope
    public int getTupleCoordinate() throws OLAPException {
        return this.getTupleIndex();
    }

    void setTupleIndex(int tupleOrdinal) throws OLAPException {
        this.tupleIndex = tupleOrdinal;
    }

    @Override
    public TupleElementInterface getElement(int index) throws OLAPException {
        if (index < 0 || index > this.elementCount) {
            throw new OLAPException(RB.getStringResource(RB_KEY, "invalidIndex.ex.txt"));
        }
        return (TupleElementInterface)this.tupleElements.get(index);
    }

    @Override
    public TupleElementInterface[] getElements(int index, int count) throws OLAPException {
        int endIndex;
        int n = endIndex = count == -1 ? this.elementCount : index + count;
        if (index < 0 || index > this.elementCount || endIndex < 0 || endIndex > this.elementCount) {
            throw new OLAPException(RB.getStringResource(RB_KEY, "invalidIndex.ex.txt"));
        }
        ArrayList values = index == 0 && endIndex == this.elementCount ? this.tupleElements : this.tupleElements.subList(index, endIndex);
        return values.toArray(new TupleElementInterface[values.size()]);
    }

    public void addElement(TupleElementInterface element) throws OLAPException {
        this.addElement(-1, element);
    }

    public void addElement(int index, TupleElementInterface element) throws OLAPException {
        if (index == -1) {
            index = this.elementCount;
        }
        if (index > this.elementCount || index < 0) {
            throw new OLAPException(RB.getStringResource(RB_KEY, "invalidIndex.ex.txt"));
        }
        this.tupleElements.add(index, element);
        ++this.elementCount;
        if (element instanceof TupleElement) {
            ((TupleElement)element).setTupleElementIndex(index);
            ((TupleElement)element).setTuple(this);
        }
        if (this.axis != null && this.axis instanceof Axis) {
            ((Axis)this.axis).calculateMinMaxCoordinates(null);
        }
    }

    public void setElements(int index, int endIndex, TupleElementInterface[] tupleElements) throws OLAPException {
        if (tupleElements == null || index < 0 || index > this.elementCount || endIndex < index || endIndex > this.elementCount) {
            throw new OLAPException(RB.getStringResource(RB_KEY, "invalidIndex.ex.txt"));
        }
        int i = index;
        for (int j = 0; j < tupleElements.length; ++j) {
            tupleElements[j].setMinimumCoordinate(((TupleElementInterface)this.tupleElements.get(i)).getMinimumCoordinate());
            tupleElements[j].setMaximumCoordinate(((TupleElementInterface)this.tupleElements.get(i)).getMaximumCoordinate());
            this.tupleElements.add(i, tupleElements[j]);
            if (tupleElements[j] instanceof TupleElement) {
                ((TupleElement)tupleElements[j]).setTuple(this);
            }
            ++i;
        }
        this.calculateTupleElementIndex();
    }

    public TupleElementInterface removeElement(int index) throws OLAPException {
        if (index == -1) {
            index = this.elementCount - 1;
        }
        if (index < 0 || index >= this.elementCount || this.tupleElements == null) {
            throw new OLAPException(RB.getStringResource(RB_KEY, "invalidIndex.ex.txt"));
        }
        TupleElement tupleElement = (TupleElement)this.tupleElements.remove(index);
        if (tupleElement != null) {
            --this.elementCount;
        }
        if (this.elementCount == 0) {
            ((Axis)this.axis).removeTuple(this.tupleIndex);
        } else {
            this.calculateTupleElementIndex();
        }
        if (this.axis != null) {
            ((Axis)this.axis).calculateMinMaxCoordinates(null);
        }
        return tupleElement;
    }

    private void calculateTupleElementIndex() throws OLAPException {
        int cnt = this.tupleElements.size();
        int i = 0;
        int j = cnt - 1;
        while (i < cnt) {
            ((TupleElement)this.tupleElements.get(i)).setTupleElementIndex(j);
            ++i;
            --j;
        }
    }

    @Override
    public AxisInterface getAxis() throws OLAPException {
        return this.axis;
    }

    public void setAxis(AxisInterface axis) throws OLAPException {
        this.axis = axis;
    }

    @Override
    public int getTupleDepth() throws OLAPException {
        return this.elementCount;
    }
}

