/*
 * Decompiled with CFR 0.152.
 */
package com.sas.storage.olap.embedded;

import com.sas.codepolicy.SASScope;
import com.sas.storage.olap.AxisInterface;
import com.sas.storage.olap.OLAPException;
import com.sas.storage.olap.OLAPUtil;
import com.sas.storage.olap.ResultSetInterface;
import com.sas.storage.olap.ResultSetMetadataInterface;
import com.sas.storage.olap.embedded.RB;
import com.sas.storage.olap.embedded.ResultSetMetadata;
import com.sas.util.Util;
import java.util.ArrayList;

@SASScope(value="ALL")
public class ResultSet
implements ResultSetInterface {
    @SASScope
    public static final String RB_KEY = "ResultSet.";
    private String mdxQuery;
    private ArrayList cellValues;
    private ResultSetMetadataInterface resultSetMetadata;

    public ResultSet() throws OLAPException {
        this(null);
    }

    public ResultSet(ResultSetMetadataInterface rsm) throws OLAPException {
        this.resultSetMetadata = rsm == null ? new ResultSetMetadata() : rsm;
        this.cellValues = new ArrayList(10);
    }

    @Override
    public final ResultSetMetadataInterface getResultSetMetadata() throws OLAPException {
        return this.resultSetMetadata;
    }

    @Override
    public final String getQueryStatement() throws OLAPException {
        return this.mdxQuery;
    }

    @Override
    public long getCellCount() throws OLAPException {
        AxisInterface[] axes = this.resultSetMetadata.getAxes(0, -1);
        int cellCount = 0;
        if (axes != null) {
            int axisNum = axes.length;
            if (((ResultSetMetadata)this.resultSetMetadata).getSlicerAxis() != null) {
                --axisNum;
            }
            if (axisNum > 0) {
                cellCount = axes[0].getTupleCount();
                for (int i = 1; i < axisNum; ++i) {
                    cellCount *= axes[i].getTupleCount();
                }
            }
        }
        return cellCount;
    }

    @Override
    public Object[] getCells(long startCell, long endCell) throws OLAPException {
        if (endCell == -1L) {
            endCell = this.getCellCount() - 1L;
        }
        if (startCell < 0L || endCell < 0L || startCell > endCell) {
            throw new IllegalArgumentException(RB.getStringResource(RB_KEY, "invalidOrdinal.ex.txt"));
        }
        long[] returnkeys = this.getCellOrdinals(startCell, endCell);
        for (int i = 0; i < returnkeys.length; ++i) {
            int size = this.cellValues.size();
            if (returnkeys[i] < (long)size) continue;
            int k = size;
            while ((long)k <= returnkeys[i]) {
                this.cellValues.add(k, ".");
                ++k;
            }
        }
        return this.cellValues.subList((int)startCell, (int)endCell + 1).toArray();
    }

    @Override
    public String[] getFormattedCells(long startCell, long endCell) throws OLAPException {
        Object[] cells = this.getCells(startCell, endCell);
        String[] formattedCells = new String[cells.length];
        for (int i = 0; i < cells.length; ++i) {
            formattedCells[i] = cells[i].toString();
        }
        return formattedCells;
    }

    @Override
    public boolean isReadOnly() throws OLAPException {
        return false;
    }

    public void setResultSetMetadata(ResultSetMetadataInterface rsm) throws OLAPException {
        if (Util.unequal((Object)this.resultSetMetadata, (Object)rsm)) {
            this.resultSetMetadata = rsm;
            if (rsm instanceof ResultSetMetadata) {
                ((ResultSetMetadata)rsm).setResultSet(this);
            }
        }
    }

    @Override
    public void setFormattedCells(long startCell, long endCell, String[] values) throws OLAPException {
        this.setCells(startCell, endCell, values);
    }

    @Override
    public void setCells(long startCell, long endCell, Object[] values) throws OLAPException {
        if (values != null && values.length > 0) {
            if (endCell < startCell) {
                endCell = values.length - 1;
            }
            if (startCell < 0L || endCell < 0L || startCell > endCell) {
                throw new IllegalArgumentException(RB.getStringResource(RB_KEY, "invalidOrdinal.ex.txt"));
            }
            int k = 0;
            long[] returnkeys = this.getCellOrdinals(startCell, endCell);
            for (int i = 0; i < returnkeys.length; ++i) {
                if (returnkeys[i] < (long)this.cellValues.size() && k < values.length) {
                    this.cellValues.set((int)returnkeys[i], values[k++]);
                    continue;
                }
                this.cellValues.add(values[k++]);
            }
        }
    }

    @SASScope
    public void addCells(long startCell, long endCell, Object[] values) throws OLAPException {
        this.setCells(startCell, endCell, values);
    }

    public void removeCells(long startCell, long endCell) throws OLAPException {
        if (this.cellValues == null || this.cellValues.size() == 0) {
            throw new IllegalArgumentException(RB.getStringResource(RB_KEY, "invalidOrdinal.ex.txt"));
        }
        if (endCell == -1L) {
            endCell = this.getCellCount() - 1L;
        }
        long[] returnkeys = this.getCellOrdinals(startCell, endCell);
        for (int i = 0; i < returnkeys.length; ++i) {
            this.cellValues.set(Long.valueOf(returnkeys[i]).intValue(), ".");
        }
    }

    @Override
    public void close() {
    }

    private long[] getCellOrdinals(long startCell, long endCell) throws OLAPException {
        if (this.resultSetMetadata == null) {
            return new long[0];
        }
        int startOrdinal = (int)startCell;
        int endOrdinal = (int)endCell;
        int[] startCoord = OLAPUtil.calculateTupleCoordinates(this.resultSetMetadata, startOrdinal);
        int[] endCoord = OLAPUtil.calculateTupleCoordinates(this.resultSetMetadata, endOrdinal);
        int[] currentCoordinates = new int[startCoord.length];
        int nCellsRequested = endOrdinal - startOrdinal + 1;
        for (int i = 1; i < startCoord.length; ++i) {
            if (i == 1) {
                nCellsRequested = 1;
            }
            nCellsRequested *= (endCoord[i] - startCoord[i] + 1) * (endCoord[i - 1] - startCoord[i - 1] + 1);
        }
        long[] returnkeys = new long[nCellsRequested];
        this.calculateOrdinals(startCoord.length - 1, startCoord, endCoord, currentCoordinates, returnkeys, 0);
        return returnkeys;
    }

    private int calculateOrdinals(int axisNumber, int[] startingCoordinates, int[] endingCoordinates, int[] currentCoordinates, long[] returnKeys, int index) throws OLAPException {
        for (int i = startingCoordinates[axisNumber]; i <= endingCoordinates[axisNumber]; ++i) {
            currentCoordinates[axisNumber] = i;
            if (axisNumber == 0) {
                if (index >= returnKeys.length) continue;
                returnKeys[index++] = OLAPUtil.calculateCellOrdinal(this.resultSetMetadata, currentCoordinates);
                continue;
            }
            index = this.calculateOrdinals(--axisNumber, startingCoordinates, endingCoordinates, currentCoordinates, returnKeys, index);
            ++axisNumber;
        }
        return index;
    }
}

