/*
 * Decompiled with CFR 0.152.
 */
package com.sas.storage.olap;

import com.sas.codepolicy.SASScope;
import com.sas.storage.olap.PerformanceTuning;
import com.sas.util.log.LoggerRepository2;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.BitSet;
import java.util.Properties;
import java.util.StringTokenizer;

@SASScope
public abstract class CacheProperties {
    protected static final int DEFAULT_CELL_PAGE_COUNT = 1;
    protected static final int DEFAULT_MAJOR_AXES_PAGE_COUNT = CacheProperties.propertyAsInt("DefaultMajorAxesPageCount", 100);
    protected static final int DEFAULT_OTHER_AXES_PAGE_COUNT = 1;
    protected static final int DEFAULT_CELL_BUFFERSIZE = CacheProperties.propertyAsInt("DefaultCellBufferSize", 400);
    protected static final int DEFAULT_COLUMNS_AXIS_BUFFERSIZE = CacheProperties.propertyAsInt("DefaultColumnsAxisBufferSize", 5000);
    protected static final int DEFAULT_ROWS_AXIS_BUFFERSIZE = CacheProperties.propertyAsInt("DefaultRowsAxisBufferSize", 12500);
    protected static final int DEFAULT_PAGES_AXIS_BUFFERSIZE = 125;
    protected static final int DEFAULT_SECTIONS_AXIS_BUFFERSIZE = 125;
    protected static final int DEFAULT_CHAPTERS_AXIS_BUFFERSIZE = 125;
    protected static final int DEFAULT_SLICERS_AXIS_BUFFERSIZE = 1;
    protected static final int DEFAULT_CELL_PAGESIZE = -1;
    protected static final int DEFAULT_ROWS_AXIS_PAGESIZE = CacheProperties.propertyAsInt("DefaultRowsAxisPageSize", 40);
    protected static final int DEFAULT_COLUMNS_AXIS_PAGESIZE = CacheProperties.propertyAsInt("DefaultColumnsAxisPageSize", 10);
    protected static final int DEFAULT_PAGES_AXIS_PAGESIZE = 25;
    protected static final int DEFAULT_SECTIONS_AXIS_PAGESIZE = 25;
    protected static final int DEFAULT_CHAPTERS_AXIS_PAGESIZE = 25;
    protected static final int DEFAULT_SLICERS_AXIS_PAGESIZE = 1;
    protected int bufferSize;
    protected int pageSize;
    protected int pageCount;
    protected boolean lookAheadEnabled;
    protected BitSet changeBits = new BitSet();
    protected static int BUFFER_SIZE_BIT = 0;
    protected static int PAGE_SIZE_BIT = 1;
    protected static int PAGE_COUNT_BIT = 2;
    protected static int LOOKAHEAD_BIT = 3;
    protected int cacheType;
    protected static Properties propertiesList;

    private static int propertyAsInt(String propertyName, int defaultValue) {
        int rval = defaultValue;
        try {
            String propertyValue;
            if (propertiesList == null) {
                propertiesList = CacheProperties.loadPropertyFile("PerformanceTuning.properties");
            }
            if ((propertyValue = propertiesList.getProperty(propertyName)) != null) {
                rval = Integer.parseInt(propertyValue);
            }
        }
        catch (RuntimeException runtimeException) {
            // empty catch block
        }
        return rval;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static synchronized Properties loadPropertyFile(String propertyKey) {
        propertiesList = new Properties();
        String propertyFileNames = System.getProperty(propertyKey);
        if (propertyFileNames != null) {
            StringTokenizer tokenizer = new StringTokenizer(propertyFileNames, ",");
            while (tokenizer.hasMoreTokens()) {
                String propertyFileName = tokenizer.nextToken();
                InputStream propertyFileStream = ClassLoader.getSystemClassLoader().getResourceAsStream(propertyFileName);
                try {
                    if (propertyFileStream == null) {
                        throw new Exception();
                    }
                    propertiesList.load(propertyFileStream);
                }
                catch (Exception e) {
                    FileInputStream filePropertyFileStream = null;
                    try {
                        filePropertyFileStream = new FileInputStream(propertyFileName);
                        propertiesList.load(filePropertyFileStream);
                    }
                    catch (IOException ioe) {
                        System.out.println("Error reading property file: " + propertyFileName);
                        System.out.println("   " + ioe);
                    }
                    finally {
                        try {
                            if (filePropertyFileStream == null) continue;
                            filePropertyFileStream.close();
                        }
                        catch (IOException ioe) {
                            LoggerRepository2.getLogger(CacheProperties.class.getPackage().getName(), null).error(ioe.getMessage(), (Throwable)ioe);
                        }
                    }
                }
                finally {
                    try {
                        if (propertyFileStream == null) continue;
                        propertyFileStream.close();
                    }
                    catch (IOException ioe) {
                        LoggerRepository2.getLogger(CacheProperties.class.getPackage().getName(), null).error(ioe.getMessage(), (Throwable)ioe);
                    }
                }
            }
        }
        return propertiesList;
    }

    CacheProperties() {
    }

    public boolean hasChanged() {
        return !this.changeBits.isEmpty();
    }

    public BitSet getChangeBits() {
        return this.changeBits;
    }

    public void setChangeBits(BitSet bits) {
        this.changeBits = bits;
    }

    public int getBufferSize() {
        return this.bufferSize;
    }

    public void setBufferSize(int bufferSize) {
        this.bufferSize = bufferSize;
        this.changeBits.set(BUFFER_SIZE_BIT);
    }

    public int getPageSize() {
        return this.pageSize;
    }

    public void setPageSize(int pageSize) {
        this.pageSize = pageSize;
        this.changeBits.set(PAGE_SIZE_BIT);
    }

    public int getPageCount() {
        return this.pageCount;
    }

    public void setPageCount(int pageCount) {
        this.pageCount = pageCount;
        this.changeBits.set(PAGE_COUNT_BIT);
    }

    public int getLookAhead() {
        int lookAhead = this.pageCount * this.pageSize;
        if (this.pageCount == PerformanceTuning.MAX_VALUE || this.pageSize == PerformanceTuning.MAX_VALUE) {
            lookAhead = PerformanceTuning.MAX_VALUE;
        } else if (lookAhead < 0) {
            lookAhead = 16;
        }
        return lookAhead;
    }

    public boolean isLookAheadEnabled() {
        return this.lookAheadEnabled;
    }

    public void setLookAheadEnabled(boolean lookAheadEnabled) {
        this.lookAheadEnabled = lookAheadEnabled;
        this.changeBits.set(LOOKAHEAD_BIT);
    }

    public void setCacheType(int type) {
        this.cacheType = type;
    }

    public int getCacheType() {
        return this.cacheType;
    }

    public Object clone() throws CloneNotSupportedException {
        CacheProperties clone = (CacheProperties)super.clone();
        clone.bufferSize = this.bufferSize;
        clone.lookAheadEnabled = this.lookAheadEnabled;
        clone.pageCount = this.pageCount;
        clone.pageSize = this.pageSize;
        clone.changeBits = this.changeBits;
        return clone;
    }
}

