/*
 * Decompiled with CFR 0.152.
 */
package com.sas.storage.jdbc.export;

import com.sas.MissingValues;
import com.sas.codepolicy.SASScope;
import com.sas.storage.jdbc.export.ExcelDirectives;
import com.sas.storage.jdbc.export.RB;
import com.sas.table.FormattedInterface;
import com.sas.text.ExcelFormat;
import com.sas.text.SASDateTimeFormat;
import com.sas.util.Strings;
import com.sas.util.log.CommonLoggerInterface;
import com.sas.util.log.LoggerRepository2;
import java.sql.Time;
import java.sql.Timestamp;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import javax.swing.table.TableModel;

@SASScope
public class SAStoExcelUtil {
    public static final String EXCEL_DEFAULT_NUMERIC_FORMAT = "General Number";
    public static final String EXCEL_DEFAULT_DATE_FORMAT = "General Date";
    public static final String EXCEL_DEFAULT_TIME_FORMAT = "General Time";
    public static final int DATA_TYPE_UNDEFINED = -1;
    public static final int DATA_TYPE_DATE = 0;
    public static final int DATA_TYPE_TIME = 1;
    public static final int DATA_TYPE_DATETIME = 2;
    public static final int DATA_TYPE_NUMERIC = 3;
    public static final String RB_KEY = "SAStoExcelUtil.";
    public static final String EXCEL_NAME_SPACE = "xmlns:x=\"urn:schemas-microsoft-com:office:excel\"";
    public static String EXCEL_XML_TEXT_DIRECTIVE = " x:str ";
    public static String EXCEL_XML_FORMATTING_NUMERIC_DIRECTIVE = " x:num";
    public static String EXCEL_TEXT_FORMAT = "\\@";
    protected static final String LOCALIZED_FORMAT = "LF";
    protected static final String NUMERIC_LOCALIZED_FORMAT = "NLF";
    protected static final String JAPANESE_LOCALIZED_FORMAT = "JLF";
    protected static final String JAPANESE_FORMAT = "JF";
    private static List<String> sasMissingValues = new ArrayList<String>();
    protected static final Locale DEFAULT_LOCALE;
    protected static final CommonLoggerInterface log;
    protected static Map<String, String> DateFormatsMapping;
    protected static Map<String, String> TimeFormatsMapping;
    protected static Map<String, String> DateTimeFormatsMapping;
    protected static Map<String, String> NumericFormatsMapping;
    public static String[] weekdayFormats;
    private static String[] formatsWithDecimalPart;
    private static String[] localizedDateTimeFormatsToRemap;
    public static Map<String, String> iso639toSASLanguageCodeMapping;
    public static final Map<String, String> temporarilyRemappedLocalizedFormats;

    public static String appendExcelCellFormattingDirectiveToCustomAttributes(int rowNumber, int colModelIndex, TableModel tm, String currentCustomAttributes, Locale locale) {
        Object rawValue = null;
        Class unformattedClass = null;
        String format = null;
        String excelCellFormattingDirective = null;
        StringBuffer attrs = new StringBuffer(20);
        if (tm instanceof FormattedInterface) {
            try {
                String excelFormat;
                rawValue = ((FormattedInterface)tm).getUnformattedValueAt(rowNumber - 1, colModelIndex - 1);
                unformattedClass = ((FormattedInterface)tm).getUnformattedColumnClass(colModelIndex - 1);
                format = ((FormattedInterface)tm).getFormat(colModelIndex - 1);
                int dataType = SAStoExcelUtil.getDataType(locale, unformattedClass, format);
                String string = excelFormat = ((FormattedInterface)tm).isFormattedDataUsed() ? null : SAStoExcelUtil.getDefaultExcelFormat(dataType);
                if (currentCustomAttributes != null && !currentCustomAttributes.trim().equals("")) {
                    attrs.append(currentCustomAttributes);
                }
                excelCellFormattingDirective = EXCEL_XML_TEXT_DIRECTIVE;
            }
            catch (Exception e) {
                excelCellFormattingDirective = SAStoExcelUtil.getMicrosoftOfficeNumberFormatXMLDirective(EXCEL_TEXT_FORMAT);
            }
        } else {
            excelCellFormattingDirective = SAStoExcelUtil.getMicrosoftOfficeNumberFormatXMLDirective(EXCEL_TEXT_FORMAT);
        }
        if (excelCellFormattingDirective != null) {
            attrs.append(excelCellFormattingDirective);
        }
        return attrs.toString();
    }

    public static String getDefaultExcelFormat(int dataType) {
        String excelFormat;
        switch (dataType) {
            case 0: 
            case 2: {
                excelFormat = EXCEL_DEFAULT_DATE_FORMAT;
                break;
            }
            case 1: {
                excelFormat = EXCEL_DEFAULT_TIME_FORMAT;
                break;
            }
            case 3: {
                excelFormat = EXCEL_DEFAULT_NUMERIC_FORMAT;
                break;
            }
            default: {
                excelFormat = EXCEL_TEXT_FORMAT;
            }
        }
        return excelFormat;
    }

    public static int getDataType(Locale locale, Class<?> unformattedClass, String format) {
        int dataType = -1;
        if (SAStoExcelUtil.isSASDate(unformattedClass, format, locale)) {
            dataType = 0;
        } else if (SAStoExcelUtil.isSASTime(unformattedClass, format, locale)) {
            dataType = 1;
        } else if (SAStoExcelUtil.isSASDateTime(unformattedClass, format, locale)) {
            dataType = 2;
        } else if (Number.class.isAssignableFrom(unformattedClass)) {
            dataType = 3;
        }
        return dataType;
    }

    public static String[] getFormatPieces(String sasFormatName, Locale locale) {
        String[] pieces = new String[]{"", "", ""};
        if (sasFormatName != null && !"".equals(sasFormatName.trim())) {
            String toSplit = "";
            int indexOfDot = sasFormatName.lastIndexOf(".");
            if (indexOfDot >= 0) {
                if (indexOfDot + 1 < sasFormatName.length()) {
                    pieces[2] = sasFormatName.substring(indexOfDot + 1);
                }
                if (indexOfDot > 0) {
                    toSplit = sasFormatName.substring(0, indexOfDot);
                }
                if (toSplit.length() > 0) {
                    char curChar;
                    int i;
                    StringBuffer buff = new StringBuffer();
                    for (i = toSplit.length() - 1; i >= 0 && Character.isDigit(curChar = toSplit.charAt(i)); --i) {
                        buff.append(curChar);
                    }
                    pieces[1] = buff.reverse().toString();
                    pieces[0] = sasFormatName.substring(0, i + 1);
                }
            } else if (log.isWarnEnabled() && !"BESTFIT".equalsIgnoreCase(sasFormatName.trim())) {
                log.warn(MessageFormat.format(RB.getStringResource(RB_KEY, "invalidSASFormatName.fmt.log", locale), sasFormatName));
            }
        }
        return pieces;
    }

    public static String getExcelDateFormat(String sasFormat, Locale locale) {
        String excelFormat = SAStoExcelUtil.getExcelFormat(sasFormat, DateFormatsMapping, EXCEL_DEFAULT_DATE_FORMAT, locale);
        if (log.isDebugEnabled()) {
            log.debug(MessageFormat.format(RB.getStringResource(RB_KEY, "mappingSASFormatToExcelFormat.fmt.log", locale), sasFormat, excelFormat));
        }
        return excelFormat;
    }

    public static String getExcelNumericFormat(String sasFormat, Locale locale) {
        String excelFormat = SAStoExcelUtil.getExcelFormat(sasFormat, NumericFormatsMapping, EXCEL_DEFAULT_NUMERIC_FORMAT, locale);
        if (log.isDebugEnabled()) {
            log.debug(MessageFormat.format(RB.getStringResource(RB_KEY, "mappingSASFormatToExcelFormat.fmt.log", locale), sasFormat, excelFormat));
        }
        return excelFormat;
    }

    public static String getExcelDateTimeFormat(String sasFormat, Locale locale) {
        String excelFormat = SAStoExcelUtil.getExcelFormat(sasFormat, DateTimeFormatsMapping, EXCEL_DEFAULT_DATE_FORMAT, locale);
        if (log.isDebugEnabled()) {
            log.debug(MessageFormat.format(RB.getStringResource(RB_KEY, "mappingSASFormatToExcelFormat.fmt.log", locale), sasFormat, excelFormat));
        }
        return excelFormat;
    }

    public static String getExcelTimeFormat(String sasFormat, Locale locale) {
        String excelFormat = SAStoExcelUtil.getExcelFormat(sasFormat, TimeFormatsMapping, EXCEL_DEFAULT_TIME_FORMAT, locale);
        if (log.isDebugEnabled()) {
            log.debug(MessageFormat.format(RB.getStringResource(RB_KEY, "mappingSASFormatToExcelFormat.fmt.log", locale), sasFormat, excelFormat));
        }
        return excelFormat;
    }

    private static String getExcelFormat(String sasFormat, Map<String, String> map, String defaultExcelFormat, Locale locale) {
        String excelFormat = defaultExcelFormat;
        if (map != null && sasFormat != null && !".".equals(sasFormat) && !"".equals(sasFormat.trim())) {
            int decimalSize;
            int size;
            String shortSASFormat;
            block52: {
                String[] pieces;
                block51: {
                    sasFormat = sasFormat.toUpperCase();
                    shortSASFormat = SAStoExcelUtil.getFormatPieces(sasFormat, locale)[0];
                    shortSASFormat = SAStoExcelUtil.remapLocalizedDateTimeFormat(shortSASFormat, locale);
                    if ("NLDATEYQ".equals(shortSASFormat = SAStoExcelUtil.temporarilyRemapLocalizedFormats(shortSASFormat))) {
                        shortSASFormat = "NLDATE";
                    }
                    size = -1;
                    decimalSize = -1;
                    pieces = SAStoExcelUtil.getFormatPieces(sasFormat, locale);
                    if (pieces[1] != null && !"".equals(pieces[1].trim())) {
                        try {
                            size = Integer.parseInt(pieces[1]);
                        }
                        catch (NumberFormatException e) {
                            if (!log.isWarnEnabled()) break block51;
                            log.warn(MessageFormat.format(RB.getStringResource(RB_KEY, "unparseableInteger.fmt.log", locale), pieces[1]));
                        }
                    }
                }
                if (pieces[2] != null && !"".equals(pieces[2].trim())) {
                    try {
                        decimalSize = Integer.parseInt(pieces[2]);
                    }
                    catch (NumberFormatException e) {
                        if (!log.isWarnEnabled()) break block52;
                        log.warn(MessageFormat.format(RB.getStringResource(RB_KEY, "unparseableInteger.fmt.log", locale), pieces[2]));
                    }
                }
            }
            if ("".equals(shortSASFormat) && EXCEL_DEFAULT_NUMERIC_FORMAT.equals(defaultExcelFormat) && size == -1) {
                return excelFormat;
            }
            if (map.containsKey(shortSASFormat)) {
                String decimals;
                excelFormat = map.get(shortSASFormat);
                if (LOCALIZED_FORMAT.equals(excelFormat)) {
                    if (locale == null) {
                        locale = DEFAULT_LOCALE;
                    }
                    excelFormat = ExcelFormat.getFormat((String)shortSASFormat, (Locale)locale);
                    try {
                        excelFormat = Strings.replace((String)excelFormat, (int)0, (int)-1, (String)"'", (String)"\"");
                    }
                    catch (Exception e) {
                        excelFormat = null;
                    }
                    if (excelFormat == null) {
                        excelFormat = defaultExcelFormat;
                    }
                } else if (NUMERIC_LOCALIZED_FORMAT.equals(excelFormat)) {
                    if (locale == null) {
                        locale = DEFAULT_LOCALE;
                    }
                    excelFormat = ExcelFormat.getNumeric((String)shortSASFormat, (Locale)locale);
                    try {
                        excelFormat = Strings.replace((String)excelFormat, (int)0, (int)-1, (String)"'", (String)"\"");
                    }
                    catch (Exception e) {
                        excelFormat = null;
                    }
                    if (excelFormat == null) {
                        excelFormat = defaultExcelFormat;
                    }
                } else if (JAPANESE_LOCALIZED_FORMAT.equals(excelFormat)) {
                    shortSASFormat = SAStoExcelUtil.getCorrespondentJapaneseNLformat(shortSASFormat);
                    excelFormat = ExcelFormat.getFormat((String)shortSASFormat, (Locale)Locale.JAPAN);
                    try {
                        excelFormat = Strings.replace((String)excelFormat, (int)0, (int)-1, (String)"'", (String)"\"");
                    }
                    catch (Exception e) {
                        excelFormat = null;
                    }
                    if (excelFormat == null) {
                        excelFormat = defaultExcelFormat;
                    }
                } else if (JAPANESE_FORMAT.equals(excelFormat)) {
                    excelFormat = ExcelFormat.getFormat((String)shortSASFormat, (Locale)Locale.JAPAN);
                    try {
                        excelFormat = Strings.replace((String)excelFormat, (int)0, (int)-1, (String)"'", (String)"\"");
                    }
                    catch (Exception e) {
                        excelFormat = null;
                    }
                    if (excelFormat == null) {
                        excelFormat = defaultExcelFormat;
                    }
                }
                if ("FRACT".equals(shortSASFormat) && size > 5) {
                    int len = size / 2;
                    String questionMarks = SAStoExcelUtil.getRepeatedPattern("?", len);
                    if (questionMarks != null) {
                        excelFormat = new StringBuffer("#\\\\ ").append(questionMarks).append("/").append(questionMarks).toString();
                    }
                } else if ("Z".equals(shortSASFormat)) {
                    if (decimalSize > 0) {
                        int len = size - decimalSize;
                        if (len < 0) {
                            len = 0;
                        }
                        String integerPart = SAStoExcelUtil.getRepeatedPattern("0", len);
                        String decimalPart = SAStoExcelUtil.getRepeatedPattern("0", decimalSize);
                        StringBuffer format = new StringBuffer(len + decimalSize + 1);
                        if (integerPart != null) {
                            format.append(integerPart);
                        }
                        format.append(".");
                        if (decimalPart != null) {
                            format.append(decimalPart);
                        }
                        excelFormat = format.toString();
                    } else if (size > 0) {
                        excelFormat = SAStoExcelUtil.getRepeatedPattern("0", size);
                    }
                } else if (excelFormat != null && excelFormat.endsWith("mmmm") && size > 0 && size < 4) {
                    excelFormat = excelFormat.replaceAll("mmmm", "mmm");
                } else if (excelFormat != null && excelFormat.endsWith("dddd") && size > 0 && size < 4) {
                    excelFormat = excelFormat.replaceAll("dddd", "ddd");
                } else if (Strings.indexOf((String)shortSASFormat, (String[])formatsWithDecimalPart) != -1 && decimalSize > 0 && (decimals = SAStoExcelUtil.getRepeatedPattern("0", decimalSize)) != null) {
                    String search = null;
                    if (excelFormat.indexOf("#0") != -1) {
                        search = "#0";
                    } else if (excelFormat.indexOf("0") != -1) {
                        search = "0";
                    }
                    if (search != null) {
                        excelFormat = excelFormat.replaceAll(search, new StringBuffer(search).append(".").append(decimals).toString());
                    }
                }
            }
        }
        return excelFormat;
    }

    public static String getRepeatedPattern(String pattern, int times) {
        String repeatedPattern = null;
        if (pattern != null && times > 0) {
            StringBuffer patterns = new StringBuffer(pattern.length() * times);
            for (int i = 0; i < times; ++i) {
                patterns.append(pattern);
            }
            repeatedPattern = patterns.toString();
        }
        return repeatedPattern;
    }

    private static String getExcelFormula(String sasFormatName, double excelValue) {
        String shortSASFormatName;
        String excelFormula = null;
        if (sasFormatName != null && !Double.isNaN(excelValue) && !"".equalsIgnoreCase(shortSASFormatName = SAStoExcelUtil.getFormatPieces(sasFormatName, DEFAULT_LOCALE)[0].toUpperCase()) && Strings.indexOf((String)shortSASFormatName, (String[])weekdayFormats) != -1) {
            StringBuilder sb = new StringBuilder("=WEEKDAY(").append(Double.toString(excelValue));
            if (shortSASFormatName.endsWith("DFDN")) {
                sb.append(",2");
            }
            sb.append(")");
            excelFormula = sb.toString();
        }
        return excelFormula;
    }

    public static ExcelDirectives getExcelXMLNumericFormattingDirective(Object rawValue, String sasFormatName, int dataType, Locale locale, String xFormat) {
        ExcelDirectives excelDirectives = new ExcelDirectives();
        if (rawValue != null && (dataType == 0 || dataType == 1 || dataType == 2 || dataType == 3)) {
            String excelFormula;
            String sasValueString = rawValue.toString().trim();
            String excelFormat = xFormat;
            String numDirective = null;
            boolean isMissing = false;
            isMissing = sasMissingValues.contains(sasValueString);
            double sasValue = Double.NaN;
            double excelValue = Double.NaN;
            boolean treatAsString = false;
            if (!isMissing) {
                if (dataType != 3) {
                    block20: {
                        try {
                            sasValue = Double.parseDouble(sasValueString);
                        }
                        catch (NumberFormatException e1) {
                            sasValue = SAStoExcelUtil.getSASDateTimeValue(rawValue, dataType);
                            if (sasValue != Double.NaN) break block20;
                            treatAsString = true;
                            if (sasValueString == null || "".equals(sasValueString.trim()) || !log.isWarnEnabled()) break block20;
                            log.warn(MessageFormat.format(RB.getStringResource(RB_KEY, "unparseableDouble.fmt.log", locale), sasValueString));
                        }
                    }
                    if (treatAsString) {
                        numDirective = SAStoExcelUtil.getExcelXMLFormattingDirectiveForNumberStoredAsText(sasValueString);
                        if (log.isInfoEnabled()) {
                            log.info(MessageFormat.format(RB.getStringResource(RB_KEY, "numberStoredAsText.fmt.log", locale), sasValueString));
                        }
                    } else {
                        excelValue = SAStoExcelUtil.getExcelValue(dataType, sasValue, locale);
                        numDirective = SAStoExcelUtil.getExcelXMLNumDirective(excelValue, sasFormatName);
                    }
                } else if (sasValueString != null) {
                    try {
                        sasValue = Double.parseDouble(sasValueString);
                        sasValueString = Double.toString(sasValue);
                    }
                    catch (NumberFormatException e1) {
                        treatAsString = true;
                    }
                    if ("NaN".equals(sasValueString.trim())) {
                        treatAsString = true;
                    }
                    if (treatAsString) {
                        excelFormat = EXCEL_TEXT_FORMAT;
                    } else {
                        numDirective = SAStoExcelUtil.getExcelXMLNumDirective(sasValueString);
                    }
                }
            }
            if (numDirective != null) {
                excelDirectives.getXmlDirectives().add(numDirective);
            }
            if (excelFormat == null && !isMissing) {
                excelFormat = SAStoExcelUtil.getExcelFormat(sasFormatName, dataType, locale);
            }
            if ((excelFormula = SAStoExcelUtil.getExcelFormula(sasFormatName, excelValue)) != null) {
                excelDirectives.getXmlDirectives().add(SAStoExcelUtil.getExcelFormulaXMLDirective(excelFormula));
            }
            if (excelFormat != null) {
                excelDirectives.setFormatDirective(SAStoExcelUtil.getMicrosoftOfficeNumberFormatXMLDirective(excelFormat));
            }
        } else {
            throw new IllegalArgumentException();
        }
        return excelDirectives;
    }

    public static String getExcelFormat(String sasFormatName, int dataType, Locale locale) {
        String excelFormat = null;
        switch (dataType) {
            case 3: {
                excelFormat = SAStoExcelUtil.getExcelNumericFormat(sasFormatName, locale);
                break;
            }
            case 1: {
                excelFormat = SAStoExcelUtil.getExcelTimeFormat(sasFormatName, locale);
                break;
            }
            case 0: {
                excelFormat = SAStoExcelUtil.getExcelDateFormat(sasFormatName, locale);
                break;
            }
            case 2: {
                excelFormat = SAStoExcelUtil.getExcelDateTimeFormat(sasFormatName, locale);
                break;
            }
        }
        return excelFormat;
    }

    public static double getExcelValue(int dataType, double sasValue, Locale locale) {
        double excelValue = Double.NaN;
        switch (dataType) {
            case 1: {
                excelValue = SAStoExcelUtil.getExcelTime(sasValue, locale);
                break;
            }
            case 2: {
                excelValue = SAStoExcelUtil.getExcelDateTime(sasValue, locale);
                break;
            }
            case 0: {
                excelValue = SAStoExcelUtil.getExcelDate(sasValue, locale);
                break;
            }
        }
        return excelValue;
    }

    public static double getSASDateTimeValue(Object rawValue, int dataType) {
        double sasValue = Double.NaN;
        if (rawValue instanceof Date) {
            switch (dataType) {
                case 1: {
                    sasValue = SASDateTimeFormat.javaDateToSASTime((long)((Date)rawValue).getTime());
                    break;
                }
                case 2: {
                    if (rawValue instanceof Timestamp) {
                        sasValue = SASDateTimeFormat.javaDateToSASDateTime((long)((Timestamp)rawValue).getTime());
                        break;
                    }
                    sasValue = SASDateTimeFormat.javaDateToSASDateTime((long)((Date)rawValue).getTime());
                    break;
                }
                case 0: {
                    sasValue = SASDateTimeFormat.javaDateToSASDate((long)((Date)rawValue).getTime());
                    break;
                }
            }
        }
        return sasValue;
    }

    public static ExcelDirectives getExcelXMLNumericFormattingDirective(Object rawValue, String sasFormatName, int dataType, Locale locale) {
        return SAStoExcelUtil.getExcelXMLNumericFormattingDirective(rawValue, sasFormatName, dataType, locale, null);
    }

    private static String getExcelXMLNumDirective(String excelValue) {
        String directive = null;
        if (excelValue != null) {
            directive = new StringBuffer(EXCEL_XML_FORMATTING_NUMERIC_DIRECTIVE).append("=\"").append(Strings.quoteForXML((String)excelValue)).append("\"").toString();
        }
        return directive;
    }

    private static String getExcelXMLNumDirective(double excelValue, String sasFormatName) {
        StringBuffer buffer = new StringBuffer(EXCEL_XML_FORMATTING_NUMERIC_DIRECTIVE);
        if (excelValue != Double.NaN && sasFormatName != null && Strings.indexOf((String)SAStoExcelUtil.getFormatPieces(sasFormatName, DEFAULT_LOCALE)[0].toUpperCase(), (String[])weekdayFormats) == -1) {
            buffer.append("=\"").append(excelValue).append("\"");
        }
        return buffer.toString();
    }

    public static String getMicrosoftOfficeNumberFormatXMLDirective(String excelFormat) {
        return excelFormat != null ? new StringBuffer("mso-number-format:'").append(Strings.quoteForXML((String)excelFormat)).append("'").toString() : "";
    }

    private static String getExcelFormulaXMLDirective(String excelFormula) {
        return excelFormula != null ? new StringBuffer(" x:fmla=\"").append(Strings.quoteForXML((String)excelFormula)).append("\"").toString() : "";
    }

    public static String getExcelXMLFormattingDirectiveForNumberStoredAsText(String dataCellValue) {
        String directives = null;
        if (dataCellValue != null) {
            directives = new StringBuffer(SAStoExcelUtil.getExcelXMLNumDirective(dataCellValue)).append(SAStoExcelUtil.getMicrosoftOfficeNumberFormatXMLDirective(EXCEL_TEXT_FORMAT)).toString();
        }
        return directives;
    }

    public static boolean isSASTime(Class<?> unformattedClass, String format, Locale locale) {
        return unformattedClass != null ? Time.class.isAssignableFrom(unformattedClass) || SAStoExcelUtil.isSASTimeFormat(format, locale) && (Date.class.isAssignableFrom(unformattedClass) || Double.class == unformattedClass) : false;
    }

    public static boolean isSASDateTime(Class<?> unformattedClass, String format, Locale locale) {
        return unformattedClass != null ? Timestamp.class.isAssignableFrom(unformattedClass) || SAStoExcelUtil.isSASDateTimeFormat(format, locale) && (Date.class.isAssignableFrom(unformattedClass) || Double.class == unformattedClass) : false;
    }

    public static boolean isSASDate(Class<?> unformattedClass, String format, Locale locale) {
        return unformattedClass != null ? (Double.class == unformattedClass || Date.class.isAssignableFrom(unformattedClass)) && SAStoExcelUtil.isSASDateFormat(format, locale) : false;
    }

    public static double getExcelDate(double sasDate, Locale locale) {
        double excelDate = sasDate + 21916.0;
        if (excelDate <= 60.0) {
            excelDate -= 1.0;
        } else {
            if (excelDate >= 767070.0) {
                excelDate += 1.0;
            }
            if (excelDate >= 2228040.0) {
                excelDate += 1.0;
            }
        }
        if (log.isDebugEnabled()) {
            log.debug(MessageFormat.format(RB.getStringResource(RB_KEY, "computingExcelDate.fmt.log", locale), sasDate, excelDate));
        }
        return excelDate;
    }

    public static double getExcelTime(double sasTime, Locale locale) {
        double excelValue = sasTime / 86400.0;
        if (log.isDebugEnabled()) {
            log.debug(MessageFormat.format(RB.getStringResource(RB_KEY, "computingExcelTime.fmt.log", locale), sasTime, excelValue));
        }
        return excelValue;
    }

    public static double getExcelDateTime(double sasDateTime, Locale locale) {
        double seconds = sasDateTime / 86400.0;
        double days = Math.floor(seconds);
        seconds -= days;
        days = SAStoExcelUtil.getExcelDate(days, locale);
        double excelValue = days + seconds;
        if (log.isDebugEnabled()) {
            log.debug(MessageFormat.format(RB.getStringResource(RB_KEY, "computingExcelDateTime.fmt.log", locale), sasDateTime, excelValue));
        }
        return excelValue;
    }

    public static boolean isSASDateFormat(String format, Locale locale) {
        if (format != null) {
            format = format.toUpperCase();
        }
        return DateFormatsMapping.containsKey(SAStoExcelUtil.getFormatPieces(format, locale)[0]);
    }

    public static boolean isSASTimeFormat(String format, Locale locale) {
        if (format != null) {
            format = format.toUpperCase();
        }
        return TimeFormatsMapping.containsKey(SAStoExcelUtil.getFormatPieces(format, locale)[0]);
    }

    public static boolean isSASDateTimeFormat(String format, Locale locale) {
        if (format != null) {
            format = format.toUpperCase();
        }
        return DateTimeFormatsMapping.containsKey(SAStoExcelUtil.getFormatPieces(format, locale)[0]);
    }

    public static String remapLocalizedDateTimeFormat(String shortSASFormat, Locale locale) {
        String remapped = shortSASFormat;
        if (shortSASFormat != null) {
            shortSASFormat = shortSASFormat.toUpperCase();
        }
        if (Strings.indexOf((String)shortSASFormat, (String[])localizedDateTimeFormatsToRemap) != -1 && locale != null) {
            String isoLanguage = locale.getLanguage();
            if (!iso639toSASLanguageCodeMapping.containsKey(isoLanguage)) {
                isoLanguage = "en";
            }
            if (shortSASFormat.startsWith("EUR") && !shortSASFormat.equals("EUR")) {
                String country;
                if (("fr".equals(isoLanguage) || "de".equals(isoLanguage)) && "CH".equals(country = locale.getCountry())) {
                    isoLanguage = isoLanguage + "-" + country;
                }
                remapped = iso639toSASLanguageCodeMapping.get(isoLanguage) + shortSASFormat.substring(3);
            }
        }
        return remapped;
    }

    public static String getCorrespondentJapaneseNLformat(String shortSASFormat) {
        String nlFormat = shortSASFormat;
        if (shortSASFormat != null && (shortSASFormat = shortSASFormat.toUpperCase()).startsWith("J")) {
            nlFormat = "NL" + shortSASFormat.substring(1);
        }
        return nlFormat;
    }

    public static String[] getMappedSASFormatNames(int dataType) {
        Vector<String> mappedSASFormatNames = new Vector<String>();
        switch (dataType) {
            case 0: {
                mappedSASFormatNames.addAll(DateFormatsMapping.keySet());
                break;
            }
            case 1: {
                mappedSASFormatNames.addAll(TimeFormatsMapping.keySet());
                break;
            }
            case 2: {
                mappedSASFormatNames.addAll(DateTimeFormatsMapping.keySet());
                break;
            }
            case 3: {
                mappedSASFormatNames.addAll(NumericFormatsMapping.keySet());
                break;
            }
            case -1: {
                mappedSASFormatNames.addAll(DateFormatsMapping.keySet());
                mappedSASFormatNames.addAll(TimeFormatsMapping.keySet());
                mappedSASFormatNames.addAll(DateTimeFormatsMapping.keySet());
                mappedSASFormatNames.addAll(NumericFormatsMapping.keySet());
            }
        }
        return mappedSASFormatNames.toArray(new String[0]);
    }

    public static boolean isNumericMissingValue(String value) {
        boolean isMissing = false;
        if (value != null) {
            MissingValues numericMissingValues = MissingValues.getNumericMissingValues(null);
            int count = 29;
            for (int i = 0; i < count; ++i) {
                if (!value.equals(MissingValues.toQueryString((MissingValues)MissingValues.get((int)i)))) continue;
                isMissing = true;
                break;
            }
        }
        return isMissing;
    }

    public static boolean isFormatSupported(String formatName, int dataType) {
        boolean formatSupported = false;
        if (formatName != null) {
            String[] pieces;
            Set<String> keys = null;
            switch (dataType) {
                case 0: {
                    keys = DateFormatsMapping.keySet();
                    break;
                }
                case 1: {
                    keys = TimeFormatsMapping.keySet();
                    break;
                }
                case 2: {
                    keys = DateTimeFormatsMapping.keySet();
                    break;
                }
                case 3: {
                    keys = NumericFormatsMapping.keySet();
                    break;
                }
            }
            if (keys != null && (pieces = SAStoExcelUtil.getFormatPieces(formatName.trim().toUpperCase(), Locale.US))[0] != null) {
                formatSupported = keys.contains(pieces[0]);
            }
        }
        return formatSupported;
    }

    public static String getFormattedValueAsExcelFormat(String formattedValue) {
        String formattedValueAsExcelFormat = null;
        if (formattedValue != null) {
            StringBuffer sb = new StringBuffer();
            int nChars = formattedValue.length();
            for (int i = 0; i < nChars; ++i) {
                sb.append('\\').append('\\').append(formattedValue.charAt(i));
            }
            formattedValueAsExcelFormat = sb.toString();
            char[] specialCharacters = new char[]{'\"', '\''};
            String[] replacementStrings = new String[]{"&quot;", "&rsquo;"};
            formattedValueAsExcelFormat = Strings.replace((String)formattedValueAsExcelFormat, (char[])specialCharacters, (String[])replacementStrings);
        }
        return formattedValueAsExcelFormat;
    }

    public static String temporarilyRemapLocalizedFormats(String shortSASFormat) {
        String remapped = shortSASFormat;
        if (temporarilyRemappedLocalizedFormats.containsKey(shortSASFormat)) {
            remapped = temporarilyRemappedLocalizedFormats.get(shortSASFormat);
        }
        return remapped;
    }

    static {
        sasMissingValues.add(".");
        sasMissingValues.add("Dot");
        DEFAULT_LOCALE = Locale.US;
        log = LoggerRepository2.getLogger(SAStoExcelUtil.class.getPackage().getName(), null);
        DateFormatsMapping = new HashMap<String, String>(30);
        DateFormatsMapping.put("AFRDFDD", "[$-436]dd.mm.yyyy");
        DateFormatsMapping.put("AFRDFDE", "[$-436]ddmmmyyyy");
        DateFormatsMapping.put("AFRDFDN", null);
        DateFormatsMapping.put("AFRDFDWN", "[$-436]dddd");
        DateFormatsMapping.put("AFRDFMN", "[$-436]mmmm");
        DateFormatsMapping.put("AFRDFMY", "[$-436]mmmyyyy");
        DateFormatsMapping.put("AFRDFWDX", "[$-436]dd mmmm yyyy");
        DateFormatsMapping.put("AFRDFWKX", "[$-436]dddd, dd mmmm yyyy");
        DateFormatsMapping.put("B8601DA", "[$-409]yyyymmdd");
        DateFormatsMapping.put("CATDFDD", "[$-403]dd/mm/yyyy");
        DateFormatsMapping.put("CATDFDE", "[$-403]ddmmmyyyy");
        DateFormatsMapping.put("CATDFDN", null);
        DateFormatsMapping.put("CATDFDWN", "[$-403]dddd");
        DateFormatsMapping.put("CATDFMN", "[$-403]mmmm");
        DateFormatsMapping.put("CATDFMY", "[$-403]mmmyyyy");
        DateFormatsMapping.put("CATDFWDX", "[$-403]dd mmmm yyyy");
        DateFormatsMapping.put("CATDFWKX", "[$-403]dddd, dd mmmm yyyy");
        DateFormatsMapping.put("CRODFDD", "[$-41a]dd.mm.yyyy");
        DateFormatsMapping.put("CRODFDE", "[$-41a]ddmmmyyyy");
        DateFormatsMapping.put("CRODFDN", null);
        DateFormatsMapping.put("CRODFDWN", "[$-41a]dddd");
        DateFormatsMapping.put("CRODFMN", "[$-41a]mmmm");
        DateFormatsMapping.put("CRODFMY", "[$-41a]mmmyyyy");
        DateFormatsMapping.put("CRODFWDX", "[$-41a]dd mmmm yyyy");
        DateFormatsMapping.put("CRODFWKX", "[$-41a]dddd, dd mmmm yyyy");
        DateFormatsMapping.put("CSYDFDD", "[$-405]dd/mm/yyyy");
        DateFormatsMapping.put("CSYDFDE", "[$-405]ddmmmyyyy");
        DateFormatsMapping.put("CSYDFDN", null);
        DateFormatsMapping.put("CSYDFDWN", "[$-405]dddd");
        DateFormatsMapping.put("CSYDFMN", "[$-405]mmmm");
        DateFormatsMapping.put("CSYDFMY", "[$-405]mmmyyyy");
        DateFormatsMapping.put("CSYDFWDX", "[$-405]dd mmmm yyyy");
        DateFormatsMapping.put("CSYDFWKX", "[$-405]dddd, dd mmmm yyyy");
        DateFormatsMapping.put("DANDFDD", "[$-406]dd.mm.yyyy");
        DateFormatsMapping.put("DANDFDE", "[$-406]ddmmmyyyy");
        DateFormatsMapping.put("DANDFDN", null);
        DateFormatsMapping.put("DANDFDWN", "[$-406]dddd");
        DateFormatsMapping.put("DANDFMN", "[$-406]mmmm");
        DateFormatsMapping.put("DANDFMY", "[$-406]mmmyyyy");
        DateFormatsMapping.put("DANDFWDX", "[$-406]dd mmmm yyyy");
        DateFormatsMapping.put("DANDFWKX", "[$-406]dddd, dd mmmm yyyy");
        DateFormatsMapping.put("DATE", "[$-409]ddmmmyyyy");
        DateFormatsMapping.put("DAY", "[$-409]dd");
        DateFormatsMapping.put("DDMMYY", "[$-409]dd/mm/yyyy");
        DateFormatsMapping.put("DDMMYYB", "[$-409]dd mm yyyy");
        DateFormatsMapping.put("DDMMYYC", "[$-409]dd:mm:yyyy");
        DateFormatsMapping.put("DDMMYYD", "[$-409]dd-mm-yyyy");
        DateFormatsMapping.put("DDMMYYN", "[$-409]ddmmyyyy");
        DateFormatsMapping.put("DDMMYYP", "[$-409]dd.mm.yyyy");
        DateFormatsMapping.put("DDMMYYS", "[$-409]dd/mm/yyyy");
        DateFormatsMapping.put("DESDFDD", "[$-807]dd.mm.yyyy");
        DateFormatsMapping.put("DESDFDE", "[$-807]ddmmmyyyy");
        DateFormatsMapping.put("DESDFDN", null);
        DateFormatsMapping.put("DESDFDWN", "[$-807]dddd");
        DateFormatsMapping.put("DESDFMN", "[$-807]mmmm");
        DateFormatsMapping.put("DESDFMY", "[$-807]mmmyyyy");
        DateFormatsMapping.put("DESDFWDX", "[$-807]dd mmmm yyyy");
        DateFormatsMapping.put("DESDFWKX", "[$-807]dddd, dd mmmm yyyy");
        DateFormatsMapping.put("DEUDFDD", "[$-407]dd.mm.yyyy");
        DateFormatsMapping.put("DEUDFDE", "[$-407]ddmmmyyyy");
        DateFormatsMapping.put("DEUDFDN", null);
        DateFormatsMapping.put("DEUDFDWN", "[$-407]dddd");
        DateFormatsMapping.put("DEUDFMN", "[$-407]mmmm");
        DateFormatsMapping.put("DEUDFMY", "[$-407]mmmyyyy");
        DateFormatsMapping.put("DEUDFWDX", "[$-407]dd mmmm yyyy");
        DateFormatsMapping.put("DEUDFWKX", "[$-407]dddd, dd mmmm yyyy");
        DateFormatsMapping.put("DOWNAME", "[$-409]dddd");
        DateFormatsMapping.put("E8601DA", "[$-409]yyyy-mm-dd");
        DateFormatsMapping.put("ENGDFDD", "[$-409]dd.mm.yyyy");
        DateFormatsMapping.put("ENGDFDE", "[$-409]ddmmmyyyy");
        DateFormatsMapping.put("ENGDFDN", null);
        DateFormatsMapping.put("ENGDFDWN", "[$-409]dddd");
        DateFormatsMapping.put("ENGDFMN", "[$-409]mmmm");
        DateFormatsMapping.put("ENGDFMY", "[$-409]mmmyyyy");
        DateFormatsMapping.put("ENGDFWDX", "[$-409]dd mmmm yyyy");
        DateFormatsMapping.put("ENGDFWKX", "[$-409]dddd, dd mmmm yyyy");
        DateFormatsMapping.put("ESPDFDD", "[$-c0a]dd.mm.yyyy");
        DateFormatsMapping.put("ESPDFDE", "[$-c0a]ddmmmyyyy");
        DateFormatsMapping.put("ESPDFDN", null);
        DateFormatsMapping.put("ESPDFDWN", "[$-c0a]dddd");
        DateFormatsMapping.put("ESPDFMN", "[$-c0a]dddd");
        DateFormatsMapping.put("ESPDFMY", "[$-c0a]mmmyyyy");
        DateFormatsMapping.put("ESPDFWDX", "[$-c0a]dd mmmm yyyy");
        DateFormatsMapping.put("ESPDFWKX", "[$-c0a]dddd, dd mmmm yyyy");
        DateFormatsMapping.put("EURDFDD", null);
        DateFormatsMapping.put("EURDFDE", null);
        DateFormatsMapping.put("EURDFDN", null);
        DateFormatsMapping.put("EURDFDWN", null);
        DateFormatsMapping.put("EURDFMN", null);
        DateFormatsMapping.put("EURDFMY", null);
        DateFormatsMapping.put("EURDFWDX", null);
        DateFormatsMapping.put("EURDFWKX", null);
        DateFormatsMapping.put("FINDFDD", "[$-40b]dd.mm.yyyy");
        DateFormatsMapping.put("FINDFDE", "[$-40b]ddmmmyyyy");
        DateFormatsMapping.put("FINDFDN", null);
        DateFormatsMapping.put("FINDFDWN", "[$-40b]dddd");
        DateFormatsMapping.put("FINDFMN", "[$-40b]mmmm");
        DateFormatsMapping.put("FINDFMY", "[$-40b]mmmyyyy");
        DateFormatsMapping.put("FINDFWDX", "[$-40b]dd mmmm yyyy");
        DateFormatsMapping.put("FINDFWKX", "[$-40b]dddd, dd mmmm yyyy");
        DateFormatsMapping.put("FRADFDD", "[$-40c]dd/mm/yyyy");
        DateFormatsMapping.put("FRADFDE", "[$-40c]ddmmmyyyy");
        DateFormatsMapping.put("FRADFDN", null);
        DateFormatsMapping.put("FRADFDWN", "[$-40c]dddd");
        DateFormatsMapping.put("FRADFMN", "[$-40c]mmmm");
        DateFormatsMapping.put("FRADFMY", "[$-40c]mmmyyyy");
        DateFormatsMapping.put("FRADFWDX", "[$-40c]dd mmmm yyyy");
        DateFormatsMapping.put("FRADFWKX", "[$-40c]dddd, dd mmmm yyyy");
        DateFormatsMapping.put("FRSDFDD", "[$-40c]dd/mm/yyyy");
        DateFormatsMapping.put("FRSDFDE", "[$-40c]ddmmmyyyy");
        DateFormatsMapping.put("FRSDFDN", null);
        DateFormatsMapping.put("FRSDFDWN", "[$-40c]dddd");
        DateFormatsMapping.put("FRSDFMN", "[$-40c]mmmm");
        DateFormatsMapping.put("FRSDFMY", "[$-40c]mmmyyyy");
        DateFormatsMapping.put("FRSDFWDX", "[$-40c]dd mmmm yyyy");
        DateFormatsMapping.put("FRSDFWKX", "[$-40c]dddd, dd mmmm yyyy");
        DateFormatsMapping.put("HDATE", "[$-40D]yyyy mmmm dd");
        DateFormatsMapping.put("HEBDATE", "[$-40D]yyyy mmmm dd");
        DateFormatsMapping.put("HUNDFDD", "[$-40e]dd.mm.yyyy");
        DateFormatsMapping.put("HUNDFDE", "[$-40e]ddmmmyyyy");
        DateFormatsMapping.put("HUNDFDN", null);
        DateFormatsMapping.put("HUNDFDWN", "[$-40e]dddd");
        DateFormatsMapping.put("HUNDFMN", "[$-40e]mmmm");
        DateFormatsMapping.put("HUNDFMY", "[$-40e]mmmyyyy");
        DateFormatsMapping.put("HUNDFWDX", "[$-40e]dd mmmm yyyy");
        DateFormatsMapping.put("HUNDFWKX", "[$-40e]dddd, dd mmmm yyyy");
        DateFormatsMapping.put("IS8601DA", "[$-409]yyyy-mm-dd");
        DateFormatsMapping.put("IS8601DN", "[$-409]yyyy-mm-dd");
        DateFormatsMapping.put("ITADFDD", "[$-410]dd/mm/yyyy");
        DateFormatsMapping.put("ITADFDE", "[$-410]ddmmmyyyy");
        DateFormatsMapping.put("ITADFDN", null);
        DateFormatsMapping.put("ITADFDWN", "[$-410]dddd");
        DateFormatsMapping.put("ITADFMN", "[$-410]mmmm");
        DateFormatsMapping.put("ITADFMY", "[$-410]mmmyyyy");
        DateFormatsMapping.put("ITADFWDX", "[$-410]dd mmmm yyyy");
        DateFormatsMapping.put("ITADFWKX", "[$-410]dddd, dd mmmm yyyy");
        DateFormatsMapping.put("JDATEMD", JAPANESE_LOCALIZED_FORMAT);
        DateFormatsMapping.put("JDATEMDW", JAPANESE_FORMAT);
        DateFormatsMapping.put("JDATEMNW", JAPANESE_FORMAT);
        DateFormatsMapping.put("JDATEMON", JAPANESE_FORMAT);
        DateFormatsMapping.put("JDATEQRW", JAPANESE_FORMAT);
        DateFormatsMapping.put("JDATEQTR", JAPANESE_FORMAT);
        DateFormatsMapping.put("JDATESEM", JAPANESE_FORMAT);
        DateFormatsMapping.put("JDATESMW", JAPANESE_FORMAT);
        DateFormatsMapping.put("JDATEWK", JAPANESE_FORMAT);
        DateFormatsMapping.put("JDATEYDW", JAPANESE_FORMAT);
        DateFormatsMapping.put("JDATEYM", JAPANESE_LOCALIZED_FORMAT);
        DateFormatsMapping.put("JDATEYMD", JAPANESE_FORMAT);
        DateFormatsMapping.put("JDATEYMW", JAPANESE_FORMAT);
        DateFormatsMapping.put("JNENGO", JAPANESE_FORMAT);
        DateFormatsMapping.put("JNENGOW", JAPANESE_FORMAT);
        DateFormatsMapping.put("JULDATE", "[$-409]m/d/yyyy");
        DateFormatsMapping.put("JULDAY", "[$-409]m/d/yyyy");
        DateFormatsMapping.put("JULIAN", "[$-409]m/d/yyyy");
        DateFormatsMapping.put("MACDFDD", "[$-42f]dd.mm.yyyy");
        DateFormatsMapping.put("MACDFDE", "[$-42f]ddmmmyyyy");
        DateFormatsMapping.put("MACDFDN", null);
        DateFormatsMapping.put("MACDFDWN", "[$-42f]dddd");
        DateFormatsMapping.put("MACDFMN", "[$-42f]mmmm");
        DateFormatsMapping.put("MACDFMY", "[$-42f]mmmyyyy");
        DateFormatsMapping.put("MACDFWDX", "[$-42f]dd mmmm yyyy");
        DateFormatsMapping.put("MACDFWKX", "[$-42f]dddd, dd mmmm yyyy");
        DateFormatsMapping.put("MINGUO", "[$-804]yyyy/mm/dd");
        DateFormatsMapping.put("MMDDYY", "[$-409]mm/dd/yyyy");
        DateFormatsMapping.put("MMDDYYB", "[$-409]mm dd yyyy");
        DateFormatsMapping.put("MMDDYYC", "[$-409]mm:dd:yyyy");
        DateFormatsMapping.put("MMDDYYD", "[$-409]mm-dd-yyyy");
        DateFormatsMapping.put("MMDDYYN", "[$-409]mmddyyyy");
        DateFormatsMapping.put("MMDDYYP", "[$-409]mm.dd.yyyy");
        DateFormatsMapping.put("MMDDYYS", "[$-409]mm/dd/yyyy");
        DateFormatsMapping.put("MMYY", "[$-409]mm yyyy");
        DateFormatsMapping.put("MMYYC", "[$-409]mm:yyyy");
        DateFormatsMapping.put("MMYYD", "[$-409]mm-yyyy");
        DateFormatsMapping.put("MMYYN", "[$-409]mmyyyy");
        DateFormatsMapping.put("MMYYP", "[$-409]mm.yyyy");
        DateFormatsMapping.put("MMYYS", "[$-409]mm/yyyy");
        DateFormatsMapping.put("MONNAME", "[$-409]mmmm");
        DateFormatsMapping.put("MONTH", "[$-409]m");
        DateFormatsMapping.put("MONYY", "[$-409]mmmyyyy");
        DateFormatsMapping.put("NENGO", "m/d/yyyy");
        DateFormatsMapping.put("NLDATE", LOCALIZED_FORMAT);
        DateFormatsMapping.put("NLDATEMD", LOCALIZED_FORMAT);
        DateFormatsMapping.put("NLDATEMN", LOCALIZED_FORMAT);
        DateFormatsMapping.put("NLDATEYM", LOCALIZED_FORMAT);
        DateFormatsMapping.put("NLDATEYQ", LOCALIZED_FORMAT);
        DateFormatsMapping.put("NLDATEYR", LOCALIZED_FORMAT);
        DateFormatsMapping.put("NLDATEYW", LOCALIZED_FORMAT);
        DateFormatsMapping.put("NLDATEW", LOCALIZED_FORMAT);
        DateFormatsMapping.put("NLDATEWN", LOCALIZED_FORMAT);
        DateFormatsMapping.put("NLDDFDD", "[$-413]dd-mm-yyyy");
        DateFormatsMapping.put("NLDDFDE", "[$-413]ddmmmyyyy");
        DateFormatsMapping.put("NLDDFDN", null);
        DateFormatsMapping.put("NLDDFDWN", "[$-413]dddd");
        DateFormatsMapping.put("NLDDFMN", "[$-413]mmmm");
        DateFormatsMapping.put("NLDDFMY", "[$-413]mmmyyyy");
        DateFormatsMapping.put("NLDDFWDX", "[$-413]dd mmmm yyyy");
        DateFormatsMapping.put("NLDDFWKX", "[$-413]dddd, dd mmmm yyyy");
        DateFormatsMapping.put("NORDFDD", "[$-414]dd.mm.yyyy");
        DateFormatsMapping.put("NORDFDE", "[$-414]ddmmmyyyy");
        DateFormatsMapping.put("NORDFDN", null);
        DateFormatsMapping.put("NORDFDWN", "[$-414]dddd");
        DateFormatsMapping.put("NORDFMN", "[$-414]mmmm");
        DateFormatsMapping.put("NORDFMY", "[$-414]mmmyyyy");
        DateFormatsMapping.put("NORDFWDX", "[$-414]dd mmmm yyyy");
        DateFormatsMapping.put("NORDFWKX", "[$-414]dddd, dd mmmm yyyy");
        DateFormatsMapping.put("PDJULG", "[$-409]yyyymmdd");
        DateFormatsMapping.put("PDJULI", "[$-409]yyyymmdd");
        DateFormatsMapping.put("POLDFDD", "[$-415]dd-mm-yyyy");
        DateFormatsMapping.put("POLDFDE", "[$-415]ddmmmyyyy");
        DateFormatsMapping.put("POLDFDN", null);
        DateFormatsMapping.put("POLDFDWN", "[$-415]dddd");
        DateFormatsMapping.put("POLDFMN", "[$-415]mmmm");
        DateFormatsMapping.put("POLDFMY", "[$-415]mmmyyyy");
        DateFormatsMapping.put("POLDFWDX", "[$-415]dd mmmm yyyy");
        DateFormatsMapping.put("POLDFWKX", "[$-415]dddd, dd mmmm yyyy");
        DateFormatsMapping.put("PTGDFDD", "[$-416]dd/mm/yyyy");
        DateFormatsMapping.put("PTGDFDE", "[$-416]ddmmmyyyy");
        DateFormatsMapping.put("PTGDFDN", null);
        DateFormatsMapping.put("PTGDFDWN", "[$-416]dddd");
        DateFormatsMapping.put("PTGDFMN", "[$-416]mmmm");
        DateFormatsMapping.put("PTGDFMY", "[$-416]mmmyyyy");
        DateFormatsMapping.put("PTGDFWDX", "[$-416]dd mmmm yyyy");
        DateFormatsMapping.put("PTGDFWKX", "[$-416]dddd, dd mmmm yyyy");
        DateFormatsMapping.put("QTR", "[$-409]m/d/yyyy");
        DateFormatsMapping.put("QTRR", "[$-409]m/d/yyyy");
        DateFormatsMapping.put("RSTDODB", "[$-409]d mmm yy");
        DateFormatsMapping.put("RSTDODS", "[$-409]mm/dd/yyyy");
        DateFormatsMapping.put("RSTDOMN", "[$-409]mmmyy");
        DateFormatsMapping.put("RSTDOMY", "[$-409]mmm yy");
        DateFormatsMapping.put("RUSDFDD", "[$-419]dd.mm.yyyy");
        DateFormatsMapping.put("RUSDFDE", "[$-419]ddmmmyyyy");
        DateFormatsMapping.put("RUSDFDN", null);
        DateFormatsMapping.put("RUSDFDWN", "[$-419]dddd");
        DateFormatsMapping.put("RUSDFMN", "[$-419]mmmm");
        DateFormatsMapping.put("RUSDFMY", "[$-419]mmmyyyy");
        DateFormatsMapping.put("RUSDFWDX", "[$-419]dd mmmm yyyy");
        DateFormatsMapping.put("RUSDFWKX", "[$-419]dddd, dd mmmm yyyy");
        DateFormatsMapping.put("SLODFDD", "[$-41b]dd.mm.yyyy");
        DateFormatsMapping.put("SLODFDE", "[$-41b]ddmmmyyyy");
        DateFormatsMapping.put("SLODFDN", null);
        DateFormatsMapping.put("SLODFDWN", "[$-41b]dddd");
        DateFormatsMapping.put("SLODFMN", "[$-41b]mmmm");
        DateFormatsMapping.put("SLODFMY", "[$-41b]mmmyyyy");
        DateFormatsMapping.put("SLODFWDX", "[$-41b]dd mmmm yyyy");
        DateFormatsMapping.put("SLODFWKX", "[$-41b]dddd, dd mmmm yyyy");
        DateFormatsMapping.put("SVEDFDD", "[$-41d]dd.mm.yyyy");
        DateFormatsMapping.put("SVEDFDE", "[$-41d]ddmmmyyyy");
        DateFormatsMapping.put("SVEDFDN", null);
        DateFormatsMapping.put("SVEDFDWN", "[$-41d]dddd");
        DateFormatsMapping.put("SVEDFMN", "[$-41d]mmmm");
        DateFormatsMapping.put("SVEDFMY", "[$-41d]mmmyyyy");
        DateFormatsMapping.put("SVEDFWDX", "[$-41d]dd mmmm yyyy");
        DateFormatsMapping.put("SVEDFWKX", "[$-41d]dddd, dd mmmm yyyy");
        DateFormatsMapping.put("WEEKDATE", "[$-409]dddd, mmmm dd, yyyy");
        DateFormatsMapping.put("WEEKDATX", "[$-409]dddd, dd mmmm yyyy");
        DateFormatsMapping.put("WEEKDAY", null);
        DateFormatsMapping.put("WEEKU", "[$-409]yyyy-mm-dd");
        DateFormatsMapping.put("WEEKV", "[$-409]yyyy-mm-dd");
        DateFormatsMapping.put("WEEKW", "[$-409]yyyy-mm-dd");
        DateFormatsMapping.put("WORDDATE", "[$-409]mmmm dd, yyyy");
        DateFormatsMapping.put("WORDDATX", "[$-409]dd mmmm yyyy");
        DateFormatsMapping.put("XYYMMDD", "[$-409]yyyy-mm-dd");
        DateFormatsMapping.put("YEAR", "[$-409]yyyy");
        DateFormatsMapping.put("YYMM", "[$-409]yyyy mm");
        DateFormatsMapping.put("YYMMC", "[$-409]yyyy:mm");
        DateFormatsMapping.put("YYMMD", "[$-409]yyyy-mm");
        DateFormatsMapping.put("YYMMN", "[$-409]yyyymm");
        DateFormatsMapping.put("YYMMP", "[$-409]yyyy.mm");
        DateFormatsMapping.put("YYMMS", "[$-409]yyyy/mm");
        DateFormatsMapping.put("YYMMDD", "[$-409]yyyy-mm-dd");
        DateFormatsMapping.put("YYMMDDB", "[$-409]yyyy mm dd");
        DateFormatsMapping.put("YYMMDDC", "[$-409]yyyy:mm:dd");
        DateFormatsMapping.put("YYMMDDD", "[$-409]yyyy-mm-dd");
        DateFormatsMapping.put("YYMMDDN", "[$-409]yyyymmdd");
        DateFormatsMapping.put("YYMMDDP", "[$-409]yyyy.mm.dd");
        DateFormatsMapping.put("YYMMDDS", "[$-409]yyyy/mm/dd");
        DateFormatsMapping.put("YYMON", "[$-409]yyyymmm");
        DateFormatsMapping.put("YYQ", "m/d/y");
        DateFormatsMapping.put("YYQC", "m/d/y");
        DateFormatsMapping.put("YYQD", "m/d/y");
        DateFormatsMapping.put("YYQN", "m/d/y");
        DateFormatsMapping.put("YYQP", "m/d/y");
        DateFormatsMapping.put("YYQR", "m/d/y");
        DateFormatsMapping.put("YYQRC", "m/d/y");
        DateFormatsMapping.put("YYQRD", "m/d/y");
        DateFormatsMapping.put("YYQRN", "m/d/y");
        DateFormatsMapping.put("YYQRP", "m/d/y");
        DateFormatsMapping.put("YYQRS", "m/d/y");
        DateFormatsMapping.put("YYQS", "m/d/y");
        DateFormatsMapping.put("YYQZ", "m/d/y");
        DateFormatsMapping.put("YYWEEKU", "[$-409]yyyy-mm-dd");
        DateFormatsMapping.put("YYWEEKV", "[$-409]yyyy-mm-dd");
        DateFormatsMapping.put("YYWEEKW", "[$-409]yyyy-mm-dd");
        TimeFormatsMapping = new HashMap<String, String>(20);
        TimeFormatsMapping.put("B8601LZ", "[$-409]hhmmss");
        TimeFormatsMapping.put("B8601TM", "[$-409]hhmmss.00");
        TimeFormatsMapping.put("B8601TZ", "[$-409]hhmmss");
        TimeFormatsMapping.put("E8601LZ", "[$-409]hh:mm:ss");
        TimeFormatsMapping.put("E8601TM", "[$-409]hh:mm:ss.00");
        TimeFormatsMapping.put("E8601TZ", "[$-409]hh:mm:ss");
        TimeFormatsMapping.put("HHMM", "[$-409][h]:mm");
        TimeFormatsMapping.put("HOUR", "[$-409]h:mm");
        TimeFormatsMapping.put("IS8601LZ", "[$-409]hh:mm:ss");
        TimeFormatsMapping.put("IS8601TM", "[$-409]hh:mm:ss");
        TimeFormatsMapping.put("IS8601TZ", "[$-409]hh:mm:ss");
        TimeFormatsMapping.put("JTIMEH", JAPANESE_FORMAT);
        TimeFormatsMapping.put("JTIMEHM", JAPANESE_FORMAT);
        TimeFormatsMapping.put("JTIMEHMS", JAPANESE_FORMAT);
        TimeFormatsMapping.put("JTIMEHW", JAPANESE_FORMAT);
        TimeFormatsMapping.put("JTIMEMW", JAPANESE_FORMAT);
        TimeFormatsMapping.put("JTIMESW", JAPANESE_FORMAT);
        TimeFormatsMapping.put("MMSS", "[$-409][mm]:ss");
        TimeFormatsMapping.put("NLDATMTZ", LOCALIZED_FORMAT);
        TimeFormatsMapping.put("TIME", "[h]:mm:ss");
        TimeFormatsMapping.put("TIMEAMPM", "h:mm:ss AM/PM");
        DateTimeFormatsMapping = new HashMap<String, String>(43);
        DateTimeFormatsMapping.put("AFRDFDT", "[$-436]ddmmmyyyy:h:mm:ss");
        DateTimeFormatsMapping.put("B8601DN", "[$-409]yyyymmdd");
        DateTimeFormatsMapping.put("B8601DT", "[$-409]yyyymmdd\\Thhmmss");
        DateTimeFormatsMapping.put("B8601DZ", "[$-409]yyyymmdd\\Thhmmss");
        DateTimeFormatsMapping.put("CATDFDT", "[$-403]ddmmmyyyy:h:mm:ss");
        DateTimeFormatsMapping.put("CRODFDT", "[$-41a]ddmmmyyyy:h:mm:ss");
        DateTimeFormatsMapping.put("CSYDFDT", "[$-405]ddmmmyyyy:h:mm:ss");
        DateTimeFormatsMapping.put("DANDFDT", "[$-406]ddmmmyyyy:h:mm:ss");
        DateTimeFormatsMapping.put("DATEAMPM", "[$-409]ddmmmyyyy:h:mm:ss AM/PM");
        DateTimeFormatsMapping.put("DATETIME", "[$-409]ddmmmyyyy h:mm:ss");
        DateTimeFormatsMapping.put("DESDFDT", "[$-807]ddmmmyyyy:h:mm:ss");
        DateTimeFormatsMapping.put("DEUDFDT", "[$-407]ddmmmyyyy:h:mm:ss");
        DateTimeFormatsMapping.put("DTDATE", "[$-409]ddmmmyyyy");
        DateTimeFormatsMapping.put("DTMONYY", "[$-409]mmmyyyy");
        DateTimeFormatsMapping.put("DTWKDATX", "[$-409]dddd, dd mmmm yyyy");
        DateTimeFormatsMapping.put("DTYEAR", "[$-409]yyyy");
        DateTimeFormatsMapping.put("DTYYQC", "[$-409]ddmmmyyyy");
        DateTimeFormatsMapping.put("E8601DN", "[$-409]yyyy-mm-dd");
        DateTimeFormatsMapping.put("E8601DT", "[$-409]yyyy-mm-dd\\Thh:mm:ss.00");
        DateTimeFormatsMapping.put("E8601DZ", "[$-409]yyyy-mm-dd\\Thh:mm:ss");
        DateTimeFormatsMapping.put("ENGDFDT", "[$-409]ddmmmyyyy:h:mm:ss");
        DateTimeFormatsMapping.put("ESPDFDT", "[$-c0a]ddmmmyyyy:h:mm:ss");
        DateTimeFormatsMapping.put("EURDFDT", null);
        DateTimeFormatsMapping.put("FINDFDT", "[$-40b]ddmmmyyyy:h:mm:ss");
        DateTimeFormatsMapping.put("FRADFDT", "[$-40c]ddmmmyyyy:h:mm:ss");
        DateTimeFormatsMapping.put("FRSDFDT", "[$-40c]ddmmmyyyy:h:mm:ss");
        DateTimeFormatsMapping.put("HUNDFDT", "[$-40e]ddmmmyyyy:h:mm:ss");
        DateTimeFormatsMapping.put("IS8601DT", "[$-409]yyyy-mm-dd\\\\Thh:mm:ss");
        DateTimeFormatsMapping.put("IS8601DZ", "[$-409]yyyy-mm-dd\\\\Thh:mm:ss");
        DateTimeFormatsMapping.put("ITADFDT", "[$-410]ddmmmyyyy:h:mm:ss");
        DateTimeFormatsMapping.put("JDATEYT", JAPANESE_FORMAT);
        DateTimeFormatsMapping.put("JDATEYTW", JAPANESE_FORMAT);
        DateTimeFormatsMapping.put("JNENGOT", JAPANESE_FORMAT);
        DateTimeFormatsMapping.put("JNENGOTW", JAPANESE_FORMAT);
        DateTimeFormatsMapping.put("MACDFDT", "[$-42f]ddmmmyyyy:h:mm:ss");
        DateTimeFormatsMapping.put("MDYAMPM", "[$-409]dd/mm/yyyy hh:mm AM/PM");
        DateTimeFormatsMapping.put("NLDATM", LOCALIZED_FORMAT);
        DateTimeFormatsMapping.put("NLDATMAP", LOCALIZED_FORMAT);
        DateTimeFormatsMapping.put("NLDATMDT", LOCALIZED_FORMAT);
        DateTimeFormatsMapping.put("NLDATMMD", LOCALIZED_FORMAT);
        DateTimeFormatsMapping.put("NLDATMMN", "mmmm");
        DateTimeFormatsMapping.put("NLDATMTM", LOCALIZED_FORMAT);
        DateTimeFormatsMapping.put("NLDATMYQ", null);
        DateTimeFormatsMapping.put("NLDATMYR", LOCALIZED_FORMAT);
        DateTimeFormatsMapping.put("NLDATMYW", null);
        DateTimeFormatsMapping.put("NLDATMW", LOCALIZED_FORMAT);
        DateTimeFormatsMapping.put("NLDATMWN", LOCALIZED_FORMAT);
        DateTimeFormatsMapping.put("NLDATMWZ", LOCALIZED_FORMAT);
        DateTimeFormatsMapping.put("NLDATMYM", LOCALIZED_FORMAT);
        DateTimeFormatsMapping.put("NLDATMZ", LOCALIZED_FORMAT);
        DateTimeFormatsMapping.put("NLDDFDT", "[$-413]ddmmmyyyy:h:mm:ss");
        DateTimeFormatsMapping.put("NLTIMAP", LOCALIZED_FORMAT);
        DateTimeFormatsMapping.put("NLTIME", LOCALIZED_FORMAT);
        DateTimeFormatsMapping.put("NORDFDT", "[$-414]ddmmmyyyy:h:mm:ss");
        DateTimeFormatsMapping.put("POLDFDT", "[$-415]ddmmmyyyy:h:mm:ss");
        DateTimeFormatsMapping.put("PTGDFDT", "[$-416]ddmmmyyyy:h:mm:ss");
        DateTimeFormatsMapping.put("RUSDFDT", "[$-419]ddmmmyyyy:h:mm:ss");
        DateTimeFormatsMapping.put("SLODFDT", "[$-41b]ddmmmyyyy:h:mm:ss");
        DateTimeFormatsMapping.put("SVEDFDT", "[$-41d]ddmmmyyyy:h:mm:ss");
        DateTimeFormatsMapping.put("TOD", "h:mm:ss");
        DateTimeFormatsMapping.put("TWMDY", "[$-409]h:mm dddd, mmmm dd, yyyy");
        NumericFormatsMapping = new HashMap<String, String>(40);
        NumericFormatsMapping.put("", "0");
        NumericFormatsMapping.put("BEST", EXCEL_DEFAULT_NUMERIC_FORMAT);
        NumericFormatsMapping.put("BESTD", EXCEL_DEFAULT_NUMERIC_FORMAT);
        NumericFormatsMapping.put("BESTX", EXCEL_DEFAULT_NUMERIC_FORMAT);
        NumericFormatsMapping.put("BINARY", EXCEL_DEFAULT_NUMERIC_FORMAT);
        NumericFormatsMapping.put("COMMA", "#,##0");
        NumericFormatsMapping.put("COMMAX", "#,##0");
        NumericFormatsMapping.put("D", EXCEL_DEFAULT_NUMERIC_FORMAT);
        NumericFormatsMapping.put("DOLLAR", "[$$-409]#,##0_);[$$-409]-#,##0");
        NumericFormatsMapping.put("DOLLARX", "[$$-409]#,##0_);[$$-409]-#,##0");
        NumericFormatsMapping.put("E", "0.00E+00");
        NumericFormatsMapping.put("EURFRATS", EXCEL_DEFAULT_NUMERIC_FORMAT);
        NumericFormatsMapping.put("EURFRBEF", EXCEL_DEFAULT_NUMERIC_FORMAT);
        NumericFormatsMapping.put("EURFRCHF", EXCEL_DEFAULT_NUMERIC_FORMAT);
        NumericFormatsMapping.put("EURFRCZK", EXCEL_DEFAULT_NUMERIC_FORMAT);
        NumericFormatsMapping.put("EURFRDEM", EXCEL_DEFAULT_NUMERIC_FORMAT);
        NumericFormatsMapping.put("EURFRDKK", EXCEL_DEFAULT_NUMERIC_FORMAT);
        NumericFormatsMapping.put("EURFRESP", EXCEL_DEFAULT_NUMERIC_FORMAT);
        NumericFormatsMapping.put("EURFRFIM", EXCEL_DEFAULT_NUMERIC_FORMAT);
        NumericFormatsMapping.put("EURFRFRF", EXCEL_DEFAULT_NUMERIC_FORMAT);
        NumericFormatsMapping.put("EURFRGBP", EXCEL_DEFAULT_NUMERIC_FORMAT);
        NumericFormatsMapping.put("EURFRGRD", EXCEL_DEFAULT_NUMERIC_FORMAT);
        NumericFormatsMapping.put("EURFRHUF", EXCEL_DEFAULT_NUMERIC_FORMAT);
        NumericFormatsMapping.put("EURFRIEP", EXCEL_DEFAULT_NUMERIC_FORMAT);
        NumericFormatsMapping.put("EURFRITL", EXCEL_DEFAULT_NUMERIC_FORMAT);
        NumericFormatsMapping.put("EURFRLUF", EXCEL_DEFAULT_NUMERIC_FORMAT);
        NumericFormatsMapping.put("EURFRNLG", EXCEL_DEFAULT_NUMERIC_FORMAT);
        NumericFormatsMapping.put("EURFRNOK", EXCEL_DEFAULT_NUMERIC_FORMAT);
        NumericFormatsMapping.put("EURFRPLZ", EXCEL_DEFAULT_NUMERIC_FORMAT);
        NumericFormatsMapping.put("EURFRPTE", EXCEL_DEFAULT_NUMERIC_FORMAT);
        NumericFormatsMapping.put("EURFRROL", EXCEL_DEFAULT_NUMERIC_FORMAT);
        NumericFormatsMapping.put("EURFRRUR", EXCEL_DEFAULT_NUMERIC_FORMAT);
        NumericFormatsMapping.put("EURFRSEK", EXCEL_DEFAULT_NUMERIC_FORMAT);
        NumericFormatsMapping.put("EURFRSIT", EXCEL_DEFAULT_NUMERIC_FORMAT);
        NumericFormatsMapping.put("EURFRTRL", EXCEL_DEFAULT_NUMERIC_FORMAT);
        NumericFormatsMapping.put("EURFRYUD", EXCEL_DEFAULT_NUMERIC_FORMAT);
        NumericFormatsMapping.put("EURO", "[$\u20ac-1]#,##0;[$\u20ac-1]-#,##0");
        NumericFormatsMapping.put("EUROX", "[$\u20ac-1]#,##0;[$\u20ac-1]-#,##0");
        NumericFormatsMapping.put("EURTOATS", EXCEL_DEFAULT_NUMERIC_FORMAT);
        NumericFormatsMapping.put("EURTOBEF", EXCEL_DEFAULT_NUMERIC_FORMAT);
        NumericFormatsMapping.put("EURTOCHF", EXCEL_DEFAULT_NUMERIC_FORMAT);
        NumericFormatsMapping.put("EURTOCZK", EXCEL_DEFAULT_NUMERIC_FORMAT);
        NumericFormatsMapping.put("EURTODEM", EXCEL_DEFAULT_NUMERIC_FORMAT);
        NumericFormatsMapping.put("EURTODKK", EXCEL_DEFAULT_NUMERIC_FORMAT);
        NumericFormatsMapping.put("EURTOESP", EXCEL_DEFAULT_NUMERIC_FORMAT);
        NumericFormatsMapping.put("EURTOFIM", EXCEL_DEFAULT_NUMERIC_FORMAT);
        NumericFormatsMapping.put("EURTOFRF", EXCEL_DEFAULT_NUMERIC_FORMAT);
        NumericFormatsMapping.put("EURTOGBP", EXCEL_DEFAULT_NUMERIC_FORMAT);
        NumericFormatsMapping.put("EURTOGRD", EXCEL_DEFAULT_NUMERIC_FORMAT);
        NumericFormatsMapping.put("EURTOHUF", EXCEL_DEFAULT_NUMERIC_FORMAT);
        NumericFormatsMapping.put("EURTOIEP", EXCEL_DEFAULT_NUMERIC_FORMAT);
        NumericFormatsMapping.put("EURTOITL", EXCEL_DEFAULT_NUMERIC_FORMAT);
        NumericFormatsMapping.put("EURTOLUF", EXCEL_DEFAULT_NUMERIC_FORMAT);
        NumericFormatsMapping.put("EURTONLG", EXCEL_DEFAULT_NUMERIC_FORMAT);
        NumericFormatsMapping.put("EURTONOK", EXCEL_DEFAULT_NUMERIC_FORMAT);
        NumericFormatsMapping.put("EURTOPLZ", EXCEL_DEFAULT_NUMERIC_FORMAT);
        NumericFormatsMapping.put("EURTOPTE", EXCEL_DEFAULT_NUMERIC_FORMAT);
        NumericFormatsMapping.put("EURTOROL", EXCEL_DEFAULT_NUMERIC_FORMAT);
        NumericFormatsMapping.put("EURTORUR", EXCEL_DEFAULT_NUMERIC_FORMAT);
        NumericFormatsMapping.put("EURTOSEK", EXCEL_DEFAULT_NUMERIC_FORMAT);
        NumericFormatsMapping.put("EURTOSIT", EXCEL_DEFAULT_NUMERIC_FORMAT);
        NumericFormatsMapping.put("EURTOTRL", EXCEL_DEFAULT_NUMERIC_FORMAT);
        NumericFormatsMapping.put("EURTOYUD", EXCEL_DEFAULT_NUMERIC_FORMAT);
        NumericFormatsMapping.put("F", "0");
        NumericFormatsMapping.put("FLOAT", EXCEL_DEFAULT_NUMERIC_FORMAT);
        NumericFormatsMapping.put("FRACT", "#\\\\ ??/??");
        NumericFormatsMapping.put("HEX", EXCEL_DEFAULT_NUMERIC_FORMAT);
        NumericFormatsMapping.put("IB", EXCEL_DEFAULT_NUMERIC_FORMAT);
        NumericFormatsMapping.put("IBR", EXCEL_DEFAULT_NUMERIC_FORMAT);
        NumericFormatsMapping.put("IEEE", EXCEL_DEFAULT_NUMERIC_FORMAT);
        NumericFormatsMapping.put("IEEER", EXCEL_DEFAULT_NUMERIC_FORMAT);
        NumericFormatsMapping.put("LOGPROB", EXCEL_DEFAULT_NUMERIC_FORMAT);
        NumericFormatsMapping.put("MRB", EXCEL_DEFAULT_NUMERIC_FORMAT);
        NumericFormatsMapping.put("NEGPAREN", "#,##0_);(#,##0)");
        NumericFormatsMapping.put("NLBEST", NUMERIC_LOCALIZED_FORMAT);
        NumericFormatsMapping.put("NLD", null);
        NumericFormatsMapping.put("NLMNIAED", "[$AED]#,##0.##_);([$AED]#,##0.##)");
        NumericFormatsMapping.put("NLMNIAUD", "[$AUD]#,##0.##_);([$AUD]#,##0.##)");
        NumericFormatsMapping.put("NLMNIBGN", "[$BGN]#,##0.##_);([$BGN]#,##0.##)");
        NumericFormatsMapping.put("NLMNIBRL", "[$BRL]#,##0.##_);([$BRL]#,##0.##)");
        NumericFormatsMapping.put("NLMNICAD", "[$CAD]#,##0.##_);([$CAD]#,##0.##)");
        NumericFormatsMapping.put("NLMNICHF", "[$CHF]#,##0.##_);([$CHF]#,##0.##)");
        NumericFormatsMapping.put("NLMNICNY", "[$CNY]#,##0.##_);([$CNY]#,##0.##)");
        NumericFormatsMapping.put("NLMNICZK", "[$CZK]#,##0.##_);([$CZK]#,##0.##)");
        NumericFormatsMapping.put("NLMNIDKK", "[$DKK]#,##0.##_);([$DKK]#,##0.##)");
        NumericFormatsMapping.put("NLMNIEEK", "[$EEK]#,##0.##_);([$EEK]#,##0.##)");
        NumericFormatsMapping.put("NLMNIEGP", "[$EGP]#,##0.##_);([$EGP]#,##0.##)");
        NumericFormatsMapping.put("NLMNIEUR", "[$EUR]#,##0.##_);([$EUR]#,##0.##)");
        NumericFormatsMapping.put("NLMNIGBP", "[$GBP]#,##0.##_);([$GBP]#,##0.##)");
        NumericFormatsMapping.put("NLMNIHKD", "[$HKD]#,##0.##_);([$HKD]#,##0.##)");
        NumericFormatsMapping.put("NLMNIHRK", "[$HRK]#,##0.##_);([$HRK]#,##0.##)");
        NumericFormatsMapping.put("NLMNIHUF", "[$HUF]#,##0.##_);([$HUF]#,##0.##)");
        NumericFormatsMapping.put("NLMNIIDR", "[$IDR]#,##0.##_);([$IDR]#,##0.##)");
        NumericFormatsMapping.put("NLMNIILS", "[$ILS]#,##0.##_);([$ILS]#,##0.##)");
        NumericFormatsMapping.put("NLMNIINR", "[$INR]#,##0.##_);([$INR]#,##0.##)");
        NumericFormatsMapping.put("NLMNIJPY", "[$JPY]#,##0.##_);([$JPY]#,##0.##)");
        NumericFormatsMapping.put("NLMNIKRW", "[$KRW]#,##0.##_);([$KRW]#,##0.##)");
        NumericFormatsMapping.put("NLMNILTL", "[$LTL]#,##0.##_);([$LTL]#,##0.##)");
        NumericFormatsMapping.put("NLMNILVL", "[$LVL]#,##0.##_);([$LVL]#,##0.##)");
        NumericFormatsMapping.put("NLMNIMOP", "[$MOP]#,##0.##_);([$MOP]#,##0.##)");
        NumericFormatsMapping.put("NLMNIMXN", "[$MXN]#,##0.##_);([$MXN]#,##0.##)");
        NumericFormatsMapping.put("NLMNIMYR", "[$MYR]#,##0.##_);([$MYR]#,##0.##)");
        NumericFormatsMapping.put("NLMNINOK", "[$NOK]#,##0.##_);([$NOK]#,##0.##)");
        NumericFormatsMapping.put("NLMNINZD", "[$NZD]#,##0.##_);([$NZD]#,##0.##)");
        NumericFormatsMapping.put("NLMNIPLN", "[$PLN]#,##0.##_);([$PLN]#,##0.##)");
        NumericFormatsMapping.put("NLMNIROL", "[$ROL]#,##0.##_);([$ROL]#,##0.##)");
        NumericFormatsMapping.put("NLMNIRUB", "[$RUB]#,##0.##_);([$RUB]#,##0.##)");
        NumericFormatsMapping.put("NLMNIRUR", "[$RUR]#,##0.##_);([$RUR]#,##0.##)");
        NumericFormatsMapping.put("NLMNISEK", "[$SEK]#,##0.##_);([$SEK]#,##0.##)");
        NumericFormatsMapping.put("NLMNISGD", "[$SGD]#,##0.##_);([$SGD]#,##0.##)");
        NumericFormatsMapping.put("NLMNISKK", "[$SKK]#,##0.##_);([$SKK]#,##0.##)");
        NumericFormatsMapping.put("NLMNITHB", "[$THB]#,##0.##_);([$THB]#,##0.##)");
        NumericFormatsMapping.put("NLMNITRY", "[$TRY]#,##0.##_);([$TRY]#,##0.##)");
        NumericFormatsMapping.put("NLMNITWD", "[$TWD]#,##0.##_);([$TWD]#,##0.##)");
        NumericFormatsMapping.put("NLMNIUSD", "[$USD]#,##0.##_);([$USD]#,##0.##)");
        NumericFormatsMapping.put("NLMNIZAR", "[$ZAR]#,##0.##_);([$ZAR]#,##0.##)");
        NumericFormatsMapping.put("NLMNLAED", "[$AED]#,##0.##_);([$AED]#,##0.##)");
        NumericFormatsMapping.put("NLMNLAUD", "[$AUD]#,##0.##_);([$AUD]#,##0.##)");
        NumericFormatsMapping.put("NLMNLBGN", "[$BGN]#,##0.##_);([$BGN]#,##0.##)");
        NumericFormatsMapping.put("NLMNLBRL", "[$BRL]#,##0.##_);([$BRL]#,##0.##)");
        NumericFormatsMapping.put("NLMNLCAD", "[$CAD]#,##0.##_);([$CAD]#,##0.##)");
        NumericFormatsMapping.put("NLMNLCHF", "[$CHF]#,##0.##_);([$CHF]#,##0.##)");
        NumericFormatsMapping.put("NLMNLCNY", "[$CNY]#,##0.##_);([$CNY]#,##0.##)");
        NumericFormatsMapping.put("NLMNLCZK", "[$CZK]#,##0.##_);([$CZK]#,##0.##)");
        NumericFormatsMapping.put("NLMNLDKK", "[$DKK]#,##0.##_);([$DKK]#,##0.##)");
        NumericFormatsMapping.put("NLMNLEEK", "[$EEK]#,##0.##_);([$EEK]#,##0.##)");
        NumericFormatsMapping.put("NLMNLEGP", "[$EGP]#,##0.##_);([$EGP]#,##0.##)");
        NumericFormatsMapping.put("NLMNLEUR", "[$EUR]#,##0.##_);([$EUR]#,##0.##)");
        NumericFormatsMapping.put("NLMNLGBP", "[$GBP]#,##0.##_);([$GBP]#,##0.##)");
        NumericFormatsMapping.put("NLMNLHKD", "[$HKD]#,##0.##_);([$HKD]#,##0.##)");
        NumericFormatsMapping.put("NLMNLHRK", "[$HRK]#,##0.##_);([$HRK]#,##0.##)");
        NumericFormatsMapping.put("NLMNLHUF", "[$HUF]#,##0.##_);([$HUF]#,##0.##)");
        NumericFormatsMapping.put("NLMNLIDR", "[$IDR]#,##0.##_);([$IDR]#,##0.##)");
        NumericFormatsMapping.put("NLMNLILS", "[$ILS]#,##0.##_);([$ILS]#,##0.##)");
        NumericFormatsMapping.put("NLMNLINR", "[$INR]#,##0.##_);([$INR]#,##0.##)");
        NumericFormatsMapping.put("NLMNLJPY", "[$JPY]#,##0.##_);([$JPY]#,##0.##)");
        NumericFormatsMapping.put("NLMNLKRW", "[$KRW]#,##0.##_);([$KRW]#,##0.##)");
        NumericFormatsMapping.put("NLMNLLTL", "[$LTL]#,##0.##_);([$LTL]#,##0.##)");
        NumericFormatsMapping.put("NLMNLLVL", "[$LVL]#,##0.##_);([$LVL]#,##0.##)");
        NumericFormatsMapping.put("NLMNLMOP", "[$MOP]#,##0.##_);([$MOP]#,##0.##)");
        NumericFormatsMapping.put("NLMNLMXN", "[$MXN]#,##0.##_);([$MXN]#,##0.##)");
        NumericFormatsMapping.put("NLMNLMYR", "[$MYR]#,##0.##_);([$MYR]#,##0.##)");
        NumericFormatsMapping.put("NLMNLNOK", "[$NOK]#,##0.##_);([$NOK]#,##0.##)");
        NumericFormatsMapping.put("NLMNLNZD", "[$NZD]#,##0.##_);([$NZD]#,##0.##)");
        NumericFormatsMapping.put("NLMNLPLN", "[$PLN]#,##0.##_);([$PLN]#,##0.##)");
        NumericFormatsMapping.put("NLMNLROL", "[$ROL]#,##0.##_);([$ROL]#,##0.##)");
        NumericFormatsMapping.put("NLMNLRUB", "[$RUB]#,##0.##_);([$RUB]#,##0.##)");
        NumericFormatsMapping.put("NLMNLRUR", "[$RUR]#,##0.##_);([$RUR]#,##0.##)");
        NumericFormatsMapping.put("NLMNLSEK", "[$SEK]#,##0.##_);([$SEK]#,##0.##)");
        NumericFormatsMapping.put("NLMNLSGD", "[$SGD]#,##0.##_);([$SGD]#,##0.##)");
        NumericFormatsMapping.put("NLMNLSKK", "[$SKK]#,##0.##_);([$SKK]#,##0.##)");
        NumericFormatsMapping.put("NLMNLTHB", "[$THB]#,##0.##_);([$THB]#,##0.##)");
        NumericFormatsMapping.put("NLMNLTRY", "[$TRY]#,##0.##_);([$TRY]#,##0.##)");
        NumericFormatsMapping.put("NLMNLTWD", "[$TWD]#,##0.##_);([$TWD]#,##0.##)");
        NumericFormatsMapping.put("NLMNLUSD", "$#,##0.##_);($#,##0.##)");
        NumericFormatsMapping.put("NLMNLZAR", "[$ZAR]#,##0.##_);([$ZAR]#,##0.##)");
        NumericFormatsMapping.put("NLMNY", NUMERIC_LOCALIZED_FORMAT);
        NumericFormatsMapping.put("NLMNYI", NUMERIC_LOCALIZED_FORMAT);
        NumericFormatsMapping.put("NLNUM", NUMERIC_LOCALIZED_FORMAT);
        NumericFormatsMapping.put("NLNUMI", NUMERIC_LOCALIZED_FORMAT);
        NumericFormatsMapping.put("NLPCT", NUMERIC_LOCALIZED_FORMAT);
        NumericFormatsMapping.put("NLPCTI", NUMERIC_LOCALIZED_FORMAT);
        NumericFormatsMapping.put("NLPCTN", NUMERIC_LOCALIZED_FORMAT);
        NumericFormatsMapping.put("NLPCTP", NUMERIC_LOCALIZED_FORMAT);
        NumericFormatsMapping.put("NLPVALUE", NUMERIC_LOCALIZED_FORMAT);
        NumericFormatsMapping.put("NLSTRMON", "General; ; ;");
        NumericFormatsMapping.put("NLSTRQTR", "General; ; ;");
        NumericFormatsMapping.put("NLSTRWK", "General; ; ;");
        NumericFormatsMapping.put("NUMX", "0");
        NumericFormatsMapping.put("OCTAL", EXCEL_DEFAULT_NUMERIC_FORMAT);
        NumericFormatsMapping.put("ODDSR", EXCEL_DEFAULT_NUMERIC_FORMAT);
        NumericFormatsMapping.put("PCPIB", EXCEL_DEFAULT_NUMERIC_FORMAT);
        NumericFormatsMapping.put("PD", EXCEL_DEFAULT_NUMERIC_FORMAT);
        NumericFormatsMapping.put("PERCENT", "0%;(0%)");
        NumericFormatsMapping.put("PERCENTN", "0%");
        NumericFormatsMapping.put("PIB", EXCEL_DEFAULT_NUMERIC_FORMAT);
        NumericFormatsMapping.put("PIBR", EXCEL_DEFAULT_NUMERIC_FORMAT);
        NumericFormatsMapping.put("PK", EXCEL_DEFAULT_NUMERIC_FORMAT);
        NumericFormatsMapping.put("PVALUE", EXCEL_DEFAULT_NUMERIC_FORMAT);
        NumericFormatsMapping.put("RB", EXCEL_DEFAULT_NUMERIC_FORMAT);
        NumericFormatsMapping.put("ROMAN", EXCEL_DEFAULT_NUMERIC_FORMAT);
        NumericFormatsMapping.put("RSTDOCNY", "#,##0%");
        NumericFormatsMapping.put("RSTDOCYY", "#,##0%_);(#,##0%)");
        NumericFormatsMapping.put("RSTDODN", "[$$-409]#,##0;([$$-409]#,##0)");
        NumericFormatsMapping.put("RSTDONYN", "0_);(0)");
        NumericFormatsMapping.put("RSTDOPH", "(000) 000-000");
        NumericFormatsMapping.put("RSTDOPNY", "#,##0%");
        NumericFormatsMapping.put("RSTDOPYN", "#,##0_);(#,##0)");
        NumericFormatsMapping.put("RSTDOPYY", "#,##0_)%;(#,##0%)");
        NumericFormatsMapping.put("RSTDOZP", "0000-000");
        NumericFormatsMapping.put("S370FF", EXCEL_DEFAULT_NUMERIC_FORMAT);
        NumericFormatsMapping.put("S370FHEX", EXCEL_DEFAULT_NUMERIC_FORMAT);
        NumericFormatsMapping.put("S370FIB", EXCEL_DEFAULT_NUMERIC_FORMAT);
        NumericFormatsMapping.put("S370FIBU", EXCEL_DEFAULT_NUMERIC_FORMAT);
        NumericFormatsMapping.put("S370FPD", EXCEL_DEFAULT_NUMERIC_FORMAT);
        NumericFormatsMapping.put("S370FPDU", EXCEL_DEFAULT_NUMERIC_FORMAT);
        NumericFormatsMapping.put("S370FPIB", EXCEL_DEFAULT_NUMERIC_FORMAT);
        NumericFormatsMapping.put("S370FRB", EXCEL_DEFAULT_NUMERIC_FORMAT);
        NumericFormatsMapping.put("S370FZD", EXCEL_DEFAULT_NUMERIC_FORMAT);
        NumericFormatsMapping.put("S370FZDL", EXCEL_DEFAULT_NUMERIC_FORMAT);
        NumericFormatsMapping.put("S370FZDS", EXCEL_DEFAULT_NUMERIC_FORMAT);
        NumericFormatsMapping.put("S370FZDT", EXCEL_DEFAULT_NUMERIC_FORMAT);
        NumericFormatsMapping.put("S370FZDU", EXCEL_DEFAULT_NUMERIC_FORMAT);
        NumericFormatsMapping.put("SIZEK", EXCEL_DEFAULT_NUMERIC_FORMAT);
        NumericFormatsMapping.put("SIZEKB", EXCEL_DEFAULT_NUMERIC_FORMAT);
        NumericFormatsMapping.put("SIZEKMG", EXCEL_DEFAULT_NUMERIC_FORMAT);
        NumericFormatsMapping.put("SSN", "000-00-0000");
        NumericFormatsMapping.put("UNXEPOCH", EXCEL_DEFAULT_NUMERIC_FORMAT);
        NumericFormatsMapping.put("VAXRB", EXCEL_DEFAULT_NUMERIC_FORMAT);
        NumericFormatsMapping.put("VMSZN", EXCEL_DEFAULT_NUMERIC_FORMAT);
        NumericFormatsMapping.put("W", "0");
        NumericFormatsMapping.put("WORDF", EXCEL_DEFAULT_NUMERIC_FORMAT);
        NumericFormatsMapping.put("WORDS", EXCEL_DEFAULT_NUMERIC_FORMAT);
        NumericFormatsMapping.put("YEN", "[$\u00a5-411]#,##0;[$\u00a5-411]-#,##0");
        NumericFormatsMapping.put("Z", "0");
        NumericFormatsMapping.put("ZD", EXCEL_DEFAULT_NUMERIC_FORMAT);
        weekdayFormats = new String[]{"WEEKDAY", "AFRDFDN", "CATDFDN", "CRODFDN", "CSYDFDN", "DANDFDN", "DESDFDN", "DEUDFDN", "ENGDFDN", "ESPDFDN", "EURDFDN", "FINDFDN", "FRADFDN", "FRSDFDN", "HUNDFDN", "ITADFDN", "MACDFDN", "NLDDFDN", "NORDFDN", "POLDFDN", "PTGDFDN", "RUSDFDN", "SLODFDN", "SVEDFDN"};
        formatsWithDecimalPart = new String[]{"COMMA", "COMMAX", "DOLLAR", "DOLLARX", "EURO", "EUROX", "F", "", "PERCENT", "PERCENTN", "YEN", "SIZEMB", "SIZEKB", "SIZEK", "NLNUM", "NLNUMI", "NLPCT", "NLPCTI", "NEGPAREN", "NUMX", "RSTDOCNY", "RSTDOCYY", "RSTDODN", "RSTDONYN", "RSTDOPNY", "RSTDOPYN", "RSTDOPYY"};
        localizedDateTimeFormatsToRemap = new String[]{"EURDFDD", "EURDFDE", "EURDFDT", "EURDFDWN", "EURDFMN", "EURDFMY", "EURDFWDX", "EURDFWKX"};
        iso639toSASLanguageCodeMapping = new HashMap<String, String>(40);
        iso639toSASLanguageCodeMapping.put("af", "AFR");
        iso639toSASLanguageCodeMapping.put("ca", "CAT");
        iso639toSASLanguageCodeMapping.put("hr", "CRO");
        iso639toSASLanguageCodeMapping.put("cs", "CSY");
        iso639toSASLanguageCodeMapping.put("da", "DAN");
        iso639toSASLanguageCodeMapping.put("nl", "NLD");
        iso639toSASLanguageCodeMapping.put("en", "ENG");
        iso639toSASLanguageCodeMapping.put("fi", "FIN");
        iso639toSASLanguageCodeMapping.put("fr", "FRA");
        iso639toSASLanguageCodeMapping.put("de", "DEU");
        iso639toSASLanguageCodeMapping.put("hu", "HUN");
        iso639toSASLanguageCodeMapping.put("it", "ITA");
        iso639toSASLanguageCodeMapping.put("mk", "MAC");
        iso639toSASLanguageCodeMapping.put("no", "NOR");
        iso639toSASLanguageCodeMapping.put("pl", "POL");
        iso639toSASLanguageCodeMapping.put("pt", "PTG");
        iso639toSASLanguageCodeMapping.put("ru", "RUS");
        iso639toSASLanguageCodeMapping.put("sl", "SLO");
        iso639toSASLanguageCodeMapping.put("es", "ESP");
        iso639toSASLanguageCodeMapping.put("sv", "SVE");
        iso639toSASLanguageCodeMapping.put("fr-CH", "FRS");
        iso639toSASLanguageCodeMapping.put("de-CH", "DES");
        temporarilyRemappedLocalizedFormats = new HashMap<String, String>(4);
        temporarilyRemappedLocalizedFormats.put("NLDATMYQ", "NLDATMYM");
        temporarilyRemappedLocalizedFormats.put("NLDATMYW", "NLDATMDT");
        temporarilyRemappedLocalizedFormats.put("NLD", "NLBEST");
    }
}

