/*
 * Decompiled with CFR 0.152.
 */
package com.sas.storage.jdbc;

import com.sas.beans.ExtendedBeanInfo;
import com.sas.sasserver.tree.LevelDataInterface;
import com.sas.storage.jdbc.JDBCColumnValuesAdapter;
import com.sas.storage.jdbc.RB;
import com.sas.swing.models.IndexedMutableTreeNode;
import com.sas.util.Util;
import com.sas.util.transforms.TransformException;
import com.sas.util.transforms.TransformInterface;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.EventListener;
import java.util.EventObject;
import javax.swing.event.EventListenerList;
import javax.swing.event.TreeModelEvent;
import javax.swing.event.TreeModelListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;

public class JDBCToTreeModelAdapter
extends JDBCColumnValuesAdapter
implements TreeModel,
LevelDataInterface {
    public static final String RB_KEY = "JDBCToTreeModelAdapter.";
    protected EventListenerList listenerList = new EventListenerList();
    protected int initialLevelsRead;
    protected String levelColumnName;
    protected String indexColumnName;
    protected String textColumnName;
    protected DefaultTreeModel treeModel;
    protected boolean inInit;
    protected TransformInterface nodeTransform;
    private String originalQueryStatment;
    protected String whereClause;

    public JDBCToTreeModelAdapter() {
        this(null, null);
    }

    public JDBCToTreeModelAdapter(ResultSet result) {
        super(result);
        this.initialLevelsRead = 0;
    }

    public JDBCToTreeModelAdapter(Connection conn, String queryStatement) {
        super(conn, queryStatement);
        this.initialLevelsRead = 3;
    }

    @Override
    public void addTreeModelListener(TreeModelListener l) {
        this.listenerList.add(TreeModelListener.class, l);
    }

    @Override
    public void removeTreeModelListener(TreeModelListener l) {
        this.listenerList.remove(TreeModelListener.class, l);
    }

    public int getInitialLevelsRead() {
        return this.initialLevelsRead;
    }

    public void setInitialLevelsRead(int initialLevelsRead) {
        int oldInitialLevelsRead = this.initialLevelsRead;
        if (oldInitialLevelsRead != initialLevelsRead) {
            this.initialLevelsRead = initialLevelsRead;
            this.spcs.firePropertyChange("initialLevelsRead", oldInitialLevelsRead, initialLevelsRead);
        }
    }

    @Override
    public String getLevelColumnName() {
        return this.levelColumnName;
    }

    @Override
    public void setLevelColumnName(String levelColumnName) {
        String oldLevelColumnName = this.levelColumnName;
        if (Util.unequal((Object)oldLevelColumnName, (Object)levelColumnName)) {
            this.levelColumnName = levelColumnName;
            this.initialized = false;
            this.fireModelEvent();
            this.spcs.firePropertyChange("levelColumnName", oldLevelColumnName, levelColumnName);
        }
    }

    @Override
    public String getIndexColumnName() {
        return this.indexColumnName;
    }

    @Override
    public void setIndexColumnName(String indexColumnName) {
        String oldIndexColumnName = this.indexColumnName;
        if (Util.unequal((Object)oldIndexColumnName, (Object)indexColumnName)) {
            this.indexColumnName = indexColumnName;
            this.initialized = false;
            this.fireModelEvent();
            this.spcs.firePropertyChange("indexColumnName", oldIndexColumnName, indexColumnName);
        }
    }

    @Override
    public String getTextColumnName() {
        return this.textColumnName;
    }

    @Override
    public void setTextColumnName(String textColumnName) {
        String oldTextColumnName = this.textColumnName;
        if (Util.unequal((Object)oldTextColumnName, (Object)textColumnName)) {
            this.textColumnName = textColumnName;
            this.initialized = false;
            this.fireModelEvent();
            this.spcs.firePropertyChange("textColumnName", oldTextColumnName, textColumnName);
        }
    }

    @Override
    protected void init() {
        if (this.initialized) {
            return;
        }
        if (this.inInit) {
            return;
        }
        this.inInit = true;
        DefaultMutableTreeNode rootNode = null;
        int count = 1;
        try {
            this.originalQueryStatment = this.queryStatement;
            if (this.initialLevelsRead > 0 && !this.resultSetUsed) {
                this.queryStatement = this.originalQueryStatment + " where " + this.levelColumnName + " <= " + this.initialLevelsRead;
            }
            super.init();
            this.queryStatement = this.originalQueryStatment;
            if (!this.forwardOnly) {
                this.result.first();
            } else {
                this.result.next();
            }
            int levelColumn = this.retrieveColumnIndex(this.levelColumnName);
            int indexColumn = this.retrieveColumnIndex(this.indexColumnName);
            rootNode = this.getTreeNode(count, this.result);
            if (this.initialLevelsRead < 1 || rootNode.getLevel() < this.initialLevelsRead - 1) {
                ((IndexedMutableTreeNode)rootNode).setChildrenRead(true);
            }
            int parentLevel = this.convertToInt(this.retrieveColumnValueAt(levelColumn, this.result));
            DefaultMutableTreeNode parentNode = rootNode;
            IndexedMutableTreeNode oldNode = null;
            while (this.result.next()) {
                ++count;
                int newIndex = this.convertToInt(this.retrieveColumnValueAt(indexColumn, this.result));
                if (oldNode != null) {
                    oldNode.setNextRelativeIndex(newIndex);
                }
                DefaultMutableTreeNode childNode = this.getTreeNode(newIndex, this.result);
                int childLevel = this.convertToInt(this.retrieveColumnValueAt(levelColumn, this.result));
                if (childLevel == parentLevel + 1) {
                    parentNode.add(childNode);
                } else {
                    for (int i = childLevel; i < parentLevel + 1; ++i) {
                        parentNode = (DefaultMutableTreeNode)parentNode.getParent();
                    }
                    parentNode.add(childNode);
                }
                parentNode = childNode;
                parentLevel = childLevel;
                if (this.initialLevelsRead < 1 || childNode.getLevel() < this.initialLevelsRead - 1) {
                    ((IndexedMutableTreeNode)childNode).setChildrenRead(true);
                }
                oldNode = (IndexedMutableTreeNode)childNode;
            }
        }
        catch (SQLException se) {
            this.inInit = false;
            se.printStackTrace();
            throw new IllegalStateException(se.getMessage());
        }
        finally {
            if (rootNode == null) {
                rootNode = new DefaultMutableTreeNode();
            }
            this.treeModel = new DefaultTreeModel(rootNode);
            this.inInit = false;
        }
    }

    private int convertToInt(Object obj) {
        int intValue;
        if (obj instanceof Number) {
            intValue = ((Number)obj).intValue();
        } else if (obj instanceof String) {
            try {
                String indexString = ((String)obj).trim();
                intValue = Integer.parseInt(indexString);
            }
            catch (NumberFormatException e) {
                throw new IllegalStateException(RB.getStringResource(RB_KEY, "convertInt1.ex.txt"));
            }
        } else {
            throw new IllegalStateException(RB.getStringResource(RB_KEY, "convertInt2.ex.txt"));
        }
        return intValue;
    }

    public void addChildren(Object parentNode, ResultSet queryResult) {
        if (queryResult != null && parentNode instanceof IndexedMutableTreeNode) {
            try {
                int parentsNextRelativeIndex = ((IndexedMutableTreeNode)parentNode).getNextRelativeIndex();
                ResultSetMetaData queryMeta = queryResult.getMetaData();
                int indexColumn = queryResult.findColumn(this.indexColumnName);
                int levelColumn = queryResult.findColumn(this.levelColumnName);
                if (!this.forwardOnly && !queryResult.isBeforeFirst()) {
                    queryResult.beforeFirst();
                }
                IndexedMutableTreeNode oldNode = null;
                int parentNodeIndex = ((IndexedMutableTreeNode)parentNode).getIndex();
                int parentNodeLevel = ((IndexedMutableTreeNode)parentNode).getLevel() + 1;
                while (queryResult.next()) {
                    int newIndex = this.convertToInt(this.retrieveColumnValueAt(indexColumn, queryResult));
                    int newLevel = this.convertToInt(this.retrieveColumnValueAt(levelColumn, queryResult));
                    if (newLevel != parentNodeLevel + 1 || newIndex <= parentNodeIndex || parentsNextRelativeIndex != 0 && newIndex >= parentsNextRelativeIndex) continue;
                    if (oldNode != null) {
                        oldNode.setNextRelativeIndex(newIndex);
                    }
                    DefaultMutableTreeNode childNode = this.getTreeNode(newIndex, queryResult);
                    ((IndexedMutableTreeNode)parentNode).add(childNode);
                    oldNode = (IndexedMutableTreeNode)childNode;
                }
                if (oldNode != null) {
                    oldNode.setNextRelativeIndex(parentsNextRelativeIndex);
                }
                ((IndexedMutableTreeNode)parentNode).setChildrenRead(true);
            }
            catch (SQLException se) {
                throw new IllegalStateException(se.getMessage());
            }
        }
    }

    public void setNodeTransform(TransformInterface nodeTransform) {
        TransformInterface old = this.getNodeTransform();
        if (old != nodeTransform) {
            this.nodeTransform = nodeTransform;
            this.initialized = false;
            this.fireModelEvent();
            this.spcs.firePropertyChange("nodeTransform", old, nodeTransform);
        }
    }

    public TransformInterface getNodeTransform() {
        return this.nodeTransform;
    }

    private Object getTreeNodeValue(ResultSet resultSet) {
        Object treeNodeObject = null;
        try {
            if (this.isRetrieveAllColumnValues() || this.textColumnName == null || this.textColumnName.equals("")) {
                return this.retrieveValueAt(1, resultSet);
            }
            int textColumnIndex = resultSet.findColumn(this.textColumnName);
            treeNodeObject = this.retrieveValueAt(textColumnIndex, resultSet);
        }
        catch (SQLException se) {
            se.printStackTrace();
            throw new IllegalStateException(se.getMessage());
        }
        return treeNodeObject;
    }

    private DefaultMutableTreeNode getTreeNode(int index, ResultSet resultSet) {
        DefaultMutableTreeNode node = null;
        if (this.nodeTransform != null) {
            try {
                node = (DefaultMutableTreeNode)this.nodeTransform.transform((Object)this.getColumnValuesMap(resultSet));
            }
            catch (TransformException te) {
                throw new IllegalStateException(te.getMessage());
            }
            catch (SQLException se) {
                throw new IllegalStateException(se.getMessage());
            }
        } else {
            node = new IndexedMutableTreeNode(index, this.getTreeNodeValue(resultSet));
        }
        return node;
    }

    protected boolean readChildren(Object node) {
        if (!this.resultSetUsed && node instanceof IndexedMutableTreeNode && !((IndexedMutableTreeNode)node).isChildrenRead()) {
            try {
                if (((IndexedMutableTreeNode)node).getNextRelativeIndex() == ((IndexedMutableTreeNode)node).getIndex() + 1) {
                    ((IndexedMutableTreeNode)node).setChildrenRead(true);
                    return true;
                }
                int level = ((IndexedMutableTreeNode)node).getLevel() + 1;
                int index = ((IndexedMutableTreeNode)node).getIndex();
                String whereClause = " where " + this.levelColumnName + " = " + (level + 1) + " and " + this.indexColumnName + " > " + index;
                int parentsNextRelativeIndex = ((IndexedMutableTreeNode)node).getNextRelativeIndex();
                if (parentsNextRelativeIndex != 0) {
                    whereClause = whereClause + " and " + this.indexColumnName + " < " + parentsNextRelativeIndex;
                }
                String newQueryStatement = this.originalQueryStatment + whereClause;
                if (this.stmt == null) {
                    throw new IllegalStateException(RB.getStringResource("JDBCAdapter.", "statementNotExecute.ex.txt"));
                }
                ResultSet queryResult = this.stmt.executeQuery(newQueryStatement);
                this.addChildren(node, queryResult);
                return this.treeModel.isLeaf(node);
            }
            catch (SQLException se) {
                throw new IllegalStateException(se.getMessage());
            }
        }
        return false;
    }

    @Override
    public Object getChild(Object parent, int index) {
        if (this.designTime) {
            return null;
        }
        this.init();
        this.readChildren(parent);
        return this.treeModel.getChild(parent, index);
    }

    @Override
    public boolean isLeaf(Object node) {
        if (this.designTime) {
            return true;
        }
        this.init();
        this.readChildren(node);
        return this.treeModel.isLeaf(node);
    }

    @Override
    public int getChildCount(Object parent) {
        if (this.designTime) {
            return 0;
        }
        this.init();
        this.readChildren(parent);
        return this.treeModel.getChildCount(parent);
    }

    @Override
    public void valueForPathChanged(TreePath path, Object newValue) {
        this.init();
        this.treeModel.valueForPathChanged(path, newValue);
    }

    @Override
    public int getIndexOfChild(Object parent, Object child) {
        this.init();
        this.readChildren(parent);
        return this.treeModel.getIndexOfChild(parent, child);
    }

    @Override
    public Object getRoot() {
        if (this.designTime) {
            return new DefaultMutableTreeNode(null, false);
        }
        this.init();
        return this.treeModel.getRoot();
    }

    public static ExtendedBeanInfo getExtendedBeanInfo() {
        String[][][] propertyMetadata = new String[][][]{{{"Name", "connection"}, {"Hidden", "true"}}, {{"Name", "model"}, {"Property editor class", "com.sas.beans.editors._InstanceEditor"}}, {{"Name", "resultSetRequeryUsed"}, {"Expert", "true"}}, {{"Name", "root"}, {"Expert", "true"}}};
        ExtendedBeanInfo ebi = new ExtendedBeanInfo();
        ebi.shortDescription = RB.getStringResource(RB_KEY, "shortDescription.txt");
        ebi.propertyMetadata = propertyMetadata;
        return ebi;
    }

    @Override
    public void fireCellEvent(int row, int column) {
        this.fireModelEvent(new TreeModelEvent((Object)this, new Object[]{this.getRoot()}));
    }

    @Override
    public void fireModelEvent(EventObject event) {
        if (this.conn != null && this.queryStatement != null && this.textColumnName != null && this.indexColumnName != null && this.levelColumnName != null && event instanceof TreeModelEvent) {
            EventListener[] listeners = this.listenerList.getListeners(TreeModelListener.class);
            int n = listeners.length;
            for (int i = 0; i < n; ++i) {
                ((TreeModelListener)listeners[i]).treeStructureChanged((TreeModelEvent)event);
            }
        }
    }

    @Override
    public void fireModelEvent() {
        if ((this.conn != null && this.queryStatement != null || this.resultSetUsed && this.result != null) && this.textColumnName != null && this.indexColumnName != null && this.levelColumnName != null) {
            this.fireModelEvent(new TreeModelEvent((Object)this, new Object[]{this.getRoot()}));
        }
    }
}

