/*
 * Decompiled with CFR 0.152.
 */
package com.sas.storage.jdbc;

import com.sas.storage.jdbc.JDBCAdapter;
import com.sas.storage.jdbc.RB;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;

public abstract class JDBCRowCountAdapter
extends JDBCAdapter {
    public static final String RB_KEY = "JDBCRowCountAdapter.";
    protected boolean maxRowsFound;
    protected int currentMaxRowCount;
    protected int readAheadAmount = 1000;
    protected boolean trueRowCountCalculated;
    protected static final int READ_AHEAD_AMOUNT = 1000;

    public JDBCRowCountAdapter() {
        this(null, null);
    }

    public JDBCRowCountAdapter(ResultSet result) {
        super(result);
    }

    public JDBCRowCountAdapter(Connection conn, String queryStatement) {
        super(conn, queryStatement);
    }

    public void setTrueRowCountCalculated(boolean trueRowCountCalculated) {
        if (this.trueRowCountCalculated == trueRowCountCalculated) {
            return;
        }
        this.trueRowCountCalculated = trueRowCountCalculated;
        this.spcs.firePropertyChange("trueRowCountCalculated", trueRowCountCalculated ? Boolean.FALSE : Boolean.TRUE, trueRowCountCalculated ? Boolean.TRUE : Boolean.FALSE);
    }

    public boolean isTrueRowCountCalculated() {
        return this.trueRowCountCalculated;
    }

    public int getReadAheadAmount() {
        return this.readAheadAmount;
    }

    public void setReadAheadAmount(int readAheadAmount) {
        int oldReadAheadAmount = this.readAheadAmount;
        if (oldReadAheadAmount == readAheadAmount) {
            return;
        }
        if (readAheadAmount < 1) {
            throw new IllegalArgumentException(RB.getStringResource(RB_KEY, "invalidReadAheadAmount.ex.txt"));
        }
        this.readAheadAmount = readAheadAmount;
        this.spcs.firePropertyChange("readAheadAmount", oldReadAheadAmount, readAheadAmount);
    }

    protected void calculateCurrentMaxRowCount(int requestedRow) throws SQLException {
        this.init();
        if (this.maxRowsFound || requestedRow + this.getReadAheadAmount() <= this.currentMaxRowCount) {
            return;
        }
        int oldCount = this.currentMaxRowCount;
        int targetRow = this.readAheadAmount + (this.currentMaxRowCount > requestedRow ? this.currentMaxRowCount : requestedRow);
        if (!this.forwardOnly) {
            boolean isOnResultSet = this.result.absolute(targetRow);
            if (!isOnResultSet) {
                this.result.last();
                this.maxRowsFound = true;
            }
            this.currentMaxRowCount = this.result.getRow();
        } else {
            int advanceAmount = targetRow - this.rowNumber;
            for (int i = 0; i < advanceAmount; ++i) {
                if (!this.result.next()) {
                    this.maxRowsFound = true;
                    this.initialized = false;
                    this.init();
                    break;
                }
                this.currentMaxRowCount = ++this.rowNumber;
            }
        }
        this.fireModelInsertEvent(oldCount, this.currentMaxRowCount - 1);
    }

    @Override
    public void setQueryStatement(String queryStatement) {
        this.currentMaxRowCount = 0;
        this.maxRowsFound = false;
        super.setQueryStatement(queryStatement);
    }

    @Override
    public void setConnection(Connection conn) {
        this.currentMaxRowCount = 0;
        this.maxRowsFound = false;
        super.setConnection(conn);
    }

    protected abstract void fireModelInsertEvent(int var1, int var2);
}

