/*
 * Decompiled with CFR 0.152.
 */
package com.sas.storage.flattened.sasmdx;

import com.sas.codepolicy.SASScope;
import com.sas.iom.SASIOMDefs.LongSeqHolder;
import com.sas.iom.SASIOMDefs.StringSeqHolder;
import com.sas.iom.SASIOMDefs.VariableArray2dOfStringHolder;
import com.sas.iom.SASMDX.DataType;
import com.sas.iom.SASMDX.DataTypeSeqHolder;
import com.sas.iom.SASMDX.IFlatDataSet;
import com.sas.iom.SASMDX.IFlatDataSet_1_2;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;

@SASScope(value="ALL")
public class FlattenResultSetMetadata
implements ResultSetMetaData {
    @SASScope
    public static final String RB_KEY = "FlattenResultSetMetadata.";
    private static int COLUMN_INDEX = 0;
    private static int LONG_HEADING = 1;
    private static int SHORT_HEADING = 2;
    private static int DATA_TYPE = 3;
    private static int COLUMN_TYPE = 4;
    private static int COLUMN_TYPE_NAME = 5;
    private static int COLUMN_CLASS_NAME = 6;
    private static int MAX_SIZE = 7;
    private static int COLUMN_LABEL = 8;
    private static int COLUMN_FORMAT = 9;
    private int cellValueFormat;
    private IFlatDataSet _flatDataSet;
    private LinkedHashMap columnList;
    private int numCols = -1;

    @SASScope
    public FlattenResultSetMetadata(IFlatDataSet flatDataSet, int cellValueFormat, String[] formatStrings) throws SQLException {
        this._flatDataSet = flatDataSet;
        this.cellValueFormat = cellValueFormat;
        this.initializeColumnInfo(formatStrings);
    }

    private void initializeColumnInfo(String[] formatStrings) throws SQLException {
        try {
            StringSeqHolder heading = new StringSeqHolder();
            StringSeqHolder shortHeading = new StringSeqHolder();
            DataTypeSeqHolder dataTypes = new DataTypeSeqHolder();
            VariableArray2dOfStringHolder values = new VariableArray2dOfStringHolder();
            LongSeqHolder maxSize = new LongSeqHolder();
            StringSeqHolder label = new StringSeqHolder();
            ((IFlatDataSet_1_2)this._flatDataSet).GetColumnInfo_3(0, -1, heading, shortHeading, dataTypes, maxSize, label);
            this.numCols = heading.value.length;
            String[] headers = heading.value;
            this.columnList = new LinkedHashMap(this.numCols);
            for (int i = 0; i < this.numCols; ++i) {
                List<String> columnInfo = new ArrayList<Object>(9);
                Integer colIndex = i;
                columnInfo.add(COLUMN_INDEX, (String)((Object)colIndex));
                columnInfo.add(heading.value[i]);
                columnInfo.add(SHORT_HEADING, heading.value[i]);
                columnInfo.add(DATA_TYPE, (String)dataTypes.value[i]);
                columnInfo = this.initDataTypeInfo(columnInfo);
                columnInfo.add(MAX_SIZE, (String)((Object)Integer.valueOf(0)));
                columnInfo.add(COLUMN_LABEL, label.value[i]);
                if (formatStrings != null && i < formatStrings.length) {
                    columnInfo.add(COLUMN_FORMAT, formatStrings[i]);
                }
                this.columnList.put(colIndex, columnInfo);
            }
        }
        catch (Exception e) {
            throw new SQLException();
        }
    }

    private List getList(int columnNumber) throws SQLException {
        Integer key;
        if (this.numCols == -1) {
            this.initializeColumnInfo(null);
        }
        if (this.columnList.containsKey(key = Integer.valueOf(columnNumber - 1))) {
            return (List)this.columnList.get(key);
        }
        return null;
    }

    private List getList(String columnName) throws SQLException {
        if (this.numCols == -1) {
            this.initializeColumnInfo(null);
        }
        for (List list : this.columnList.values()) {
            if (!list.contains(columnName)) continue;
            return list;
        }
        return null;
    }

    public void close() {
        try {
            this._flatDataSet.Close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public String getSchemaName(int p1) throws SQLException {
        return null;
    }

    @Override
    public boolean isSearchable(int columnNumber) throws SQLException {
        return true;
    }

    @Override
    public int getPrecision(int columnNumber) throws SQLException {
        return 0;
    }

    @Override
    public boolean isAutoIncrement(int columnNumber) throws SQLException {
        return true;
    }

    @Override
    public boolean isWritable(int columnNumber) throws SQLException {
        return false;
    }

    @Override
    public String getCatalogName(int columnNumber) throws SQLException {
        return null;
    }

    @Override
    public int getColumnDisplaySize(int columnNumber) throws SQLException {
        List list = this.getList(columnNumber);
        return (Integer)list.get(MAX_SIZE);
    }

    @Override
    public String getColumnName(int columnNumber) throws SQLException {
        List list = this.getList(columnNumber);
        return (String)list.get(SHORT_HEADING);
    }

    @Override
    public String getTableName(int columnNumber) throws SQLException {
        return null;
    }

    @Override
    public boolean isDefinitelyWritable(int columnNumber) throws SQLException {
        return false;
    }

    @Override
    public String getColumnTypeName(int columnNumber) throws SQLException {
        List list = this.getList(columnNumber);
        if (list.size() > 9) {
            return (String)list.get(COLUMN_FORMAT);
        }
        return (String)list.get(COLUMN_TYPE_NAME);
    }

    @Override
    public boolean isCaseSensitive(int columnNumber) throws SQLException {
        return true;
    }

    @Override
    public boolean isReadOnly(int columnNumber) throws SQLException {
        return true;
    }

    @Override
    public int getScale(int columnNumber) throws SQLException {
        return 0;
    }

    @Override
    public boolean isSigned(int columnNumber) throws SQLException {
        return true;
    }

    @Override
    public int isNullable(int columnNumber) throws SQLException {
        return 0;
    }

    @Override
    public boolean isCurrency(int columnNumber) throws SQLException {
        return false;
    }

    @Override
    public int getColumnCount() throws SQLException {
        return this.numCols;
    }

    @Override
    public String getColumnClassName(int columnNumber) throws SQLException {
        List list = this.getList(columnNumber);
        return (String)list.get(COLUMN_CLASS_NAME);
    }

    @Override
    public String getColumnLabel(int columnNumber) throws SQLException {
        List list = this.getList(columnNumber);
        return (String)list.get(COLUMN_LABEL);
    }

    @Override
    public int getColumnType(int columnNumber) throws SQLException {
        List list = this.getList(columnNumber);
        return (Integer)list.get(COLUMN_TYPE);
    }

    public int getColumnIndex(String columnName) throws SQLException {
        List list = this.getList(columnName);
        return (Integer)list.get(COLUMN_INDEX);
    }

    private List initDataTypeInfo(List colInfo) {
        DataType dt = (DataType)colInfo.get(DATA_TYPE);
        if (this.cellValueFormat == 1) {
            colInfo.add(COLUMN_TYPE, 1);
            colInfo.add(COLUMN_TYPE_NAME, "String");
            colInfo.add(COLUMN_CLASS_NAME, "java.lang.String");
        } else {
            switch (dt.value()) {
                case 0: {
                    colInfo.add(COLUMN_TYPE, 2000);
                    colInfo.add(COLUMN_TYPE_NAME, "Unspecified");
                    colInfo.add(COLUMN_CLASS_NAME, "java.lang.Object");
                    break;
                }
                case 1: {
                    colInfo.add(COLUMN_TYPE, 1);
                    colInfo.add(COLUMN_TYPE_NAME, "String");
                    colInfo.add(COLUMN_CLASS_NAME, "java.lang.String");
                    break;
                }
                case 2: {
                    colInfo.add(COLUMN_TYPE, 8);
                    colInfo.add(COLUMN_TYPE_NAME, "Double");
                    colInfo.add(COLUMN_CLASS_NAME, "java.lang.Double");
                    break;
                }
                case 3: {
                    colInfo.add(COLUMN_TYPE, -5);
                    colInfo.add(COLUMN_TYPE_NAME, "Long");
                    colInfo.add(COLUMN_CLASS_NAME, "java.lang.Long");
                    break;
                }
                case 4: {
                    colInfo.add(COLUMN_TYPE, 5);
                    colInfo.add(COLUMN_TYPE_NAME, "Short");
                    colInfo.add(COLUMN_CLASS_NAME, "java.lang.Short");
                    break;
                }
                case 5: {
                    colInfo.add(COLUMN_TYPE, 16);
                    colInfo.add(COLUMN_TYPE_NAME, "Boolean");
                    colInfo.add(COLUMN_CLASS_NAME, "java.lang.Boolean");
                    break;
                }
                default: {
                    colInfo.add(COLUMN_TYPE, 1);
                    colInfo.add(COLUMN_TYPE_NAME, "String");
                    colInfo.add(COLUMN_CLASS_NAME, "java.lang.String");
                }
            }
        }
        return colInfo;
    }

    @Override
    public <T> T unwrap(Class<T> iface) throws SQLException {
        return null;
    }

    @Override
    public boolean isWrapperFor(Class<?> iface) throws SQLException {
        return false;
    }
}

