/*
 * Decompiled with CFR 0.152.
 */
package com.sas.storage.editableproperties;

import com.sas.storage.editableproperties.PropertyMap;
import com.sas.storage.editableproperties.RB;
import com.sas.text.Message;
import com.sas.util.log.CommonLoggerInterface;
import com.sas.util.log.LoggerFactoryInterface;
import com.sas.util.log.LoggerRepository2;
import com.sas.util.log.log4j.Log4JFactory2;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Serializable;
import java.io.Writer;
import java.nio.charset.Charset;
import java.nio.charset.CharsetEncoder;
import java.util.ArrayList;
import java.util.List;

public class PropertyList
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static final String RB_KEY = "PropertyList.";
    List<CharSequence> list;
    PropertyMap map = new PropertyMap();
    protected String sectionName = null;
    private transient LoggerFactoryInterface loggerFactory = null;
    private transient CommonLoggerInterface logger = null;
    protected static final int COMMENT = 1;
    protected static final int PROPERTY_NAME = 2;
    protected static final int PROPERTY_VALUE = 3;
    protected static final int QUOTED_VALUE = 4;
    protected static final int SECTION_NAME = 5;
    protected static final int BLANK_LINE = 6;

    public PropertyList() {
        this.list = new ArrayList<CharSequence>(5);
    }

    public void save(Writer writer) throws IOException {
        this.save(writer, null);
    }

    public void save(OutputStream os) throws IOException {
        BufferedWriter writer = new BufferedWriter(new OutputStreamWriter(os));
        this.save(writer, null);
    }

    public void save(OutputStream os, Charset cs) throws IOException {
        BufferedWriter writer = new BufferedWriter(new OutputStreamWriter(os, cs));
        this.save(writer, cs);
    }

    protected void save(Writer writer, Charset cs) throws IOException {
        String newline = System.getProperty("line.separator");
        CharsetEncoder encoder = null;
        if (cs != null && cs.canEncode()) {
            encoder = cs.newEncoder();
        }
        for (CharSequence entry : this.list) {
            if (entry instanceof Comment) {
                writer.append(PropertyList.escapeString(null, encoder, entry, 1));
            } else {
                StringBuffer buffer = new StringBuffer();
                PropertyList.escapeString(buffer, encoder, entry, 2);
                buffer.append("=");
                PropertyList.escapeString(buffer, encoder, this.map.getProperty((String)entry), 3);
                writer.append(buffer);
            }
            writer.append(newline);
        }
        writer.flush();
    }

    protected static StringBuffer escapeString(StringBuffer buffer, CharsetEncoder encoder, CharSequence string, int escapeType) {
        if (buffer == null) {
            buffer = new StringBuffer();
        }
        if (string == null) {
            return buffer;
        }
        if (escapeType == 4) {
            buffer.append("\"");
        } else if (escapeType == 5) {
            buffer.append("[");
        }
        for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            if (c == '\\') {
                buffer.append("\\\\");
                continue;
            }
            if (c == '\r') {
                buffer.append("\\r");
                continue;
            }
            if (c == '\n') {
                buffer.append("\\n");
                continue;
            }
            if (c == '\t') {
                buffer.append("\\t");
                continue;
            }
            if (Character.getType(c) == 15 || encoder != null && !encoder.canEncode(c) || encoder == null && c > '\u007f') {
                buffer.append("\\u");
                buffer.append(Integer.toHexString(c + 65536).substring(1));
                continue;
            }
            if (escapeType == 2 && c == '=') {
                buffer.append("\\=");
                continue;
            }
            if (escapeType == 4 && c == '\"') {
                buffer.append("\\\"");
                continue;
            }
            if (escapeType == 5 && c == ']') {
                buffer.append("\\]");
                continue;
            }
            if (i == 0 && escapeType == 2 && (c == '[' || c == '#' || c == '!')) {
                buffer.append('\\');
                buffer.append(c);
                continue;
            }
            if (escapeType != 1 && (i == 0 || i == string.length() - 1) && c == ' ') {
                buffer.append("\\u0020");
                continue;
            }
            buffer.append(c);
        }
        if (escapeType == 4) {
            buffer.append("\"");
        } else if (escapeType == 5) {
            buffer.append("]");
        }
        return buffer;
    }

    public void addBlankLine() {
        this.list.add(new Comment(""));
    }

    public void addComment(String comment) {
        this.list.add(new Comment(comment));
    }

    public void addProperty(String name, String value) {
        if (this.map.containsProperty(name)) {
            throw new IllegalArgumentException(Message.format((String)RB.getStringResource(RB_KEY, "PropertyAlreadyDefined.fmt"), (Object)PropertyList.escapeString(null, null, name, 4)));
        }
        this.map.setProperty(name, value);
        this.list.add(name);
    }

    public void addProperty(String name, PropertyList nestedList) {
        if (this.map.containsNestedProperty(name)) {
            throw new IllegalArgumentException(Message.format((String)RB.getStringResource(RB_KEY, "PropertyAlreadyDefined.fmt"), (Object)PropertyList.escapeString(null, null, name, 4)));
        }
        for (CharSequence entry : nestedList.list) {
            if (entry instanceof Comment) {
                this.list.add(entry);
                continue;
            }
            this.addProperty(name + "." + entry, nestedList.getMap().getProperty((String)entry));
        }
    }

    public void addProperty(String name, int index, String value) {
        if (index < 0) {
            throw new IllegalArgumentException(RB.getStringResource(RB_KEY, "InvalidPropertyIndex.log"));
        }
        String propname = name + "[" + Integer.toString(index) + "]";
        this.addProperty(propname, value);
    }

    public void addProperty(String name, int index, PropertyList nestedList) {
        if (index < 0) {
            throw new IllegalArgumentException(RB.getStringResource(RB_KEY, "InvalidPropertyIndex.log"));
        }
        String propname = name + "[" + Integer.toString(index) + "]";
        if (this.map.containsNestedProperty(propname)) {
            throw new IllegalArgumentException(Message.format((String)RB.getStringResource(RB_KEY, "PropertyAlreadyDefined.fmt"), (Object)PropertyList.escapeString(null, null, name, 4)));
        }
        this.addProperty(propname, nestedList);
    }

    public PropertyMap getMap() {
        return this.map;
    }

    public boolean isEmpty() {
        return this.list.isEmpty();
    }

    protected CommonLoggerInterface getLogger2() {
        if (null == this.logger) {
            this.logger = LoggerRepository2.getLogger(this.getClass().getName(), new Log4JFactory2());
        }
        return this.logger;
    }

    protected static class Comment
    implements CharSequence,
    Serializable {
        private static final long serialVersionUID = 1L;
        String comment;

        public Comment(String comment) {
            this.comment = comment.startsWith("#") || comment.startsWith("!") || comment.length() == 0 ? comment : "# " + comment;
        }

        @Override
        public char charAt(int index) {
            return this.comment.charAt(index);
        }

        @Override
        public int length() {
            return this.comment.length();
        }

        @Override
        public CharSequence subSequence(int start, int end) {
            return this.comment.subSequence(start, end);
        }

        public boolean equals(Object obj) {
            return this.comment.equals(obj);
        }

        public int hashCode() {
            return this.comment.hashCode();
        }

        @Override
        public String toString() {
            return this.comment.toString();
        }
    }
}

