/*
 * Decompiled with CFR 0.152.
 */
package com.sas.storage.editableproperties;

import com.sas.storage.editableproperties.LocalizedResourceBundleFactory;
import com.sas.storage.editableproperties.PropertyMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;

public class LocalizedResourceBundle {
    LocalizedResourceBundleFactory factory;
    List<PropertyMap> maps;

    LocalizedResourceBundle(LocalizedResourceBundleFactory factory, Locale locale) {
        this.factory = factory;
        this.maps = new ArrayList<PropertyMap>(4);
        if (locale != null) {
            String locale2;
            if (factory.resources.containsSection(locale.toString())) {
                this.maps.add(factory.resources.getSection(locale.toString()));
            }
            if (locale.getVariant().length() > 0 && locale.getCountry().length() > 0 && factory.resources.containsSection(locale2 = locale.getLanguage() + "_" + locale.getCountry())) {
                this.maps.add(factory.resources.getSection(locale2));
            }
            if (locale.getCountry().length() > 0 && (locale.getVariant().length() > 0 || locale.getLanguage().length() > 0) && factory.resources.containsSection(locale.getLanguage())) {
                this.maps.add(factory.resources.getSection(locale.getLanguage()));
            }
        }
        if (factory.resources.containsSection("")) {
            this.maps.add(factory.resources.getSection(""));
        }
    }

    public String getResource(String key) {
        for (PropertyMap map : this.maps) {
            if (!map.containsProperty(key)) continue;
            return map.getProperty(key);
        }
        return null;
    }

    public boolean containsResource(String key) {
        for (PropertyMap map : this.maps) {
            if (!map.containsProperty(key)) continue;
            return true;
        }
        return false;
    }
}

