/*
 * Decompiled with CFR 0.152.
 */
package com.sas.storage.editableproperties;

import com.sas.codepolicy.SASScope;
import com.sas.storage.editableproperties.RB;
import com.sas.storage.editableproperties.SectionedPropertyMap;
import com.sas.text.Message;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.charset.Charset;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.logging.log4j.Logger;

@SASScope
public class LocalizationUtil2 {
    static final String LOCPROP_EXTENSION = ".locprop";

    public static SectionedPropertyMap getLocalizableProperties(Logger logger, File baseFile) {
        String propFilename;
        SectionedPropertyMap properties = new SectionedPropertyMap();
        File baseDir = baseFile.getParentFile();
        File propFile = null;
        String baseName = baseFile.getName();
        Locale locale = Locale.getDefault();
        if (locale.getLanguage().length() == 0) {
            return null;
        }
        if (locale.getCountry().length() > 0) {
            propFilename = baseName + "_" + locale.getLanguage() + "_" + locale.getCountry() + LOCPROP_EXTENSION;
            propFile = baseDir != null ? new File(baseDir, propFilename) : new File(propFilename);
            if (!propFile.exists()) {
                propFile = null;
            }
        }
        if (propFile == null) {
            propFilename = baseName + "_" + locale.getLanguage() + LOCPROP_EXTENSION;
            propFile = baseDir != null ? new File(baseDir, propFilename) : new File(propFilename);
            if (!propFile.exists()) {
                return null;
            }
        }
        try {
            InputStreamReader rdr = new InputStreamReader((InputStream)new FileInputStream(propFile), Charset.forName("US-ASCII"));
            properties = new SectionedPropertyMap();
            properties.load(rdr);
            ((Reader)rdr).close();
            logger.info(Message.format((ResourceBundle)RB.getResources(), (String)"LocalizationUtil.LoadLocalizableProperties.fmt.txt", (Object)propFile.getPath()));
        }
        catch (IOException e) {
            properties = null;
            logger.warn(Message.format((ResourceBundle)RB.getResources(), (String)"LocalizationUtil.ReadError.fmt.txt", (Object)propFile.getPath()));
        }
        catch (SecurityException e) {
            properties = null;
            logger.warn(Message.format((ResourceBundle)RB.getResources(), (String)"LocalizationUtil.ReadError.fmt.txt", (Object)propFile.getPath()));
        }
        return properties;
    }

    public static Map<Locale, SectionedPropertyMap> getMultiLocaleProperties(Logger logger, File baseFile) {
        HashMap<Locale, SectionedPropertyMap> properties = new HashMap<Locale, SectionedPropertyMap>();
        File baseDir = baseFile.getParentFile();
        String[] files = baseDir == null ? new File(".").list() : baseDir.list();
        Pattern pattern = Pattern.compile("\\Q" + baseFile.getName() + "\\E_(\\p{Alpha}{2})(_(\\p{Alpha}{2}))?\\Q" + LOCPROP_EXTENSION + "\\E");
        for (String file : files) {
            Matcher m = pattern.matcher(file);
            if (!m.matches()) continue;
            String language = m.group(1).toLowerCase();
            String country = m.group(3);
            Locale fileLocale = country == null ? new Locale(language) : new Locale(language, country.toUpperCase());
            File propFile = baseDir != null ? new File(baseDir, file) : new File(file);
            try {
                InputStreamReader rdr = new InputStreamReader((InputStream)new FileInputStream(propFile), Charset.forName("US-ASCII"));
                SectionedPropertyMap localeMap = new SectionedPropertyMap();
                localeMap.load(rdr);
                ((Reader)rdr).close();
                properties.put(fileLocale, localeMap);
                if (null == logger) continue;
                logger.info(Message.format((ResourceBundle)RB.getResources(), (String)"LocalizationUtil.LoadLocalizableProperties.fmt.txt", (Object)propFile.getPath()));
            }
            catch (IOException e) {
                if (null == logger) continue;
                logger.warn(Message.format((ResourceBundle)RB.getResources(), (String)"LocalizationUtil.ReadError.fmt.txt", (Object)propFile.getPath()));
            }
            catch (SecurityException e) {
                if (null == logger) continue;
                logger.warn(Message.format((ResourceBundle)RB.getResources(), (String)"LocalizationUtil.ReadError.fmt.txt", (Object)propFile.getPath()));
            }
        }
        return properties;
    }

    public static Map<Locale, SectionedPropertyMap> getMultiLocalePropertiesFromURL(Logger logger, URL baseURL) {
        HashMap<Locale, SectionedPropertyMap> properties = new HashMap<Locale, SectionedPropertyMap>();
        String basePath = baseURL.getPath();
        int dotOffset = basePath.lastIndexOf(46);
        if (!(dotOffset <= 0 || basePath.contains("/") && dotOffset <= basePath.indexOf("/"))) {
            basePath = basePath.substring(0, dotOffset);
        }
        try {
            for (Locale locale : Locale.getAvailableLocales()) {
                String path = basePath + "_" + locale.toString() + LOCPROP_EXTENSION;
                URL locpropURL = new URL(baseURL, path);
                try {
                    InputStream stream = locpropURL.openStream();
                    if (stream == null) continue;
                    InputStreamReader rdr = new InputStreamReader(stream, Charset.forName("US-ASCII"));
                    SectionedPropertyMap localeMap = new SectionedPropertyMap();
                    localeMap.load(rdr);
                    ((Reader)rdr).close();
                    properties.put(locale, localeMap);
                    logger.info(Message.format((ResourceBundle)RB.getResources(), (String)"LocalizationUtil.LoadLocalizableProperties.fmt.txt", (Object)path));
                }
                catch (IOException e) {
                    // empty catch block
                }
            }
        }
        catch (MalformedURLException e1) {
            logger.error("Unexpected locprop URL error", (Throwable)e1);
        }
        return properties;
    }

    public static Locale getDefaultLocale(Set<Locale> locales) {
        Locale locale = Locale.getDefault();
        if (locales.contains(locale)) {
            return locale;
        }
        if (locale.getVariant() != null && locale.getVariant().length() > 0 && locales.contains(locale = new Locale(locale.getLanguage(), locale.getCountry()))) {
            return locale;
        }
        if (locales.contains(locale = new Locale(locale.getLanguage()))) {
            return locale;
        }
        return null;
    }
}

