/*
 * Decompiled with CFR 0.152.
 */
package com.sas.prompts.datatypes.values;

import com.sas.MissingValues;
import com.sas.SpecialValues;
import com.sas.models.AnnotatedValueInterface;
import com.sas.models.EncodingInterface;
import com.sas.models.FileLocationInterface;
import com.sas.models.FontInfoInterface;
import com.sas.models.HyperlinkInterface;
import com.sas.models.OLAPMemberNameInterface;
import com.sas.models.SASLibraryLocationInterface;
import com.sas.models.datasources.DataSourceColumnInterface;
import com.sas.models.datasources.DataSourceInterface;
import com.sas.models.metadataSource.MetadataSource;
import com.sas.prompts.datatypes.values.AnnotatedValue;
import com.sas.prompts.datatypes.values.BasePersistedValue;
import com.sas.prompts.datatypes.values.BooleanValue;
import com.sas.prompts.datatypes.values.CollectionValue;
import com.sas.prompts.datatypes.values.ColorValue;
import com.sas.prompts.datatypes.values.DataSourceColumnValue;
import com.sas.prompts.datatypes.values.DataSourceValue;
import com.sas.prompts.datatypes.values.DateRangeValue;
import com.sas.prompts.datatypes.values.DateValue;
import com.sas.prompts.datatypes.values.DoubleRangeValue;
import com.sas.prompts.datatypes.values.DoubleValue;
import com.sas.prompts.datatypes.values.FileLocationValue;
import com.sas.prompts.datatypes.values.FontValue;
import com.sas.prompts.datatypes.values.HyperlinkValue;
import com.sas.prompts.datatypes.values.IntegerRangeValue;
import com.sas.prompts.datatypes.values.IntegerValue;
import com.sas.prompts.datatypes.values.MaskedValue;
import com.sas.prompts.datatypes.values.MetadataSourceValue;
import com.sas.prompts.datatypes.values.MissingValue;
import com.sas.prompts.datatypes.values.MonthValue;
import com.sas.prompts.datatypes.values.NullValue;
import com.sas.prompts.datatypes.values.OLAPMemberNameValue;
import com.sas.prompts.datatypes.values.QuarterValue;
import com.sas.prompts.datatypes.values.SASLibraryLocationValue;
import com.sas.prompts.datatypes.values.SpecialValue;
import com.sas.prompts.datatypes.values.StringRangeValue;
import com.sas.prompts.datatypes.values.StringValue;
import com.sas.prompts.datatypes.values.TimeValue;
import com.sas.prompts.datatypes.values.TimestampValue;
import com.sas.prompts.datatypes.values.WeekValue;
import com.sas.prompts.datatypes.values.WeekdayValue;
import com.sas.prompts.datatypes.values.YearValue;
import com.sas.util.DatePeriod;
import com.sas.util.DateTypes;
import com.sas.util.xmlpersist.PersistenceInterface;
import java.awt.Color;
import java.util.Date;
import java.util.List;

public class ValueUtil {
    public static PersistenceInterface getPersistableValue(Object value) {
        BasePersistedValue persistableValue = null;
        if (value instanceof String) {
            persistableValue = new StringValue();
        } else if (value instanceof EncodingInterface) {
            persistableValue = new MaskedValue(((EncodingInterface)value).getEncoding());
        } else if (value instanceof Integer) {
            persistableValue = new IntegerValue();
        } else if (value instanceof Double) {
            persistableValue = new DoubleValue();
        } else if (value instanceof Boolean) {
            persistableValue = new BooleanValue();
        } else if (value instanceof DatePeriod) {
            DateTypes dateType = ((DatePeriod)value).getPeriodType();
            persistableValue = dateType == DateTypes.YEAR ? new YearValue() : (dateType == DateTypes.QUARTER ? new QuarterValue() : (dateType == DateTypes.MONTH ? new MonthValue() : (dateType == DateTypes.WEEK ? new WeekValue() : (dateType == DateTypes.WEEKDAY ? new WeekdayValue() : (dateType == DateTypes.TIME ? new TimeValue() : (dateType == DateTypes.TIMESTAMP ? new TimestampValue() : (dateType == DateTypes.HOUR ? new TimeValue() : (dateType == DateTypes.MINUTE ? new TimeValue() : new DateValue()))))))));
        } else if (value instanceof Date) {
            persistableValue = new DateValue();
        } else if (value instanceof MissingValues) {
            persistableValue = new MissingValue();
        } else if (value instanceof SpecialValues) {
            persistableValue = new SpecialValue();
        } else if (value instanceof List) {
            persistableValue = new CollectionValue();
        } else if (value instanceof Integer[]) {
            persistableValue = new IntegerRangeValue();
        } else if (value instanceof Double[]) {
            persistableValue = new DoubleRangeValue();
        } else if (value instanceof String[]) {
            persistableValue = new StringRangeValue();
        } else if (value instanceof Date[]) {
            persistableValue = new DateRangeValue();
        } else if (value instanceof String[]) {
            persistableValue = new StringRangeValue();
        } else if (value instanceof Color) {
            persistableValue = new ColorValue();
        } else if (value instanceof DataSourceInterface) {
            persistableValue = new DataSourceValue();
        } else if (value instanceof DataSourceColumnInterface) {
            persistableValue = new DataSourceColumnValue();
        } else if (value instanceof FileLocationInterface) {
            persistableValue = new FileLocationValue();
        } else if (value instanceof SASLibraryLocationInterface) {
            persistableValue = new SASLibraryLocationValue();
        } else if (value instanceof FontInfoInterface) {
            persistableValue = new FontValue();
        } else if (value instanceof HyperlinkInterface) {
            persistableValue = new HyperlinkValue();
        } else if (value instanceof SpecialValues) {
            persistableValue = new SpecialValue();
        } else if (value instanceof OLAPMemberNameInterface) {
            persistableValue = new OLAPMemberNameValue();
        } else if (value == null) {
            persistableValue = new NullValue();
        } else if (value instanceof AnnotatedValueInterface) {
            persistableValue = new AnnotatedValue();
        } else if (value instanceof MetadataSource) {
            persistableValue = new MetadataSourceValue();
        }
        if (persistableValue != null) {
            persistableValue.setValue(value);
        }
        return persistableValue;
    }
}

