/*
 * Decompiled with CFR 0.152.
 */
package com.sas.prompts.datatypes.values;

import com.sas.models.metadataSource.MetadataSource;
import com.sas.models.metadataSource.MetadataSourceImpl;
import com.sas.prompts.datatypes.values.BasePersistedValue;
import com.sas.util.xmlpersist.AttributesProvider;
import com.sas.util.xmlpersist.MetadataDescriptor;
import com.sas.util.xmlpersist.PromptsWritingContext;
import com.sas.util.xmlpersist.XmlUtil;
import com.sas.util.xmlpersist.impl.PersistHelper;
import com.sas.util.xmlpersist.impl.PersistenceFactory;
import java.util.HashMap;
import java.util.prefs.BackingStoreException;
import org.w3c.dom.Element;

public class MetadataSourceValue
extends BasePersistedValue {
    @Override
    public String getDefinitionElementName() {
        return "MetadataSource";
    }

    @Override
    public void consumeAttributes(AttributesProvider provider) {
        String dataSourceLocation = PersistHelper.parseSBIPUrl(provider.consumeAttr("targetURL"));
        MetadataSourceImpl newDataSource = new MetadataSourceImpl(dataSourceLocation);
        newDataSource.setMetadataType(provider.consumeAttr("type"));
        this.setValue(newDataSource);
        this.getLogger2().debug("consumeAttributes(), value was set to:", dataSourceLocation);
    }

    @Override
    protected void writeDefinition(Element element, PromptsWritingContext writingContext) throws BackingStoreException {
        if (null != this.getValue()) {
            super.writeDefinition(element, writingContext);
            MetadataSource dataSource = (MetadataSource)this.getValue();
            if (null != dataSource.getMetadataSourceURL()) {
                String absPath = PersistHelper.parseSBIPUrl(dataSource.getMetadataSourceURL());
                XmlUtil.setAttr(element, "targetURL", "URL::" + absPath);
                this.getLogger2().debug("writeDefinition(),metadataSourceURL: URL::", absPath);
            }
            if (null != dataSource.getMetadataType() && null != dataSource.getMetadataType()) {
                XmlUtil.setAttr(element, "type", dataSource.getMetadataType());
            }
            this.createMetadataDescriptor(dataSource, writingContext);
        } else {
            this.getLogger2().debug("writeDefinition(), No value to write");
        }
    }

    protected final void createMetadataDescriptor(MetadataSource dataSource, PromptsWritingContext writingContext) {
        MetadataDescriptor md = PersistenceFactory.newMetadataDescriptor(null);
        HashMap<String, String> info = new HashMap<String, String>();
        info.put("SBIP_URL", dataSource.getMetadataSourceURL());
        md.setAdditionalInfo(info);
        md.setType(dataSource.getMetadataType());
        writingContext.addMetadataDescriptor(md);
    }
}

