/*
 * Decompiled with CFR 0.152.
 */
package com.sas.prompts.datatypes.values;

import com.sas.models.Hyperlink;
import com.sas.models.HyperlinkInterface;
import com.sas.prompts.datatypes.values.BasePersistedValue;
import com.sas.util.LocalizableString;
import com.sas.util.xmlpersist.AttributesProvider;
import com.sas.util.xmlpersist.PromptsWritingContext;
import com.sas.util.xmlpersist.RelatedObjectListsHolder;
import com.sas.util.xmlpersist.XmlUtil;
import com.sas.util.xmlpersist.impl.LocalizedText;
import java.util.ArrayList;
import java.util.List;
import java.util.prefs.BackingStoreException;
import org.w3c.dom.Element;
import org.xml.sax.SAXException;

public class HyperlinkValue
extends BasePersistedValue {
    @Override
    public String getDefinitionElementName() {
        return "Hyperlink";
    }

    @Override
    public void consumeAttributes(AttributesProvider provider) {
        super.consumeAttributes(provider);
        String hyperlinkLocation = provider.consumeAttr("dataSourceLocation");
        Hyperlink newHyperlink = new Hyperlink();
        newHyperlink.setLinkLocation(hyperlinkLocation);
        this.setValue(newHyperlink);
        this.getLogger2().debug("consumeAttributes(), value was set to:", hyperlinkLocation);
    }

    @Override
    public void consumeRelatedObjects(RelatedObjectListsHolder roHolder) throws SAXException {
        super.consumeRelatedObjects(roHolder);
        ArrayList labelList = roHolder.consumeObjects("Label");
        if (labelList != null && labelList.size() > 0) {
            LocalizableString label = LocalizedText.fromPersistableList(labelList);
            Hyperlink hyperlink = (Hyperlink)this.getValue();
            hyperlink.setLinkLabel(label);
        }
    }

    @Override
    protected void writeDefinition(Element element, PromptsWritingContext writingContext) throws BackingStoreException {
        if (null != this.getValue()) {
            super.writeDefinition(element, writingContext);
            HyperlinkInterface hyperlink = (HyperlinkInterface)this.getValue();
            List list = LocalizedText.getPersistableList(hyperlink.getLinkLabel(), null);
            if (!list.isEmpty()) {
                this.getLogger2().debug("Writing labels.");
                HyperlinkValue.writeRelatedObjects(list, element, writingContext, "Label");
            }
            XmlUtil.setAttr(element, "dataSourceLocation", hyperlink.getLinkLocation());
        } else {
            this.getLogger2().debug("No value to write");
        }
    }
}

