/*
 * Decompiled with CFR 0.152.
 */
package com.sas.prompts.datatypes.values;

import com.sas.models.datasources.BaseDataSource;
import com.sas.models.datasources.DataSourceInterface;
import com.sas.prompts.datatypes.values.BasePersistedValue;
import com.sas.util.xmlpersist.AttributesProvider;
import com.sas.util.xmlpersist.MetadataDescriptor;
import com.sas.util.xmlpersist.PromptsWritingContext;
import com.sas.util.xmlpersist.XmlUtil;
import com.sas.util.xmlpersist.impl.PersistHelper;
import com.sas.util.xmlpersist.impl.PersistenceFactory;
import java.util.HashMap;
import java.util.prefs.BackingStoreException;
import org.w3c.dom.Element;

public class DataSourceValue
extends BasePersistedValue {
    @Override
    public String getDefinitionElementName() {
        return "DataSource";
    }

    @Override
    public void consumeAttributes(AttributesProvider provider) {
        Long dataSourceType = provider.consumeLongAttr("dataSourceType", 0L);
        String dataSourceLocation = PersistHelper.parseSBIPUrl(provider.consumeAttr("dataSourceLocation"));
        BaseDataSource newDataSource = new BaseDataSource(dataSourceType.longValue(), dataSourceLocation);
        this.setValue(newDataSource);
        this.getLogger2().debug("consumeAttributes(), value was set to:", dataSourceType + " : " + dataSourceLocation);
    }

    @Override
    protected void writeDefinition(Element element, PromptsWritingContext writingContext) throws BackingStoreException {
        if (null != this.getValue()) {
            super.writeDefinition(element, writingContext);
            DataSourceInterface dataSource = (DataSourceInterface)this.getValue();
            XmlUtil.setLongAttr(element, "dataSourceType", dataSource.getDataSourceType());
            if (null != dataSource.getDataSourceLocation()) {
                String absPath = PersistHelper.parseSBIPUrl(dataSource.getDataSourceLocation());
                XmlUtil.setAttr(element, "dataSourceLocation", "URL::" + absPath);
                this.getLogger2().debug("writeDefinition(),dataSourceLocation: URL::", absPath);
            }
            this.createMetadataDescriptor(dataSource, writingContext);
        } else {
            this.getLogger2().debug("No value to write");
        }
    }

    protected final void createMetadataDescriptor(DataSourceInterface dataSource, PromptsWritingContext writingContext) {
        MetadataDescriptor md = PersistenceFactory.newMetadataDescriptor(null);
        HashMap<String, String> info = new HashMap<String, String>();
        info.put("SBIP_URL", dataSource.getDataSourceLocation());
        md.setAdditionalInfo(info);
        long type = dataSource.getDataSourceType();
        if (type == 1L) {
            md.setType("PHYSICAL_TABLE");
        } else if (type == 4L || type == 8L) {
            md.setType("INFORMATION_MAP");
        } else if (type == 2L) {
            md.setType("OLAP_CUBE");
        }
        writingContext.addMetadataDescriptor(md);
    }
}

