/*
 * Decompiled with CFR 0.152.
 */
package com.sas.prompts.datatypes.values;

import com.sas.models.datasources.BaseDataSourceColumn;
import com.sas.models.datasources.DataSourceColumnInterface;
import com.sas.models.datasources.DataSourceInterface;
import com.sas.prompts.datatypes.values.BasePersistedValue;
import com.sas.prompts.datatypes.values.DataSourceValue;
import com.sas.prompts.datatypes.values.ValueUtil;
import com.sas.util.Strings;
import com.sas.util.xmlpersist.AttributesProvider;
import com.sas.util.xmlpersist.PersistenceInterface;
import com.sas.util.xmlpersist.PromptsWritingContext;
import com.sas.util.xmlpersist.RelatedObjectListsHolder;
import com.sas.util.xmlpersist.XmlUtil;
import java.util.ArrayList;
import java.util.prefs.BackingStoreException;
import org.w3c.dom.Element;
import org.xml.sax.SAXException;

public class DataSourceColumnValue
extends BasePersistedValue {
    @Override
    public String getDefinitionElementName() {
        return "DataSourceColumn";
    }

    @Override
    public void consumeAttributes(AttributesProvider provider) {
        Long columnType = provider.consumeLongAttr("columnType", 0L);
        String columnName = provider.consumeAttr("columnName");
        String columnLabel = provider.consumeAttr("columnLabel");
        BaseDataSourceColumn newDataSourceColumn = new BaseDataSourceColumn(null, columnName, columnLabel, columnType.longValue());
        this.setValue(newDataSourceColumn);
        this.getLogger2().debug("consumeAttributes(), value was set to:", columnType + " : " + columnName);
    }

    @Override
    public void consumeRelatedObjects(RelatedObjectListsHolder roHolder) throws SAXException {
        ArrayList list;
        super.consumeRelatedObjects(roHolder);
        if (null != this.getValue() && !(list = roHolder.consumeObjects("DataSource")).isEmpty()) {
            this.getLogger2().debug("consumeRelObjects, DataSource ");
            DataSourceValue dataSourceValue = (DataSourceValue)list.get(0);
            ((BaseDataSourceColumn)this.getValue()).setDataSource((DataSourceInterface)dataSourceValue.getValue());
        }
    }

    @Override
    protected void writeDefinition(Element element, PromptsWritingContext writingContext) throws BackingStoreException {
        if (null != this.getValue()) {
            super.writeDefinition(element, writingContext);
            DataSourceColumnInterface dataSourceColumn = (DataSourceColumnInterface)this.getValue();
            XmlUtil.setLongAttr(element, "columnType", dataSourceColumn.getColumnType());
            String colName = dataSourceColumn.getColumnName();
            String colLabel = dataSourceColumn.getColumnLabel();
            XmlUtil.setAttr(element, "columnName", colName);
            if (!Strings.equal((String)colName, (String)colLabel, (boolean)false, (boolean)false)) {
                XmlUtil.setAttr(element, "columnLabel", colLabel);
            }
            ArrayList<PersistenceInterface> valueObjects = new ArrayList<PersistenceInterface>();
            PersistenceInterface itemValue = ValueUtil.getPersistableValue(dataSourceColumn.getDataSource());
            valueObjects.add(itemValue);
            DataSourceColumnValue.writeRelatedObjects(valueObjects, element, writingContext, "DataSource");
        } else {
            this.getLogger2().debug("No value to write");
        }
    }
}

