/*
 * Decompiled with CFR 0.152.
 */
package com.sas.prompts.datatypes.values;

import com.sas.datatypes.DataTypeInterface;
import com.sas.models.AnnotatedValueInterface;
import com.sas.models.SimpleAnnotatedValue;
import com.sas.prompts.datatypes.values.BasePersistedValue;
import com.sas.prompts.datatypes.values.ValueUtil;
import com.sas.util.xmlpersist.PersistenceInterface;
import com.sas.util.xmlpersist.PromptsWritingContext;
import com.sas.util.xmlpersist.RelatedObjectListsHolder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Locale;
import java.util.prefs.BackingStoreException;
import org.w3c.dom.Element;
import org.xml.sax.SAXException;

public class AnnotatedValue
extends BasePersistedValue {
    private DataTypeInterface partialDataType;

    @Override
    public String getDefinitionElementName() {
        return "AnnotatedValue";
    }

    @Override
    public void consumeRelatedObjects(RelatedObjectListsHolder roHolder) throws SAXException {
        Object valueHolderValue;
        super.consumeRelatedObjects(roHolder);
        ArrayList valueHolder = roHolder.consumeObjects("Value");
        ArrayList annotations = roHolder.consumeObjects("Annotations");
        SimpleAnnotatedValue value = new SimpleAnnotatedValue();
        if (valueHolder != null && valueHolder.size() > 0 && (valueHolderValue = valueHolder.get(0)) instanceof BasePersistedValue) {
            value.setValue(((BasePersistedValue)valueHolderValue).getValue(), Locale.US);
        }
        if (annotations != null) {
            for (Object annotation : annotations) {
                if (!(annotation instanceof BasePersistedValue)) continue;
                String key = ((BasePersistedValue)annotation).getKey();
                Object annotationValue = ((BasePersistedValue)annotation).getValue();
                value.setAnnotationValue(key, annotationValue, Locale.US);
            }
        }
        this.setValue(value);
    }

    @Override
    protected void writeDefinition(Element element, PromptsWritingContext writingContext) throws BackingStoreException {
        if (null != this.getValue()) {
            super.writeDefinition(element, writingContext);
            AnnotatedValueInterface value = (AnnotatedValueInterface)this.getValue();
            ArrayList<PersistenceInterface> valueObjects = new ArrayList<PersistenceInterface>(1);
            PersistenceInterface itemValue = ValueUtil.getPersistableValue(value.getValue());
            valueObjects.add(itemValue);
            AnnotatedValue.writeRelatedObjects(valueObjects, element, writingContext, "Value");
            Collection keys = value.getAnnotationKeys();
            ArrayList<PersistenceInterface> valueObjects2 = new ArrayList<PersistenceInterface>(keys.size());
            for (String key : keys) {
                PersistenceInterface itemValue2 = ValueUtil.getPersistableValue(value.getAnnotationValue(key));
                if (itemValue2 instanceof BasePersistedValue) {
                    ((BasePersistedValue)itemValue2).setKey(key);
                }
                valueObjects2.add(itemValue2);
            }
            AnnotatedValue.writeRelatedObjects(valueObjects2, element, writingContext, "Annotations");
        } else {
            this.getLogger2().debug("No value to write");
        }
    }
}

