/*
 * Decompiled with CFR 0.152.
 */
package com.sas.framework.personalization;

import com.ibm.icu.text.DateFormat;
import com.ibm.icu.text.SimpleDateFormat;
import com.sas.framework.personalization.AbstractDateTimeFormat;
import com.sas.framework.personalization.CurrencyDisplay;
import com.sas.framework.personalization.CurrencyNumberFormat;
import com.sas.framework.personalization.LongDateFormat;
import com.sas.framework.personalization.ShortDateFormat;
import com.sas.framework.personalization.TimeDateFormat;
import com.sas.framework.personalization.TimeFormat;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.text.NumberFormat;
import java.text.ParseException;
import java.util.Collections;
import java.util.Currency;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.Locale;
import java.util.Map;

public class PreferredFormat {
    private static Map dateFormatMap = Collections.synchronizedMap(new LinkedHashMap(){
        private static final long serialVersionUID = 1L;

        protected boolean removeEldestEntry(Map.Entry eldest) {
            return this.size() > 100;
        }
    });

    private PreferredFormat() {
    }

    public static String getShortDate(ShortDateFormat sdf, Date date, Locale locale) {
        DateFormat df = PreferredFormat.getDateFormat(sdf, locale);
        return df.format(date);
    }

    public static String getTimeDate(TimeDateFormat tdf, Date date, Locale locale) {
        DateFormat df = PreferredFormat.getDateFormat(tdf, locale);
        return df.format(date);
    }

    public static String getTime(TimeFormat tf, Date date, Locale locale) {
        DateFormat df = PreferredFormat.getDateFormat(tf, locale);
        return df.format(date);
    }

    public static String getLongDate(LongDateFormat ldf, Date date, Locale locale) {
        DateFormat df = PreferredFormat.getDateFormat(ldf, locale);
        return df.format(date);
    }

    public static String getCurrencyValue(CurrencyNumberFormat cnf, CurrencyDisplay cd, double value, String isoCurrencyCode, Locale locale) {
        return PreferredFormat.getCurrencyValue(cnf, cd, value, isoCurrencyCode, locale, -1);
    }

    public static String getCurrencyValue(CurrencyNumberFormat cnf, CurrencyDisplay cd, double value, String isoCurrencyCode, Locale locale, int decimals) {
        String retval = null;
        DecimalFormat df = (DecimalFormat)NumberFormat.getCurrencyInstance(locale);
        if (decimals >= 0) {
            df.setMaximumFractionDigits(decimals);
            if (decimals > 0) {
                df.setMinimumFractionDigits(decimals);
            }
        }
        DecimalFormatSymbols dfs = df.getDecimalFormatSymbols();
        Currency currency = Currency.getInstance(isoCurrencyCode);
        if (((Object)((Object)cd)).equals((Object)CurrencyDisplay.SYMBOL)) {
            dfs.setCurrencySymbol(currency.getSymbol(locale));
            df.setDecimalFormatSymbols(dfs);
        } else if (((Object)((Object)cd)).equals((Object)CurrencyDisplay.ISOCODE)) {
            dfs.setCurrencySymbol(currency.getCurrencyCode());
            df.setDecimalFormatSymbols(dfs);
        }
        retval = value < 0.0 ? (((Object)((Object)cnf)).equals((Object)CurrencyNumberFormat.PARENTHESIS) ? "(" + df.format(Math.abs(value)) + ")" : "-" + df.format(Math.abs(value))) : df.format(value);
        return retval;
    }

    private static DateFormat getDateFormat(AbstractDateTimeFormat e, Locale locale) {
        String label = e.getPattern(locale);
        DateFormat df = (DateFormat)dateFormatMap.get(label);
        if (null == df) {
            df = new SimpleDateFormat(label, locale);
            dateFormatMap.put(label, df);
        }
        return df;
    }

    @Deprecated
    public static Date isDateValid(String newDateString, String dateFormat) throws ParseException {
        SimpleDateFormat parser = new SimpleDateFormat(dateFormat);
        Date date = parser.parse(newDateString);
        return date;
    }

    public static Date parseDate(String newDateString, String dateFormat) throws ParseException {
        SimpleDateFormat parser = new SimpleDateFormat(dateFormat);
        Date date = parser.parse(newDateString);
        return date;
    }
}

