/*
 * Decompiled with CFR 0.152.
 */
package com.sas.framework.personalization;

import com.sas.framework.personalization.i18n.RB;
import java.util.EnumSet;
import java.util.Locale;
import java.util.Set;

public enum NotificationDeliveryType {
    USER_PREFERENCE(16, "userpreference"),
    MAIL(32, "email"),
    PORTLET(64, "portlet"),
    SMS(128, "sms"),
    DIGEST(256, "digest");

    private static final String RB_KEY = "Enum.NotificationDeliveryType";
    private final short bitValue;
    private final String resourceKey;

    private NotificationDeliveryType(short bitValue, String resourceKey) {
        this.bitValue = bitValue;
        this.resourceKey = resourceKey;
    }

    public String getLabel(Locale locale) {
        return RB.get("Enum.NotificationDeliveryType." + this.resourceKey + ".txt", locale);
    }

    public short getValue() {
        return this.bitValue;
    }

    public static short union(NotificationDeliveryType ... values) {
        for (NotificationDeliveryType type : values) {
            if (type != USER_PREFERENCE) continue;
            throw new IllegalArgumentException("Cannot include USER_PREFERENCE in a union...");
        }
        short result = 0;
        for (NotificationDeliveryType type : values) {
            result = (short)(result + type.bitValue);
        }
        return result;
    }

    public static Set<NotificationDeliveryType> parse(short value) {
        EnumSet<NotificationDeliveryType> set = EnumSet.noneOf(NotificationDeliveryType.class);
        for (NotificationDeliveryType type : NotificationDeliveryType.values()) {
            if ((value & type.bitValue) != type.bitValue) continue;
            set.add(type);
        }
        return set;
    }
}

