/*
 * Decompiled with CFR 0.152.
 */
package com.sas.services.webdav;

import com.sas.codepolicy.SASScope;
import com.sas.services.webdav.DavPropertyItem;
import com.sas.services.webdav.GetPropertyAction;
import com.sas.services.webdav.NamespaceRegistry;
import com.sas.services.webdav.RB;
import com.sas.services.webdav.TransformerFactoryFactory;
import com.sas.text.Message;
import java.io.InputStream;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.nio.charset.StandardCharsets;
import java.security.AccessController;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.ResourceBundle;
import java.util.regex.Pattern;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import org.apache.jackrabbit.webdav.property.DavProperty;
import org.jdom2.input.DOMBuilder;
import org.jdom2.output.Format;
import org.jdom2.output.XMLOutputter;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;
import org.xml.sax.InputSource;

@SASScope
public class XMLUtil {
    private static final String NODE = "node";
    public static final String XML_VERSION = "1.0";
    public static final String CHARSET_ENCODING_UTF8 = "utf-8";
    public static final String CHARSET_ENCODING = "utf-8";
    private static final String REGEX_XML_DECLARATION = "<\\?xml.*>\\s";
    private static final Pattern REGEX_PATTERN_XML_DECLARATION = Pattern.compile("<\\?xml.*>\\s");
    public static final String W3C_XML_SCHEMA = "http://www.w3.org/2001/XMLSchema";
    public static final String W3C_XML_SCHEMAINSTANCE = "http://www.w3.org/2001/XMLSchema-instance";
    public static final String JAXP_PROPERTY_SCHEMALANGUAGE = "http://java.sun.com/xml/jaxp/properties/schemaLanguage";
    public static final String JAXP_PROPERTY_SCHEMASOURCE = "http://java.sun.com/xml/jaxp/properties/schemaSource";
    private static DocumentBuilder docBuilder = null;

    private XMLUtil() {
    }

    public static final String applyXSL(String input, String xsl) throws TransformerConfigurationException, TransformerException, IllegalArgumentException {
        return XMLUtil.applyXSL(input, xsl, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final String applyXSL(String input, String xsl, Map transformationParameters) throws TransformerConfigurationException, TransformerException, IllegalArgumentException {
        if (input == null) {
            throw new IllegalArgumentException(XMLUtil.getInvalidArgumentNullParameterMsg("input"));
        }
        if (xsl == null) {
            throw new IllegalArgumentException(XMLUtil.getInvalidArgumentNullParameterMsg("xsl"));
        }
        StringWriter result = new StringWriter(input.length());
        String string = XML_VERSION;
        synchronized (XML_VERSION) {
            TransformerFactory tFactory = TransformerFactoryFactory.newFactory();
            Transformer transformer = tFactory.newTransformer(new StreamSource(new StringReader(xsl)));
            if (transformationParameters != null && transformationParameters.size() > 0) {
                Iterator iter = transformationParameters.entrySet().iterator();
                Map.Entry mapEntry = null;
                while (iter.hasNext()) {
                    mapEntry = iter.next();
                    transformer.setParameter((String)mapEntry.getKey(), mapEntry.getValue());
                }
            }
            transformer.transform(new StreamSource(new StringReader(input)), new StreamResult(result));
            // ** MonitorExit[var4_4] (shouldn't be in output)
            return result.toString();
        }
    }

    public static final String convertNodeToString(Node node) throws IllegalArgumentException {
        if (node == null) {
            throw new IllegalArgumentException(XMLUtil.getInvalidArgumentNullMsg());
        }
        return XMLUtil.convertNodeToString(node, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final String convertNodeToString(Node node, Properties outputFormatProperties) throws IllegalArgumentException {
        String string;
        block9: {
            if (node == null) {
                throw new IllegalArgumentException(XMLUtil.getInvalidArgumentNullParameterMsg(NODE));
            }
            string = null;
            TransformerException ex = null;
            try {
                DOMSource domSource = new DOMSource(node);
                StringWriter stringWriter = new StringWriter();
                StreamResult streamResult = new StreamResult(stringWriter);
                TransformerFactory transformerFactory = TransformerFactoryFactory.newFactory();
                Transformer transformer = transformerFactory.newTransformer();
                if (outputFormatProperties != null && outputFormatProperties.size() > 0) {
                    transformer.setOutputProperties(outputFormatProperties);
                }
                transformer.transform(domSource, streamResult);
                string = stringWriter.toString();
            }
            catch (TransformerConfigurationException e) {
                ex = e;
                return ex;
            }
            catch (TransformerException e) {
                ex = e;
                return ex;
            }
            finally {
                if (ex == null) break block9;
                throw new IllegalArgumentException(ex.getLocalizedMessage());
            }
        }
        return string;
    }

    public static final String convertNodeToString(Node node, boolean isOmitXMLDeclarationInOutput) throws IllegalArgumentException {
        if (node == null) {
            throw new IllegalArgumentException(XMLUtil.getInvalidArgumentNullParameterMsg(NODE));
        }
        Properties outputFormatProperties = new Properties();
        if (isOmitXMLDeclarationInOutput) {
            outputFormatProperties.put("omit-xml-declaration", "yes");
        }
        return XMLUtil.convertNodeToString(node, outputFormatProperties);
    }

    public static final Document convertStringToDocument(String string) throws IllegalArgumentException {
        if (string == null) {
            throw new IllegalArgumentException(XMLUtil.getInvalidArgumentNullMsg());
        }
        Document document = null;
        try (StringReader stringReader = new StringReader(string);){
            document = XMLUtil.convertInputSourceToDocument(new InputSource(stringReader));
        }
        return document;
    }

    public static final Document convertStreamToDocument(InputStream stream) throws IllegalArgumentException {
        if (stream == null) {
            throw new IllegalArgumentException(XMLUtil.getInvalidArgumentNullMsg());
        }
        return XMLUtil.convertInputSourceToDocument(new InputSource(stream));
    }

    /*
     * Exception decompiling
     */
    public static final Document convertInputSourceToDocument(InputSource inputSource) throws IllegalArgumentException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public static String node2String(Node node) throws IllegalArgumentException {
        if (node == null) {
            throw new IllegalArgumentException(XMLUtil.getInvalidArgumentNullMsg());
        }
        StringBuilder pw = new StringBuilder();
        XMLUtil.print(node, null, pw);
        String value = pw.toString();
        return value;
    }

    private static void print(Node node, NamespaceRegistry namespaceStack, StringBuilder sbuilder) {
        if (node == null) {
            return;
        }
        boolean hasChildren = false;
        short type = node.getNodeType();
        switch (type) {
            case 9: {
                sbuilder.append("<?xml version=\"1.0\"?>\n");
                NodeList children = node.getChildNodes();
                if (children == null) break;
                int numChildren = children.getLength();
                for (int i = 0; i < numChildren; ++i) {
                    XMLUtil.print(children.item(i), namespaceStack, sbuilder);
                }
                break;
            }
            case 1: {
                NamedNodeMap attrs;
                namespaceStack = new NamespaceRegistry(namespaceStack);
                sbuilder.append('<' + node.getNodeName());
                String elPrefix = node.getPrefix();
                String elNamespaceURI = node.getNamespaceURI();
                if (elPrefix != null && elNamespaceURI != null) {
                    boolean prefixIsDeclared = false;
                    try {
                        String namespaceURI = namespaceStack.lookup(elPrefix);
                        if (elNamespaceURI.equals(namespaceURI)) {
                            prefixIsDeclared = true;
                        }
                    }
                    catch (IllegalArgumentException namespaceURI) {
                        // empty catch block
                    }
                    if (!prefixIsDeclared) {
                        XMLUtil.printNamespaceDecl(node, namespaceStack, sbuilder);
                    }
                }
                int len = (attrs = node.getAttributes()) != null ? attrs.getLength() : 0;
                for (int i = 0; i < len; ++i) {
                    Attr attr = (Attr)attrs.item(i);
                    sbuilder.append(' ' + attr.getNodeName() + "=\"" + XMLUtil.normalize(attr.getValue()) + '\"');
                    String attrPrefix = attr.getPrefix();
                    String attrNamespaceURI = attr.getNamespaceURI();
                    if (attrPrefix == null || attrNamespaceURI == null) continue;
                    boolean prefixIsDeclared = false;
                    try {
                        String namespaceURI = namespaceStack.lookup(attrPrefix);
                        if (attrNamespaceURI.equals(namespaceURI)) {
                            prefixIsDeclared = true;
                        }
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        // empty catch block
                    }
                    if (prefixIsDeclared) continue;
                    XMLUtil.printNamespaceDecl(attr, namespaceStack, sbuilder);
                }
                NodeList children = node.getChildNodes();
                if (children != null) {
                    int numChildren = children.getLength();
                    boolean bl = hasChildren = numChildren > 0;
                    if (hasChildren) {
                        sbuilder.append('>');
                    }
                    for (int i = 0; i < numChildren; ++i) {
                        XMLUtil.print(children.item(i), namespaceStack, sbuilder);
                    }
                } else {
                    hasChildren = false;
                }
                if (hasChildren) break;
                sbuilder.append("/>");
                break;
            }
            case 5: {
                sbuilder.append('&');
                sbuilder.append(node.getNodeName());
                sbuilder.append(';');
                break;
            }
            case 4: {
                sbuilder.append("<![CDATA[");
                sbuilder.append(node.getNodeValue());
                sbuilder.append("]]>");
                break;
            }
            case 3: {
                sbuilder.append(XMLUtil.normalize(node.getNodeValue()));
                break;
            }
            case 8: {
                sbuilder.append("<!--");
                sbuilder.append(node.getNodeValue());
                sbuilder.append("-->");
                break;
            }
            case 7: {
                sbuilder.append("<?");
                sbuilder.append(node.getNodeName());
                String data = node.getNodeValue();
                if (data != null && data.length() > 0) {
                    sbuilder.append(' ');
                    sbuilder.append(data);
                }
                sbuilder.append("?>\n");
                break;
            }
        }
        if (type == 1 && hasChildren) {
            sbuilder.append("</");
            sbuilder.append(node.getNodeName());
            sbuilder.append('>');
            hasChildren = false;
        }
    }

    public static String getAttributeNS(Element element, String namespaceURI, String localPart) {
        if (element == null) {
            throw new IllegalArgumentException(XMLUtil.getInvalidArgumentNullParameterMsg("element"));
        }
        Attr attr = element.getAttributeNodeNS(namespaceURI, localPart);
        return attr != null ? attr.getValue() : null;
    }

    private static void printNamespaceDecl(Node node, NamespaceRegistry namespaceStack, StringBuilder sbuilder) throws IllegalArgumentException {
        if (node == null) {
            throw new IllegalArgumentException(XMLUtil.getInvalidArgumentNullParameterMsg(NODE));
        }
        switch (node.getNodeType()) {
            case 2: {
                XMLUtil.printNamespaceDecl(((Attr)node).getOwnerElement(), node, namespaceStack, sbuilder);
                break;
            }
            case 1: {
                XMLUtil.printNamespaceDecl((Element)node, node, namespaceStack, sbuilder);
                break;
            }
        }
    }

    private static void printNamespaceDecl(Element owner, Node node, NamespaceRegistry namespaceStack, StringBuilder sbuilder) throws IllegalArgumentException {
        if (node == null) {
            throw new IllegalArgumentException(XMLUtil.getInvalidArgumentNullParameterMsg(NODE));
        }
        String namespaceURI = node.getNamespaceURI();
        String prefix = node.getPrefix();
        if (!namespaceURI.equals("http://www.w3.org/2000/xmlns/") || !prefix.equals("xmlns")) {
            if (XMLUtil.getAttributeNS(owner, "http://www.w3.org/2000/xmlns/", prefix) == null) {
                sbuilder.append(" xmlns:" + prefix + "=\"" + namespaceURI + '\"');
            }
        } else {
            prefix = node.getLocalName();
            namespaceURI = node.getNodeValue();
        }
        namespaceStack.register(prefix, namespaceURI);
    }

    public static String normalize(String s) {
        String lineSeparator = AccessController.doPrivileged(new GetPropertyAction("line.separator"));
        int strlen = s != null ? s.length() : 0;
        StringBuilder str = new StringBuilder(strlen + strlen / 10);
        block7: for (int i = 0; i < strlen; ++i) {
            char ch = s.charAt(i);
            switch (ch) {
                case '<': {
                    str.append("&lt;");
                    continue block7;
                }
                case '>': {
                    str.append("&gt;");
                    continue block7;
                }
                case '&': {
                    str.append("&amp;");
                    continue block7;
                }
                case '\"': {
                    str.append("&quot;");
                    continue block7;
                }
                case '\n': {
                    if (i > 0) {
                        char lastChar = str.charAt(str.length() - 1);
                        if (lastChar != '\r') {
                            str.append(lineSeparator);
                            continue block7;
                        }
                        str.append('\n');
                        continue block7;
                    }
                    str.append(lineSeparator);
                    continue block7;
                }
                default: {
                    str.append(ch);
                }
            }
        }
        return str.toString();
    }

    public static final String stripXMLDeclaration(String xml) {
        String value = xml;
        if (xml != null && REGEX_XML_DECLARATION != null) {
            value = REGEX_PATTERN_XML_DECLARATION.matcher(xml).replaceFirst("");
        }
        return value;
    }

    private static final String getInvalidArgumentNullMsg() {
        return RB.getStringResource("IllegalArgument.null.ex.txt");
    }

    private static final String getInvalidArgumentNullParameterMsg(Object nullParameterName) {
        return Message.format((ResourceBundle)RB.getResources(), (String)"IllegalArgument.null.ex.fmt.txt", (Object)nullParameterName);
    }

    public static DocumentBuilder newBuilder() throws ParserConfigurationException {
        if (docBuilder == null) {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            factory.setValidating(false);
            factory.setNamespaceAware(true);
            docBuilder = factory.newDocumentBuilder();
        }
        return docBuilder;
    }

    public static Document newDocument() throws ParserConfigurationException {
        return XMLUtil.newBuilder().newDocument();
    }

    public static List<String> getDavPropertyHrefs(DavProperty<?> davProperty) throws ParserConfigurationException {
        return XMLUtil.getHrefs(davProperty.toXml(XMLUtil.newDocument()));
    }

    private static List<String> getHrefs(Element element) {
        List<String> list = Collections.synchronizedList(new ArrayList());
        NodeList hrefNodes = XMLUtil.getElementsByTagNameNS(element, "href", "DAV:");
        if (hrefNodes != null) {
            for (int i = 0; i < hrefNodes.getLength(); ++i) {
                Node hrefNode = hrefNodes.item(i);
                String href = XMLUtil.getTextValue(hrefNode);
                if (href == null || href.length() <= 0) continue;
                list.add(href);
            }
        }
        return list;
    }

    public static NodeList getElementsByTagNameNS(Node node, String tagName, String namespace) {
        NodeList list = null;
        if (node == null) {
            return list;
        }
        if (!(node instanceof Document) && !(node instanceof Element)) {
            throw new IllegalArgumentException("The node parameter must be an Element or a Document node");
        }
        try {
            list = ((Element)node).getElementsByTagNameNS(namespace, tagName);
        }
        catch (NoSuchMethodError e) {
            List<Element> synchronizedList = Collections.synchronizedList(new ArrayList());
            XMLUtil.getChildElementsByTagNameNS(synchronizedList, node, tagName, namespace);
            list = new NodeListImpl(synchronizedList);
        }
        return list;
    }

    public static void getChildElementsByTagNameNS(List<Element> list, Node node, String tagName, String namespace) {
        NodeList nodeList = node.getChildNodes();
        if (null != nodeList) {
            for (int i = 0; i < nodeList.getLength(); ++i) {
                try {
                    Element element = (Element)nodeList.item(i);
                    if (tagName.equals(XMLUtil.getElementLocalName(element)) && namespace.equals(XMLUtil.getElementNamespaceURI(element))) {
                        list.add(element);
                        continue;
                    }
                    XMLUtil.getChildElementsByTagNameNS(list, element, tagName, namespace);
                    continue;
                }
                catch (ClassCastException classCastException) {
                    // empty catch block
                }
            }
        }
    }

    public static String getElementLocalName(Node element) {
        String localName;
        block3: {
            if (element == null) {
                throw new IllegalArgumentException("The element cannot be null");
            }
            localName = null;
            try {
                localName = element.getLocalName();
            }
            catch (NoSuchMethodError e) {
                int index;
                if (!(element instanceof Element) || (index = (localName = ((Element)element).getTagName()).indexOf(58)) <= 0 || index >= localName.length() - 1) break block3;
                localName = localName.substring(index + 1);
            }
        }
        return localName;
    }

    public static String getElementNamespaceURI(Node element) {
        if (element == null) {
            throw new IllegalArgumentException("The element cannot be null");
        }
        String namespace = null;
        try {
            namespace = element.getNamespaceURI();
        }
        catch (NoSuchMethodError e) {
            String tagName;
            int index;
            String attribute = "xmlns";
            if (element instanceof Element && (index = (tagName = ((Element)element).getTagName()).indexOf(58)) > 0 && index < tagName.length() - 1) {
                attribute = attribute + ':' + tagName.substring(0, index);
            }
            boolean found = false;
            for (Node node = element; !found && node != null; node = node.getParentNode()) {
                try {
                    String tmp = ((Element)node).getAttribute(attribute);
                    if (tmp == null || tmp.equals("")) continue;
                    namespace = tmp;
                    found = true;
                    continue;
                }
                catch (ClassCastException classCastException) {
                    // empty catch block
                }
            }
        }
        return namespace;
    }

    public static Element getFirstElement(Node node, String namespace, String name) {
        NodeList children = node.getChildNodes();
        if (children == null) {
            return null;
        }
        for (int i = 0; i < children.getLength(); ++i) {
            try {
                Element child = (Element)children.item(i);
                if (!name.equals(XMLUtil.getElementLocalName(child)) || !namespace.equals(XMLUtil.getElementNamespaceURI(child))) continue;
                return child;
            }
            catch (ClassCastException classCastException) {
                // empty catch block
            }
        }
        return null;
    }

    public static String getTextValue(Node node) {
        StringBuilder text = new StringBuilder();
        NodeList nodeList = node.getChildNodes();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            if (nodeList.item(i).getNodeType() == 3 || nodeList.item(i).getNodeType() == 4) {
                text.append(((Text)nodeList.item(i)).getData());
                continue;
            }
            text.append(XMLUtil.getTextValue(nodeList.item(i)));
        }
        return text.toString();
    }

    public static String getPropertyAsString(DavPropertyItem davPropertyItem) throws ParserConfigurationException {
        String value = "";
        int httpStatusCode = davPropertyItem.getStatusCode();
        if (200 == httpStatusCode) {
            String elementLocalName;
            Element element = davPropertyItem.getDavProperty().toXml(XMLUtil.newDocument());
            switch (elementLocalName = element.getLocalName()) {
                case "acl": {
                    value = XMLUtil.getPropertyAsStringAcl(element, davPropertyItem.getDavResourceHref());
                    break;
                }
                case "lockdiscovery": {
                    value = XMLUtil.getPropertyAsStringLockDiscovery(element);
                    break;
                }
                case "principal-collection-set": {
                    value = XMLUtil.getPropertyAsStringPrincipalCollectionSet(element);
                    break;
                }
                case "resourcetype": {
                    value = XMLUtil.getPropertyAsStringResourceType(element);
                    break;
                }
                case "supportedlock": {
                    value = XMLUtil.getPropertyAsStringSupportedLock(element);
                    break;
                }
                case "current-user-privilege-set": {
                    value = XMLUtil.getPropertyAsStringCurrentUserPrivilegeSet(element);
                    break;
                }
                case "href": 
                case "checked-in": 
                case "checked-out": 
                case "creationuser": 
                case "modificationuser": 
                case "owner": {
                    value = XMLUtil.getPropertyAsStringHREF(element);
                    break;
                }
                default: {
                    value = XMLUtil.getPropertyAsStringDefault(element);
                }
            }
        }
        return value;
    }

    private static String getPropertyAsStringHREF(Element element) {
        String hrefValue = "";
        Element href = XMLUtil.getFirstElement(element, "DAV:", "href");
        if (href != null) {
            hrefValue = XMLUtil.getTextValue(href);
        }
        return hrefValue;
    }

    private static String getPropertyAsStringDefault(Element element) {
        StringBuilder text = new StringBuilder();
        DOMBuilder builder = new DOMBuilder();
        XMLOutputter outputter = new XMLOutputter(Format.getPrettyFormat());
        org.jdom2.Element jdomElement = builder.build(element);
        List children = jdomElement.getChildren();
        if (!children.isEmpty()) {
            text.append(outputter.outputString(children));
        }
        text.append(jdomElement.getTextTrim());
        return text.toString();
    }

    private static String getPropertyAsStringAcl(Element element, String responseHref) {
        List<String> aces = XMLUtil.getAces(element, responseHref);
        return XMLUtil.getPropertyString(aces);
    }

    private static String getPropertyString(List<String> list) {
        if (list.size() == 0) {
            return "";
        }
        StringBuilder propertyString = new StringBuilder(list.get(0));
        for (int i = 1; i < list.size(); ++i) {
            propertyString.append(", ");
            propertyString.append(list.get(i));
        }
        return propertyString.toString();
    }

    private static List<String> getAces(Element element, String responseHref) {
        ArrayList<String> aces = new ArrayList<String>();
        NodeList children = element.getChildNodes();
        if (children == null || children.getLength() == 0) {
            return aces;
        }
        for (int i = 0; i < children.getLength(); ++i) {
            String ace;
            String localName;
            Node child = children.item(i);
            String namespace = XMLUtil.getElementNamespaceURI(child);
            if (!"DAV:".equals(namespace) || !"ace".equals(localName = XMLUtil.getElementLocalName(child)) || null == (ace = XMLUtil.parseAce(child, responseHref))) continue;
            aces.add(ace);
        }
        return aces;
    }

    private static String parseAce(Node element, String responseHref) {
        String principal = null;
        Element child = XMLUtil.getFirstElement(element, "DAV:", "principal");
        if (child == null) {
            System.err.println("Error: mandatory element <principal> is missing !");
            System.err.println("element: " + element);
            return null;
        }
        Element href = XMLUtil.getFirstElement(child, "DAV:", "href");
        if (href != null) {
            principal = XMLUtil.getTextValue(href);
            try {
                principal = URLDecoder.decode(principal, StandardCharsets.UTF_8.name());
            }
            catch (UnsupportedEncodingException e) {
                System.err.println("Warning: decoding href element failed!");
                System.err.println("reason: " + e.getMessage());
            }
        }
        String[] types = new String[]{"all", "authenticated", "unauthenticated", "property", "self"};
        for (int i = 0; i < types.length && principal == null; ++i) {
            Element type = XMLUtil.getFirstElement(child, "DAV:", types[i]);
            if (type == null) continue;
            principal = types[i];
        }
        if (principal == null) {
            System.err.println("Error: unknown type of principal");
            System.err.println("element: " + element);
            return null;
        }
        boolean negative = false;
        boolean inherited = false;
        boolean protectedAce = false;
        boolean inheritable = true;
        String inheritedFrom = "";
        child = XMLUtil.getFirstElement(element, "DAV:", "grant");
        if (child == null) {
            negative = true;
        }
        if ((child = XMLUtil.getFirstElement(element, "DAV:", "inherited")) != null) {
            href = XMLUtil.getFirstElement(child, "DAV:", "href");
            String shref = null;
            if (href != null) {
                shref = XMLUtil.getTextValue(href);
                if (!shref.equals(responseHref)) {
                    inherited = true;
                    inheritedFrom = shref;
                }
            } else {
                System.err.println("Error: mandatory element <href> is missing !");
                return null;
            }
        }
        if ((child = XMLUtil.getFirstElement(element, "DAV:", "protected")) != null) {
            protectedAce = true;
        }
        if ((child = XMLUtil.getFirstElement(element, "http://jakarta.apache.org/slide/", "non-inheritable")) != null) {
            inheritable = false;
        }
        StringBuilder aclString = new StringBuilder();
        if (negative) {
            aclString.append("denied to ");
        } else {
            aclString.append("granted to ");
        }
        aclString.append(principal);
        aclString.append(" (");
        if (protectedAce) {
            aclString.append("protected");
        } else {
            aclString.append("not protected");
        }
        aclString.append(")");
        aclString.append(" (");
        if (inherited) {
            aclString.append("inherited from '");
            aclString.append(inheritedFrom);
            aclString.append("'");
        } else {
            aclString.append("not inherited");
        }
        aclString.append(")");
        return aclString.toString();
    }

    private static String getPropertyAsStringResourceType(Element element) {
        boolean isCollection = false;
        boolean isPrincipal = false;
        NodeList nodeList = element.getChildNodes();
        int numNodes = nodeList.getLength();
        for (int i = 0; i < numNodes; ++i) {
            Element child = (Element)nodeList.item(i);
            String elementLocalName = XMLUtil.getElementLocalName(child);
            String namespaceURI = XMLUtil.getElementNamespaceURI(child);
            if (!"DAV:".equals(namespaceURI)) continue;
            if ("collection".equals(elementLocalName)) {
                isCollection = true;
            }
            if (!"principal".equals(elementLocalName)) continue;
            isPrincipal = true;
        }
        return isCollection ? "COLLECTION" : "";
    }

    private static String getPropertyAsStringLockDiscovery(Element element) {
        List<String> activeLocks = XMLUtil.getActiveLocks(element);
        return XMLUtil.getPropertyString(activeLocks);
    }

    private static List<String> getActiveLocks(Element element) {
        ArrayList<String> list = new ArrayList<String>();
        NodeList children = element.getChildNodes();
        if (children == null || children.getLength() == 0) {
            return list;
        }
        for (int i = 0; i < children.getLength(); ++i) {
            String localName;
            Element child = (Element)children.item(i);
            String namespace = XMLUtil.getElementNamespaceURI(child);
            if (!"DAV:".equals(namespace) || !"activelock".equals(localName = XMLUtil.getElementLocalName(child))) continue;
            list.add(XMLUtil.parseActiveLock(child));
        }
        return list;
    }

    private static String getPropertyAsStringPrincipalCollectionSet(Element element) {
        List<String> hrefs = XMLUtil.getHrefs(element);
        return XMLUtil.getPropertyString(hrefs);
    }

    private static boolean hasReadAccess(Element element) {
        NodeList readPrivilege = XMLUtil.getElementsByTagNameNS(element, "read", "DAV:");
        return readPrivilege.getLength() == 1;
    }

    private static boolean hasWriteAccess(Element element) {
        NodeList writePrivilege = XMLUtil.getElementsByTagNameNS(element, "write", "DAV:");
        return writePrivilege.getLength() == 1;
    }

    private static String getPropertyAsStringSupportedLock(Element element) {
        List<String> supportedLocks = XMLUtil.getSupportedLockEntries(element);
        return XMLUtil.getPropertyString(supportedLocks);
    }

    private static List<String> getSupportedLockEntries(Element element) {
        ArrayList<String> list = new ArrayList<String>();
        NodeList children = element.getChildNodes();
        if (children == null || children.getLength() == 0) {
            return list;
        }
        for (int i = 0; i < children.getLength(); ++i) {
            String localName;
            Element child = (Element)children.item(i);
            String namespace = XMLUtil.getElementNamespaceURI(child);
            if (!"DAV:".equals(namespace) || !"lockentry".equals(localName = XMLUtil.getElementLocalName(child))) continue;
            list.add(XMLUtil.parseSupportedLock(child));
        }
        return list;
    }

    private static String parseSupportedLock(Element element) {
        Element lockType;
        int ls = -1;
        int lt = -1;
        Element child = XMLUtil.getFirstElement(element, "DAV:", "lockscope");
        if (child != null) {
            Element lockScope = XMLUtil.getFirstElement(child, "DAV:", "exclusive");
            if (lockScope != null) {
                ls = 0;
            }
            if ((lockScope = XMLUtil.getFirstElement(child, "DAV:", "shared")) != null) {
                ls = 1;
            }
        }
        if ((child = XMLUtil.getFirstElement(element, "DAV:", "locktype")) != null && (lockType = XMLUtil.getFirstElement(child, "DAV:", "write")) != null) {
            lt = 0;
        }
        StringBuilder lockString = new StringBuilder();
        if (ls == 0) {
            lockString.append("Exclusive");
        } else if (ls == 1) {
            lockString.append("Shared");
        }
        if (lt == 0) {
            lockString.append(" write lock");
        }
        return lockString.toString();
    }

    private static String parseActiveLock(Element element) {
        Element href;
        Element href2;
        String timeout;
        int at;
        String depth;
        int ls = -1;
        int lt = -1;
        Element child = XMLUtil.getFirstElement(element, "DAV:", "lockscope");
        if (child != null) {
            Element lockScope = XMLUtil.getFirstElement(child, "DAV:", "exclusive");
            if (lockScope != null) {
                ls = 0;
            }
            if ((lockScope = XMLUtil.getFirstElement(child, "DAV:", "shared")) != null) {
                ls = 1;
            }
        }
        if ((child = XMLUtil.getFirstElement(element, "DAV:", "locktype")) != null) {
            Element lockType = XMLUtil.getFirstElement(child, "DAV:", "write");
            if (lockType != null) {
                lt = 0;
            } else {
                lockType = XMLUtil.getFirstElement(child, "DAV:", "transaction");
                if (lockType != null) {
                    lt = 1;
                }
            }
        }
        int d = -1;
        child = XMLUtil.getFirstElement(element, "DAV:", "depth");
        if (child != null && (depth = XMLUtil.getTextValue(child)) != null) {
            if ("0".equals(depth)) {
                d = 0;
            } else if ("1".equals(depth)) {
                d = 1;
            } else if ("infinity".equalsIgnoreCase(depth)) {
                d = Integer.MAX_VALUE;
            } else {
                try {
                    d = Integer.parseInt(depth);
                    if (d < 0) {
                        d = -1;
                    }
                }
                catch (NumberFormatException ex) {
                    d = -1;
                }
            }
        }
        String owner = null;
        child = XMLUtil.getFirstElement(element, "DAV:", "owner");
        owner = XMLUtil.getTextValue(child);
        int t = -1;
        child = XMLUtil.getFirstElement(element, "DAV:", "timeout");
        if (child != null && (at = (timeout = XMLUtil.getTextValue(child)).indexOf(45)) > 0) {
            try {
                t = Integer.parseInt(timeout.substring(at + 1));
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        String lockToken = null;
        child = XMLUtil.getFirstElement(element, "DAV:", "locktoken");
        if (child != null && (href2 = XMLUtil.getFirstElement(child, "DAV:", "href")) != null) {
            lockToken = XMLUtil.getTextValue(href2);
        }
        String principalUrl = null;
        child = XMLUtil.getFirstElement(element, "DAV:", "principal-URL");
        if (child != null && (href = XMLUtil.getFirstElement(child, "DAV:", "href")) != null) {
            principalUrl = XMLUtil.getTextValue(href);
        }
        StringBuilder lockString = new StringBuilder();
        if (ls == 0) {
            lockString.append("Exclusive");
        } else if (ls == 1) {
            lockString.append("Shared");
        }
        if (lt == 0) {
            lockString.append(" write lock");
        }
        if (d == Integer.MAX_VALUE) {
            lockString.append(" depth:infinity");
        } else if (d != -1) {
            lockString.append(" depth:" + d);
        }
        if (owner != null) {
            lockString.append(" owner:" + owner);
        }
        if (t != -1) {
            lockString.append(" timeout:" + t);
        }
        if (lockToken != null) {
            lockString.append(" token:" + lockToken);
        }
        return lockString.toString();
    }

    private static String getPropertyAsStringCurrentUserPrivilegeSet(Element element) {
        String theResult = "";
        theResult = XMLUtil.hasReadAccess(element) ? "Read" : theResult;
        theResult = XMLUtil.hasWriteAccess(element) ? theResult + " Write" : theResult;
        return theResult.trim();
    }

    static class NodeListImpl
    implements NodeList {
        private List<Element> list;

        NodeListImpl(List<Element> list) {
            this.list = list;
        }

        @Override
        public Node item(int index) {
            return this.list.get(index);
        }

        @Override
        public int getLength() {
            return this.list.size();
        }
    }
}

