/*
 * Decompiled with CFR 0.152.
 */
package com.sas.services.webdav;

import com.sas.codepolicy.BinaryCompatibilityOnly;
import com.sas.codepolicy.SASScope;
import com.sas.services.webdav.DAVException;
import com.sas.services.webdav.DAVResource;
import com.sas.services.webdav.DavPropertyItem;
import com.sas.services.webdav.PropertyMap;
import com.sas.services.webdav.XMLUtil;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.rmi.RemoteException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;

@SASScope(value="ALL")
@BinaryCompatibilityOnly
public class Utils {
    public static final int PATH_KEY = 1;
    public static final int URL_KEY = 2;
    static char[] hexChars = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};
    static char[] translateChars = new char[]{'.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', ' ', '!', '\"', '#', '$', '%', '&', '.', '(', ')', '*', '+', ',', '-', '.', '/', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', ':', ';', '<', '=', '>', '?', '@', 'A', 'B', 'C', 'D', 'E', 'F', 'G', 'H', 'I', 'J', 'K', 'L', 'M', 'N', 'O', 'P', 'Q', 'R', 'S', 'T', 'U', 'V', 'W', 'X', 'Y', 'Z', '[', '\\', ']', '^', '_', '`', 'a', 'b', 'c', 'd', 'e', 'f', 'g', 'h', 'i', 'j', 'k', 'l', 'm', 'n', 'o', 'p', 'q', 'r', 's', 't', 'u', 'v', 'w', 'x', 'y', 'z', '{', '|', '}', '~', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.'};
    private static final String CDATA_START = "<![CDATA[";
    private static final String CDATA_END = "]]>";
    private static final String CDATA_END_ESCAPED = "]]&gt;";

    public static String bytesToHex(byte[] chars) {
        char[] prtChars = new char[16];
        StringBuilder buffer = new StringBuilder();
        buffer.append(' ');
        for (int i = 0; i < chars.length; ++i) {
            if (i % 16 == 0) {
                if (i > 0) {
                    buffer.append(" |" + String.valueOf(prtChars));
                    buffer.append("|\n ");
                }
                buffer.append(Utils.intToHex(i, 8) + ":");
                for (int j = 0; j < 16; ++j) {
                    prtChars[j] = 32;
                }
            }
            if (i % 4 == 0) {
                buffer.append(' ');
            }
            buffer.append(hexChars[chars[i] >> 4 & 0xF]);
            buffer.append(hexChars[chars[i] & 0xF]);
            prtChars[i % 16] = translateChars[chars[i] < 0 ? chars[i] + 256 : chars[i]];
        }
        int charsOnLine = chars.length % 16;
        if (charsOnLine == 0) {
            charsOnLine = 16;
        }
        for (int i = charsOnLine; i < 16; ++i) {
            buffer.append(' ');
            buffer.append(' ');
        }
        if (charsOnLine < 5) {
            buffer.append(' ');
        }
        if (charsOnLine < 9) {
            buffer.append(' ');
        }
        if (charsOnLine < 13) {
            buffer.append(' ');
        }
        buffer.append(" |" + String.valueOf(prtChars) + "|\n");
        return buffer.toString();
    }

    public static String byteStreamToHex(InputStream byteStream) {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        try {
            int c;
            while ((c = byteStream.read()) != -1) {
                baos.write(c);
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return Utils.bytesToHex(baos.toByteArray());
    }

    public static String stringToHex(String chars) {
        StringBuilder result = new StringBuilder();
        int charsLength = chars.length();
        for (int i = 0; i < charsLength; ++i) {
            result.append(Utils.intToHex(chars.charAt(i), 2));
        }
        return new String(result);
    }

    public static String intToHex(int number, int width) {
        char[] result = new char[width];
        for (int i = 0; i < width; ++i) {
            int aNibble = number & 0xF;
            number >>= 4;
            result[width - i - 1] = hexChars[aNibble];
        }
        return new String(result);
    }

    public static boolean isSameUrl(String url1, String url2) {
        if (url1.equals(url2)) {
            return true;
        }
        String _url1 = url1;
        String _url2 = url2;
        if (_url1.endsWith("/")) {
            _url1 = _url1.substring(0, _url1.length() - 1);
        }
        if (_url2.endsWith("/")) {
            _url2 = _url2.substring(0, _url2.length() - 1);
        }
        return _url1.equals(_url2);
    }

    public static boolean isCollection(Map properties) {
        String resourcetype = (String)properties.get("{DAV:}resourcetype");
        return resourcetype != null && resourcetype.equals("COLLECTION");
    }

    public static PropertyMap convertDavPropertyArray(List<DavPropertyItem> davPropertyItems) throws ParserConfigurationException {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        factory.setValidating(false);
        factory.setNamespaceAware(true);
        PropertyMap properties = new PropertyMap();
        for (DavPropertyItem davPropertyItem : davPropertyItems) {
            String namespaceURI = davPropertyItem.getDavProperty().getName().getNamespace().getURI();
            if (null == namespaceURI) {
                namespaceURI = "";
            }
            String mapKey = String.format("{%s}%s", namespaceURI, XMLUtil.getElementLocalName(davPropertyItem.getDavProperty().toXml(factory.newDocumentBuilder().newDocument())));
            properties.put(mapKey, XMLUtil.getPropertyAsString(davPropertyItem));
        }
        return properties;
    }

    public static String getRelativePath(String urlString) {
        String _relPath;
        int ptr = urlString.lastIndexOf(47);
        if (ptr < 0) {
            _relPath = urlString;
        } else if (urlString.endsWith("/")) {
            int ptr2 = urlString.lastIndexOf(47, ptr - 1);
            _relPath = urlString.substring(ptr2 + 1, ptr);
        } else {
            _relPath = urlString.substring(ptr + 1);
        }
        return _relPath;
    }

    public static String addSegment(String path, String segment) {
        String tmpSegment;
        if (path == null && segment == null) {
            return "";
        }
        if (path == null) {
            return segment.trim();
        }
        if (segment == null) {
            return path.trim();
        }
        StringBuilder tmp = new StringBuilder(path.trim());
        if (tmp.length() == 0 || tmp.charAt(tmp.length() - 1) != '/') {
            tmp.append("/");
        }
        if ((tmpSegment = segment.trim()).length() > 0 && tmpSegment.charAt(0) == '/') {
            if (tmpSegment.length() > 1) {
                tmp.append(tmpSegment.substring(1));
            }
        } else {
            tmp.append(tmpSegment);
        }
        return tmp.toString();
    }

    public static String CDATA(String text) {
        if (text == null) {
            return "";
        }
        if (!text.startsWith(CDATA_START)) {
            if (text.indexOf(CDATA_END) > -1) {
                text = text.replaceAll(CDATA_END, CDATA_END_ESCAPED);
            }
            return CDATA_START + text + CDATA_END;
        }
        return text;
    }

    public static String XMLESCAPE(String text) {
        if (text == null) {
            return "";
        }
        if (text.startsWith(CDATA_START) && text.endsWith(CDATA_END)) {
            return text;
        }
        text = text.replaceAll("&", "&amp;");
        text = text.replaceAll("\"", "&quot;");
        text = text.replaceAll("<", "&lt;");
        text = text.replaceAll(">", "&gt;");
        return text;
    }

    public static String stripLeadingSlashes(String buffer) {
        StringBuffer _buffer = new StringBuffer(buffer);
        while (_buffer.length() > 0 && _buffer.charAt(0) == '/') {
            _buffer.deleteCharAt(0);
        }
        return _buffer.toString();
    }

    public static void print(String a) {
        for (int i = 0; i < a.length(); ++i) {
            if (a.charAt(i) >= ' ' && a.charAt(i) < '\u0080') {
                System.out.print(a.charAt(i));
                continue;
            }
            String hex = Integer.toHexString(a.charAt(i));
            switch (hex.length()) {
                case 1: {
                    System.out.print("\\u000");
                    break;
                }
                case 2: {
                    System.out.print("\\u00");
                    break;
                }
                case 3: {
                    System.out.print("\\u0");
                    break;
                }
                case 4: {
                    System.out.print("\\u");
                    break;
                }
                default: {
                    throw new RuntimeException(hex + " is tool long to be a Character");
                }
            }
            System.out.print(hex);
        }
    }

    public static String URIDecode(String uriString) {
        return Utils.URIDecode(uriString, false);
    }

    public static String URIDecode(String uriString, boolean forcePort) {
        try {
            URI uri = new URI(uriString);
            StringBuffer sb = new StringBuffer();
            if (uri.getScheme() != null) {
                String scheme = uri.getScheme();
                String authority = uri.getAuthority();
                sb.append(scheme + "://");
                if (forcePort && authority.indexOf(":") == -1) {
                    authority = "https".equals(scheme) ? authority + ":443" : authority + ":80";
                }
                sb.append(authority);
            }
            sb.append(uri.getPath());
            return sb.toString();
        }
        catch (URISyntaxException e) {
            e.printStackTrace();
            return uriString;
        }
    }

    public static String getHostPort(DAVResource r) {
        String hostport = "";
        try {
            hostport = r.getURL().toString();
            int ptr = hostport.indexOf("://");
            if (ptr != -1) {
                int index = hostport.indexOf("/", ptr + 3);
                hostport = index == -1 ? hostport : hostport.substring(0, index);
            }
        }
        catch (RemoteException e) {
            e.printStackTrace();
        }
        catch (DAVException e) {
            e.printStackTrace();
        }
        return hostport;
    }

    public static Map transformDavProperties(String url, List<DavPropertyItem> davPropertyItems, int key) throws DAVException, RemoteException, ParserConfigurationException {
        HashMap<String, PropertyMap> _members = new HashMap<String, PropertyMap>();
        PropertyMap _currentMap = null;
        String hostport = url;
        String path = null;
        int ptr = hostport.indexOf("://");
        if (ptr != -1) {
            int index = hostport.indexOf("/", ptr + 3);
            if (index == -1) {
                path = "/";
            } else {
                path = hostport.substring(index);
                hostport = hostport.substring(0, index);
            }
        }
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        factory.setValidating(false);
        factory.setNamespaceAware(true);
        for (DavPropertyItem davPropertyItem : davPropertyItems) {
            try {
                String namespaceURI;
                URI uri = new URI(davPropertyItem.getDavResourceHref());
                if (Utils.isSameUrl(path, uri.getPath())) continue;
                String newUrl = hostport + uri.getPath();
                String mapKey = key == 1 ? uri.getPath() : newUrl;
                _currentMap = (PropertyMap)_members.get(mapKey);
                if (_currentMap == null) {
                    _currentMap = new PropertyMap();
                    _members.put(mapKey, _currentMap);
                }
                String pName = (namespaceURI = davPropertyItem.getDavProperty().getName().getNamespace().getURI()) != null ? '{' + namespaceURI + '}' + XMLUtil.getElementLocalName(davPropertyItem.getDavProperty().toXml(factory.newDocumentBuilder().newDocument())) : "{}" + XMLUtil.getElementLocalName(davPropertyItem.getDavProperty().toXml(factory.newDocumentBuilder().newDocument()));
                _currentMap.put(pName, XMLUtil.getPropertyAsString(davPropertyItem));
            }
            catch (URISyntaxException e) {
                throw new DAVException("Invalid URI returned from server", e);
            }
        }
        return _members;
    }

    public static String transformURL(String targetUrl, String originUrl) throws DAVException {
        String tempUrl;
        String newUrl;
        try {
            newUrl = new URI(originUrl).getPath();
        }
        catch (URISyntaxException e) {
            throw new DAVException("Invalid URI from server", e);
        }
        try {
            URL u = new URL(targetUrl);
            tempUrl = u.getProtocol() + "://" + u.getHost();
            if (u.getPort() != -1) {
                tempUrl = tempUrl + ":" + u.getPort();
            }
        }
        catch (MalformedURLException e) {
            tempUrl = "";
        }
        newUrl = tempUrl + newUrl;
        return newUrl;
    }
}

