/*
 * Decompiled with CFR 0.152.
 */
package com.sas.services.webdav;

import com.sas.codepolicy.SASScope;
import com.sas.services.webdav.DAVException;
import com.sas.services.webdav.DAVResource;
import com.sas.services.webdav.PropertyMap;
import com.sas.services.webdav.Resource;
import com.sas.services.webdav.ResourceInterface;
import com.sas.services.webdav.SharedResourceInterface;
import java.io.InputStream;
import java.net.URL;
import java.rmi.RemoteException;
import java.rmi.server.UnicastRemoteObject;

@SASScope
public class RemoteResource
extends UnicastRemoteObject
implements ResourceInterface {
    private static final long serialVersionUID = -3587333268036592058L;
    protected Resource resource;
    protected String _urlString;

    public RemoteResource() throws RemoteException {
    }

    public RemoteResource(Resource r) throws RemoteException {
        this.resource = r;
    }

    public RemoteResource(String url) throws DAVException, RemoteException {
        this.resource = new Resource(url);
    }

    public RemoteResource(String url, String userid, String pw) throws DAVException, RemoteException {
        this.resource = new Resource(url, userid, pw);
    }

    public RemoteResource(DAVResource r) throws DAVException, RemoteException {
        this.resource = new Resource(r);
    }

    public RemoteResource(SharedResourceInterface sr) throws DAVException, RemoteException {
        this.resource = new Resource(sr);
    }

    public RemoteResource(SharedResourceInterface sr, String urlStr) throws DAVException, RemoteException {
        this.resource = new Resource(sr, urlStr);
    }

    @Override
    public String getURL() throws DAVException, RemoteException {
        return this.resource.getURL();
    }

    @Override
    public String getName() throws DAVException, RemoteException {
        return this.resource.getName();
    }

    @Override
    public void delete() throws DAVException, RemoteException {
        this.resource.delete();
    }

    @Override
    public void lock() throws DAVException, RemoteException {
        this.resource.lock();
    }

    @Override
    public void unlock() throws DAVException, RemoteException {
        this.resource.unlock();
    }

    @Override
    public ResourceInterface copy(String destination) throws DAVException, RemoteException {
        return this.resource.copy(destination);
    }

    @Override
    public ResourceInterface move(String destination) throws DAVException, RemoteException {
        return this.resource.move(destination);
    }

    @Override
    public boolean equals(ResourceInterface r) throws DAVException, RemoteException {
        return this.resource.equals(r);
    }

    @Override
    public void removeProperties(PropertyMap pMap) throws DAVException, RemoteException {
        this.resource.removeProperties(pMap);
    }

    @Override
    public void setProperties(PropertyMap pMap) throws DAVException, RemoteException {
        this.resource.setProperties(pMap);
    }

    @Override
    public PropertyMap getProperties() throws DAVException, RemoteException {
        return this.resource.getProperties();
    }

    @Override
    public void setContents(byte[] input) throws DAVException, RemoteException {
        this.resource.setContents(input);
    }

    @Override
    public void setContents(InputStream is) throws DAVException, RemoteException {
        this.resource.setContents(is);
    }

    @Override
    public void setContents(URL url) throws DAVException, RemoteException {
        this.resource.setContents(url);
    }

    @Override
    public InputStream getContents() throws DAVException, RemoteException {
        return this.resource.getContents();
    }

    protected void setDebug(int level) {
        this.resource.setDebug(level);
    }

    @Override
    public boolean exists() throws DAVException, RemoteException {
        return this.resource.exists();
    }

    @Override
    public void close() throws DAVException, RemoteException {
        this.resource.close();
    }

    @Override
    public boolean isSharedResource() {
        return this.resource.isSharedResource();
    }

    @Override
    public SharedResourceInterface getSharedResource() {
        return this.resource.getSharedResource();
    }
}

