/*
 * Decompiled with CFR 0.152.
 */
package com.sas.services.webdav;

import com.sas.codepolicy.SASScope;

@SASScope
public class Principal {
    public static final int ALLUSERS = 0;
    public static final int AUTHENTICATED = 1;
    public static final int UNAUTHENTICATED = 2;
    public static final int REFERENCE = 3;
    public static final int PROPERTY = 4;
    public static final int SELF = 4;
    private int type;
    private String ref;
    private String prefix;

    public static Principal getPrincipalFromString(String principal) {
        if (principal.startsWith("OWNER")) {
            return new Principal(4, "owner");
        }
        if (principal.startsWith("ALL_PRINCIPALS")) {
            return new Principal(0);
        }
        if (principal.startsWith("AUTHENTICATED")) {
            return new Principal(1);
        }
        if (principal.startsWith("UNAUTHENTICATED")) {
            return new Principal(2);
        }
        return new Principal(3, principal);
    }

    public Principal(int type) {
        this.type = type;
    }

    public Principal(int type, String reference) {
        this.type = type;
        this.ref = reference;
    }

    public Principal(int type, String ns, String property) {
        this.type = type;
        this.ref = '{' + ns + '}' + property;
    }

    public int getType() {
        return this.type;
    }

    public String getRef() {
        return this.ref;
    }

    public String getExternalForm() {
        String result;
        switch (this.type) {
            case 0: {
                result = "Public";
                break;
            }
            case 1: {
                result = "Authenticated Users";
                break;
            }
            case 2: {
                result = "Unauthenticated Users";
                break;
            }
            case 3: {
                result = "Reference";
                break;
            }
            case 4: {
                result = "Property";
                break;
            }
            default: {
                result = "?? unknown ??";
            }
        }
        if (this.type == 3 || this.type == 4) {
            result = result + " " + this.ref;
        }
        return result;
    }

    public String getDumpForm() {
        String result;
        switch (this.type) {
            case 0: {
                result = "ALL_PRINCIPALS@PUBLIC";
                break;
            }
            case 1: {
                result = "AUTHENTICATED@PUBLIC";
                break;
            }
            case 2: {
                result = "UNAUTHENTICATED@PUBLIC";
                break;
            }
            case 3: {
                result = this.getRef();
                break;
            }
            case 4: {
                if ("{DAV:}owner".equals(this.getRef())) {
                    result = "OWNER@PUBLIC";
                    break;
                }
                result = this.getRef();
                break;
            }
            default: {
                result = "?? unknown ??";
            }
        }
        return result;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer(30);
        sb.append("<" + this.prefix + ":principal>");
        switch (this.type) {
            case 0: {
                sb.append("<" + this.prefix + ":href>");
                sb.append(this.ref);
                sb.append("</" + this.prefix + ":href>");
                break;
            }
            case 1: {
                sb.append("<" + this.prefix + ":all/>");
                break;
            }
            case 2: {
                sb.append("<" + this.prefix + ":authenticated/>");
                break;
            }
            case 3: {
                sb.append("<" + this.prefix + ":unauthenticated/>");
                break;
            }
            case 4: {
                sb.append("<" + this.prefix + ":property>");
                sb.append(this.ref);
                sb.append("</" + this.prefix + ":property>");
                break;
            }
            case 5: {
                sb.append("<" + this.prefix + ":self/>");
                break;
            }
        }
        sb.append("</" + this.prefix + ":principal>");
        return sb.toString();
    }

    public String getDAVPrefix() {
        return this.prefix;
    }

    public void setDAVPrefix(String prefix) {
        this.prefix = prefix;
    }

    public boolean equals(Object o) {
        if (o instanceof Principal) {
            Principal p = (Principal)o;
            return this.type == p.getType() && this.equalsOrNull(this.ref, p.getRef());
        }
        return false;
    }

    private boolean equalsOrNull(String s1, String s2) {
        if (s1 == null || s2 == null) {
            return s1 == s2;
        }
        return s1.equals(s2);
    }
}

