/*
 * Decompiled with CFR 0.152.
 */
package com.sas.services.webdav;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.apache.jackrabbit.webdav.lock.ActiveLock;
import org.apache.jackrabbit.webdav.lock.LockDiscovery;

final class LockManager {
    private final Map<String, Map<String, String>> _ownerToPathToLockTokenMap = new HashMap<String, Map<String, String>>();

    LockManager() {
    }

    void clear() {
        this._ownerToPathToLockTokenMap.clear();
    }

    Map<String, String> get(String owner) {
        Map<String, String> pathToLockTokenMap = this._ownerToPathToLockTokenMap.get(owner);
        if (null == pathToLockTokenMap) {
            pathToLockTokenMap = new HashMap<String, String>();
            this._ownerToPathToLockTokenMap.put(owner, pathToLockTokenMap);
        }
        return pathToLockTokenMap;
    }

    boolean isLocked(String davResourcePath) {
        Map<String, String> pathToLockMap;
        boolean isLocked = false;
        Iterator<Map<String, String>> iterator = this._ownerToPathToLockTokenMap.values().iterator();
        while (iterator.hasNext() && !(isLocked = (pathToLockMap = iterator.next()).containsKey(davResourcePath))) {
        }
        return isLocked;
    }

    String getLock(String davResourcePath, String owner) {
        Map<String, String> pathToLockTokenMap = this.get(owner);
        return pathToLockTokenMap.get(davResourcePath);
    }

    void addLock(String davResourcePath, String owner, String token) {
        if (null == token || token.isEmpty()) {
            throw new IllegalArgumentException();
        }
        if (null == owner) {
            throw new IllegalArgumentException();
        }
        if (null == davResourcePath) {
            throw new IllegalArgumentException();
        }
        Map<String, String> pathToLockTokenMap = this.get(owner);
        pathToLockTokenMap.put(davResourcePath, token);
    }

    Set<String> addLocks(String davResourcePath, LockDiscovery lockDiscovery) {
        if (null == davResourcePath) {
            throw new IllegalArgumentException();
        }
        HashSet<String> addedLocks = new HashSet<String>();
        if (null != lockDiscovery) {
            for (ActiveLock activeLock : lockDiscovery.getValue()) {
                String lockToken = activeLock.getToken();
                if (null == lockToken || lockToken.isEmpty()) continue;
                this.addLock(davResourcePath, activeLock.getOwner(), lockToken);
                addedLocks.add(lockToken);
            }
        }
        return addedLocks;
    }

    String removeLock(String davResourcePath, String owner) {
        Map<String, String> pathToLockTokenMap = this.get(owner);
        return pathToLockTokenMap.remove(davResourcePath);
    }
}

