/*
 * Decompiled with CFR 0.152.
 */
package com.sas.services.webdav;

import com.sas.services.webdav.DavPropertyItem;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public final class DavPropertyResult {
    private final Map<String, List<DavPropertyItem>> _davPropertyItemMap = new HashMap<String, List<DavPropertyItem>>();
    private final Set<String> _hrefs = new HashSet<String>();

    public boolean hasPartialResults() {
        return !this._hrefs.isEmpty();
    }

    private boolean addHref(String href) {
        return this._hrefs.add(href);
    }

    public boolean addDavPropertyItem(DavPropertyItem davPropertyItem) {
        String href = davPropertyItem.getDavResourceHref();
        this.addHref(href);
        List<DavPropertyItem> list = this._davPropertyItemMap.get(href);
        if (null == list) {
            list = new ArrayList<DavPropertyItem>();
            this._davPropertyItemMap.put(href, list);
        }
        return list.add(davPropertyItem);
    }

    public Map<String, List<DavPropertyItem>> getDavPropertyItemMap() {
        return this._davPropertyItemMap;
    }

    public List<DavPropertyItem> getDavProperties() {
        ArrayList<DavPropertyItem> items = new ArrayList<DavPropertyItem>();
        for (List<DavPropertyItem> list : this._davPropertyItemMap.values()) {
            items.addAll(list);
        }
        return items;
    }

    public Set<String> getHrefs() {
        return this._hrefs;
    }
}

