/*
 * Decompiled with CFR 0.152.
 */
package com.sas.services.webdav;

import com.sas.codepolicy.BinaryCompatibilityOnly;
import com.sas.codepolicy.SASScope;
import java.net.URL;
import java.security.Principal;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.Credentials;
import org.apache.http.client.CredentialsProvider;

@SASScope(value="ALL")
@BinaryCompatibilityOnly
public class ConnectionInfo {
    private CredentialsProvider _credentialsProvider;
    private AuthScope _authScope = AuthScope.ANY;
    private String _url;
    private String _user;
    private String _pw;
    private String _proxyHost;
    private int _proxyPort = -1;
    private String _proxyUser;
    private String _proxyPW;

    public ConnectionInfo(String url) {
        this._url = url;
    }

    public ConnectionInfo(String url, String user, String pw) {
        this._url = url;
        this._user = user;
        this._pw = pw;
    }

    public ConnectionInfo(ConnectionInfo connectionInfo) {
        this._url = connectionInfo.getUrl();
        this._user = connectionInfo.getUser();
        this._pw = connectionInfo.getPW();
        this._proxyHost = connectionInfo.getProxyHost();
        this._proxyPort = connectionInfo.getProxyPort();
        this._proxyUser = connectionInfo.getProxyUser();
        this._proxyPW = connectionInfo.getProxyPW();
    }

    public String getUrl() {
        return this._url;
    }

    public void setUrl(String url) {
        this._url = url;
    }

    public String getUser() {
        Credentials credentials;
        Principal userPrincipal;
        String user = this._user;
        if (null != this._credentialsProvider && null != this._authScope && null != (userPrincipal = (credentials = this._credentialsProvider.getCredentials(this._authScope)).getUserPrincipal())) {
            user = userPrincipal.getName();
        }
        return user;
    }

    public void setUser(String user) {
        this._user = user;
    }

    public String getPW() {
        Credentials credentials;
        String pw = this._pw;
        if (null != this._credentialsProvider && null != this._authScope && null != (credentials = this._credentialsProvider.getCredentials(this._authScope))) {
            pw = credentials.getPassword();
        }
        return pw;
    }

    public void setPW(String pw) {
        this._pw = pw;
    }

    public String getProxyHost() {
        return this._proxyHost;
    }

    public void setProxyHost(String proxyHost) {
        this._proxyHost = proxyHost;
    }

    public int getProxyPort() {
        return this._proxyPort;
    }

    public void setProxyPort(int proxyPort) {
        this._proxyPort = proxyPort;
    }

    public void setProxyURL(URL proxyURL) {
        this._proxyHost = proxyURL.getHost();
        this._proxyPort = proxyURL.getPort();
    }

    public String getProxyUser() {
        return this._proxyUser;
    }

    public void setProxyUser(String proxyUser) {
        this._proxyUser = proxyUser;
    }

    public String getProxyPW() {
        return this._proxyPW;
    }

    public void setProxyPW(String proxyPW) {
        this._proxyPW = proxyPW;
    }

    public CredentialsProvider getCredentialsProvider() {
        return this._credentialsProvider;
    }

    public void setCredentialsProvider(CredentialsProvider credentialsProvider) {
        this._credentialsProvider = credentialsProvider;
    }

    public AuthScope getAuthScope() {
        return this._authScope;
    }

    public void setAuthScope(AuthScope authScope) {
        this._authScope = authScope;
    }
}

