/*
 * Decompiled with CFR 0.152.
 */
package com.sas.services.webdav;

import com.sas.codepolicy.SASScope;
import com.sas.services.webdav.Ace;
import com.sas.services.webdav.DAVException;
import com.sas.services.webdav.NamespaceMap;
import com.sas.services.webdav.Principal;
import com.sas.services.webdav.Privilege;
import com.sas.services.webdav.PropertyName;
import com.sas.services.webdav.TransformerFactoryFactory;
import com.sas.services.webdav.XMLUtil;
import java.io.IOException;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

@SASScope
public class Acl {
    private List<Ace> _aceList = new ArrayList<Ace>();

    public static Acl extractAclFromResponse(Element aclElement) {
        Acl acl = new Acl();
        NodeList acelist = aclElement.getChildNodes();
        int numAces = acelist.getLength();
        for (int i = 0; i < numAces; ++i) {
            Element inherited;
            NodeList nl2;
            boolean isinherited;
            ArrayList<Privilege> privileges = new ArrayList<Privilege>();
            Node n = acelist.item(i);
            if (!(n instanceof Element)) continue;
            String inheritedfrom = null;
            boolean isGrant = true;
            Principal ppl = null;
            Element ace = (Element)n;
            if (!"ace".equals(ace.getLocalName())) continue;
            NodeList nl = ace.getElementsByTagNameNS("DAV:", "grant");
            if (nl.getLength() > 0) {
                isGrant = true;
            } else {
                nl = ace.getElementsByTagNameNS("DAV:", "deny");
                if (nl.getLength() > 0) {
                    isGrant = false;
                }
            }
            nl = ace.getElementsByTagNameNS("DAV:", "privilege");
            for (int j = 0; j < nl.getLength(); ++j) {
                Element privilege = (Element)nl.item(j);
                NodeList nl22 = privilege.getChildNodes();
                for (int k = 0; k < nl22.getLength(); ++k) {
                    if (!(nl22.item(k) instanceof Element)) continue;
                    String action = '{' + nl22.item(k).getNamespaceURI() + '}' + nl22.item(k).getLocalName();
                    Privilege priv = new Privilege(action);
                    privileges.add(priv);
                }
            }
            nl = ace.getElementsByTagNameNS("DAV:", "protected");
            boolean isprotected = nl.getLength() > 0;
            nl = ace.getElementsByTagNameNS("DAV:", "inherited");
            boolean bl = isinherited = nl.getLength() > 0;
            if (isinherited && (nl2 = (inherited = (Element)nl.item(0)).getElementsByTagNameNS("DAV:", "href")).getLength() > 0) {
                Element href = (Element)nl2.item(0);
                Node hrefVal = href.getFirstChild();
                inheritedfrom = hrefVal.getNodeValue();
            }
            if ((nl = ace.getElementsByTagNameNS("DAV:", "invert")).getLength() > 0) {
                // empty if block
            }
            if ((nl = ace.getElementsByTagNameNS("DAV:", "principal")).getLength() > 0) {
                NodeList nl23 = nl.item(0).getChildNodes();
                for (int j = 0; j < nl23.getLength(); ++j) {
                    if (!(nl23.item(j) instanceof Element)) {
                        String text;
                        if (!(nl23.item(j) instanceof Text) || !(text = ((Text)nl23.item(j)).getNodeValue()).startsWith("http")) continue;
                        ppl = new Principal(3, text);
                        continue;
                    }
                    Element principal = (Element)nl23.item(j);
                    if ("all".equals(principal.getLocalName())) {
                        ppl = new Principal(0);
                        continue;
                    }
                    if ("authenticated".equals(principal.getLocalName())) {
                        ppl = new Principal(1);
                        continue;
                    }
                    if ("unauthenticated".equals(principal.getLocalName())) {
                        ppl = new Principal(2);
                        continue;
                    }
                    if ("href".equals(principal.getLocalName())) {
                        NodeList hrefNodeList = principal.getChildNodes();
                        String reference = null;
                        for (int k = 0; k < hrefNodeList.getLength(); ++k) {
                            if (!(hrefNodeList.item(k) instanceof Text)) continue;
                            reference = hrefNodeList.item(k).getNodeValue();
                        }
                        ppl = new Principal(3, reference);
                        continue;
                    }
                    if (!"property".equals(principal.getLocalName())) continue;
                    String property = null;
                    String ns = null;
                    NodeList propertyNodeList = principal.getChildNodes();
                    for (int k = 0; k < propertyNodeList.getLength(); ++k) {
                        if (!(propertyNodeList.item(k) instanceof Element)) continue;
                        property = propertyNodeList.item(k).getLocalName();
                        ns = propertyNodeList.item(k).getNamespaceURI();
                    }
                    ppl = new Principal(4, ns, property);
                }
            }
            Ace _ace = new Ace(ppl, privileges.toArray(new Privilege[privileges.size()]), isGrant, isprotected, isinherited);
            if (isinherited) {
                _ace.setInheritedFrom(inheritedfrom);
            }
            acl.addAce(_ace);
        }
        return acl;
    }

    public void addAce(Ace ace) {
        if (null != ace) {
            boolean aceFound = false;
            for (Ace aceItem : this._aceList) {
                if (!aceItem.getPrincipal().equals(ace.getPrincipal())) continue;
                aceItem.setPrivileges(ace.getPrivileges());
                aceFound = true;
                break;
            }
            if (!aceFound) {
                this._aceList.add(ace);
            }
        }
    }

    public List<Ace> getAceList() {
        return this._aceList;
    }

    Document getUpdateableAclDocument() {
        Document doc = null;
        NamespaceMap nsMap = new NamespaceMap();
        nsMap.addNSPrefix("d", "DAV:");
        String PREFIX = "d:";
        try {
            DocumentBuilderFactory documentBuilderFactory = TransformerFactoryFactory.newDocumentBuilderFactory();
            documentBuilderFactory.setNamespaceAware(true);
            DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
            doc = documentBuilder.newDocument();
            Iterator<Ace> aceItems = this._aceList.iterator();
            Element aclE = doc.createElementNS("DAV:", PREFIX + "acl");
            while (aceItems.hasNext()) {
                Ace ace = aceItems.next();
                if (ace.isProtected() || ace.isInherited()) continue;
                Principal ppl = ace.getPrincipal();
                Element principalE = doc.createElementNS("DAV:", PREFIX + "principal");
                Element identityE = null;
                if (ppl.getType() == 0) {
                    identityE = doc.createElementNS("DAV:", PREFIX + "all");
                } else if (ppl.getType() == 1) {
                    identityE = doc.createElementNS("DAV:", PREFIX + "authenticated");
                } else if (ppl.getType() == 2) {
                    identityE = doc.createElementNS("DAV:", PREFIX + "unauthenticated");
                } else if (ppl.getType() == 3) {
                    identityE = doc.createElementNS("DAV:", PREFIX + "href");
                    identityE.appendChild(doc.createTextNode(ppl.getRef()));
                } else if (ppl.getType() == 4) {
                    identityE = doc.createElementNS("DAV:", PREFIX + "property");
                    PropertyName pn = new PropertyName(ppl.getRef());
                    String namespaceURI = pn.getNamespaceURI();
                    String propertyName = pn.getLocalName();
                    String nsprefix = nsMap.getPrefixforURI(namespaceURI);
                    identityE.appendChild(doc.createElementNS(namespaceURI, nsprefix + ':' + propertyName));
                }
                principalE.appendChild(identityE);
                Element privilegeE = null;
                Element privE = null;
                Privilege[] privs = ace.getPrivileges();
                Element grantdenyE = ace.isGrant() ? doc.createElementNS("DAV:", PREFIX + "grant") : doc.createElementNS("DAV:", PREFIX + "deny");
                for (int i = 0; i < privs.length; ++i) {
                    int ptr1;
                    Privilege priv = privs[i];
                    String privilege = priv.getName();
                    int ptr2 = privilege.indexOf(125);
                    if (ptr2 > 0 && (ptr1 = privilege.indexOf(123)) < ptr2) {
                        String ns = privilege.substring(ptr1 + 1, ptr2);
                        String nsprefix = nsMap.getPrefixforURI(ns);
                        String name = privilege.substring(ptr2 + 1);
                        privE = doc.createElementNS(ns, nsprefix + ':' + name);
                    }
                    if (privE == null) continue;
                    privilegeE = doc.createElementNS("DAV:", PREFIX + "privilege");
                    privilegeE.appendChild(privE);
                    grantdenyE.appendChild(privilegeE);
                }
                Element aceE = doc.createElementNS("DAV:", PREFIX + "ace");
                aceE.appendChild(principalE);
                if (grantdenyE != null) {
                    aceE.appendChild(grantdenyE);
                }
                aclE.appendChild(aceE);
            }
            doc.appendChild(aclE);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
        return doc;
    }

    public String getUpdateableAclString() {
        Element element;
        String acl = null;
        Document doc = this.getUpdateableAclDocument();
        if (null != doc && (element = doc.getDocumentElement()).hasChildNodes()) {
            acl = XMLUtil.node2String(doc);
        }
        return acl;
    }

    static Document toDocument(String aclXML) throws DAVException {
        if (null == aclXML) {
            throw new IllegalArgumentException();
        }
        Document aclDoc = null;
        try {
            DocumentBuilderFactory documentBuilderFactory = TransformerFactoryFactory.newDocumentBuilderFactory();
            documentBuilderFactory.setNamespaceAware(true);
            DocumentBuilder builder = documentBuilderFactory.newDocumentBuilder();
            aclDoc = builder.parse(new InputSource(new StringReader(aclXML)));
        }
        catch (ParserConfigurationException e) {
            throw new DAVException(e.getMessage(), e);
        }
        catch (SAXException e) {
            throw new DAVException(e.getMessage(), e);
        }
        catch (IOException e) {
            throw new DAVException(e.getMessage(), e);
        }
        return aclDoc;
    }
}

