/*
 * Decompiled with CFR 0.152.
 */
package com.sas.services.webdav;

import com.sas.codepolicy.SASScope;
import com.sas.services.webdav.Principal;
import com.sas.services.webdav.Privilege;

@SASScope
public class Ace {
    private Principal principal;
    private Privilege[] privileges;
    private boolean isGrant = true;
    private boolean isProtected = false;
    private boolean isInherited = false;
    private String inheritedFrom = null;

    public Ace(Principal principal, Privilege[] privileges) {
        this.principal = principal;
        this.privileges = privileges;
    }

    public Ace(Principal principal, Privilege[] privileges, boolean isGrant, boolean isProtected, boolean isInherited) {
        this.principal = principal;
        this.privileges = privileges;
        this.isGrant = isGrant;
        this.isProtected = isProtected;
        this.isInherited = isInherited;
    }

    public void setInheritedFrom(String ref) {
        this.inheritedFrom = ref;
    }

    public boolean isInherited() {
        return this.isInherited;
    }

    public String getInheritedFrom() {
        return this.inheritedFrom;
    }

    public boolean isProtected() {
        return this.isProtected;
    }

    public boolean isGrant() {
        return this.isGrant;
    }

    public Principal getPrincipal() {
        return this.principal;
    }

    public Privilege[] getPrivileges() {
        return this.privileges;
    }

    public void addPrivilege(Privilege privilege) {
        Privilege[] newprivs = new Privilege[this.privileges.length + 1];
        System.arraycopy(this.privileges, 0, newprivs, 0, this.privileges.length);
        newprivs[this.privileges.length] = privilege;
        this.privileges = newprivs;
    }

    public void setPrivileges(Privilege[] privileges) {
        this.privileges = privileges;
    }

    public void setPrincipal(Principal principal) {
        this.principal = principal;
    }
}

