/*
 * Decompiled with CFR 0.152.
 */
package com.sas.services.events.discovery;

import com.sas.codepolicy.SASScope;
import com.sas.services.InitializationException;
import com.sas.services.events.discovery.EventBrokerDiscoveryServiceInitObject;
import com.sas.services.events.discovery.RB;
import java.net.MalformedURLException;
import java.rmi.Naming;
import java.rmi.NotBoundException;
import java.rmi.Remote;
import java.rmi.RemoteException;
import java.text.MessageFormat;
import java.util.HashSet;
import java.util.ResourceBundle;
import java.util.Set;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

@SASScope
public class EventBrokerDiscoveryServiceInitializer {
    private static final String RB_KEY = "EventBrokerDiscoveryServiceInitializer.";
    private static ResourceBundle rb = RB.getResources();

    private EventBrokerDiscoveryServiceInitializer() {
    }

    public static final EventBrokerDiscoveryServiceInitObject getInitObject(Object object) throws InitializationException {
        EventBrokerDiscoveryServiceInitObject initObject = null;
        if (object instanceof Document) {
            Document document = (Document)object;
            initObject = EventBrokerDiscoveryServiceInitializer.getInitObject(document);
        } else if (object instanceof EventBrokerDiscoveryServiceInitObject) {
            initObject = (EventBrokerDiscoveryServiceInitObject)object;
        } else {
            String msg = rb.getString("EventBrokerDiscoveryServiceInitializer.invalidContext.ex.txt");
            throw new InitializationException(msg);
        }
        return initObject;
    }

    public static final EventBrokerDiscoveryServiceInitObject getInitObject(Document document) throws InitializationException {
        if (document == null) {
            throw new InitializationException(rb.getString("EventBrokerDiscoveryServiceInitializer.invalidContext.ex.txt"));
        }
        Logger logger = LogManager.getLogger((String)EventBrokerDiscoveryServiceInitializer.class.getName());
        if (logger != null && logger.isDebugEnabled()) {
            logger.debug(rb.getString("EventBrokerDiscoveryServiceInitializer.entered.txt"));
        }
        Document node = document;
        Set externalBrokerURLs = EventBrokerDiscoveryServiceInitializer.parseContext(node);
        HashSet<Remote> externalBrokerRefs = new HashSet<Remote>(externalBrokerURLs.size());
        for (String url : externalBrokerURLs) {
            try {
                externalBrokerRefs.add(Naming.lookup(url));
            }
            catch (NotBoundException nbe) {
                if (logger == null) continue;
                logger.error(MessageFormat.format(rb.getString("EventBrokerDiscoveryServiceInitializer.lookupNotBoundException.fmt.txt"), url, nbe.getMessage()));
            }
            catch (MalformedURLException mfe) {
                if (logger == null) continue;
                logger.error(MessageFormat.format(rb.getString("EventBrokerDiscoveryServiceInitializer.lookupMalformedURLException.fmt.txt"), url, mfe.getMessage()));
            }
            catch (RemoteException re) {
                if (logger == null) continue;
                logger.error(MessageFormat.format(rb.getString("EventBrokerDiscoveryServiceInitializer.lookupRemoteException.fmt.txt"), url), (Throwable)re);
            }
        }
        EventBrokerDiscoveryServiceInitObject initObject = new EventBrokerDiscoveryServiceInitObject(externalBrokerRefs);
        if (logger != null && logger.isDebugEnabled()) {
            logger.debug(rb.getString("EventBrokerDiscoveryServiceInitializer.leave.txt"));
        }
        return initObject;
    }

    private static final Set parseContext(Node node) {
        HashSet<String> externalBrokerURLs = new HashSet<String>(5);
        switch (node.getNodeType()) {
            case 9: 
            case 11: {
                NodeList nodeList = node.getChildNodes();
                for (int i = 0; i < nodeList.getLength(); ++i) {
                    Node child = nodeList.item(i);
                    EventBrokerDiscoveryServiceInitializer.parseContext(child);
                }
                break;
            }
            case 1: {
                Element element;
                String url;
                String elementName = node.getNodeName();
                if (elementName.equalsIgnoreCase("location") && (url = (element = (Element)node).getAttribute("url")) != null) {
                    externalBrokerURLs.add(url);
                }
                NodeList nodeList = node.getChildNodes();
                for (int i = 0; i < nodeList.getLength(); ++i) {
                    Node child = nodeList.item(i);
                    EventBrokerDiscoveryServiceInitializer.parseContext(child);
                }
                break;
            }
            case 3: {
                break;
            }
        }
        return externalBrokerURLs;
    }
}

