/*
 * Decompiled with CFR 0.152.
 */
package com.sas.services.events.discovery;

import com.sas.codepolicy.BinaryCompatibilityOnly;
import com.sas.codepolicy.SASScope;
import com.sas.services.AbstractServiceFactory;
import com.sas.services.RemoteServiceInterface;
import com.sas.services.ServiceConfigurationInterface;
import com.sas.services.ServiceException;
import com.sas.services.ServiceProfile;
import com.sas.services.discovery.DiscoveryServiceInterface;
import com.sas.services.events.discovery.EventBrokerDiscoveryService;
import com.sas.services.events.discovery.EventBrokerDiscoveryServiceInterface;
import com.sas.services.events.discovery.EventBrokerDiscoveryServiceProfile;
import com.sas.services.events.discovery.RB;
import java.rmi.RemoteException;
import org.apache.logging.log4j.LogManager;

@SASScope(value="ALL")
@BinaryCompatibilityOnly
public class EventBrokerDiscoveryServiceFactory
extends AbstractServiceFactory {
    public EventBrokerDiscoveryServiceFactory() {
        super((ServiceProfile)new EventBrokerDiscoveryServiceProfile());
    }

    public final RemoteServiceInterface getService(ServiceConfigurationInterface serviceConfiguration, DiscoveryServiceInterface discoveryService) throws ServiceException {
        EventBrokerDiscoveryService service = null;
        try {
            service = new EventBrokerDiscoveryService(serviceConfiguration, discoveryService);
        }
        catch (RemoteException e) {
            String msg = RB.getStringResource("EventBrokerDiscoveryServiceFactory.getService.ex.txt");
            LogManager.getLogger(EventBrokerDiscoveryServiceFactory.class).error(msg, (Throwable)e);
            throw new ServiceException((Throwable)e, msg);
        }
        catch (RuntimeException e) {
            LogManager.getLogger(EventBrokerDiscoveryServiceFactory.class).error(RB.getStringResource("EventBrokerDiscoveryServiceFactory.getService.ex.txt"), (Throwable)e);
            throw e;
        }
        return service;
    }

    public static final EventBrokerDiscoveryServiceInterface createService(ServiceConfigurationInterface serviceConfiguration, DiscoveryServiceInterface discoveryService) throws ServiceException {
        return (EventBrokerDiscoveryServiceInterface)new EventBrokerDiscoveryServiceFactory().getService(serviceConfiguration, discoveryService);
    }
}

