/*
 * Decompiled with CFR 0.152.
 */
package com.sas.services.events.broker.util;

import com.sas.services.events.broker.util.RB;
import com.sas.services.events.broker.util.TaskRunnable;
import com.sas.services.events.broker.util.ThreadPool;
import com.sas.services.events.broker.util.ThreadPoolException;
import java.text.MessageFormat;
import java.util.ResourceBundle;

public class TestThreadPool {
    public static final int SECONDS = 1000;
    public static final int MINUTES = 60000;
    private static final String RB_KEY = "TestThreadPool.";
    private static ResourceBundle rb = RB.getResources();

    public TestThreadPool() {
        try {
            ThreadPool p = new ThreadPool();
            p.init();
            Task1 task1 = new Task1();
            Task2 task2 = new Task2();
            Task3 task3 = new Task3();
            p.runTask(task1);
            p.runTask(task2);
            p.runTask(task3);
            p.term();
        }
        catch (ThreadPoolException tpe) {
            System.out.println(rb.getString("TestThreadPool.threadPoolException.txt"));
            tpe.printStackTrace();
        }
    }

    public static void main(String[] args) {
        new TestThreadPool();
    }

    class Task3
    implements TaskRunnable {
        Task3() {
        }

        @Override
        public void run() throws InterruptedException {
            try {
                System.out.println(rb.getString("TestThreadPool.task3.enter.txt"));
                Thread.sleep(120000L);
                System.out.println(rb.getString("TestThreadPool.task3.exit.txt"));
            }
            catch (InterruptedException ie) {
                System.out.println(MessageFormat.format(rb.getString("TestThreadPool.interruptException.fmt.txt"), ie.getMessage()));
            }
        }
    }

    class Task2
    implements TaskRunnable {
        Task2() {
        }

        @Override
        public void run() throws InterruptedException {
            try {
                System.out.println(rb.getString("TestThreadPool.task2.enter.txt"));
                Thread.sleep(30000L);
                System.out.println(rb.getString("TestThreadPool.task2.exit.txt"));
            }
            catch (InterruptedException ie) {
                System.out.println(MessageFormat.format(rb.getString("TestThreadPool.interruptException.fmt.txt"), ie.getMessage()));
            }
        }
    }

    class Task1
    implements TaskRunnable {
        Task1() {
        }

        @Override
        public void run() throws InterruptedException {
            try {
                System.out.println(rb.getString("TestThreadPool.task1.enter.txt"));
                Thread.sleep(60000L);
                System.out.println(rb.getString("TestThreadPool.task1.exit.txt"));
            }
            catch (InterruptedException ie) {
                System.out.println(MessageFormat.format(rb.getString("TestThreadPool.interruptException.fmt.txt"), ie.getMessage()));
            }
        }
    }
}

