/*
 * Decompiled with CFR 0.152.
 */
package com.sas.services.events.broker.util;

import com.sas.services.events.broker.util.ConditionVar;
import com.sas.services.events.broker.util.Mutex;
import com.sas.services.events.broker.util.MutexStateException;

public class RWLock {
    boolean writerOwnsLock = false;
    int nCurrentReaders = 0;
    int nWaitingReaders = 0;
    int nWaitingWriters = 0;
    Mutex mutex = new Mutex();
    ConditionVar readersCV = new ConditionVar();
    ConditionVar writersCV = new ConditionVar();

    public void readLock() {
        try {
            this.mutex.lock();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        ++this.nWaitingReaders;
        while (this.writerOwnsLock || this.nWaitingWriters > 0) {
            try {
                this.readersCV.condWait(this.mutex);
            }
            catch (InterruptedException interruptedException) {}
        }
        --this.nWaitingReaders;
        ++this.nCurrentReaders;
        try {
            this.mutex.unlock();
        }
        catch (MutexStateException mutexStateException) {
            // empty catch block
        }
    }

    public void writeLock() {
        try {
            this.mutex.lock();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        ++this.nWaitingWriters;
        while (this.writerOwnsLock || this.nCurrentReaders > 0) {
            try {
                this.writersCV.condWait(this.mutex);
            }
            catch (InterruptedException interruptedException) {}
        }
        --this.nWaitingWriters;
        this.writerOwnsLock = true;
        try {
            this.mutex.unlock();
        }
        catch (MutexStateException mutexStateException) {
            // empty catch block
        }
    }

    public void unlock() {
        try {
            this.mutex.lock();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        if (this.writerOwnsLock) {
            this.writerOwnsLock = false;
        } else {
            --this.nCurrentReaders;
        }
        if (this.nWaitingWriters > 0 && this.nCurrentReaders == 0) {
            this.writersCV.condSignal();
        } else if (this.nWaitingWriters == 0 && this.nWaitingReaders > 0) {
            this.readersCV.condBroadcast();
        }
        try {
            this.mutex.unlock();
        }
        catch (MutexStateException mutexStateException) {
            // empty catch block
        }
    }
}

