/*
 * Decompiled with CFR 0.152.
 */
package com.sas.services.events.broker.util;

import com.sas.services.events.broker.EventBrokerService;
import com.sas.services.events.broker.ListenerInterface;
import com.sas.services.events.broker.util.ConditionVar;
import com.sas.services.events.broker.util.Event;
import com.sas.services.events.broker.util.EventRequest;
import com.sas.services.events.broker.util.EventsConfiguration;
import com.sas.services.events.broker.util.ListenerEvent;
import com.sas.services.events.broker.util.Mutex;
import com.sas.services.events.broker.util.RWLock;
import com.sas.services.events.broker.util.ThreadPool;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.Vector;

public class EventContainer {
    private List _list = new ArrayList();
    private int _maxQueuedEvents;
    private EventsConfiguration _config;
    private Vector _listenerEvents = new Vector();
    private ThreadPool _tp;
    private String _brokerUser;
    private String _brokerPass;
    private EventBrokerService _broker;
    public Mutex _mutex = new Mutex();
    public ConditionVar _monitorCV = new ConditionVar();
    public ConditionVar _workerCV = new ConditionVar();
    public boolean _stop;
    public boolean _drain;
    public RWLock _rwLock = new RWLock();

    public EventContainer(int maxQueuedEvents, EventsConfiguration eventsConfig, ThreadPool tp) {
        this._maxQueuedEvents = maxQueuedEvents;
        this._config = eventsConfig;
        this._tp = tp;
    }

    public void setEventConfiguration(EventsConfiguration eventsConfig) {
        this._config = eventsConfig;
    }

    public EventsConfiguration getEventConfiguration() {
        return this._config;
    }

    public void setMaxQueuedEvents(int maxQueuedEvents) {
        this._maxQueuedEvents = maxQueuedEvents;
    }

    public int getMaxQueuedEvents() {
        return this._maxQueuedEvents;
    }

    public void setBrokerUser(String brokerUser) {
        this._brokerUser = brokerUser;
    }

    public String getBrokerUser() {
        return this._brokerUser;
    }

    public void setBrokerPass(String brokerPass) {
        this._brokerPass = brokerPass;
    }

    public String getBrokerPass() {
        return this._brokerPass;
    }

    public void setOwningBroker(EventBrokerService broker) {
        this._broker = broker;
    }

    public EventBrokerService getOwningBroker() {
        return this._broker;
    }

    public ThreadPool getThreadPool() {
        return this._tp;
    }

    public void add(EventRequest eventRequest) {
        this._list.add(eventRequest);
    }

    public EventRequest remove() {
        EventRequest eventRequest = (EventRequest)this._list.remove(0);
        return eventRequest;
    }

    public boolean isFull() {
        return this._list.size() == this._maxQueuedEvents;
    }

    public boolean isEmpty() {
        return this._list.size() == 0;
    }

    public boolean isEventConfigured(String eventName, boolean requestResponse) {
        return this.isEventConfigured(eventName, requestResponse, true);
    }

    public boolean isEventConfigured(String eventName, boolean requestResponse, boolean searchHierarchy) {
        boolean configured = false;
        if (this.getConfiguredEvents(eventName, requestResponse, searchHierarchy) != null) {
            configured = true;
        }
        return configured;
    }

    public Set getConfiguredEvents(String eventName, boolean requestResponse) {
        return this.getConfiguredEvents(eventName, requestResponse, true);
    }

    public Set getConfiguredEvents(String eventName, boolean requestResponse, boolean searchHierarchy) {
        HashSet<Event> events = null;
        if (eventName != null) {
            String hierarchyName = eventName;
            while (true) {
                int index;
                for (Event event : this._config.getEvents()) {
                    if (!event.getName().equals(hierarchyName) || requestResponse && event.getType() != 1 || !requestResponse && event.getType() != 0) continue;
                    if (events == null) {
                        events = new HashSet<Event>();
                    }
                    events.add(event);
                    break;
                }
                if (requestResponse && events != null || !searchHierarchy || (index = hierarchyName.lastIndexOf(".")) == -1) break;
                hierarchyName = hierarchyName.substring(0, index);
            }
        }
        return events;
    }

    public boolean isEventListenedFor(String eventName, boolean requestResponse) {
        return this.isEventListenedFor(eventName, requestResponse, true);
    }

    public boolean isEventListenedFor(String eventName, boolean requestResponse, boolean searchHierarchy) {
        boolean listenedFor = false;
        if (this.getEventListeners(eventName, requestResponse, searchHierarchy) != null) {
            listenedFor = true;
        }
        return listenedFor;
    }

    public Vector getEventListeners(String eventName, boolean requestResponse) {
        return this.getEventListeners(eventName, requestResponse, true);
    }

    public Vector getEventListeners(String eventName, boolean requestResponse, boolean searchHierarchy) {
        Vector<ListenerEvent> events = null;
        if (eventName != null) {
            String hierarchyName = eventName;
            while (true) {
                int index;
                for (ListenerEvent event : this._listenerEvents) {
                    if (!event.getName().equals(hierarchyName) || requestResponse && event.getType() != 1 || !requestResponse && event.getType() != 0) continue;
                    if (events == null) {
                        events = new Vector<ListenerEvent>();
                    }
                    events.add(event);
                    break;
                }
                if (requestResponse && events != null || !searchHierarchy || (index = hierarchyName.lastIndexOf(".")) == -1) break;
                hierarchyName = hierarchyName.substring(0, index);
            }
        }
        return events;
    }

    public void addEventListener(String eventName, int eventType, ListenerInterface listener) {
        ListenerEvent listenerEvent = null;
        for (ListenerEvent event : this._listenerEvents) {
            if (!event.getName().equals(eventName) || eventType != event.getType()) continue;
            listenerEvent = event;
            break;
        }
        if (listenerEvent == null) {
            listenerEvent = new ListenerEvent(eventName, eventType);
            this._listenerEvents.add(listenerEvent);
        }
        listenerEvent.addListener(listener);
    }

    public boolean removeEventListener(String eventName, int eventType, ListenerInterface listener) {
        boolean bRemoved = false;
        for (ListenerEvent event : this._listenerEvents) {
            if (!event.getName().equals(eventName) || eventType != event.getType()) continue;
            bRemoved = event.removeListener(listener);
            if (!event.getListeners().isEmpty()) break;
            this._listenerEvents.remove(event);
            break;
        }
        return bRemoved;
    }

    public void releaseEventListeners() {
        for (ListenerEvent event : this._listenerEvents) {
            event.releaseListeners();
        }
        this._listenerEvents.clear();
        System.gc();
    }
}

