/*
 * Decompiled with CFR 0.152.
 */
package com.sas.services.events.broker.monitor;

import com.sas.codepolicy.SASScope;
import com.sas.services.events.broker.EventResponseHandlerInterface;
import com.sas.services.events.broker.monitor.RB;
import com.sas.services.events.broker.monitor.ResponseAgent;
import com.sas.services.events.broker.monitor.ResponseException;
import java.rmi.RemoteException;
import java.util.ResourceBundle;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@SASScope
public class RMIResponseAgent
implements ResponseAgent {
    static final long serialVersionUID = -1505753039981910197L;
    private EventResponseHandlerInterface responseHandler;
    private Logger logger = null;
    private static final String RB_KEY = "RMIResponseAgent.";
    private static ResourceBundle rb = RB.getResources();

    public RMIResponseAgent(EventResponseHandlerInterface responseHandler) {
        this.responseHandler = responseHandler;
        this.logger = LogManager.getLogger((String)this.getClass().getName());
    }

    @Override
    public void init() throws ResponseException {
    }

    @Override
    public void sendResponse(String response) throws ResponseException {
        if (this.responseHandler != null) {
            try {
                this.responseHandler.handleResponse(response);
            }
            catch (RemoteException re) {
                this.logger.error(rb.getString("RMIResponseAgent.sendResponseRemoteException.ex.txt"), (Throwable)re);
                throw new ResponseException(rb.getString("RMIResponseAgent.sendResponseRemoteException.ex.txt"));
            }
        } else if (this.logger != null) {
            this.logger.error(rb.getString("RMIResponseAgent.notInitialized.ex.txt"));
        }
    }

    @Override
    public void term() {
        this.logger = null;
    }
}

