/*
 * Decompiled with CFR 0.152.
 */
package com.sas.services.events.broker.monitor;

import com.sas.codepolicy.SASScope;
import com.sas.services.events.ApplicationMonitorResources;
import com.sas.services.events.broker.monitor.MailResponseAgent;
import com.sas.services.events.broker.monitor.Monitor;
import com.sas.services.events.broker.monitor.MonitorException;
import com.sas.services.events.broker.monitor.MonitorThread;
import com.sas.services.events.broker.monitor.RB;
import com.sas.services.events.broker.util.EventContainer;
import com.sas.services.events.broker.util.EventRequest;
import com.sas.services.events.broker.util.MutexStateException;
import com.sas.services.logging.util.LoggerMonitor2;
import com.sas.util.SasPasswordEncodingException;
import com.sas.util.SasPasswordString;
import com.sun.mail.pop3.POP3Folder;
import java.io.IOException;
import java.io.InputStream;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.ResourceBundle;
import java.util.Vector;
import javax.mail.Address;
import javax.mail.AuthenticationFailedException;
import javax.mail.FetchProfile;
import javax.mail.Flags;
import javax.mail.Folder;
import javax.mail.FolderNotFoundException;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.Multipart;
import javax.mail.NoSuchProviderException;
import javax.mail.Part;
import javax.mail.Session;
import javax.mail.Store;
import javax.mail.UIDFolder;
import javax.mail.event.MessageCountAdapter;
import javax.mail.event.MessageCountEvent;
import javax.mail.event.MessageCountListener;
import javax.mail.internet.AddressException;
import javax.mail.internet.InternetAddress;
import javax.mail.search.SearchTerm;
import javax.mail.search.SubjectTerm;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@SASScope
public class MailMonitor
implements Monitor {
    MonitorThread self = null;
    private String name;
    private EventContainer eventContainer;
    private Logger logger;
    private LoggerMonitor2 _applicationMonitorLogger;
    private String defaultEvent;
    private String protocol;
    private String user;
    private String password;
    private String host;
    private String port;
    private String mbox = "InBox";
    private String subject;
    private String replyFrom;
    private String replyTo;
    private String replyCC;
    private String replyBCC;
    private String replySubject;
    private String debug;
    private boolean bDebugSpecified = false;
    private boolean bDebug = false;
    private Map responseProperties = new HashMap(4);
    private Session session;
    private Store store;
    private Folder folder;
    private int mode;
    private static final String RB_KEY = "MailMonitor.";
    private static ResourceBundle rb = RB.getResources();

    @Override
    public void init(String name, Map properties, EventContainer eventContainer) throws MonitorException {
        this.name = name;
        this.eventContainer = eventContainer;
        this.logger = LogManager.getLogger((String)this.getClass().getName());
        this._applicationMonitorLogger = new LoggerMonitor2(LogManager.getLogger((String)"ApplicationMonitor.EventBrokerService"));
        if (properties.containsKey("protocol")) {
            this.protocol = (String)properties.get("protocol");
        }
        if (properties.containsKey("user")) {
            this.user = (String)properties.get("user");
        }
        if (properties.containsKey("password")) {
            this.password = (String)properties.get("password");
            try {
                this.password = SasPasswordString.decode((String)this.password);
            }
            catch (SasPasswordEncodingException sasPasswordEncodingException) {
                // empty catch block
            }
        }
        if (properties.containsKey("host")) {
            this.host = (String)properties.get("host");
        }
        if (properties.containsKey("port")) {
            this.port = (String)properties.get("port");
        }
        if (properties.containsKey("inbox")) {
            this.mbox = (String)properties.get("inbox");
        }
        if (properties.containsKey("subject")) {
            this.subject = (String)properties.get("subject");
        }
        if (properties.containsKey("transport_reply_from")) {
            this.replyFrom = (String)properties.get("transport_reply_from");
        }
        if (properties.containsKey("transport_reply_to")) {
            this.replyTo = (String)properties.get("transport_reply_to");
        }
        if (properties.containsKey("transport_reply_cc")) {
            this.replyCC = (String)properties.get("transport_reply_cc");
        }
        if (properties.containsKey("transport_reply_bcc")) {
            this.replyBCC = (String)properties.get("transport_reply_bcc");
        }
        if (properties.containsKey("transport_reply_subject")) {
            this.replySubject = (String)properties.get("transport_reply_subject");
        }
        if (properties.containsKey("debug")) {
            this.bDebugSpecified = true;
            this.debug = (String)properties.get("debug");
            if (this.debug.equals("1")) {
                this.bDebug = true;
            }
        }
        if (properties.containsKey("default_event")) {
            this.defaultEvent = (String)properties.get("default_event");
        }
        if (properties.containsKey("transport_user")) {
            this.responseProperties.put("user", properties.get("transport_user"));
        }
        if (properties.containsKey("transport_password")) {
            String transport_password = (String)properties.get("transport_password");
            try {
                transport_password = SasPasswordString.decode((String)transport_password);
            }
            catch (SasPasswordEncodingException sasPasswordEncodingException) {
                // empty catch block
            }
            this.responseProperties.put("password", transport_password);
        }
        if (properties.containsKey("transport_host")) {
            this.responseProperties.put("host", properties.get("transport_host"));
        }
        if (properties.containsKey("transport_port")) {
            this.responseProperties.put("port", properties.get("transport_port"));
        }
        if (properties.containsKey("transport_reply_attachment")) {
            this.responseProperties.put("attachment", properties.get("transport_reply_attachment"));
        }
        if (this.debug != null) {
            this.responseProperties.put("debug", this.debug);
        }
        try {
            Properties props;
            try {
                props = System.getProperties();
            }
            catch (SecurityException se) {
                if (this.logger != null && this.logger.isDebugEnabled()) {
                    this.logger.debug(MessageFormat.format(rb.getString("MailMonitor.securityException.fmt.txt"), name));
                }
                props = new Properties();
            }
            if (this.logger != null && this.logger.isDebugEnabled()) {
                this.logger.debug(MessageFormat.format(rb.getString("MailMonitor.getSession.fmt.txt"), name));
            }
            this.session = Session.getDefaultInstance((Properties)props, null);
            if (this.bDebugSpecified) {
                if (this.logger != null && this.logger.isDebugEnabled()) {
                    this.logger.debug(MessageFormat.format(rb.getString("MailMonitor.setDebugSession.fmt.txt"), name));
                }
                this.session.setDebug(this.bDebug);
            }
            if (this.logger != null && this.logger.isDebugEnabled()) {
                this.logger.debug(MessageFormat.format(rb.getString("MailMonitor.getStore.fmt.txt"), name, this.protocol != null ? 1 : 0, this.protocol));
            }
            this.store = this.protocol != null ? this.session.getStore(this.protocol) : this.session.getStore();
            if (this.logger != null && this.logger.isDebugEnabled()) {
                this.logger.debug(MessageFormat.format(rb.getString("MailMonitor.connectStore.fmt.txt"), name, this.host != null ? 1 : 0, this.host, this.port != null ? 1 : 0, this.port, this.user != null ? 1 : 0, this.user));
            }
            if (this.host != null || this.port != null || this.user != null || this.password != null) {
                int nPort = -1;
                if (this.port != null) {
                    try {
                        nPort = Integer.parseInt(this.port);
                    }
                    catch (NumberFormatException numberFormatException) {
                        // empty catch block
                    }
                }
                this.store.connect(this.host, nPort, this.user, this.password);
            } else {
                this.store.connect();
            }
            if (this.logger != null && this.logger.isDebugEnabled()) {
                this.logger.debug(MessageFormat.format(rb.getString("MailMonitor.getDefaultFolder.fmt.txt"), name));
            }
            this.folder = this.store.getDefaultFolder();
            if (this.folder == null) {
                throw new MonitorException(rb.getString("MailMonitor.noDefaultFolder.ex.txt"));
            }
            if (!this.folder.exists()) {
                throw new MonitorException(rb.getString("MailMonitor.noDefaultFolder.ex.txt"));
            }
            if (this.logger != null && this.logger.isDebugEnabled()) {
                this.logger.debug(MessageFormat.format(rb.getString("MailMonitor.getFolder.fmt.txt"), name, this.mbox));
            }
            this.folder = this.folder.getFolder(this.mbox);
            if (this.folder == null) {
                throw new MonitorException(rb.getString("MailMonitor.invalidFolder.ex.txt"));
            }
            if (!this.folder.exists()) {
                throw new MonitorException(rb.getString("MailMonitor.invalidFolder.ex.txt"));
            }
            try {
                if (this.logger != null && this.logger.isDebugEnabled()) {
                    this.logger.debug(MessageFormat.format(rb.getString("MailMonitor.openFolder.fmt.txt"), name));
                }
                this.folder.open(2);
                this.mode = 2;
            }
            catch (MessagingException me) {
                if (this.logger != null && this.logger.isDebugEnabled()) {
                    this.logger.debug(MessageFormat.format(rb.getString("MailMonitor.retryOpenFolder.fmt.txt"), name));
                }
                this.folder.open(1);
                this.mode = 1;
            }
        }
        catch (NoSuchProviderException nspe) {
            if (this.logger != null) {
                this.logger.error(MessageFormat.format(rb.getString("MailMonitor.initNoSuchProviderException.fmt.txt"), name), (Throwable)nspe);
            }
            throw new MonitorException(rb.getString("MailMonitor.initNoSuchProviderException.ex.txt"));
        }
        catch (AuthenticationFailedException afe) {
            if (this.logger != null) {
                this.logger.error(MessageFormat.format(rb.getString("MailMonitor.initAuthenticationFailedException.fmt.txt"), name), (Throwable)afe);
            }
            throw new MonitorException(rb.getString("MailMonitor.initAuthenticationFailedException.ex.txt"));
        }
        catch (MessagingException me) {
            if (this.logger != null) {
                this.logger.error(MessageFormat.format(rb.getString("MailMonitor.initMessagingException.fmt.txt"), name), (Throwable)me);
            }
            throw new MonitorException(rb.getString("MailMonitor.initMessagingException.ex.txt"));
        }
        catch (IllegalStateException ise) {
            if (this.logger != null) {
                this.logger.error(MessageFormat.format(rb.getString("MailMonitor.initIllegalStateException.fmt.txt"), name), (Throwable)ise);
            }
            throw new MonitorException(rb.getString("MailMonitor.initIllegalStateException.ex.txt"));
        }
        if (this._applicationMonitorLogger != null && this._applicationMonitorLogger.isLoggingEnabled()) {
            this._applicationMonitorLogger.log(ApplicationMonitorResources.COLUMN_ACTION, MessageFormat.format(rb.getString("MailMonitor.started.AppMonitor.fmt.txt"), name), ApplicationMonitorResources.COLUMN_EVENT_NAME, "", ApplicationMonitorResources.COLUMN_HANDLER_NAME, "", ApplicationMonitorResources.COLUMN_INFORMATION, MessageFormat.format(rb.getString("MailMonitor.listening.AppMonitor.fmt.txt"), this.folder.getName(), this.store.getURLName().toString(), this.subject != null && this.subject.length() > 0 ? 1 : 0, '\'' + this.subject + '\''));
        }
        if (this.logger != null && this.logger.isInfoEnabled()) {
            this.logger.info(MessageFormat.format(rb.getString("MailMonitor.listening.fmt.txt"), name, this.folder.getName(), this.store.getURLName().toString(), this.subject != null && this.subject.length() > 0 ? 1 : 0, this.subject));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        this.self = (MonitorThread)Thread.currentThread();
        Message[] msgs = null;
        Vector<String> vUIDs = null;
        try {
            String UID;
            int i;
            FetchProfile fp2;
            if (this.folder.getMessageCount() > 0) {
                msgs = this.folder.getMessages();
                this.self.disableInterrupts();
                this.processMessages(msgs);
                this.self.enableInterrupts();
            }
            if (!(this.folder instanceof POP3Folder)) {
                this.folder.addMessageCountListener((MessageCountListener)new MessageCountAdapter(){

                    public void messagesAdded(MessageCountEvent event) {
                        MailMonitor.this.self.disableInterrupts();
                        Message[] msgs = event.getMessages();
                        MailMonitor.this.processMessages(msgs);
                        MailMonitor.this.self.enableInterrupts();
                    }
                });
            } else if (msgs != null && msgs.length > 0) {
                try {
                    fp2 = new FetchProfile();
                    fp2.add((FetchProfile.Item)UIDFolder.FetchProfileItem.UID);
                    this.folder.fetch(msgs, fp2);
                    vUIDs = new Vector<String>(msgs.length);
                    for (i = 0; i < msgs.length; ++i) {
                        UID = ((POP3Folder)this.folder).getUID(msgs[i]);
                        vUIDs.add(UID);
                    }
                }
                catch (MessagingException fp2) {
                    // empty catch block
                }
            }
            while (!Thread.interrupted()) {
                Thread.yield();
                if (Thread.interrupted()) {
                    break;
                }
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException e) {
                    break;
                }
                this.folder.getMessageCount();
                if (!(this.folder instanceof POP3Folder)) continue;
                this.folder.close(true);
                try {
                    this.folder.open(2);
                    this.mode = 2;
                }
                catch (MessagingException me) {
                    this.folder.open(1);
                    this.mode = 1;
                }
                if (this.folder.getMessageCount() <= 0) continue;
                msgs = this.folder.getMessages();
                this.self.disableInterrupts();
                try {
                    fp2 = new FetchProfile();
                    fp2.add((FetchProfile.Item)UIDFolder.FetchProfileItem.UID);
                    this.folder.fetch(msgs, fp2);
                    for (i = 0; i < msgs.length; ++i) {
                        UID = ((POP3Folder)this.folder).getUID(msgs[i]);
                        if (vUIDs.contains(UID)) continue;
                        vUIDs.add(UID);
                        Message[] msg = new Message[]{msgs[i]};
                        this.processMessages(msg);
                    }
                }
                catch (MessagingException fp3) {
                    // empty catch block
                }
                this.self.enableInterrupts();
            }
        }
        catch (FolderNotFoundException fnfe) {
            if (this.logger != null) {
                this.logger.error(MessageFormat.format(rb.getString("MailMonitor.runFolderNotFoundException.fmt.txt"), this.name), (Throwable)fnfe);
            }
        }
        catch (MessagingException me) {
            if (this.logger != null) {
                this.logger.error(MessageFormat.format(rb.getString("MailMonitor.runMessagingException.fmt.txt"), this.name), (Throwable)me);
            }
        }
        catch (IllegalStateException ise) {
            if (this.logger != null) {
                this.logger.error(MessageFormat.format(rb.getString("MailMonitor.runIllegalStateException.fmt.txt"), this.name), (Throwable)ise);
            }
        }
        finally {
            try {
                this.folder.close(true);
                this.store.close();
            }
            catch (MessagingException fnfe) {
            }
            catch (IllegalStateException fnfe) {}
        }
        if (this.logger != null && this.logger.isDebugEnabled()) {
            this.logger.debug(MessageFormat.format(rb.getString("MailMonitor.exit.fmt.txt"), this.name, Thread.currentThread().getName()));
        }
        this.logger = null;
    }

    void processMessages(Message[] msgs) {
        block60: {
            String strEvent = null;
            EventRequest eventRequest = null;
            try {
                FetchProfile fp = new FetchProfile();
                fp.add(FetchProfile.Item.ENVELOPE);
                this.folder.fetch(msgs, fp);
                SubjectTerm subjectTerm = null;
                if (this.subject != null) {
                    subjectTerm = new SubjectTerm(this.subject);
                }
                for (int i = 0; i < msgs.length; ++i) {
                    block59: {
                        MailResponseAgent responseAgent;
                        block58: {
                            Message replyMessage;
                            block57: {
                                block56: {
                                    block55: {
                                        block54: {
                                            if (this.logger != null && this.logger.isDebugEnabled()) {
                                                this.logger.debug(MessageFormat.format(rb.getString("MailMonitor.newMessage.fmt.txt"), this.name));
                                            }
                                            if (this.subject != null && !msgs[i].match((SearchTerm)subjectTerm)) {
                                                if (this.logger == null || !this.logger.isDebugEnabled()) continue;
                                                this.logger.debug(MessageFormat.format(rb.getString("MailMonitor.subjectMismatch.fmt.txt"), this.name, this.subject));
                                                continue;
                                            }
                                            replyMessage = msgs[i].reply(true);
                                            if (this.replyFrom != null) {
                                                try {
                                                    replyMessage.setFrom((Address)new InternetAddress(this.replyFrom));
                                                }
                                                catch (AddressException ae) {
                                                    replyMessage.setFrom();
                                                }
                                            } else {
                                                replyMessage.setFrom();
                                            }
                                            if (this.replyTo != null) {
                                                try {
                                                    replyMessage.setRecipients(Message.RecipientType.TO, (Address[])InternetAddress.parse((String)this.replyTo));
                                                }
                                                catch (AddressException ae) {
                                                    if (this.logger != null) {
                                                        this.logger.error(MessageFormat.format(rb.getString("MailMonitor.setReplyToAddressException.fmt.txt"), this.name), (Throwable)ae);
                                                    }
                                                }
                                                catch (MessagingException me) {
                                                    if (this.logger != null) {
                                                        this.logger.error(MessageFormat.format(rb.getString("MailMonitor.setReplyToMessagingException.fmt.txt"), this.name), (Throwable)me);
                                                    }
                                                }
                                                catch (IllegalStateException ise) {
                                                    if (this.logger == null) break block54;
                                                    this.logger.error(MessageFormat.format(rb.getString("MailMonitor.setReplyToIllegalStateException.fmt.txt"), this.name), (Throwable)ise);
                                                }
                                            }
                                        }
                                        if (this.replyCC != null) {
                                            try {
                                                replyMessage.setRecipients(Message.RecipientType.CC, (Address[])InternetAddress.parse((String)this.replyCC));
                                            }
                                            catch (AddressException ae) {
                                                if (this.logger != null) {
                                                    this.logger.error(MessageFormat.format(rb.getString("MailMonitor.setReplyCCAddressException.fmt.txt"), this.name), (Throwable)ae);
                                                }
                                            }
                                            catch (MessagingException me) {
                                                if (this.logger != null) {
                                                    this.logger.error(MessageFormat.format(rb.getString("MailMonitor.setReplyCCMessagingException.fmt.txt"), this.name), (Throwable)me);
                                                }
                                            }
                                            catch (IllegalStateException ise) {
                                                if (this.logger == null) break block55;
                                                this.logger.error(MessageFormat.format(rb.getString("MailMonitor.setReplyCCIllegalStateException.fmt.txt"), this.name), (Throwable)ise);
                                            }
                                        }
                                    }
                                    if (this.replyBCC != null) {
                                        try {
                                            replyMessage.setRecipients(Message.RecipientType.BCC, (Address[])InternetAddress.parse((String)this.replyBCC));
                                        }
                                        catch (AddressException ae) {
                                            if (this.logger != null) {
                                                this.logger.error(MessageFormat.format(rb.getString("MailMonitor.setReplyBCCAddressException.fmt.txt"), this.name), (Throwable)ae);
                                            }
                                        }
                                        catch (MessagingException me) {
                                            if (this.logger != null) {
                                                this.logger.error(MessageFormat.format(rb.getString("MailMonitor.setReplyBCCMessagingException.fmt.txt"), this.name), (Throwable)me);
                                            }
                                        }
                                        catch (IllegalStateException ise) {
                                            if (this.logger == null) break block56;
                                            this.logger.error(MessageFormat.format(rb.getString("MailMonitor.setReplyBCCIllegalStateException.fmt.txt"), this.name), (Throwable)ise);
                                        }
                                    }
                                }
                                try {
                                    if (this.replySubject != null) {
                                        replyMessage.setSubject(this.replySubject);
                                    } else {
                                        String oldSubject = replyMessage.getSubject();
                                        replyMessage.setSubject(oldSubject + " (SAS EventBroker response)");
                                    }
                                }
                                catch (MessagingException me) {
                                    if (this.logger != null) {
                                        this.logger.error(MessageFormat.format(rb.getString("MailMonitor.setReplySubjectMessagingException.fmt.txt"), this.name), (Throwable)me);
                                    }
                                }
                                catch (IllegalStateException ise) {
                                    if (this.logger == null) break block57;
                                    this.logger.error(MessageFormat.format(rb.getString("MailMonitor.setReplySubjectIllegalStateException.fmt.txt"), this.name), (Throwable)ise);
                                }
                            }
                            this.responseProperties.put("replyMessage", replyMessage);
                            responseAgent = new MailResponseAgent(this.name, this.responseProperties, this.logger);
                            try {
                                if (this.logger != null && this.logger.isDebugEnabled()) {
                                    this.logger.debug(rb.getString("MailMonitor.getContent.txt"));
                                }
                                strEvent = this.getContent((Part)msgs[i]);
                                if (this.mode != 2) break block58;
                                try {
                                    msgs[i].setFlag(Flags.Flag.DELETED, true);
                                    msgs[i].saveChanges();
                                    this.folder.expunge();
                                }
                                catch (Exception saveChangesException) {
                                    this.folder.close(true);
                                    try {
                                        this.folder.open(2);
                                        this.mode = 2;
                                    }
                                    catch (MessagingException me) {
                                        this.folder.open(1);
                                        this.mode = 1;
                                    }
                                }
                            }
                            catch (Exception e) {
                                if (this.logger == null) continue;
                                this.logger.error(MessageFormat.format(rb.getString("MailMonitor.discardMessage.fmt.txt"), this.name, e.getMessage()));
                                continue;
                            }
                        }
                        eventRequest = new EventRequest(strEvent, responseAgent);
                        if (this.defaultEvent != null) {
                            eventRequest.setDefaultEvent(this.defaultEvent);
                        }
                        try {
                            this.eventContainer._mutex.lock();
                        }
                        catch (InterruptedException ie) {
                            if (this.logger == null) break block59;
                            this.logger.error(MessageFormat.format(rb.getString("MailMonitor.mutexInterrupt.fmt.txt"), this.name));
                        }
                    }
                    while (this.eventContainer.isFull()) {
                        try {
                            this.eventContainer._monitorCV.condWait(this.eventContainer._mutex);
                        }
                        catch (InterruptedException ie) {
                            if (this.logger == null) continue;
                            this.logger.error(MessageFormat.format(rb.getString("MailMonitor.condWaitInterrupt.fmt.txt"), this.name));
                        }
                    }
                    this.eventContainer.add(eventRequest);
                    try {
                        this.eventContainer._mutex.unlock();
                    }
                    catch (MutexStateException mutexStateException) {
                        // empty catch block
                    }
                    this.eventContainer._workerCV.condSignal();
                }
            }
            catch (MessagingException me) {
                if (this.logger != null) {
                    this.logger.error(MessageFormat.format(rb.getString("MailMonitor.runMessagingException.fmt.txt"), this.name), (Throwable)me);
                }
            }
            catch (IllegalStateException ise) {
                if (this.logger == null) break block60;
                this.logger.error(MessageFormat.format(rb.getString("MailMonitor.runIllegalStateException.fmt.txt"), this.name), (Throwable)ise);
            }
        }
    }

    private String getContent(Part part) throws Exception {
        String content;
        block22: {
            content = null;
            InputStream is = null;
            try {
                Object contentObject = part.getContent();
                if (contentObject instanceof String) {
                    content = (String)contentObject;
                    break block22;
                }
                if (contentObject instanceof InputStream) {
                    int c;
                    is = (InputStream)contentObject;
                    StringBuffer contentBuffer = new StringBuffer();
                    while ((c = is.read()) != -1) {
                        contentBuffer.append((char)c);
                    }
                    content = new String(contentBuffer);
                    break block22;
                }
                if (contentObject instanceof Multipart) {
                    Multipart multiPart = (Multipart)contentObject;
                    int parts = multiPart.getCount();
                    part = multiPart.getBodyPart(parts - 1);
                    if ((contentObject = part.getContent()) instanceof String) {
                        content = (String)contentObject;
                        break block22;
                    }
                    if (contentObject instanceof InputStream) {
                        int c;
                        is = (InputStream)contentObject;
                        StringBuffer contentBuffer = new StringBuffer();
                        while ((c = is.read()) != -1) {
                            contentBuffer.append((char)c);
                        }
                        content = new String(contentBuffer);
                        break block22;
                    }
                    throw new Exception(rb.getString("MailMonitor.getContentUnexpectedContent.ex.txt"));
                }
                throw new Exception(rb.getString("MailMonitor.getContentUnexpectedContent.ex.txt"));
            }
            catch (IOException ioe) {
                if (this.logger != null) {
                    this.logger.error(MessageFormat.format(rb.getString("MailMonitor.getContentIOException.fmt.txt"), this.name), (Throwable)ioe);
                }
                throw new Exception(rb.getString("MailMonitor.getContentIOException.ex.txt"));
            }
            catch (MessagingException me) {
                if (this.logger != null) {
                    this.logger.error(MessageFormat.format(rb.getString("MailMonitor.getContentMessagingException.fmt.txt"), this.name), (Throwable)me);
                }
                throw new Exception(rb.getString("MailMonitor.getContentMessagingException.ex.txt"));
            }
            catch (IndexOutOfBoundsException ie) {
                if (this.logger != null) {
                    this.logger.error(MessageFormat.format(rb.getString("MailMonitor.getContentIndexOutOfBoundsException.fmt.txt"), this.name), (Throwable)ie);
                }
                throw new Exception(rb.getString("MailMonitor.getContentIndexOutOfBoundsException.ex.txt"));
            }
            finally {
                if (is != null) {
                    try {
                        is.close();
                    }
                    catch (IOException iOException) {}
                }
            }
        }
        return content;
    }
}

