/*
 * Decompiled with CFR 0.152.
 */
package com.sas.services.events.broker.monitor;

import com.sas.codepolicy.SASScope;
import com.sas.services.events.ApplicationMonitorResources;
import com.sas.services.events.broker.monitor.MQJMSResponseAgent;
import com.sas.services.events.broker.monitor.Monitor;
import com.sas.services.events.broker.monitor.MonitorException;
import com.sas.services.events.broker.monitor.MonitorThread;
import com.sas.services.events.broker.monitor.RB;
import com.sas.services.events.broker.util.EventContainer;
import com.sas.services.events.broker.util.EventRequest;
import com.sas.services.events.broker.util.MutexStateException;
import com.sas.services.logging.util.LoggerMonitor2;
import com.sas.util.SasPasswordEncodingException;
import com.sas.util.SasPasswordString;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.Map;
import java.util.ResourceBundle;
import javax.jms.BytesMessage;
import javax.jms.ConnectionMetaData;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageListener;
import javax.jms.Queue;
import javax.jms.QueueConnection;
import javax.jms.QueueConnectionFactory;
import javax.jms.QueueReceiver;
import javax.jms.QueueSession;
import javax.jms.TextMessage;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@SASScope
public class MQJMSMonitor
implements Monitor,
MessageListener {
    private static final int NUM_BYTES_IN_PACKET = 80;
    private static final int SLEEP_TIME_MSEC = 1000;
    private static final int DEFAULT_PORT = 1414;
    private MonitorThread self;
    private String name;
    private EventContainer eventContainer;
    private Logger logger;
    private LoggerMonitor2 _applicationMonitorLogger;
    private String defaultEvent;
    private String strHost;
    private int port;
    private String strUser;
    private String strPassword;
    private String strChannel;
    private String strQueue;
    private String strSelector;
    private final Map responseProperties = new HashMap(5);
    private Queue queue;
    private QueueSession session;
    private QueueConnection connection;
    private QueueConnectionFactory factory;
    private QueueReceiver receiver;
    private static final String RB_KEY = "MQJMSMonitor.";
    private static ResourceBundle rb = RB.getResources();

    @Override
    public void init(String name, Map properties, EventContainer eventContainer) throws MonitorException {
        String tmpPassword;
        String tmpUser;
        this.name = name;
        this.eventContainer = eventContainer;
        this.logger = LogManager.getLogger((String)this.getClass().getName());
        this._applicationMonitorLogger = new LoggerMonitor2(LogManager.getLogger((String)"ApplicationMonitor.EventBrokerService"));
        this.strHost = properties.containsKey("host") ? (String)properties.get("host") : "localhost";
        if (properties.containsKey("port")) {
            try {
                this.port = Integer.parseInt((String)properties.get("port"));
            }
            catch (NumberFormatException e) {
                if (this.logger != null && this.logger.isWarnEnabled()) {
                    this.logger.warn(MessageFormat.format(rb.getString("MQJMSMonitor.invalidPort.fmt.txt"), properties.get("port"), name));
                }
                this.port = 1414;
            }
        } else {
            this.port = 1414;
        }
        if (properties.containsKey("user") && (tmpUser = (String)properties.get("user")).length() > 0) {
            this.strUser = tmpUser;
        }
        if (properties.containsKey("password") && (tmpPassword = (String)properties.get("password")).length() > 0) {
            this.strPassword = tmpPassword;
            try {
                this.strPassword = SasPasswordString.decode((String)this.strPassword);
            }
            catch (SasPasswordEncodingException sasPasswordEncodingException) {
                // empty catch block
            }
        }
        this.strChannel = properties.containsKey("channel") ? (String)properties.get("channel") : "JAVA.CHANNEL";
        if (!properties.containsKey("queue")) {
            throw new MonitorException(rb.getString("MQJMSMonitor.noQueue.ex.txt"));
        }
        this.strQueue = (String)properties.get("queue");
        if (properties.containsKey("selector")) {
            this.strSelector = (String)properties.get("selector");
        }
        if (properties.containsKey("default_event")) {
            this.defaultEvent = (String)properties.get("default_event");
        }
        if (this.strUser != null) {
            this.responseProperties.put("user", this.strUser);
        }
        if (this.strPassword != null) {
            this.responseProperties.put("password", this.strPassword);
        }
        if (properties.containsKey("reply_to_queue")) {
            this.responseProperties.put("reply_to_queue", properties.get("reply_to_queue"));
        }
        try {
            Class<?> qClass;
            if (this.logger != null && this.logger.isDebugEnabled()) {
                this.logger.debug(MessageFormat.format(rb.getString("MQJMSMonitor.createQCF.fmt.txt"), name, this.strHost, this.port, this.strChannel));
            }
            this.factory = null;
            try {
                qClass = this.getClass().getClassLoader().loadClass("com.ibm.mq.jms.MQQueueConnectionFactory");
                Constructor<?> ctor = qClass.getConstructor(null);
                ctor.setAccessible(true);
                this.factory = (QueueConnectionFactory)ctor.newInstance(null);
                Class[] params = new Class[]{Integer.TYPE};
                Object[] args = new Object[]{1};
                Method method = this.factory.getClass().getDeclaredMethod("setTransportType", params);
                method.setAccessible(true);
                method.invoke((Object)this.factory, args);
                params = new Class[]{String.class};
                args = new Object[]{this.strHost};
                method = this.factory.getClass().getDeclaredMethod("setHostName", params);
                method.setAccessible(true);
                method.invoke((Object)this.factory, args);
                params = new Class[]{Integer.TYPE};
                args = new Object[]{this.port};
                method = this.factory.getClass().getDeclaredMethod("setPort", params);
                method.setAccessible(true);
                method.invoke((Object)this.factory, args);
                params = new Class[]{String.class};
                args = new Object[]{this.strChannel};
                method = this.factory.getClass().getDeclaredMethod("setChannel", params);
                method.setAccessible(true);
                method.invoke((Object)this.factory, args);
            }
            catch (ClassNotFoundException ex) {
                if (this.logger != null) {
                    this.logger.error(MessageFormat.format(rb.getString("MQJMSMonitor.initJMSException.fmt.txt"), name), (Throwable)ex);
                }
                throw new MonitorException(rb.getString("MQJMSMonitor.initJMSException.ex.txt"));
            }
            catch (InvocationTargetException ex) {
                if (this.logger != null) {
                    this.logger.error(MessageFormat.format(rb.getString("MQJMSMonitor.initJMSException.fmt.txt"), name), (Throwable)ex);
                }
                throw new MonitorException(rb.getString("MQJMSMonitor.initJMSException.ex.txt"));
            }
            catch (InstantiationException ex) {
                if (this.logger != null) {
                    this.logger.error(MessageFormat.format(rb.getString("MQJMSMonitor.initJMSException.fmt.txt"), name), (Throwable)ex);
                }
                throw new MonitorException(rb.getString("MQJMSMonitor.initJMSException.ex.txt"));
            }
            catch (IllegalAccessException ex) {
                if (this.logger != null) {
                    this.logger.error(MessageFormat.format(rb.getString("MQJMSMonitor.initJMSException.fmt.txt"), name), (Throwable)ex);
                }
                throw new MonitorException(rb.getString("MQJMSMonitor.initJMSException.ex.txt"));
            }
            catch (NoSuchMethodException ex) {
                if (this.logger != null) {
                    this.logger.error(MessageFormat.format(rb.getString("MQJMSMonitor.initJMSException.fmt.txt"), name), (Throwable)ex);
                }
                throw new MonitorException(rb.getString("MQJMSMonitor.initJMSException.ex.txt"));
            }
            this.responseProperties.put("qcf", this.factory);
            if (this.logger != null && this.logger.isDebugEnabled()) {
                this.logger.debug(MessageFormat.format(rb.getString("MQJMSMonitor.createQueueConnection.fmt.txt"), name));
            }
            this.connection = this.strUser != null && this.strPassword != null ? this.factory.createQueueConnection(this.strUser, this.strPassword) : this.factory.createQueueConnection();
            this.connection.start();
            if (this.logger != null && this.logger.isDebugEnabled()) {
                this.logger.debug(MessageFormat.format(rb.getString("MQJMSMonitor.createQueueSession.fmt.txt"), name));
            }
            this.session = this.connection.createQueueSession(false, 1);
            if (this.logger != null && this.logger.isDebugEnabled()) {
                this.logger.debug(MessageFormat.format(rb.getString("MQJMSMonitor.createQueue.fmt.txt"), name, this.strQueue));
            }
            this.queue = null;
            try {
                qClass = this.getClass().getClassLoader().loadClass("com.ibm.mq.jms.MQQueue");
                Class[] params = new Class[]{String.class};
                Object[] args = new Object[]{"queue:///" + this.strQueue};
                Constructor<?> ctor = qClass.getConstructor(params);
                ctor.setAccessible(true);
                this.queue = (Queue)ctor.newInstance(args);
            }
            catch (ClassNotFoundException ex) {
                if (this.logger != null) {
                    this.logger.error(MessageFormat.format(rb.getString("MQJMSMonitor.initJMSException.fmt.txt"), name), (Throwable)ex);
                }
                throw new MonitorException(rb.getString("MQJMSMonitor.initJMSException.ex.txt"));
            }
            catch (NoSuchMethodException ex) {
                if (this.logger != null) {
                    this.logger.error(MessageFormat.format(rb.getString("MQJMSMonitor.initJMSException.fmt.txt"), name), (Throwable)ex);
                }
                throw new MonitorException(rb.getString("MQJMSMonitor.initJMSException.ex.txt"));
            }
            catch (InvocationTargetException ex) {
                if (this.logger != null) {
                    this.logger.error(MessageFormat.format(rb.getString("MQJMSMonitor.initJMSException.fmt.txt"), name), (Throwable)ex);
                }
                throw new MonitorException(rb.getString("MQJMSMonitor.initJMSException.ex.txt"));
            }
            catch (IllegalAccessException ex) {
                if (this.logger != null) {
                    this.logger.error(MessageFormat.format(rb.getString("MQJMSMonitor.initJMSException.fmt.txt"), name), (Throwable)ex);
                }
                throw new MonitorException(rb.getString("MQJMSMonitor.initJMSException.ex.txt"));
            }
            catch (InstantiationException ex) {
                if (this.logger != null) {
                    this.logger.error(MessageFormat.format(rb.getString("MQJMSMonitor.initJMSException.fmt.txt"), name), (Throwable)ex);
                }
                throw new MonitorException(rb.getString("MQJMSMonitor.initJMSException.ex.txt"));
            }
            if (this.logger != null && this.logger.isDebugEnabled()) {
                this.logger.debug(MessageFormat.format(rb.getString("MQJMSMonitor.createReceiver.fmt.txt"), name, this.strSelector != null ? 1 : 0, this.strSelector));
            }
            this.receiver = this.strSelector != null ? this.session.createReceiver(this.queue, this.strSelector) : this.session.createReceiver(this.queue);
        }
        catch (JMSException je) {
            if (this.logger != null) {
                this.logger.error(MessageFormat.format(rb.getString("MQJMSMonitor.initJMSException.fmt.txt"), name), (Throwable)je);
            }
            throw new MonitorException(rb.getString("MQJMSMonitor.initJMSException.ex.txt"));
        }
        String queueName = "";
        String providerName = "";
        String providerVersion = "";
        try {
            queueName = this.queue.getQueueName();
            ConnectionMetaData connectionMetadata = this.connection.getMetaData();
            providerName = connectionMetadata.getJMSProviderName();
            providerVersion = connectionMetadata.getProviderVersion();
        }
        catch (JMSException je) {
            this.logger.error(je.getMessage(), (Throwable)je);
        }
        if (this._applicationMonitorLogger != null && this._applicationMonitorLogger.isLoggingEnabled()) {
            this._applicationMonitorLogger.log(ApplicationMonitorResources.COLUMN_ACTION, MessageFormat.format(rb.getString("MQJMSMonitor.started.AppMonitor.fmt.txt"), name), ApplicationMonitorResources.COLUMN_EVENT_NAME, "", ApplicationMonitorResources.COLUMN_HANDLER_NAME, "", ApplicationMonitorResources.COLUMN_INFORMATION, MessageFormat.format(rb.getString("MQJMSMonitor.listening.AppMonitor.fmt.txt"), queueName, providerName, providerVersion, this.strSelector != null && this.strSelector.length() > 0 ? 1 : 0, '\'' + this.strSelector + '\''));
        }
        if (this.logger != null && this.logger.isInfoEnabled()) {
            this.logger.info(MessageFormat.format(rb.getString("MQJMSMonitor.listening.fmt.txt"), name, queueName, providerName, providerVersion, this.strSelector != null && this.strSelector.length() > 0 ? 1 : 0, this.strSelector));
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void run() {
        this.self = (MonitorThread)Thread.currentThread();
        try {
            if (this.logger != null && this.logger.isDebugEnabled()) {
                this.logger.debug(MessageFormat.format(rb.getString("MQJMSMonitor.setMessageListener.fmt.txt"), this.name));
            }
            this.receiver.setMessageListener((MessageListener)this);
            while (!Thread.interrupted()) {
                Thread.yield();
                if (!Thread.interrupted()) {
                    try {
                        Thread.sleep(1000L);
                        continue;
                    }
                    catch (InterruptedException e) {
                        // empty catch block
                    }
                }
                break;
            }
        }
        catch (JMSException je) {
            if (this.logger != null) {
                this.logger.error(MessageFormat.format(rb.getString("MQJMSMonitor.runJMSException.fmt.txt"), this.name), (Throwable)je);
            }
        }
        finally {
            try {
                this.receiver.close();
                this.session.close();
                this.connection.close();
            }
            catch (JMSException jMSException) {}
        }
        if (this.logger != null && this.logger.isDebugEnabled()) {
            this.logger.debug(MessageFormat.format(rb.getString("MQJMSMonitor.exit.fmt.txt"), this.name, Thread.currentThread().getName()));
        }
        this.logger = null;
    }

    public void onMessage(Message msg) {
        String strEvent = null;
        EventRequest eventRequest = null;
        if (this.logger != null && this.logger.isDebugEnabled()) {
            this.logger.debug(MessageFormat.format(rb.getString("MQJMSMonitor.receivedMessage.fmt.txt"), this.name));
        }
        this.self.disableInterrupts();
        if (msg instanceof TextMessage || msg instanceof BytesMessage) {
            block28: {
                block27: {
                    block26: {
                        if (msg instanceof TextMessage) {
                            try {
                                strEvent = ((TextMessage)msg).getText();
                            }
                            catch (JMSException je) {
                                if (this.logger != null) {
                                    this.logger.error(MessageFormat.format(rb.getString("MQJMSMonitor.failedGetText.fmt.txt"), this.name), (Throwable)je);
                                }
                                this.self.enableInterrupts();
                                return;
                            }
                        }
                        try {
                            int packetLength;
                            byte[] data = null;
                            int length = 0;
                            byte[] packet = new byte[80];
                            while ((packetLength = ((BytesMessage)msg).readBytes(packet)) != -1) {
                                length += packetLength;
                            }
                            data = new byte[length];
                            ((BytesMessage)msg).reset();
                            length = ((BytesMessage)msg).readBytes(data);
                            strEvent = new String(data);
                        }
                        catch (JMSException je) {
                            if (this.logger != null) {
                                this.logger.error(MessageFormat.format(rb.getString("MQJMSMonitor.failedGetBytes.fmt.txt"), this.name), (Throwable)je);
                            }
                            this.self.enableInterrupts();
                            return;
                        }
                        try {
                            this.responseProperties.put("replyCorrelId", msg.getJMSMessageID());
                        }
                        catch (JMSException je) {
                            if (this.logger == null) break block26;
                            this.logger.error(MessageFormat.format(rb.getString("MQJMSMonitor.failedGetMessageID.fmt.txt"), this.name), (Throwable)je);
                        }
                    }
                    try {
                        Destination replyToDest = msg.getJMSReplyTo();
                        if (replyToDest != null) {
                            this.responseProperties.put("reply_to_dest", replyToDest);
                        } else {
                            this.responseProperties.remove("reply_to_dest");
                        }
                    }
                    catch (JMSException je) {
                        if (this.logger == null) break block27;
                        this.logger.error(MessageFormat.format(rb.getString("MQJMSMonitor.failedGetReplyDest.fmt.txt"), this.name), (Throwable)je);
                    }
                }
                MQJMSResponseAgent responseAgent = new MQJMSResponseAgent(this.name, this.responseProperties, this.logger);
                eventRequest = new EventRequest(strEvent, responseAgent);
                if (this.defaultEvent != null) {
                    eventRequest.setDefaultEvent(this.defaultEvent);
                }
                try {
                    this.eventContainer._mutex.lock();
                }
                catch (InterruptedException ie) {
                    if (this.logger == null) break block28;
                    this.logger.error(MessageFormat.format(rb.getString("MQJMSMonitor.mutexInterrupt.fmt.txt"), this.name));
                }
            }
            while (this.eventContainer.isFull()) {
                try {
                    this.eventContainer._monitorCV.condWait(this.eventContainer._mutex);
                }
                catch (InterruptedException ie) {
                    if (this.logger == null) continue;
                    this.logger.error(MessageFormat.format(rb.getString("MQJMSMonitor.condWaitInterrupt.fmt.txt"), this.name));
                }
            }
            this.eventContainer.add(eventRequest);
            try {
                this.eventContainer._mutex.unlock();
            }
            catch (MutexStateException mutexStateException) {
                // empty catch block
            }
            this.eventContainer._workerCV.condSignal();
        } else if (this.logger != null) {
            this.logger.error(MessageFormat.format(rb.getString("MQJMSMonitor.invalidMessage.fmt.txt"), this.name));
        }
        this.self.enableInterrupts();
    }
}

