/*
 * Decompiled with CFR 0.152.
 */
package com.sas.services.events.broker.monitor;

import com.sas.codepolicy.SASScope;
import com.sas.services.events.broker.monitor.RB;
import com.sas.services.events.broker.monitor.ResponseAgent;
import com.sas.services.events.broker.monitor.ResponseException;
import java.text.MessageFormat;
import java.util.Hashtable;
import java.util.Map;
import java.util.ResourceBundle;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.Queue;
import javax.jms.QueueConnection;
import javax.jms.QueueConnectionFactory;
import javax.jms.QueueSender;
import javax.jms.QueueSession;
import javax.jms.TextMessage;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import org.apache.logging.log4j.Logger;

@SASScope
public class JMSResponseAgent
implements ResponseAgent {
    static final long serialVersionUID = 8425519854837678721L;
    private String name;
    private Logger logger;
    private String strJNDIQName;
    private String strJNDIICF;
    private String strJNDIURL;
    private String strJNDIAuth;
    private String strJNDIPrincipal;
    private String strJNDICredentials;
    private String strCorrelId;
    private Queue destQueue;
    private InitialContext ctx;
    private Queue queue = null;
    private QueueSession session = null;
    private QueueConnection connection = null;
    private QueueConnectionFactory factory = null;
    private QueueSender sender = null;
    private String loggingContext;
    private static final String RB_KEY = "JMSResponseAgent.";
    private static ResourceBundle rb = RB.getResources();

    public JMSResponseAgent(String name, Map properties, Logger logger) {
        this.name = name;
        this.logger = logger;
        this.loggingContext = this.getClass().getName();
        this.strJNDIQName = (String)properties.get("replyToJNDIQName");
        this.factory = (QueueConnectionFactory)properties.get("JNDIQueueFactory");
        this.strJNDIICF = (String)properties.get("replyToJNDIICF");
        this.strJNDIURL = (String)properties.get("replyToJNDIURL");
        this.strJNDIAuth = (String)properties.get("replyToJNDIAuth");
        this.strJNDIPrincipal = (String)properties.get("replyToJNDIPrincipal");
        this.strJNDICredentials = (String)properties.get("replyToJNDICredentials");
        this.destQueue = (Queue)properties.get("replyToDest");
        this.strCorrelId = (String)properties.get("replyCorrelId");
    }

    @Override
    public void init() throws ResponseException {
        if (this.destQueue == null && this.strJNDIQName == null) {
            throw new ResponseException(rb.getString("JMSResponseAgent.noReplyQueue.ex.txt"));
        }
        try {
            if (this.destQueue == null) {
                Hashtable<String, String> env = new Hashtable<String, String>();
                env.put("java.naming.factory.initial", this.strJNDIICF);
                env.put("java.naming.provider.url", this.strJNDIURL);
                env.put("java.naming.security.authentication", this.strJNDIAuth);
                if (!this.strJNDIAuth.equalsIgnoreCase("none")) {
                    if (this.strJNDIPrincipal != null) {
                        env.put("java.naming.security.principal", this.strJNDIPrincipal);
                    }
                    if (this.strJNDICredentials != null) {
                        env.put("java.naming.security.credentials", this.strJNDICredentials);
                    }
                }
                this.ctx = new InitialContext(env);
                if (this.logger != null && this.logger.isDebugEnabled()) {
                    this.logger.debug(MessageFormat.format(rb.getString("JMSResponseAgent.createQueue.fmt.txt"), this.name, this.strJNDIQName), (Object)this.loggingContext);
                }
                this.queue = (Queue)this.ctx.lookup(this.strJNDIQName);
            } else {
                this.queue = this.destQueue;
            }
            if (this.logger != null && this.logger.isDebugEnabled()) {
                this.logger.debug(MessageFormat.format(rb.getString("JMSResponseAgent.createQueueConnection.fmt.txt"), this.name), (Object)this.loggingContext);
            }
            this.connection = this.factory.createQueueConnection();
            this.connection.start();
            if (this.logger != null && this.logger.isDebugEnabled()) {
                this.logger.debug(MessageFormat.format(rb.getString("JMSResponseAgent.createQueueSession.fmt.txt"), this.name), (Object)this.loggingContext);
            }
            this.session = this.connection.createQueueSession(false, 1);
            if (this.logger != null && this.logger.isDebugEnabled()) {
                this.logger.debug(MessageFormat.format(rb.getString("JMSResponseAgent.createSender.fmt.txt"), this.name), (Object)this.loggingContext);
            }
            this.sender = this.session.createSender(this.queue);
        }
        catch (JMSException je) {
            if (this.logger != null) {
                this.logger.error(MessageFormat.format(rb.getString("JMSResponseAgent.initJMSException.fmt.txt"), this.name), (Object)this.loggingContext, (Object)je);
            }
            throw new ResponseException(rb.getString("JMSResponseAgent.initJMSException.ex.txt"));
        }
        catch (NamingException ne) {
            if (this.logger != null) {
                this.logger.error(MessageFormat.format(rb.getString("JMSResponseAgent.initNamingException.fmt.txt"), this.name), (Object)this.loggingContext, (Object)ne);
            }
            throw new ResponseException(rb.getString("JMSResponseAgent.initNamingException.ex.txt"));
        }
        finally {
            if (this.ctx != null) {
                try {
                    this.ctx.close();
                }
                catch (Exception exception) {}
            }
        }
    }

    @Override
    public void sendResponse(String response) throws ResponseException {
        if (this.sender != null) {
            try {
                TextMessage message;
                block7: {
                    message = this.session.createTextMessage(response);
                    try {
                        if (this.strCorrelId != null) {
                            message.setJMSCorrelationID(this.strCorrelId);
                        }
                    }
                    catch (JMSException je) {
                        if (this.logger == null) break block7;
                        this.logger.error(MessageFormat.format(rb.getString("JMSResponseAgent.failedSetMessageID.fmt.txt"), this.name), (Object)this.loggingContext, (Object)je);
                    }
                }
                this.sender.send((Message)message);
            }
            catch (JMSException je) {
                if (this.logger != null) {
                    this.logger.error(MessageFormat.format(rb.getString("JMSResponseAgent.sendResponseJMSException.fmt.txt"), this.name), (Object)this.loggingContext, (Object)je);
                }
                throw new ResponseException(rb.getString("JMSResponseAgent.sendResponseJMSException.ex.txt"));
            }
        }
        throw new ResponseException(rb.getString("JMSResponseAgent.notInitialized.ex.txt"));
    }

    @Override
    public void term() {
        try {
            if (this.sender != null) {
                this.sender.close();
            }
            if (this.session != null) {
                this.session.close();
            }
            if (this.connection != null) {
                this.connection.close();
            }
        }
        catch (JMSException jMSException) {
            // empty catch block
        }
    }
}

