/*
 * Decompiled with CFR 0.152.
 */
package com.sas.services.events.broker.monitor;

import com.sas.codepolicy.SASScope;
import com.sas.services.events.ApplicationMonitorResources;
import com.sas.services.events.broker.monitor.JMSResponseAgent;
import com.sas.services.events.broker.monitor.Monitor;
import com.sas.services.events.broker.monitor.MonitorException;
import com.sas.services.events.broker.monitor.MonitorThread;
import com.sas.services.events.broker.monitor.RB;
import com.sas.services.events.broker.util.EventContainer;
import com.sas.services.events.broker.util.EventRequest;
import com.sas.services.events.broker.util.MutexStateException;
import com.sas.services.logging.util.LoggerMonitor2;
import com.sas.util.SasPasswordEncodingException;
import com.sas.util.SasPasswordString;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Map;
import java.util.ResourceBundle;
import javax.jms.BytesMessage;
import javax.jms.ConnectionMetaData;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageListener;
import javax.jms.Queue;
import javax.jms.QueueConnection;
import javax.jms.QueueConnectionFactory;
import javax.jms.QueueReceiver;
import javax.jms.QueueSession;
import javax.jms.TextMessage;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@SASScope
public class JMSMonitor
implements Monitor,
MessageListener {
    private static final int SLEEP_TIME_MSEC = 1000;
    private static final int NUM_BYTES_IN_PACKET = 80;
    private MonitorThread self;
    private String name;
    private EventContainer eventContainer;
    private Logger logger;
    private LoggerMonitor2 _applicationMonitorLogger;
    private String defaultEvent;
    private String strJNDIQName;
    private String strJNDIQCFName;
    private String strJNDIICF;
    private String strJNDIURL;
    private String strJNDIAuth = "none";
    private String strJNDIPrincipal;
    private String strJNDICredentials;
    private String strSelector;
    private final Map responseProperties = new HashMap(10);
    private InitialContext ctx;
    private Queue queue;
    private QueueSession session;
    private QueueConnection connection;
    private QueueConnectionFactory factory;
    private QueueReceiver receiver;
    private static final String RB_KEY = "JMSMonitor.";
    private static ResourceBundle rb = RB.getResources();

    @Override
    public void init(String name, Map properties, EventContainer eventContainer) throws MonitorException {
        String tmpJNDICredentials;
        String tmpJNDIPrincipal;
        this.name = name;
        this.eventContainer = eventContainer;
        this.logger = LogManager.getLogger((String)this.getClass().getName());
        this._applicationMonitorLogger = new LoggerMonitor2(LogManager.getLogger((String)"ApplicationMonitor.EventBrokerService"));
        if (!properties.containsKey("queue")) {
            throw new MonitorException(rb.getString("JMSMonitor.noQueue.ex.txt"));
        }
        this.strJNDIQName = (String)properties.get("queue");
        if (!properties.containsKey("qcf")) {
            throw new MonitorException(rb.getString("JMSMonitor.noQCF.ex.txt"));
        }
        this.strJNDIQCFName = (String)properties.get("qcf");
        if (!properties.containsKey("icf")) {
            throw new MonitorException(rb.getString("JMSMonitor.noICF.ex.txt"));
        }
        this.strJNDIICF = (String)properties.get("icf");
        StringBuffer sb = new StringBuffer();
        if (properties.containsKey("dir")) {
            String dir = (String)properties.get("dir");
            int index = dir.indexOf("://");
            if (index == -1) {
                sb.append("file:///");
            }
            sb.append(dir);
        } else {
            String protocol = "ldap";
            String dn = "";
            if (properties.containsKey("dn")) {
                String dnProp = (String)properties.get("dn");
                int index = dnProp.indexOf("$jndi-protocol$");
                if (index == -1) {
                    dn = "/" + dnProp;
                } else {
                    int equalsIndex = dnProp.indexOf(61, index);
                    if (equalsIndex != -1) {
                        protocol = dnProp.substring(equalsIndex + 1).trim();
                    }
                }
            }
            sb.append(protocol + "://");
            if (properties.containsKey("host")) {
                sb.append(properties.get("host"));
                sb.append(":");
            } else {
                sb.append("localhost:");
            }
            if (properties.containsKey("port")) {
                sb.append(properties.get("port"));
            } else {
                sb.append("389");
            }
            sb.append(dn);
        }
        this.strJNDIURL = sb.toString();
        if (properties.containsKey("auth_type")) {
            this.strJNDIAuth = (String)properties.get("auth_type");
            if (this.strJNDIAuth.equals("0")) {
                this.strJNDIAuth = "none";
            } else if (this.strJNDIAuth.equals("1")) {
                this.strJNDIAuth = "simple";
            }
        }
        if (properties.containsKey("user") && (tmpJNDIPrincipal = (String)properties.get("user")).length() > 0) {
            this.strJNDIPrincipal = tmpJNDIPrincipal;
        }
        if (properties.containsKey("password") && (tmpJNDICredentials = (String)properties.get("password")).length() > 0) {
            this.strJNDICredentials = tmpJNDICredentials;
            try {
                this.strJNDICredentials = SasPasswordString.decode((String)this.strJNDICredentials);
            }
            catch (SasPasswordEncodingException dn) {
                // empty catch block
            }
        }
        if (properties.containsKey("selector")) {
            this.strSelector = (String)properties.get("selector");
        }
        if (properties.containsKey("default_event")) {
            this.defaultEvent = (String)properties.get("default_event");
        }
        this.responseProperties.put("replyToJNDIICF", this.strJNDIICF);
        this.responseProperties.put("replyToJNDIURL", this.strJNDIURL);
        this.responseProperties.put("replyToJNDIAuth", this.strJNDIAuth);
        this.responseProperties.put("replyToJNDIPrincipal", this.strJNDIPrincipal);
        this.responseProperties.put("replyToJNDICredentials", this.strJNDICredentials);
        if (properties.containsKey("reply_to_queue")) {
            this.responseProperties.put("replyToJNDIQName", properties.get("reply_to_queue"));
        }
        try {
            Hashtable<String, String> env = new Hashtable<String, String>();
            env.put("java.naming.factory.initial", this.strJNDIICF);
            env.put("java.naming.provider.url", this.strJNDIURL);
            env.put("java.naming.security.authentication", this.strJNDIAuth);
            if (!this.strJNDIAuth.equalsIgnoreCase("none")) {
                if (this.strJNDIPrincipal != null) {
                    env.put("java.naming.security.principal", this.strJNDIPrincipal);
                }
                if (this.strJNDICredentials != null) {
                    env.put("java.naming.security.credentials", this.strJNDICredentials);
                }
            }
            this.ctx = new InitialContext(env);
            if (this.logger != null && this.logger.isDebugEnabled()) {
                this.logger.debug(MessageFormat.format(rb.getString("JMSMonitor.createQCF.fmt.txt"), name, this.strJNDIQCFName));
            }
            this.factory = (QueueConnectionFactory)this.ctx.lookup(this.strJNDIQCFName);
            this.responseProperties.put("JNDIQueueFactory", this.factory);
            if (this.logger != null && this.logger.isDebugEnabled()) {
                this.logger.debug(MessageFormat.format(rb.getString("JMSMonitor.createQueueConnection.fmt.txt"), name));
            }
            this.connection = this.factory.createQueueConnection();
            this.connection.start();
            if (this.logger != null && this.logger.isDebugEnabled()) {
                this.logger.debug(MessageFormat.format(rb.getString("JMSMonitor.createQueueSession.fmt.txt"), name));
            }
            this.session = this.connection.createQueueSession(false, 1);
            if (this.logger != null && this.logger.isDebugEnabled()) {
                this.logger.debug(MessageFormat.format(rb.getString("JMSMonitor.createQueue.fmt.txt"), name, this.strJNDIQName));
            }
            this.queue = (Queue)this.ctx.lookup(this.strJNDIQName);
            if (this.logger != null && this.logger.isDebugEnabled()) {
                this.logger.debug(MessageFormat.format(rb.getString("JMSMonitor.createReceiver.fmt.txt"), name, this.strSelector != null ? 1 : 0, this.strSelector));
            }
            this.receiver = this.strSelector != null ? this.session.createReceiver(this.queue, this.strSelector) : this.session.createReceiver(this.queue);
        }
        catch (JMSException je) {
            if (this.logger != null) {
                this.logger.error(MessageFormat.format(rb.getString("JMSMonitor.initJMSException.fmt.txt"), name), (Throwable)je);
            }
            throw new MonitorException(rb.getString("JMSMonitor.initJMSException.ex.txt"));
        }
        catch (NamingException ne) {
            if (this.logger != null) {
                this.logger.error(MessageFormat.format(rb.getString("JMSMonitor.initNamingException.fmt.txt"), name), (Throwable)ne);
            }
            throw new MonitorException(rb.getString("JMSMonitor.initNamingException.ex.txt"));
        }
        finally {
            if (this.ctx != null) {
                try {
                    this.ctx.close();
                }
                catch (Exception exception) {}
            }
        }
        String queueName = "";
        String providerName = "";
        String providerVersion = "";
        try {
            queueName = this.queue.getQueueName();
            ConnectionMetaData connectionMetadata = this.connection.getMetaData();
            providerName = connectionMetadata.getJMSProviderName();
            providerVersion = connectionMetadata.getProviderVersion();
        }
        catch (JMSException je) {
            this.logger.error(je.getMessage(), (Throwable)je);
        }
        if (this._applicationMonitorLogger != null && this._applicationMonitorLogger.isLoggingEnabled()) {
            this._applicationMonitorLogger.log(ApplicationMonitorResources.COLUMN_ACTION, MessageFormat.format(rb.getString("JMSMonitor.started.AppMonitor.fmt.txt"), name), ApplicationMonitorResources.COLUMN_EVENT_NAME, "", ApplicationMonitorResources.COLUMN_HANDLER_NAME, "", ApplicationMonitorResources.COLUMN_INFORMATION, MessageFormat.format(rb.getString("JMSMonitor.listening.AppMonitor.fmt.txt"), queueName, providerName, providerVersion, this.strSelector != null && this.strSelector.length() > 0 ? 1 : 0, '\'' + this.strSelector + '\''));
        }
        if (this.logger != null && this.logger.isInfoEnabled()) {
            this.logger.info(MessageFormat.format(rb.getString("JMSMonitor.listening.fmt.txt"), name, queueName, providerName, providerVersion, this.strSelector != null && this.strSelector.length() > 0 ? 1 : 0, this.strSelector));
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void run() {
        this.self = (MonitorThread)Thread.currentThread();
        try {
            if (this.logger != null && this.logger.isDebugEnabled()) {
                this.logger.debug(MessageFormat.format(rb.getString("JMSMonitor.setMessageListener.fmt.txt"), this.name));
            }
            this.receiver.setMessageListener((MessageListener)this);
            while (!Thread.interrupted()) {
                Thread.yield();
                if (!Thread.interrupted()) {
                    try {
                        Thread.sleep(1000L);
                        continue;
                    }
                    catch (InterruptedException e) {
                        // empty catch block
                    }
                }
                break;
            }
        }
        catch (JMSException je) {
            if (this.logger != null) {
                this.logger.error(MessageFormat.format(rb.getString("JMSMonitor.runJMSException.fmt.txt"), this.name), (Throwable)je);
            }
        }
        finally {
            try {
                this.receiver.close();
                this.session.close();
                this.connection.close();
            }
            catch (JMSException jMSException) {}
        }
        if (this.logger != null && this.logger.isDebugEnabled()) {
            this.logger.debug(MessageFormat.format(rb.getString("JMSMonitor.exit.fmt.txt"), this.name, Thread.currentThread().getName()));
        }
        this.logger = null;
    }

    public void onMessage(Message msg) {
        String strEvent = null;
        EventRequest eventRequest = null;
        if (this.logger != null && this.logger.isDebugEnabled()) {
            this.logger.debug(MessageFormat.format(rb.getString("JMSMonitor.receivedMessage.fmt.txt"), this.name));
        }
        this.self.disableInterrupts();
        if (msg instanceof TextMessage || msg instanceof BytesMessage) {
            block28: {
                block27: {
                    block26: {
                        if (msg instanceof TextMessage) {
                            try {
                                strEvent = ((TextMessage)msg).getText();
                            }
                            catch (JMSException je) {
                                if (this.logger != null) {
                                    this.logger.error(MessageFormat.format(rb.getString("JMSMonitor.failedGetText.fmt.txt"), this.name), (Throwable)je);
                                }
                                this.self.enableInterrupts();
                                return;
                            }
                        }
                        try {
                            int packetLength;
                            byte[] data = null;
                            int length = 0;
                            byte[] packet = new byte[80];
                            while ((packetLength = ((BytesMessage)msg).readBytes(packet)) != -1) {
                                length += packetLength;
                            }
                            data = new byte[length];
                            ((BytesMessage)msg).reset();
                            length = ((BytesMessage)msg).readBytes(data);
                            strEvent = new String(data);
                        }
                        catch (JMSException je) {
                            if (this.logger != null) {
                                this.logger.error(MessageFormat.format(rb.getString("JMSMonitor.failedGetBytes.fmt.txt"), this.name), (Throwable)je);
                            }
                            this.self.enableInterrupts();
                            return;
                        }
                        try {
                            this.responseProperties.put("replyCorrelId", msg.getJMSMessageID());
                        }
                        catch (JMSException je) {
                            if (this.logger == null) break block26;
                            this.logger.error(MessageFormat.format(rb.getString("JMSMonitor.failedGetMessageID.fmt.txt"), this.name), (Throwable)je);
                        }
                    }
                    try {
                        Destination replyToDest = msg.getJMSReplyTo();
                        if (replyToDest != null) {
                            this.responseProperties.put("replyToDest", replyToDest);
                        } else {
                            this.responseProperties.remove("replyToDest");
                        }
                    }
                    catch (JMSException je) {
                        if (this.logger == null) break block27;
                        this.logger.error(MessageFormat.format(rb.getString("JMSMonitor.failedGetReplyDest.fmt.txt"), this.name), (Throwable)je);
                    }
                }
                JMSResponseAgent responseAgent = new JMSResponseAgent(this.name, this.responseProperties, this.logger);
                eventRequest = new EventRequest(strEvent, responseAgent);
                if (this.defaultEvent != null) {
                    eventRequest.setDefaultEvent(this.defaultEvent);
                }
                try {
                    this.eventContainer._mutex.lock();
                }
                catch (InterruptedException ie) {
                    if (this.logger == null) break block28;
                    this.logger.error(MessageFormat.format(rb.getString("JMSMonitor.mutexInterrupt.fmt.txt"), this.name));
                }
            }
            while (this.eventContainer.isFull()) {
                try {
                    this.eventContainer._monitorCV.condWait(this.eventContainer._mutex);
                }
                catch (InterruptedException ie) {
                    if (this.logger == null) continue;
                    this.logger.error(MessageFormat.format(rb.getString("JMSMonitor.condWaitInterrupt.fmt.txt"), this.name));
                }
            }
            this.eventContainer.add(eventRequest);
            try {
                this.eventContainer._mutex.unlock();
            }
            catch (MutexStateException mutexStateException) {
                // empty catch block
            }
            this.eventContainer._workerCV.condSignal();
        } else if (this.logger != null) {
            this.logger.error(MessageFormat.format(rb.getString("JMSMonitor.invalidMessage.fmt.txt"), this.name));
        }
        this.self.enableInterrupts();
    }
}

