/*
 * Decompiled with CFR 0.152.
 */
package com.sas.services.events.broker.monitor;

import com.sas.codepolicy.SASScope;
import com.sas.services.events.ApplicationMonitorResources;
import com.sas.services.events.broker.monitor.JMQResponseAgent;
import com.sas.services.events.broker.monitor.Monitor;
import com.sas.services.events.broker.monitor.MonitorException;
import com.sas.services.events.broker.monitor.MonitorThread;
import com.sas.services.events.broker.monitor.RB;
import com.sas.services.events.broker.util.EventContainer;
import com.sas.services.events.broker.util.EventRequest;
import com.sas.services.events.broker.util.MutexStateException;
import com.sas.services.logging.util.LoggerMonitor2;
import com.sas.util.SasPasswordEncodingException;
import com.sas.util.SasPasswordString;
import com.sun.messaging.QueueConnectionFactory;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.Map;
import java.util.ResourceBundle;
import javax.jms.BytesMessage;
import javax.jms.ConnectionMetaData;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageListener;
import javax.jms.Queue;
import javax.jms.QueueConnection;
import javax.jms.QueueReceiver;
import javax.jms.QueueSession;
import javax.jms.TextMessage;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@SASScope
public class JMQMonitor
implements Monitor,
MessageListener {
    private static final int SLEEP_TIME_MSEC = 1000;
    private MonitorThread self;
    private String name;
    private EventContainer eventContainer;
    private Logger logger;
    private LoggerMonitor2 _applicationMonitorLogger;
    private String defaultEvent;
    private String strHost;
    private String strPort;
    private String strUser;
    private String strPassword;
    private String strQueue;
    private String strSelector;
    private final Map responseProperties = new HashMap(4);
    private com.sun.messaging.Queue queue;
    private QueueSession session;
    private QueueConnection connection;
    private QueueConnectionFactory factory;
    private QueueReceiver receiver;
    private static final String RB_KEY = "JMQMonitor.";
    private static ResourceBundle rb = RB.getResources();

    @Override
    public void init(String name, Map properties, EventContainer eventContainer) throws MonitorException {
        String tmpPassword;
        String tmpUser;
        this.name = name;
        this.eventContainer = eventContainer;
        this.logger = LogManager.getLogger((String)this.getClass().getName());
        this._applicationMonitorLogger = new LoggerMonitor2(LogManager.getLogger((String)"ApplicationMonitor.EventBrokerService"));
        if (properties.containsKey("host")) {
            this.strHost = (String)properties.get("host");
        }
        if (properties.containsKey("port")) {
            this.strPort = (String)properties.get("port");
        }
        if (properties.containsKey("user") && (tmpUser = (String)properties.get("user")).length() > 0) {
            this.strUser = tmpUser;
        }
        if (properties.containsKey("password") && (tmpPassword = (String)properties.get("password")).length() > 0) {
            this.strPassword = tmpPassword;
            try {
                this.strPassword = SasPasswordString.decode((String)this.strPassword);
            }
            catch (SasPasswordEncodingException sasPasswordEncodingException) {
                // empty catch block
            }
        }
        if (!properties.containsKey("queue")) {
            throw new MonitorException(rb.getString("JMQMonitor.noQueue.ex.txt"));
        }
        this.strQueue = (String)properties.get("queue");
        if (properties.containsKey("selector")) {
            this.strSelector = (String)properties.get("selector");
        }
        if (properties.containsKey("default_event")) {
            this.defaultEvent = (String)properties.get("default_event");
        }
        if (this.strUser != null) {
            this.responseProperties.put("user", this.strUser);
        }
        if (this.strPassword != null) {
            this.responseProperties.put("password", this.strPassword);
        }
        if (properties.containsKey("reply_to_queue")) {
            this.responseProperties.put("reply_to_queue", properties.get("reply_to_queue"));
        }
        try {
            if (this.logger != null && this.logger.isDebugEnabled()) {
                this.logger.debug(MessageFormat.format(rb.getString("JMQMonitor.createQCF.fmt.txt"), name, this.strHost != null ? 1 : 0, this.strHost, this.strPort != null ? 1 : 0, this.strPort));
            }
            this.factory = new QueueConnectionFactory();
            if (this.strHost != null) {
                this.factory.setProperty("imqBrokerHostName", this.strHost);
            }
            if (this.strPort != null) {
                this.factory.setProperty("imqBrokerHostPort", this.strPort);
            }
            this.responseProperties.put("qcf", this.factory);
            if (this.logger != null && this.logger.isDebugEnabled()) {
                this.logger.debug(MessageFormat.format(rb.getString("JMQMonitor.createQueueConnection.fmt.txt"), name));
            }
            this.connection = this.strUser != null && this.strPassword != null ? this.factory.createQueueConnection(this.strUser, this.strPassword) : this.factory.createQueueConnection();
            this.connection.start();
            if (this.logger != null && this.logger.isDebugEnabled()) {
                this.logger.debug(MessageFormat.format(rb.getString("JMQMonitor.createQueueSession.fmt.txt"), name));
            }
            this.session = this.connection.createQueueSession(false, 1);
            if (this.logger != null && this.logger.isDebugEnabled()) {
                this.logger.debug(MessageFormat.format(rb.getString("JMQMonitor.createQueue.fmt.txt"), name, this.strQueue));
            }
            this.queue = new com.sun.messaging.Queue(this.strQueue);
            if (this.logger != null && this.logger.isDebugEnabled()) {
                this.logger.debug(MessageFormat.format(rb.getString("JMQMonitor.createReceiver.fmt.txt"), name, this.strSelector != null ? 1 : 0, this.strSelector));
            }
            this.receiver = this.strSelector != null ? this.session.createReceiver((Queue)this.queue, this.strSelector) : this.session.createReceiver((Queue)this.queue);
        }
        catch (JMSException je) {
            if (this.logger != null) {
                this.logger.error(MessageFormat.format(rb.getString("JMQMonitor.initJMSException.fmt.txt"), name), (Throwable)je);
            }
            throw new MonitorException(rb.getString("JMQMonitor.initJMSException.ex.txt"));
        }
        String queueName = "";
        String providerName = "";
        String providerVersion = "";
        try {
            queueName = this.queue.getQueueName();
            ConnectionMetaData connectionMetadata = this.connection.getMetaData();
            providerName = connectionMetadata.getJMSProviderName();
            providerVersion = connectionMetadata.getProviderVersion();
        }
        catch (JMSException je) {
            this.logger.error(je.getMessage(), (Throwable)je);
        }
        if (this._applicationMonitorLogger != null && this._applicationMonitorLogger.isLoggingEnabled()) {
            this._applicationMonitorLogger.log(ApplicationMonitorResources.COLUMN_ACTION, MessageFormat.format(rb.getString("JMQMonitor.started.AppMonitor.fmt.txt"), name), ApplicationMonitorResources.COLUMN_EVENT_NAME, "", ApplicationMonitorResources.COLUMN_HANDLER_NAME, "", ApplicationMonitorResources.COLUMN_INFORMATION, MessageFormat.format(rb.getString("JMQMonitor.listening.AppMonitor.fmt.txt"), queueName, providerName, providerVersion, this.strSelector != null && this.strSelector.length() > 0 ? 1 : 0, '\'' + this.strSelector + '\''));
        }
        if (this.logger != null && this.logger.isInfoEnabled()) {
            this.logger.info(MessageFormat.format(rb.getString("JMQMonitor.listening.fmt.txt"), name, queueName, providerName, providerVersion, this.strSelector != null && this.strSelector.length() > 0 ? 1 : 0, this.strSelector));
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void run() {
        this.self = (MonitorThread)Thread.currentThread();
        try {
            if (this.logger != null && this.logger.isDebugEnabled()) {
                this.logger.debug(MessageFormat.format(rb.getString("JMQMonitor.setMessageListener.fmt.txt"), this.name));
            }
            this.receiver.setMessageListener((MessageListener)this);
            while (!Thread.interrupted()) {
                Thread.yield();
                if (!Thread.interrupted()) {
                    try {
                        Thread.sleep(1000L);
                        continue;
                    }
                    catch (InterruptedException e) {
                        // empty catch block
                    }
                }
                break;
            }
        }
        catch (JMSException je) {
            if (this.logger != null) {
                this.logger.error(MessageFormat.format(rb.getString("JMQMonitor.runJMSException.fmt.txt"), this.name), (Throwable)je);
            }
        }
        finally {
            try {
                this.receiver.close();
                this.session.close();
                this.connection.close();
            }
            catch (JMSException jMSException) {}
        }
        if (this.logger != null && this.logger.isDebugEnabled()) {
            this.logger.debug(MessageFormat.format(rb.getString("JMQMonitor.exit.fmt.txt"), this.name, Thread.currentThread().getName()));
        }
        this.logger = null;
    }

    public void onMessage(Message msg) {
        String strEvent = null;
        EventRequest eventRequest = null;
        if (this.logger != null && this.logger.isDebugEnabled()) {
            this.logger.debug(MessageFormat.format(rb.getString("JMQMonitor.receivedMessage.fmt.txt"), this.name));
        }
        this.self.disableInterrupts();
        if (msg instanceof TextMessage || msg instanceof BytesMessage) {
            block28: {
                block27: {
                    block26: {
                        if (msg instanceof TextMessage) {
                            try {
                                strEvent = ((TextMessage)msg).getText();
                            }
                            catch (JMSException je) {
                                if (this.logger != null) {
                                    this.logger.error(MessageFormat.format(rb.getString("JMQMonitor.failedGetText.fmt.txt"), this.name), (Throwable)je);
                                }
                                this.self.enableInterrupts();
                                return;
                            }
                        }
                        try {
                            int packetLength;
                            byte[] data = null;
                            int length = 0;
                            byte[] packet = new byte[80];
                            while ((packetLength = ((BytesMessage)msg).readBytes(packet)) != -1) {
                                length += packetLength;
                            }
                            data = new byte[length];
                            ((BytesMessage)msg).reset();
                            length = ((BytesMessage)msg).readBytes(data);
                            strEvent = new String(data);
                        }
                        catch (JMSException je) {
                            if (this.logger != null) {
                                this.logger.error(MessageFormat.format(rb.getString("JMQMonitor.failedGetBytes.fmt.txt"), this.name), (Throwable)je);
                            }
                            this.self.enableInterrupts();
                            return;
                        }
                        try {
                            this.responseProperties.put("replyCorrelId", msg.getJMSMessageID());
                        }
                        catch (JMSException je) {
                            if (this.logger == null) break block26;
                            this.logger.error(MessageFormat.format(rb.getString("JMQMonitor.failedGetMessageID.fmt.txt"), this.name), (Throwable)je);
                        }
                    }
                    try {
                        Destination replyToDest = msg.getJMSReplyTo();
                        if (replyToDest != null) {
                            this.responseProperties.put("reply_to_dest", replyToDest);
                        } else {
                            this.responseProperties.remove("reply_to_dest");
                        }
                    }
                    catch (JMSException je) {
                        if (this.logger == null) break block27;
                        this.logger.error(MessageFormat.format(rb.getString("JMQMonitor.failedGetReplyDest.fmt.txt"), this.name), (Throwable)je);
                    }
                }
                JMQResponseAgent responseAgent = new JMQResponseAgent(this.name, this.responseProperties, this.logger);
                eventRequest = new EventRequest(strEvent, responseAgent);
                if (this.defaultEvent != null) {
                    eventRequest.setDefaultEvent(this.defaultEvent);
                }
                try {
                    this.eventContainer._mutex.lock();
                }
                catch (InterruptedException ie) {
                    if (this.logger == null) break block28;
                    this.logger.error(MessageFormat.format(rb.getString("JMQMonitor.mutexInterrupt.fmt.txt"), this.name));
                }
            }
            while (this.eventContainer.isFull()) {
                try {
                    this.eventContainer._monitorCV.condWait(this.eventContainer._mutex);
                }
                catch (InterruptedException ie) {
                    if (this.logger == null) continue;
                    this.logger.error(MessageFormat.format(rb.getString("JMQMonitor.condWaitInterrupt.fmt.txt"), this.name));
                }
            }
            this.eventContainer.add(eventRequest);
            try {
                this.eventContainer._mutex.unlock();
            }
            catch (MutexStateException mutexStateException) {
                // empty catch block
            }
            this.eventContainer._workerCV.condSignal();
        } else if (this.logger != null) {
            this.logger.error(MessageFormat.format(rb.getString("JMQMonitor.invalidMessage.fmt.txt"), this.name));
        }
        this.self.enableInterrupts();
    }
}

