/*
 * Decompiled with CFR 0.152.
 */
package com.sas.services.events.broker.monitor;

import com.sas.codepolicy.SASScope;
import com.sas.services.events.ApplicationMonitorResources;
import com.sas.services.events.broker.monitor.IOMEventHandlerInterface;
import com.sas.services.events.broker.monitor.IOMServant;
import com.sas.services.events.broker.monitor.LocalResponseAgent;
import com.sas.services.events.broker.monitor.Monitor;
import com.sas.services.events.broker.monitor.MonitorException;
import com.sas.services.events.broker.monitor.MonitorThread;
import com.sas.services.events.broker.monitor.RB;
import com.sas.services.events.broker.util.EventContainer;
import com.sas.services.events.broker.util.EventRequest;
import com.sas.services.events.broker.util.MutexStateException;
import com.sas.services.logging.util.LoggerMonitor2;
import java.text.MessageFormat;
import java.util.Map;
import java.util.Properties;
import java.util.ResourceBundle;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.omg.CORBA.ORB;
import org.omg.PortableServer.POA;
import org.omg.PortableServer.Servant;

@SASScope
public class IOMMonitor
implements Monitor,
IOMEventHandlerInterface {
    private MonitorThread self;
    private String name;
    private EventContainer eventContainer;
    private Logger logger;
    private LoggerMonitor2 _applicationMonitorLogger;
    private String defaultEvent;
    private String strPort;
    private String strDebugLevel;
    private POA poa;
    private static final String RB_KEY = "IOMMonitor.";
    private static ResourceBundle rb = RB.getResources();

    @Override
    public void init(String name, Map properties, EventContainer eventContainer) throws MonitorException {
        this.name = name;
        this.eventContainer = eventContainer;
        this.logger = LogManager.getLogger((String)this.getClass().getName());
        this._applicationMonitorLogger = new LoggerMonitor2(LogManager.getLogger((String)"ApplicationMonitor.EventBrokerService"));
        if (!properties.containsKey("port")) {
            throw new MonitorException(rb.getString("IOMMonitor.noPort.ex.txt"));
        }
        this.strPort = (String)properties.get("port");
        if (properties.containsKey("debugLevel")) {
            this.strDebugLevel = (String)properties.get("debugLevel");
        }
        if (properties.containsKey("default_event")) {
            this.defaultEvent = (String)properties.get("default_event");
        }
        try {
            Properties p = new Properties();
            p.put("org.omg.CORBA.ORBClass", "com.sas.net.brg.orb.BrgOrb");
            p.put("serverNames", "this");
            p.put("this.protocol", "bridge");
            p.put("this.port", this.strPort);
            if (this.strDebugLevel != null) {
                p.put("this.debugLevel", this.strDebugLevel);
            }
            String[] argv = null;
            ORB orb = ORB.init(argv, (Properties)p);
            IOMServant servant = new IOMServant(this);
            this.poa = (POA)orb.resolve_initial_references("rootPOA");
            byte[] oid = "4e70a647-8e17-11d5-b5d7-00c04f6eafd9".getBytes("ISO8859-1");
            this.poa.activate_object_with_id(oid, (Servant)servant);
            if (this.logger != null && this.logger.isDebugEnabled()) {
                this.logger.debug(MessageFormat.format(rb.getString("IOMMonitor.servantActivated.fmt.txt"), name));
            }
        }
        catch (Exception e) {
            if (this.logger != null) {
                this.logger.error(MessageFormat.format(rb.getString("IOMMonitor.initException.fmt.txt"), name), (Throwable)e);
            }
            throw new MonitorException(rb.getString("IOMMonitor.initException.ex.txt"));
        }
        if (this._applicationMonitorLogger != null && this._applicationMonitorLogger.isLoggingEnabled()) {
            this._applicationMonitorLogger.log(ApplicationMonitorResources.COLUMN_ACTION, MessageFormat.format(rb.getString("IOMMonitor.started.AppMonitor.fmt.txt"), name), ApplicationMonitorResources.COLUMN_EVENT_NAME, "", ApplicationMonitorResources.COLUMN_HANDLER_NAME, "", ApplicationMonitorResources.COLUMN_INFORMATION, MessageFormat.format(rb.getString("IOMMonitor.listening.AppMonitor.fmt.txt"), this.strPort));
        }
        if (this.logger != null && this.logger.isInfoEnabled()) {
            this.logger.info(MessageFormat.format(rb.getString("IOMMonitor.listening.fmt.txt"), name, this.strPort));
        }
    }

    @Override
    public void run() {
        this.self = (MonitorThread)Thread.currentThread();
        while (!Thread.interrupted()) {
            Thread.yield();
            if (Thread.interrupted()) break;
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException e) {
                // empty catch block
                break;
            }
        }
        if (this.logger != null && this.logger.isDebugEnabled()) {
            this.logger.debug(MessageFormat.format(rb.getString("IOMMonitor.exit.fmt.txt"), this.name, Thread.currentThread().getName()));
        }
        this.logger = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String handleEvent(String event) {
        LocalResponseAgent responseAgent;
        EventRequest eventRequest;
        String response;
        block17: {
            response = "";
            eventRequest = null;
            if (this.logger != null && this.logger.isDebugEnabled()) {
                this.logger.debug(MessageFormat.format(rb.getString("IOMMonitor.receivedEvent.fmt.txt"), this.name));
            }
            this.self.disableInterrupts();
            responseAgent = new LocalResponseAgent();
            eventRequest = new EventRequest(event, responseAgent);
            eventRequest.setSyncRequest();
            if (this.defaultEvent != null) {
                eventRequest.setDefaultEvent(this.defaultEvent);
            }
            try {
                this.eventContainer._mutex.lock();
            }
            catch (InterruptedException ie) {
                if (this.logger == null) break block17;
                this.logger.error(MessageFormat.format(rb.getString("IOMMonitor.mutexInterrupt.fmt.txt"), this.name));
            }
        }
        while (this.eventContainer.isFull()) {
            try {
                this.eventContainer._monitorCV.condWait(this.eventContainer._mutex);
            }
            catch (InterruptedException ie) {
                if (this.logger == null) continue;
                this.logger.error(MessageFormat.format(rb.getString("IOMMonitor.condWaitInterrupt.fmt.txt"), this.name));
            }
        }
        this.eventContainer.add(eventRequest);
        try {
            this.eventContainer._mutex.unlock();
        }
        catch (MutexStateException mutexStateException) {
            // empty catch block
        }
        this.eventContainer._workerCV.condSignal();
        EventRequest eventRequest2 = eventRequest;
        synchronized (eventRequest2) {
            while (!eventRequest.isSyncComplete()) {
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug(MessageFormat.format(rb.getString("IOMMonitor.waitSyncCompletion.fmt.txt"), this.name));
                }
                try {
                    eventRequest.wait();
                }
                catch (InterruptedException interruptedException) {}
            }
            if (this.logger.isDebugEnabled()) {
                this.logger.debug(MessageFormat.format(rb.getString("IOMMonitor.syncComplete.fmt.txt"), this.name));
            }
        }
        response = responseAgent.getResponse();
        this.self.enableInterrupts();
        return response;
    }
}

