/*
 * Decompiled with CFR 0.152.
 */
package com.sas.services.events.broker.monitor;

import com.sas.codepolicy.SASScope;
import com.sas.services.events.ApplicationMonitorResources;
import com.sas.services.events.broker.monitor.HTTPResponseAgent;
import com.sas.services.events.broker.monitor.Monitor;
import com.sas.services.events.broker.monitor.MonitorException;
import com.sas.services.events.broker.monitor.MonitorThread;
import com.sas.services.events.broker.monitor.RB;
import com.sas.services.events.broker.util.EventContainer;
import com.sas.services.events.broker.util.EventRequest;
import com.sas.services.events.broker.util.MutexStateException;
import com.sas.services.logging.util.LoggerMonitor2;
import com.sas.util.SasPasswordEncodingException;
import com.sas.util.SasPasswordString;
import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.URLDecoder;
import java.net.UnknownHostException;
import java.security.KeyManagementException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.UnrecoverableKeyException;
import java.security.cert.CertificateException;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.StringTokenizer;
import javax.net.ServerSocketFactory;
import javax.net.ssl.HandshakeCompletedEvent;
import javax.net.ssl.HandshakeCompletedListener;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSession;
import javax.net.ssl.SSLSocket;
import javax.xml.soap.MimeHeaders;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@SASScope
public class HTTPMonitor
implements Monitor {
    private MonitorThread self;
    private int listenerCount = 0;
    protected String name;
    protected EventContainer eventContainer;
    protected Logger logger;
    protected LoggerMonitor2 _applicationMonitorLogger;
    protected String defaultEvent;
    private String strHost;
    private int backlog = -1;
    private int port;
    private static final int DEFAULT_PORT = 80;
    protected ServerSocket server;
    private InetAddress ipAddress;
    protected static final char CR = '\r';
    protected static final char LF = '\n';
    protected static final char SP = ' ';
    protected static final char COLON = ':';
    protected static final String CRLF = "\r\n";
    protected static final String HTTP_METHOD_POST = "POST";
    protected static final String HTTP_METHOD_HEAD = "HEAD";
    protected static final String HTTP_METHOD_OPTIONS = "OPTIONS";
    protected static final String HTTP_STATUS_BAD_REQUEST = "400";
    protected static final String HTTP_STATUS_METHOD_NOT_ALLOWED = "405";
    protected static final String HTTP_STATUS_LENGTH_REQUIRED = "411";
    protected static final String HTTP_STATUS_INTERNAL_ERROR = "500";
    protected Map responseProperties = new HashMap(1);
    protected static final String RB_KEY = "HTTPMonitor.";
    protected static ResourceBundle rb = RB.getResources();

    @Override
    public void init(String name, Map properties, EventContainer eventContainer) throws MonitorException {
        String ssl2;
        block27: {
            this.name = name;
            this.eventContainer = eventContainer;
            this.logger = LogManager.getLogger((String)this.getClass().getName());
            this._applicationMonitorLogger = new LoggerMonitor2(LogManager.getLogger((String)"ApplicationMonitor.EventBrokerService"));
            if (properties.containsKey("host")) {
                this.strHost = (String)properties.get("host");
                if (this.strHost.length() > 0) {
                    try {
                        this.ipAddress = InetAddress.getByName(this.strHost);
                    }
                    catch (UnknownHostException uhe) {
                        if (this.logger == null || !this.logger.isWarnEnabled()) break block27;
                        this.logger.warn(MessageFormat.format(rb.getString("HTTPMonitor.initUnknownHostException.fmt.txt"), name, this.strHost));
                    }
                }
            }
        }
        if (properties.containsKey("port")) {
            try {
                this.port = Integer.parseInt((String)properties.get("port"));
            }
            catch (NumberFormatException e) {
                if (this.logger != null && this.logger.isWarnEnabled()) {
                    this.logger.warn(MessageFormat.format(rb.getString("HTTPMonitor.invalidPort.fmt.txt"), properties.get("port"), name, 80));
                }
                this.port = 80;
            }
        } else {
            this.port = 80;
        }
        if (properties.containsKey("backlog")) {
            try {
                this.backlog = Integer.parseInt((String)properties.get("backlog"));
            }
            catch (NumberFormatException e) {
                if (this.logger != null && this.logger.isWarnEnabled()) {
                    this.logger.warn(MessageFormat.format(rb.getString("HTTPMonitor.invalidBacklog.fmt.txt"), properties.get("backlog"), name, Integer.MAX_VALUE));
                }
                this.backlog = Integer.MAX_VALUE;
            }
        } else if (this.ipAddress != null) {
            this.backlog = Integer.MAX_VALUE;
        }
        if (properties.containsKey("default_event")) {
            this.defaultEvent = (String)properties.get("default_event");
        }
        boolean enableSSL = false;
        String keystore = "";
        String keystorepass = "";
        if (properties.containsKey("ssl_enablement") && (ssl2 = (String)properties.get("ssl_enablement")).equals("1")) {
            enableSSL = true;
        }
        if (enableSSL) {
            if (properties.containsKey("ssl_keystore")) {
                keystore = (String)properties.get("ssl_keystore");
            }
            if (properties.containsKey("ssl_keystore_password")) {
                keystorepass = (String)properties.get("ssl_keystore_password");
                try {
                    keystorepass = SasPasswordString.decode((String)keystorepass);
                }
                catch (SasPasswordEncodingException ssl2) {
                    // empty catch block
                }
            }
        }
        ServerSocketFactory ssf = this.getServerSocketFactory(enableSSL, keystore, keystorepass);
        try {
            this.server = this.ipAddress == null ? (this.backlog < 0 ? ssf.createServerSocket(this.port) : ssf.createServerSocket(this.port, this.backlog)) : ssf.createServerSocket(this.port, this.backlog, this.ipAddress);
        }
        catch (IOException ioe) {
            if (this.logger != null) {
                this.logger.error(MessageFormat.format(rb.getString("HTTPMonitor.initIOException.fmt.txt"), name), (Throwable)ioe);
            }
            throw new MonitorException(rb.getString("HTTPMonitor.initIOException.ex.txt"));
        }
        if (this._applicationMonitorLogger != null && this._applicationMonitorLogger.isLoggingEnabled()) {
            this._applicationMonitorLogger.log(ApplicationMonitorResources.COLUMN_ACTION, MessageFormat.format(rb.getString("HTTPMonitor.started.AppMonitor.fmt.txt"), name), ApplicationMonitorResources.COLUMN_EVENT_NAME, "", ApplicationMonitorResources.COLUMN_HANDLER_NAME, "", ApplicationMonitorResources.COLUMN_INFORMATION, MessageFormat.format(rb.getString("HTTPMonitor.listening.AppMonitor.fmt.txt"), this.port));
        }
        if (this.logger != null && this.logger.isInfoEnabled()) {
            this.logger.info(MessageFormat.format(rb.getString("HTTPMonitor.listening.fmt.txt"), name, this.port));
        }
    }

    @Override
    public void run() {
        block6: {
            this.self = (MonitorThread)Thread.currentThread();
            try {
                this.startListener(this.getListener());
                while (!Thread.interrupted()) {
                    Thread.yield();
                    if (Thread.interrupted()) break;
                    try {
                        Thread.sleep(1000L);
                    }
                    catch (InterruptedException e) {
                        // empty catch block
                        break;
                    }
                }
                this.server.close();
            }
            catch (Exception e) {
                if (this.logger == null) break block6;
                this.logger.error(MessageFormat.format(rb.getString("HTTPMonitor.runException.fmt.txt"), this.name), (Throwable)e);
            }
        }
        if (this.logger != null && this.logger.isDebugEnabled()) {
            this.logger.debug(MessageFormat.format(rb.getString("HTTPMonitor.exit.fmt.txt"), this.name, Thread.currentThread().getName()));
        }
        this.logger = null;
    }

    protected Runnable getListener() {
        return new HTTPListener();
    }

    protected void startListener(Runnable listener) {
        Thread t = null;
        t = new Thread(listener);
        t.setName(this.getClass().getName() + "_HTTPListener_" + t.getName());
        t.start();
    }

    protected void incrementListeners() {
        if (this.listenerCount < 1) {
            this.self.disableInterrupts();
        }
        ++this.listenerCount;
    }

    protected void decrementListeners() {
        --this.listenerCount;
        if (this.listenerCount < 1) {
            this.self.enableInterrupts();
        }
    }

    private final ServerSocketFactory getServerSocketFactory(boolean enableSSL, String keystore, String keystorepass) throws MonitorException {
        ServerSocketFactory ssf = null;
        if (enableSSL) {
            try {
                char[] pass = keystorepass.toCharArray();
                SSLContext context = SSLContext.getInstance("TLS");
                String keyalg = KeyManagerFactory.getDefaultAlgorithm();
                KeyManagerFactory kmf = KeyManagerFactory.getInstance(keyalg);
                String storeType = KeyStore.getDefaultType();
                KeyStore ks = KeyStore.getInstance(storeType);
                if (keystore.length() > 0) {
                    ks.load(new FileInputStream(keystore), pass);
                    kmf.init(ks, pass);
                }
                context.init(kmf.getKeyManagers(), null, null);
                ssf = context.getServerSocketFactory();
            }
            catch (NoSuchAlgorithmException nsae) {
                if (this.logger != null) {
                    this.logger.error(MessageFormat.format(rb.getString("HTTPMonitor.sslNoSuchAlgorithmException.fmt.txt"), this.name), (Throwable)nsae);
                }
                throw new MonitorException(rb.getString("HTTPMonitor.sslNoSuchAlgorithmException.ex.txt"));
            }
            catch (KeyStoreException kse) {
                if (this.logger != null) {
                    this.logger.error(MessageFormat.format(rb.getString("HTTPMonitor.sslKeyStoreException.fmt.txt"), this.name), (Throwable)kse);
                }
                throw new MonitorException(rb.getString("HTTPMonitor.sslKeyStoreException.ex.txt"));
            }
            catch (IOException ioe) {
                if (this.logger != null) {
                    this.logger.error(MessageFormat.format(rb.getString("HTTPMonitor.sslIOException.fmt.txt"), this.name), (Throwable)ioe);
                }
                throw new MonitorException(rb.getString("HTTPMonitor.sslIOException.ex.txt"));
            }
            catch (CertificateException ce) {
                if (this.logger != null) {
                    this.logger.error(MessageFormat.format(rb.getString("HTTPMonitor.sslCertificateException.fmt.txt"), this.name), (Throwable)ce);
                }
                throw new MonitorException(rb.getString("HTTPMonitor.sslCertificateException.ex.txt"));
            }
            catch (UnrecoverableKeyException urke) {
                if (this.logger != null) {
                    this.logger.error(MessageFormat.format(rb.getString("HTTPMonitor.sslUnrecoverableKeyException.fmt.txt"), this.name), (Throwable)urke);
                }
                throw new MonitorException(rb.getString("HTTPMonitor.sslUnrecoverableKeyException.ex.txt"));
            }
            catch (KeyManagementException kme) {
                if (this.logger != null) {
                    this.logger.error(MessageFormat.format(rb.getString("HTTPMonitor.sslKeyManagementException.fmt.txt"), this.name), (Throwable)kme);
                }
                throw new MonitorException(rb.getString("HTTPMonitor.sslKeyManagementException.ex.txt"));
            }
        } else {
            ssf = ServerSocketFactory.getDefault();
        }
        return ssf;
    }

    protected void sendResponse(String code, String reason, String data, Socket socket) {
        if (this.logger != null && this.logger.isInfoEnabled()) {
            this.logger.info(MessageFormat.format(rb.getString("HTTPMonitor.sendResponse.fmt.txt"), this.name, code, reason, data));
        }
        try {
            BufferedOutputStream bos = new BufferedOutputStream(socket.getOutputStream());
            StringBuffer sb = new StringBuffer();
            sb.append("HTTP/1.0 ");
            sb.append(code);
            sb.append(" ");
            sb.append(reason);
            sb.append(CRLF);
            String out = sb.toString();
            byte[] b = out.getBytes();
            bos.write(b, 0, b.length);
            sb = new StringBuffer();
            sb.append("Content-Length: ");
            sb.append(data.length());
            sb.append(CRLF);
            out = sb.toString();
            b = out.getBytes();
            bos.write(b, 0, b.length);
            out = "Content-Type: text/plain\r\n\r\n";
            b = out.getBytes();
            bos.write(b, 0, b.length);
            b = data.getBytes();
            bos.write(b, 0, b.length);
            bos.flush();
            socket.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    protected void sendHeadResponse(Socket socket) {
        try {
            BufferedOutputStream bos = new BufferedOutputStream(socket.getOutputStream());
            String out = "HTTP/1.0 200 OK\r\n";
            byte[] b = out.getBytes();
            bos.write(b, 0, b.length);
            out = "Server: SAS Foundation Services Event Broker 1.0\r\n";
            b = out.getBytes();
            bos.write(b, 0, b.length);
            out = "Content-Type: text/xml\r\n\r\n";
            b = out.getBytes();
            bos.write(b, 0, b.length);
            bos.flush();
            socket.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    protected void sendOptionsResponse(Socket socket) {
        try {
            BufferedOutputStream bos = new BufferedOutputStream(socket.getOutputStream());
            String out = "HTTP/1.0 200 OK\r\n";
            byte[] b = out.getBytes();
            bos.write(b, 0, b.length);
            out = "Server: SAS Foundation Services Event Broker 1.0\r\n";
            b = out.getBytes();
            bos.write(b, 0, b.length);
            out = "Content-Length: 0\r\n";
            b = out.getBytes();
            bos.write(b, 0, b.length);
            out = "Allow: HEAD, POST, OPTIONS\r\n\r\n";
            b = out.getBytes();
            bos.write(b, 0, b.length);
            bos.flush();
            socket.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    @SASScope
    class sslHandshakeCompletedListener
    implements HandshakeCompletedListener {
        sslHandshakeCompletedListener() {
        }

        @Override
        public void handshakeCompleted(HandshakeCompletedEvent event) {
            if (HTTPMonitor.this.logger != null && HTTPMonitor.this.logger.isDebugEnabled()) {
                SSLSession session = event.getSession();
                String peerHost = session.getPeerHost();
                HTTPMonitor.this.logger.debug(MessageFormat.format(rb.getString("HTTPMonitor.sslHandshakeCompleted.fmt.txt"), HTTPMonitor.this.name, peerHost));
            }
        }
    }

    @SASScope
    protected class HttpInputStream
    extends InputStream {
        InputStream _is;
        String _method;
        String _uri;
        String _protocol;
        int _contentLength = -1;
        String _contentType;

        public HttpInputStream(InputStream is) {
            this._is = is;
        }

        public String getRequestMethod() {
            return this._method;
        }

        public String getRequestURI() {
            return this._uri;
        }

        public String getRequestProtocol() {
            return this._protocol;
        }

        public int getContentLength() {
            return this._contentLength;
        }

        public String getContentType() {
            return this._contentType;
        }

        public boolean isValid() {
            boolean isValid = false;
            if (this._protocol != null && this._protocol.indexOf("HTTP") != -1) {
                isValid = true;
            }
            return isValid;
        }

        public void readRequest() throws IOException {
            int sp1;
            String request;
            while ((request = this.readLine()) == null || request.length() == 0) {
            }
            if (HTTPMonitor.this.logger != null && HTTPMonitor.this.logger.isDebugEnabled()) {
                HTTPMonitor.this.logger.debug(MessageFormat.format(rb.getString("HTTPMonitor.request.fmt.txt"), request));
            }
            if ((sp1 = request.indexOf(32)) == -1) {
                this._method = request.substring(0);
            } else {
                this._method = request.substring(0, sp1);
                int sp2 = request.indexOf(32, sp1 + 1);
                if (sp2 == -1) {
                    this._uri = request.substring(sp1 + 1);
                } else {
                    this._uri = request.substring(sp1 + 1, sp2);
                    this._protocol = request.substring(sp2 + 1);
                }
            }
        }

        public MimeHeaders readHeaders() throws IOException {
            String header;
            MimeHeaders headers = new MimeHeaders();
            if (HTTPMonitor.this.logger != null && HTTPMonitor.this.logger.isDebugEnabled()) {
                HTTPMonitor.this.logger.debug(rb.getString("HTTPMonitor.headers.txt"));
            }
            while ((header = this.readLine()) != null && header.length() != 0) {
                int colon = header.indexOf(58);
                if (colon < 0) {
                    if (HTTPMonitor.this.logger == null || !HTTPMonitor.this.logger.isDebugEnabled()) continue;
                    HTTPMonitor.this.logger.debug(MessageFormat.format(rb.getString("HTTPMonitor.invalidHeader.fmt.txt"), header));
                    continue;
                }
                String name = header.substring(0, colon).trim();
                String value = header.substring(colon + 1).trim();
                if (HTTPMonitor.this.logger != null && HTTPMonitor.this.logger.isDebugEnabled()) {
                    HTTPMonitor.this.logger.debug(MessageFormat.format(rb.getString("HTTPMonitor.header.fmt.txt"), name, value));
                }
                StringTokenizer values = new StringTokenizer(value, ",");
                while (values.hasMoreTokens()) {
                    headers.addHeader(name, values.nextToken().trim());
                }
                if (name.equalsIgnoreCase("content-length")) {
                    try {
                        this._contentLength = Integer.parseInt(value);
                    }
                    catch (NumberFormatException nfe) {
                        if (HTTPMonitor.this.logger == null) continue;
                        HTTPMonitor.this.logger.error(rb.getString("HTTPMonitor.invalidContentLength.txt"));
                    }
                    continue;
                }
                if (!name.equalsIgnoreCase("content-type")) continue;
                this._contentType = value;
            }
            return headers;
        }

        @Override
        public int read() throws IOException {
            byte[] b;
            int numbytes;
            int result = -1;
            if (this._contentLength > 0 && (numbytes = this.read(b = new byte[1])) == 1) {
                result = b[0];
            }
            return result;
        }

        @Override
        public int read(byte[] b) throws IOException {
            int result = -1;
            if (this._contentLength > 0) {
                result = this._is.read(b);
                if (result > this._contentLength && HTTPMonitor.this.logger != null) {
                    HTTPMonitor.this.logger.warn(rb.getString("HTTPMonitor.tooMuchContent.txt"));
                }
                if (result >= 0) {
                    this._contentLength -= result;
                }
            }
            return result;
        }

        @Override
        public int read(byte[] b, int off, int len) throws IOException {
            int result = -1;
            if (this._contentLength > 0) {
                result = this._is.read(b, off, len);
                if (result > this._contentLength && HTTPMonitor.this.logger != null) {
                    HTTPMonitor.this.logger.warn(rb.getString("HTTPMonitor.tooMuchContent.txt"));
                }
                if (result >= 0) {
                    this._contentLength -= result;
                }
            }
            return result;
        }

        @Override
        public int available() throws IOException {
            return this._is.available();
        }

        @Override
        public void close() throws IOException {
            this._is.close();
        }

        private String readLine() throws IOException {
            StringBuffer sb = new StringBuffer();
            while (true) {
                int ch;
                if ((ch = this._is.read()) < 0) {
                    if (sb.length() != 0) break;
                    return null;
                }
                if (ch == 13) continue;
                if (ch == 10) break;
                sb.append((char)ch);
            }
            return sb.toString();
        }
    }

    @SASScope
    protected class HTTPListener
    implements Runnable {
        private String strEvent = null;

        protected HTTPListener() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            block28: {
                Socket socket;
                EventRequest eventRequest = null;
                try {
                    socket = HTTPMonitor.this.server.accept();
                    if (socket instanceof SSLSocket) {
                        SSLSocket sslSocket = (SSLSocket)socket;
                        sslSocket.addHandshakeCompletedListener(new sslHandshakeCompletedListener());
                    }
                }
                catch (IOException ioe) {
                    if (ioe.toString().indexOf("socket closed") != -1) {
                        if (HTTPMonitor.this.logger != null && HTTPMonitor.this.logger.isDebugEnabled()) {
                            HTTPMonitor.this.logger.debug(MessageFormat.format(rb.getString("HTTPMonitor.listenerShutdown.fmt.txt"), HTTPMonitor.this.name));
                        }
                    } else if (HTTPMonitor.this.logger != null) {
                        HTTPMonitor.this.logger.error(MessageFormat.format(rb.getString("HTTPMonitor.runListenerIOException.fmt.txt"), HTTPMonitor.this.name), (Throwable)ioe);
                    }
                    return;
                }
                HTTPMonitor.this.incrementListeners();
                HTTPMonitor.this.startListener(HTTPMonitor.this.getListener());
                try {
                    HttpInputStream is = new HttpInputStream(socket.getInputStream());
                    this.strEvent = this.parseHttp(is);
                    if (!is.isValid()) {
                        String reason = "Invalid protocol.";
                        String data = "The request was not understood.";
                        HTTPMonitor.this.sendResponse(HTTPMonitor.HTTP_STATUS_BAD_REQUEST, reason, data, socket);
                        break block28;
                    }
                    String method = is.getRequestMethod();
                    if (HTTPMonitor.HTTP_METHOD_HEAD.equalsIgnoreCase(method)) {
                        HTTPMonitor.this.sendHeadResponse(socket);
                        break block28;
                    }
                    if (HTTPMonitor.HTTP_METHOD_OPTIONS.equalsIgnoreCase(method)) {
                        HTTPMonitor.this.sendOptionsResponse(socket);
                        break block28;
                    }
                    if (HTTPMonitor.HTTP_METHOD_POST.equalsIgnoreCase(method)) {
                        block29: {
                            if (this.strEvent == null || this.strEvent.length() <= 0) {
                                String reason = "No event content.";
                                String data = "No content and/or content-length was given.";
                                HTTPMonitor.this.sendResponse(HTTPMonitor.HTTP_STATUS_LENGTH_REQUIRED, reason, data, socket);
                                break block28;
                            }
                            if (HTTPMonitor.this.logger != null && HTTPMonitor.this.logger.isDebugEnabled()) {
                                HTTPMonitor.this.logger.debug(MessageFormat.format(rb.getString("HTTPMonitor.receivedEvent.fmt.txt"), HTTPMonitor.this.name, this.strEvent));
                            }
                            HTTPMonitor.this.responseProperties.put("replyToSocket", socket);
                            HTTPResponseAgent responseAgent = new HTTPResponseAgent(HTTPMonitor.this.name, HTTPMonitor.this.responseProperties, HTTPMonitor.this.logger);
                            eventRequest = new EventRequest(this.strEvent, responseAgent);
                            if (HTTPMonitor.this.defaultEvent != null) {
                                eventRequest.setDefaultEvent(HTTPMonitor.this.defaultEvent);
                            }
                            eventRequest.setReplyRequired();
                            try {
                                HTTPMonitor.this.eventContainer._mutex.lock();
                            }
                            catch (InterruptedException ie) {
                                if (HTTPMonitor.this.logger == null) break block29;
                                HTTPMonitor.this.logger.error(MessageFormat.format(rb.getString("HTTPMonitor.mutexInterrupt.fmt.txt"), HTTPMonitor.this.name));
                            }
                        }
                        while (HTTPMonitor.this.eventContainer.isFull()) {
                            try {
                                HTTPMonitor.this.eventContainer._monitorCV.condWait(HTTPMonitor.this.eventContainer._mutex);
                            }
                            catch (InterruptedException ie) {
                                if (HTTPMonitor.this.logger == null) continue;
                                HTTPMonitor.this.logger.error(MessageFormat.format(rb.getString("HTTPMonitor.condWaitInterrupt.fmt.txt"), HTTPMonitor.this.name));
                            }
                        }
                        HTTPMonitor.this.eventContainer.add(eventRequest);
                        try {
                            HTTPMonitor.this.eventContainer._mutex.unlock();
                        }
                        catch (MutexStateException ie) {
                            // empty catch block
                        }
                        HTTPMonitor.this.eventContainer._workerCV.condSignal();
                        break block28;
                    }
                    String reason = "Method not allowed.";
                    String data = method + " is not supported.";
                    HTTPMonitor.this.sendResponse(HTTPMonitor.HTTP_STATUS_METHOD_NOT_ALLOWED, reason, data, socket);
                }
                catch (Exception e) {
                    if (HTTPMonitor.this.logger != null) {
                        HTTPMonitor.this.logger.error(MessageFormat.format(rb.getString("HTTPMonitor.runListenerException.fmt.txt"), HTTPMonitor.this.name), (Throwable)e);
                    }
                    if (socket != null) {
                        Class<?> clazz = e.getClass();
                        String reason = clazz.getName();
                        String data = e.getMessage();
                        HTTPMonitor.this.sendResponse(HTTPMonitor.HTTP_STATUS_INTERNAL_ERROR, reason, data, socket);
                    }
                }
                finally {
                    HTTPMonitor.this.decrementListeners();
                }
            }
        }

        private String parseHttp(HttpInputStream is) throws IOException {
            String strEvent = "";
            is.readRequest();
            if (is.isValid()) {
                is.readHeaders();
                if (HTTPMonitor.HTTP_METHOD_POST.equalsIgnoreCase(is.getRequestMethod()) && is.getContentLength() > 0) {
                    int index;
                    int ch;
                    ByteArrayOutputStream baos = new ByteArrayOutputStream();
                    while ((ch = is.read()) != -1) {
                        baos.write(ch);
                    }
                    strEvent = baos.toString("utf-8");
                    String contentType = is.getContentType();
                    if (contentType != null && contentType.indexOf("x-www-form-urlencoded") != -1 && (index = (strEvent = URLDecoder.decode(strEvent, "utf-8")).indexOf("=")) != -1) {
                        strEvent = strEvent.substring(index + 1);
                    }
                }
            }
            return strEvent;
        }
    }
}

