/*
 * Decompiled with CFR 0.152.
 */
package com.sas.services.events.broker.flowengine;

import com.sas.codepolicy.SASScope;
import com.sas.services.InitializationException;
import com.sas.services.events.broker.flowengine.ProcessNodeInterface;
import com.sas.services.events.broker.flowengine.RB;
import java.text.MessageFormat;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.Set;

@SASScope
public class FlowNode {
    protected String _id;
    protected String _name;
    protected String _desc;
    protected String _className;
    protected boolean _bStart;
    protected Set _inputs;
    protected Set _outputs;
    protected Map _attributes;
    protected Set _successors;
    protected Set _predecessors;
    protected ProcessNodeInterface _processNode;
    private static final String RB_KEY = "FlowNode.";
    private static ResourceBundle rb = RB.getResources();

    public FlowNode() {
    }

    public FlowNode(String id, String name, String desc, String className, boolean bStart, Set inputs, Set outputs, Map attributes, Set predecessors, Set successors) {
        this._id = id;
        this._name = name;
        this._desc = desc;
        this._className = className;
        this._bStart = bStart;
        this._inputs = inputs;
        this._outputs = outputs;
        this._attributes = attributes;
        this._predecessors = predecessors;
        this._successors = successors;
    }

    public void instantiate() throws InitializationException {
        try {
            this._processNode = (ProcessNodeInterface)Class.forName(this._className).newInstance();
        }
        catch (ClassNotFoundException nfe) {
            throw new InitializationException(MessageFormat.format(rb.getString("FlowNode.processNodeClassNotFoundException.ex.fmt.txt"), this._className, nfe.getMessage()));
        }
        catch (InstantiationException ie) {
            throw new InitializationException(MessageFormat.format(rb.getString("FlowNode.processNodeInstantiationException.ex.fmt.txt"), this._className, ie.getMessage()));
        }
        catch (IllegalAccessException iae) {
            throw new InitializationException(MessageFormat.format(rb.getString("FlowNode.processNodeIllegalAccessException.ex.fmt.txt"), this._className, iae.getMessage()));
        }
    }

    public String getId() {
        return this._id;
    }

    public String getName() {
        return this._name;
    }

    public String getDesc() {
        return this._desc;
    }

    public String getClassName() {
        return this._className;
    }

    public boolean isStart() {
        return this._bStart;
    }

    public Map getAttributes() {
        return this._attributes;
    }

    public Set getInputs() {
        return this._inputs;
    }

    public Set getOutputs() {
        return this._outputs;
    }

    public Set getSuccessors() {
        return this._successors;
    }

    public Set getPredecessors() {
        return this._predecessors;
    }
}

