/*
 * Decompiled with CFR 0.152.
 */
package com.sas.services.events.broker;

import com.sas.codepolicy.BinaryCompatibilityOnly;
import com.sas.codepolicy.SASScope;
import com.sas.security.PermissionCheckProxy;
import com.sas.security.omipermissions.OMIMetadataPermission;
import com.sas.security.omipermissions.PermissionConditionException;
import com.sas.services.ParseException;
import com.sas.services.discovery.DiscoveryService;
import com.sas.services.discovery.LocalDiscoveryServiceInterface;
import com.sas.services.discovery.ServiceTemplate;
import com.sas.services.events.ApplicationMonitorResources;
import com.sas.services.events.broker.ListenerInterface;
import com.sas.services.events.broker.Message;
import com.sas.services.events.broker.MessageBodyConversionException;
import com.sas.services.events.broker.RB;
import com.sas.services.events.broker.SecurityContext;
import com.sas.services.events.broker.flowengine.ListenerDispatch;
import com.sas.services.events.broker.flowengine.ProcessFlow;
import com.sas.services.events.broker.flowengine.RuntimeFlow;
import com.sas.services.events.broker.monitor.ResponseAgent;
import com.sas.services.events.broker.monitor.ResponseException;
import com.sas.services.events.broker.util.Barrier;
import com.sas.services.events.broker.util.Event;
import com.sas.services.events.broker.util.EventContainer;
import com.sas.services.events.broker.util.EventRequest;
import com.sas.services.events.broker.util.ListenerEvent;
import com.sas.services.events.broker.util.MutexStateException;
import com.sas.services.events.broker.util.ThreadPool;
import com.sas.services.logging.util.LoggerMonitor2;
import com.sas.services.security.GetSubject;
import com.sas.services.session.SessionContextInterface;
import com.sas.services.session.SessionServiceInterface;
import com.sas.services.user.UserContextInterface;
import com.sas.services.user.UserServiceInterface;
import com.sas.services.util.XMLUtil;
import com.sas.util.ChainedException;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.io.Serializable;
import java.io.StringReader;
import java.rmi.RemoteException;
import java.security.AccessControlException;
import java.security.Permission;
import java.text.MessageFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.TimeZone;
import java.util.Vector;
import javax.security.auth.Subject;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentFragment;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXNotRecognizedException;
import org.xml.sax.SAXNotSupportedException;
import org.xml.sax.ext.LexicalHandler;
import org.xml.sax.helpers.DefaultHandler;

@SASScope(value="ALL")
@BinaryCompatibilityOnly
public class EventManager
implements Runnable {
    private EventContainer _eventContainer;
    private Logger _logger;
    private LoggerMonitor2 _applicationMonitorLogger;
    private ThreadPool _tp;
    private UserServiceInterface _userService;
    private SessionServiceInterface _sessionService;
    private static final int ERRORCODE_SHUTDOWNINPROGRESS = 10;
    private static final int ERRORCODE_PARSEEXCEPTION = 20;
    private static final int ERRORCODE_NOEVENTBINDING = 30;
    private static final int ERRORCODE_EVENTNOTCONFIGURED = 40;
    private static final int ERRORCODE_AUTHENTICATIONEXCEPTION = 50;
    private static final int ERRORCODE_NOTAUTHORIZED = 60;
    private static final int ERRORCODE_NOHANDLINGAGENT = 70;
    static ResourceBundle rb = RB.getResources();
    private static final String NS_URI = "http://www.sas.com/xml/namespace/services.events-1.1";
    private static final String NS_PREFIX = "sas-event";
    private static final String NS_PREFIX_COLON = "sas-event:";

    @SASScope
    EventManager(EventContainer eventContainer) throws IllegalArgumentException {
        block6: {
            LocalDiscoveryServiceInterface discoveryService;
            block5: {
                if (eventContainer == null) {
                    throw new IllegalArgumentException();
                }
                this._eventContainer = eventContainer;
                this._logger = LogManager.getLogger((String)this.getClass().getName());
                this._applicationMonitorLogger = new LoggerMonitor2(LogManager.getLogger((String)"ApplicationMonitor.EventBrokerService"));
                this._tp = eventContainer.getThreadPool();
                discoveryService = DiscoveryService.defaultInstance();
                try {
                    this._sessionService = (SessionServiceInterface)discoveryService.findService(new ServiceTemplate(new Class[]{SessionServiceInterface.class}, null));
                }
                catch (Throwable t) {
                    if (this._logger == null) break block5;
                    this._logger.warn(MessageFormat.format(rb.getString("EventManager.sessionServiceException.fmt.txt"), t.getClass().getName() + ": " + t.getMessage()));
                }
            }
            try {
                this._userService = (UserServiceInterface)discoveryService.findService(new ServiceTemplate(new Class[]{UserServiceInterface.class}, null));
            }
            catch (Throwable t) {
                if (this._logger == null) break block6;
                this._logger.warn(MessageFormat.format(rb.getString("EventManager.userServiceException.fmt.txt"), t.getClass().getName() + ": " + t.getMessage()));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @SASScope
    public void run() {
        boolean stop = false;
        boolean drain = false;
        while (true) {
            block197: {
                try {
                    this._eventContainer._mutex.lock();
                }
                catch (InterruptedException ie) {
                    if (this._logger == null) break block197;
                    this._logger.error(rb.getString("EventManager.interruptMutex.txt"));
                }
            }
            while (this._eventContainer.isEmpty() && !this._eventContainer._stop) {
                try {
                    this._eventContainer._workerCV.condWait(this._eventContainer._mutex);
                }
                catch (InterruptedException ie) {
                    if (this._logger == null) continue;
                    this._logger.error(rb.getString("EventManager.interruptCondWait.txt"));
                }
            }
            if (this._eventContainer._stop) {
                stop = true;
                if (this._logger != null && this._logger.isDebugEnabled()) {
                    this._logger.debug(MessageFormat.format(rb.getString("EventManager.stopSignaled.fmt.txt"), Thread.currentThread().getName()));
                }
            }
            if (this._eventContainer._drain) {
                drain = true;
                if (this._logger != null && this._logger.isDebugEnabled()) {
                    this._logger.debug(MessageFormat.format(rb.getString("EventManager.drainSignaled.fmt.txt"), Thread.currentThread().getName()));
                }
            }
            EventRequest eventRequest = this._eventContainer.isEmpty() ? null : this._eventContainer.remove();
            try {
                this._eventContainer._mutex.unlock();
            }
            catch (MutexStateException ie) {
                // empty catch block
            }
            this._eventContainer._monitorCV.condSignal();
            if (eventRequest != null) {
                Barrier barrier;
                block201: {
                    String eventName;
                    EventRequest ce2;
                    Serializable re;
                    String exceptionMsg;
                    boolean bParseException;
                    String receivedTime;
                    block198: {
                        SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss'Z'");
                        TimeZone utc = TimeZone.getTimeZone("UTC");
                        formatter.setTimeZone(utc);
                        receivedTime = formatter.format(new Date());
                        if (this._applicationMonitorLogger != null && this._applicationMonitorLogger.isLoggingEnabled()) {
                            this._applicationMonitorLogger.log(ApplicationMonitorResources.COLUMN_ACTION, ApplicationMonitorResources.ACTION_EVENT_RECEIVED, ApplicationMonitorResources.COLUMN_EVENT_NAME, "", ApplicationMonitorResources.COLUMN_HANDLER_NAME, "", ApplicationMonitorResources.COLUMN_INFORMATION, "");
                        }
                        bParseException = false;
                        exceptionMsg = null;
                        try {
                            if (this._logger != null && this._logger.isDebugEnabled()) {
                                this._logger.debug(rb.getString("EventManager.beginEventParse.txt"));
                            }
                            this.parseEvent(eventRequest);
                        }
                        catch (ParseException pe) {
                            bParseException = true;
                            exceptionMsg = pe.getMessage();
                            if (this._logger != null) {
                                this._logger.error(MessageFormat.format(rb.getString("EventManager.eventParseException.fmt.txt"), exceptionMsg));
                            }
                        }
                        catch (ChainedException ce2) {
                            bParseException = true;
                            re = ce2.getRootException();
                            exceptionMsg = re.getMessage();
                            if (this._logger == null) break block198;
                            this._logger.error(rb.getString("EventManager.eventParseException.txt"), re);
                        }
                    }
                    if (bParseException) {
                        this.sendErrorResponse(20, MessageFormat.format(rb.getString("EventManager.eventParseException.fmt.txt"), exceptionMsg), eventRequest);
                        if (eventRequest.isSyncRequest()) {
                            if (this._logger != null && this._logger.isDebugEnabled()) {
                                this._logger.debug(rb.getString("EventManager.wakeupSyncClient.txt"));
                            }
                            ce2 = eventRequest;
                            synchronized (ce2) {
                                eventRequest.setSyncComplete();
                                eventRequest.notify();
                            }
                        }
                        this.cleanup(eventRequest);
                        continue;
                    }
                    if (drain) {
                        if (this._logger != null && this._logger.isDebugEnabled()) {
                            this._logger.debug(MessageFormat.format(rb.getString("EventManager.shutdownInProgress.fmt.txt"), eventRequest.getEventName() == null ? "UNFORMATTED" : eventRequest.getEventName()));
                        }
                        this.sendErrorResponse(10, rb.getString("EventManager.shutdownInProgress.txt"), eventRequest);
                        if (eventRequest.isSyncRequest()) {
                            if (this._logger != null && this._logger.isDebugEnabled()) {
                                this._logger.debug(rb.getString("EventManager.wakeupSyncClient.txt"));
                            }
                            ce2 = eventRequest;
                            synchronized (ce2) {
                                eventRequest.notify();
                            }
                        }
                        this.cleanup(eventRequest);
                        continue;
                    }
                    if (eventRequest.isUnstructured()) {
                        eventName = eventRequest.getDefaultEvent();
                        if (eventName == null || eventName.length() == 0) {
                            eventName = this._eventContainer.getEventConfiguration().getDefaultEvent();
                        }
                        if (eventName == null || eventName.length() == 0) {
                            if (this._logger != null) {
                                this._logger.error(rb.getString("EventManager.noEventBinding.txt"));
                            }
                            this.sendErrorResponse(30, rb.getString("EventManager.noEventBinding.txt"), eventRequest);
                            if (eventRequest.isSyncRequest()) {
                                if (this._logger != null && this._logger.isDebugEnabled()) {
                                    this._logger.debug(rb.getString("EventManager.wakeupSyncClient.txt"));
                                }
                                re = eventRequest;
                                synchronized (re) {
                                    eventRequest.notify();
                                }
                            }
                            this.cleanup(eventRequest);
                            continue;
                        }
                        eventRequest.setEventName(eventName);
                        if (this._logger != null && this._logger.isInfoEnabled()) {
                            this._logger.info(MessageFormat.format(rb.getString("EventManager.receivedNonFormatEvent.fmt.txt"), eventName));
                        }
                    } else {
                        eventName = eventRequest.getEventName();
                        if (this._logger != null && this._logger.isInfoEnabled()) {
                            int choice = eventRequest.getSentFrom() != null ? 1 : 0;
                            String type = "";
                            type = eventRequest.isResponseRequired() ? "Request/Response" : "Broadcast";
                            this._logger.info(MessageFormat.format(rb.getString("EventManager.receivedEvent.fmt.txt"), eventName, type, choice, eventRequest.getSentFrom()));
                        }
                    }
                    if (this._applicationMonitorLogger != null && this._applicationMonitorLogger.isLoggingEnabled()) {
                        String information = "";
                        information = eventRequest.isUnstructured() ? ApplicationMonitorResources.INFORMATION_EVENT_UNSTRUCTURED : (eventRequest.isResponseRequired() ? ApplicationMonitorResources.INFORMATION_EVENT_TYPE_RR : ApplicationMonitorResources.INFORMATION_EVENT_TYPE_BROADCAST);
                        this._applicationMonitorLogger.log(ApplicationMonitorResources.COLUMN_ACTION, ApplicationMonitorResources.ACTION_EVENT_PROCESSING, ApplicationMonitorResources.COLUMN_EVENT_NAME, eventName, ApplicationMonitorResources.COLUMN_HANDLER_NAME, "", ApplicationMonitorResources.COLUMN_INFORMATION, information);
                    }
                    this._eventContainer._rwLock.readLock();
                    boolean eventConfigured = this._eventContainer.isEventConfigured(eventName, eventRequest.isResponseRequired());
                    boolean eventListenedFor = this._eventContainer.isEventListenedFor(eventName, eventRequest.isResponseRequired());
                    barrier = null;
                    if (!eventConfigured && !eventListenedFor) {
                        String type = "";
                        type = eventRequest.isResponseRequired() ? "Request/Response" : "Broadcast";
                        if (this._logger != null) {
                            this._logger.error(MessageFormat.format(rb.getString("EventManager.notConfigured.fmt.txt"), eventName, type));
                        }
                        this.sendErrorResponse(40, MessageFormat.format(rb.getString("EventManager.notConfigured.fmt.txt"), eventName, type), eventRequest);
                    } else {
                        eventRequest.setOwningBroker(this._eventContainer.getOwningBroker());
                        boolean bRouteToNextHandler = true;
                        boolean bSentErrorResponse = false;
                        boolean bProcessed = false;
                        Map sessionMap = eventRequest.getSessionContextUsage();
                        SecurityContext sendersContext = eventRequest.getSecurityContext();
                        SessionContextInterface sendersSessionContext = sendersContext.getSessionContext();
                        boolean bSessionContextPassedFromSender = sendersSessionContext != null;
                        UserContextInterface sendersUserContext = sendersContext.getUserContext();
                        Subject sendersSubject = null;
                        Map map = sessionMap;
                        synchronized (map) {
                            if (eventListenedFor) {
                                String strBody = null;
                                try {
                                    Message message = eventRequest.getMessage();
                                    strBody = message.getBodyAsString();
                                    message.setBody(strBody);
                                }
                                catch (MessageBodyConversionException message) {
                                    // empty catch block
                                }
                                Vector events = this._eventContainer.getEventListeners(eventName, eventRequest.isResponseRequired());
                                Iterator eventIter = events.iterator();
                                block84: while (eventIter.hasNext() && bRouteToNextHandler) {
                                    Event configuredEvent;
                                    Iterator configuredEventIter;
                                    ListenerEvent event = (ListenerEvent)eventIter.next();
                                    Set configuredEvents = this._eventContainer.getConfiguredEvents(event.getName(), eventRequest.isResponseRequired(), false);
                                    if (configuredEvents != null && (configuredEventIter = configuredEvents.iterator()).hasNext() && (configuredEvent = (Event)configuredEventIter.next()).isSecured()) {
                                        boolean isAuthorized = false;
                                        if (bSessionContextPassedFromSender) {
                                            if (sendersUserContext == null) {
                                                if (this._logger != null) {
                                                    this._logger.error(rb.getString("EventManager.authNoUC.txt"));
                                                }
                                                this.sendErrorResponse(50, rb.getString("EventManager.authException.txt"), eventRequest);
                                                bSentErrorResponse = true;
                                                if (!eventRequest.isResponseRequired()) continue;
                                                bRouteToNextHandler = false;
                                                break;
                                            }
                                        } else if (sendersSessionContext == null) {
                                            if (this._sessionService == null || this._userService == null) {
                                                if (this._logger != null) {
                                                    this._logger.error(rb.getString("EventManager.authNoService.txt"));
                                                }
                                                this.sendErrorResponse(50, rb.getString("EventManager.authException.txt"), eventRequest);
                                                bSentErrorResponse = true;
                                                if (!eventRequest.isResponseRequired()) continue;
                                                bRouteToNextHandler = false;
                                                break;
                                            }
                                            try {
                                                sendersUserContext = this._userService.newUser(sendersContext.getUserName(), sendersContext.getUserPW(), sendersContext.getDomain());
                                            }
                                            catch (Throwable t) {
                                                if (this._logger != null) {
                                                    this._logger.error(MessageFormat.format(rb.getString("EventManager.authException.fmt.txt"), sendersContext.getUserName(), sendersContext.getDomain()), t);
                                                }
                                                this.sendErrorResponse(50, rb.getString("EventManager.authException.txt"), eventRequest);
                                                bSentErrorResponse = true;
                                                if (!eventRequest.isResponseRequired()) continue;
                                                bRouteToNextHandler = false;
                                                break;
                                            }
                                            try {
                                                sendersSessionContext = this._sessionService.newSessionContext(sendersUserContext);
                                                sessionMap.put(sendersSessionContext, 0);
                                            }
                                            catch (Throwable t) {
                                                if (this._logger != null) {
                                                    this._logger.error(rb.getString("EventManager.authNoSC.txt"), t);
                                                }
                                                this.sendErrorResponse(50, rb.getString("EventManager.authException.txt"), eventRequest);
                                                bSentErrorResponse = true;
                                                try {
                                                    sendersUserContext.destroy();
                                                }
                                                catch (Throwable throwable) {
                                                    // empty catch block
                                                }
                                                sendersUserContext = null;
                                                sendersSessionContext = null;
                                                if (!eventRequest.isResponseRequired()) continue;
                                                bRouteToNextHandler = false;
                                                break;
                                            }
                                        }
                                        if (sendersSubject == null) {
                                            try {
                                                sendersSubject = GetSubject.getSubject((UserContextInterface)sendersUserContext);
                                            }
                                            catch (Throwable t) {
                                                if (this._logger != null) {
                                                    this._logger.error(rb.getString("EventManager.authNoSubject.txt"), t);
                                                }
                                                this.sendErrorResponse(50, rb.getString("EventManager.authException.txt"), eventRequest);
                                                bSentErrorResponse = true;
                                                if (!eventRequest.isResponseRequired()) continue;
                                                bRouteToNextHandler = false;
                                                break;
                                            }
                                        }
                                        try {
                                            String resource = "OMSOBJ:Event/" + configuredEvent.getId();
                                            String action = "Execute";
                                            OMIMetadataPermission perm = new OMIMetadataPermission(resource, action);
                                            PermissionCheckProxy.checkPermission((Subject)sendersSubject, (Permission)perm);
                                            isAuthorized = true;
                                        }
                                        catch (PermissionConditionException resource) {
                                        }
                                        catch (AccessControlException resource) {
                                        }
                                        catch (Throwable t) {
                                            if (this._logger != null) {
                                                this._logger.error(MessageFormat.format(rb.getString("EventManager.authFailure.fmt.txt"), t.getClass().getName() + ": " + t.getMessage()), t);
                                            }
                                            this.sendErrorResponse(60, rb.getString("EventManager.notAuthorized.txt"), eventRequest);
                                            bSentErrorResponse = true;
                                            if (!eventRequest.isResponseRequired()) continue;
                                            bRouteToNextHandler = false;
                                            break;
                                        }
                                        if (!isAuthorized) {
                                            String unauthorizedUserName;
                                            block199: {
                                                unauthorizedUserName = null;
                                                try {
                                                    unauthorizedUserName = sendersUserContext.getName();
                                                }
                                                catch (RemoteException re2) {
                                                    if (this._logger == null) break block199;
                                                    this._logger.error(re2.getMessage(), (Throwable)re2);
                                                }
                                            }
                                            if (this._logger != null && this._logger.isInfoEnabled()) {
                                                this._logger.info(MessageFormat.format(rb.getString("EventManager.notAuthorized.fmt.txt"), unauthorizedUserName, event.getName()));
                                            }
                                            this.sendErrorResponse(60, rb.getString("EventManager.notAuthorized.txt"), eventRequest);
                                            bSentErrorResponse = true;
                                            if (!eventRequest.isResponseRequired()) continue;
                                            bRouteToNextHandler = false;
                                            break;
                                        }
                                    }
                                    for (ListenerInterface listener : event.getListeners()) {
                                        Object o;
                                        if (this._logger != null && this._logger.isInfoEnabled()) {
                                            this._logger.info(MessageFormat.format(rb.getString("EventManager.instantiateDispatcher.fmt.txt"), listener.toString()));
                                        }
                                        ListenerDispatch listenerDispatch = null;
                                        try {
                                            listenerDispatch = new ListenerDispatch(listener, eventRequest);
                                        }
                                        catch (RemoteException re3) {
                                            if (this._logger == null) continue;
                                            this._logger.error(MessageFormat.format(rb.getString("EventManager.dispatchRemoteException.fmt.txt"), re3.getMessage()));
                                            continue;
                                        }
                                        try {
                                            if (eventRequest.isSyncRequest()) {
                                                if (barrier == null) {
                                                    barrier = new Barrier();
                                                }
                                                barrier.addBarrier();
                                                this._tp.runTask(listenerDispatch, barrier);
                                            } else {
                                                this._tp.runTask(listenerDispatch);
                                            }
                                        }
                                        catch (Throwable t) {
                                            if (this._logger == null) continue;
                                            this._logger.error(MessageFormat.format(rb.getString("EventManager.listenerException.fmt.txt"), t.getClass().getName() + ": " + t.getMessage()));
                                            continue;
                                        }
                                        if (bSessionContextPassedFromSender && (o = sessionMap.get(sendersSessionContext)) instanceof Integer) {
                                            Integer usageCount = (Integer)o;
                                            int i = usageCount;
                                            sessionMap.put(sendersSessionContext, ++i);
                                        }
                                        bProcessed = true;
                                        if (!eventRequest.isResponseRequired()) continue;
                                        bRouteToNextHandler = false;
                                        continue block84;
                                    }
                                }
                            }
                            if (eventConfigured && bRouteToNextHandler) {
                                Set events = this._eventContainer.getConfiguredEvents(eventName, eventRequest.isResponseRequired());
                                SessionContextInterface brokersSessionContext = null;
                                UserContextInterface brokersUserContext = null;
                                Iterator eventIter = events.iterator();
                                block86: while (eventIter.hasNext() && bRouteToNextHandler) {
                                    Event event = (Event)eventIter.next();
                                    if (this._logger != null && this._logger.isInfoEnabled()) {
                                        String desc = event.getDesc();
                                        int choice = desc.length() != 0 ? 1 : 0;
                                        this._logger.info(MessageFormat.format(rb.getString("EventManager.eventExecution.fmt.txt"), event.getName(), choice, desc));
                                    }
                                    if (event.isSecured()) {
                                        boolean isAuthorized = false;
                                        if (bSessionContextPassedFromSender) {
                                            if (sendersUserContext == null) {
                                                if (this._logger != null) {
                                                    this._logger.error(rb.getString("EventManager.authNoUC.txt"));
                                                }
                                                this.sendErrorResponse(50, rb.getString("EventManager.authException.txt"), eventRequest);
                                                bSentErrorResponse = true;
                                                if (!eventRequest.isResponseRequired()) continue;
                                                break;
                                            }
                                        } else if (sendersSessionContext == null) {
                                            if (this._sessionService == null || this._userService == null) {
                                                if (this._logger != null) {
                                                    this._logger.error(rb.getString("EventManager.authNoService.txt"));
                                                }
                                                this.sendErrorResponse(50, rb.getString("EventManager.authException.txt"), eventRequest);
                                                bSentErrorResponse = true;
                                                if (!eventRequest.isResponseRequired()) continue;
                                                break;
                                            }
                                            try {
                                                sendersUserContext = this._userService.newUser(sendersContext.getUserName(), sendersContext.getUserPW(), sendersContext.getDomain());
                                            }
                                            catch (Throwable t) {
                                                if (this._logger != null) {
                                                    this._logger.error(MessageFormat.format(rb.getString("EventManager.authException.fmt.txt"), sendersContext.getUserName(), sendersContext.getDomain()), t);
                                                }
                                                this.sendErrorResponse(50, rb.getString("EventManager.authException.txt"), eventRequest);
                                                bSentErrorResponse = true;
                                                if (!eventRequest.isResponseRequired()) continue;
                                                break;
                                            }
                                            try {
                                                sendersSessionContext = this._sessionService.newSessionContext(sendersUserContext);
                                                sessionMap.put(sendersSessionContext, 0);
                                            }
                                            catch (Throwable t) {
                                                if (this._logger != null) {
                                                    this._logger.error(rb.getString("EventManager.authNoSC.txt"), t);
                                                }
                                                this.sendErrorResponse(50, rb.getString("EventManager.authException.txt"), eventRequest);
                                                bSentErrorResponse = true;
                                                try {
                                                    sendersUserContext.destroy();
                                                }
                                                catch (Throwable listenerDispatch) {
                                                    // empty catch block
                                                }
                                                sendersUserContext = null;
                                                sendersSessionContext = null;
                                                if (!eventRequest.isResponseRequired()) continue;
                                                break;
                                            }
                                        }
                                        if (sendersSubject == null) {
                                            try {
                                                sendersSubject = GetSubject.getSubject((UserContextInterface)sendersUserContext);
                                            }
                                            catch (Throwable t) {
                                                if (this._logger != null) {
                                                    this._logger.error(rb.getString("EventManager.authNoSubject.txt"), t);
                                                }
                                                this.sendErrorResponse(50, rb.getString("EventManager.authException.txt"), eventRequest);
                                                bSentErrorResponse = true;
                                                if (!eventRequest.isResponseRequired()) continue;
                                                break;
                                            }
                                        }
                                        try {
                                            String resource = "OMSOBJ:Event/" + event.getId();
                                            String action = "Execute";
                                            OMIMetadataPermission perm = new OMIMetadataPermission(resource, action);
                                            PermissionCheckProxy.checkPermission((Subject)sendersSubject, (Permission)perm);
                                            isAuthorized = true;
                                        }
                                        catch (PermissionConditionException resource) {
                                        }
                                        catch (AccessControlException resource) {
                                        }
                                        catch (Throwable t) {
                                            if (this._logger != null) {
                                                this._logger.error(MessageFormat.format(rb.getString("EventManager.authFailure.fmt.txt"), t.getClass().getName() + ": " + t.getMessage()), t);
                                            }
                                            this.sendErrorResponse(60, rb.getString("EventManager.notAuthorized.txt"), eventRequest);
                                            bSentErrorResponse = true;
                                            if (!eventRequest.isResponseRequired()) continue;
                                            break;
                                        }
                                        if (!isAuthorized) {
                                            String unauthorizedUserName;
                                            block200: {
                                                unauthorizedUserName = null;
                                                try {
                                                    unauthorizedUserName = sendersUserContext.getName();
                                                }
                                                catch (RemoteException re4) {
                                                    if (this._logger == null) break block200;
                                                    this._logger.error(re4.getMessage(), (Throwable)re4);
                                                }
                                            }
                                            if (this._logger != null && this._logger.isInfoEnabled()) {
                                                this._logger.info(MessageFormat.format(rb.getString("EventManager.notAuthorized.fmt.txt"), unauthorizedUserName, event.getName()));
                                            }
                                            this.sendErrorResponse(60, rb.getString("EventManager.notAuthorized.txt"), eventRequest);
                                            bSentErrorResponse = true;
                                            if (!eventRequest.isResponseRequired()) continue;
                                            break;
                                        }
                                    }
                                    SecurityContext runAsContext = null;
                                    Message secureMessage = null;
                                    int runAsIdentity = event.getRunAsIdentity();
                                    if (runAsIdentity == 0) {
                                        runAsContext = sendersContext;
                                    } else if (runAsIdentity == 1) {
                                        runAsContext = new SecurityContext();
                                        runAsContext.setRunAsIdentity(runAsIdentity);
                                        runAsContext.setUserName(sendersContext.getUserName());
                                        runAsContext.setUserPW(sendersContext.getUserPW());
                                        runAsContext.setDomain(sendersContext.getDomain());
                                        if (bSessionContextPassedFromSender) {
                                            if (sendersUserContext == null) {
                                                if (this._logger != null) {
                                                    this._logger.error(rb.getString("EventManager.authNoUC.txt"));
                                                }
                                                this.sendErrorResponse(50, rb.getString("EventManager.authException.txt"), eventRequest);
                                                bSentErrorResponse = true;
                                                if (!eventRequest.isResponseRequired()) continue;
                                                break;
                                            }
                                        } else if (sendersSessionContext == null) {
                                            if (this._sessionService == null || this._userService == null) {
                                                if (this._logger != null) {
                                                    this._logger.error(rb.getString("EventManager.authNoService.txt"));
                                                }
                                                this.sendErrorResponse(50, rb.getString("EventManager.authException.txt"), eventRequest);
                                                bSentErrorResponse = true;
                                                if (!eventRequest.isResponseRequired()) continue;
                                                break;
                                            }
                                            try {
                                                sendersUserContext = this._userService.newUser(runAsContext.getUserName(), runAsContext.getUserPW(), runAsContext.getDomain());
                                            }
                                            catch (Throwable t) {
                                                if (this._logger != null) {
                                                    this._logger.error(MessageFormat.format(rb.getString("EventManager.authException.fmt.txt"), runAsContext.getUserName(), runAsContext.getDomain()), t);
                                                }
                                                this.sendErrorResponse(50, rb.getString("EventManager.authException.txt"), eventRequest);
                                                bSentErrorResponse = true;
                                                if (!eventRequest.isResponseRequired()) continue;
                                                break;
                                            }
                                            try {
                                                sendersSessionContext = this._sessionService.newSessionContext(sendersUserContext);
                                                sessionMap.put(sendersSessionContext, 0);
                                            }
                                            catch (Throwable t) {
                                                if (this._logger != null) {
                                                    this._logger.error(rb.getString("EventManager.authNoSC.txt"), t);
                                                }
                                                this.sendErrorResponse(50, rb.getString("EventManager.authException.txt"), eventRequest);
                                                bSentErrorResponse = true;
                                                try {
                                                    sendersUserContext.destroy();
                                                }
                                                catch (Throwable usageCount) {
                                                    // empty catch block
                                                }
                                                sendersUserContext = null;
                                                sendersSessionContext = null;
                                                if (!eventRequest.isResponseRequired()) continue;
                                                break;
                                            }
                                        }
                                        runAsContext.setSessionContext(sendersSessionContext);
                                        runAsContext.setUserContext(sendersUserContext);
                                        secureMessage = (Message)eventRequest.getMessage().clone();
                                        secureMessage.setSecurityContext(runAsContext);
                                    } else if (runAsIdentity == 2) {
                                        runAsContext = new SecurityContext();
                                        runAsContext.setRunAsIdentity(runAsIdentity);
                                        runAsContext.setUserName(this._eventContainer.getBrokerUser());
                                        runAsContext.setUserPW(this._eventContainer.getBrokerPass());
                                        if (brokersSessionContext == null) {
                                            if (this._sessionService == null || this._userService == null) {
                                                if (this._logger != null) {
                                                    this._logger.error(rb.getString("EventManager.authNoService.txt"));
                                                }
                                                this.sendErrorResponse(50, rb.getString("EventManager.authException.txt"), eventRequest);
                                                bSentErrorResponse = true;
                                                if (!eventRequest.isResponseRequired()) continue;
                                                break;
                                            }
                                            try {
                                                brokersUserContext = this._userService.newUser(runAsContext.getUserName(), runAsContext.getUserPW(), runAsContext.getDomain());
                                            }
                                            catch (Throwable t) {
                                                if (this._logger != null) {
                                                    this._logger.error(MessageFormat.format(rb.getString("EventManager.authException.fmt.txt"), runAsContext.getUserName(), runAsContext.getDomain()), t);
                                                }
                                                this.sendErrorResponse(50, rb.getString("EventManager.authException.txt"), eventRequest);
                                                bSentErrorResponse = true;
                                                if (!eventRequest.isResponseRequired()) continue;
                                                break;
                                            }
                                            try {
                                                brokersSessionContext = this._sessionService.newSessionContext(brokersUserContext);
                                                sessionMap.put(brokersSessionContext, 0);
                                            }
                                            catch (Throwable t) {
                                                if (this._logger != null) {
                                                    this._logger.error(rb.getString("EventManager.authNoSC.txt"), t);
                                                }
                                                this.sendErrorResponse(50, rb.getString("EventManager.authException.txt"), eventRequest);
                                                bSentErrorResponse = true;
                                                try {
                                                    brokersUserContext.destroy();
                                                }
                                                catch (Throwable usageCount) {
                                                    // empty catch block
                                                }
                                                brokersUserContext = null;
                                                brokersSessionContext = null;
                                                if (!eventRequest.isResponseRequired()) continue;
                                                break;
                                            }
                                        }
                                        runAsContext.setSessionContext(brokersSessionContext);
                                        runAsContext.setUserContext(brokersUserContext);
                                        secureMessage = (Message)eventRequest.getMessage().clone();
                                        secureMessage.setSecurityContext(runAsContext);
                                    } else if (runAsIdentity == 3) {
                                        runAsContext = new SecurityContext();
                                        runAsContext.setRunAsIdentity(runAsIdentity);
                                        runAsContext.setUserName(event.getUserId());
                                        runAsContext.setUserPW(event.getPassword());
                                        runAsContext.setDomain(event.getDomain());
                                        SessionContextInterface specifiedSessionContext = null;
                                        UserContextInterface specifiedUserContext = null;
                                        if (this._sessionService == null || this._userService == null) {
                                            if (this._logger != null) {
                                                this._logger.error(rb.getString("EventManager.authNoService.txt"));
                                            }
                                            this.sendErrorResponse(50, rb.getString("EventManager.authException.txt"), eventRequest);
                                            bSentErrorResponse = true;
                                            if (!eventRequest.isResponseRequired()) continue;
                                            break;
                                        }
                                        try {
                                            specifiedUserContext = this._userService.newUser(runAsContext.getUserName(), runAsContext.getUserPW(), runAsContext.getDomain());
                                        }
                                        catch (Throwable t) {
                                            if (this._logger != null) {
                                                this._logger.error(MessageFormat.format(rb.getString("EventManager.authException.fmt.txt"), runAsContext.getUserName(), runAsContext.getDomain()), t);
                                            }
                                            this.sendErrorResponse(50, rb.getString("EventManager.authException.txt"), eventRequest);
                                            bSentErrorResponse = true;
                                            if (!eventRequest.isResponseRequired()) continue;
                                            break;
                                        }
                                        try {
                                            specifiedSessionContext = this._sessionService.newSessionContext(specifiedUserContext);
                                            sessionMap.put(specifiedSessionContext, 0);
                                        }
                                        catch (Throwable t) {
                                            if (this._logger != null) {
                                                this._logger.error(rb.getString("EventManager.authNoSC.txt"), t);
                                            }
                                            this.sendErrorResponse(50, rb.getString("EventManager.authException.txt"), eventRequest);
                                            bSentErrorResponse = true;
                                            try {
                                                specifiedUserContext.destroy();
                                            }
                                            catch (Throwable throwable) {
                                                // empty catch block
                                            }
                                            if (!eventRequest.isResponseRequired()) continue;
                                            break;
                                        }
                                        runAsContext.setSessionContext(specifiedSessionContext);
                                        runAsContext.setUserContext(specifiedUserContext);
                                        secureMessage = (Message)eventRequest.getMessage().clone();
                                        secureMessage.setSecurityContext(runAsContext);
                                    }
                                    Set flows = event.getFlows();
                                    for (ProcessFlow processFlow : flows) {
                                        Object o;
                                        if (this._logger != null && this._logger.isInfoEnabled()) {
                                            String flowDesc = processFlow.getDesc();
                                            int choice = flowDesc.length() != 0 ? 1 : 0;
                                            this._logger.info(MessageFormat.format(rb.getString("EventManager.instantiateFlow.fmt.txt"), processFlow.getName(), choice, flowDesc));
                                        }
                                        RuntimeFlow runtimeFlow = null;
                                        try {
                                            runtimeFlow = new RuntimeFlow(processFlow, eventRequest, secureMessage, this._tp);
                                        }
                                        catch (RemoteException re5) {
                                            if (this._logger == null) continue;
                                            this._logger.error(MessageFormat.format(rb.getString("EventManager.runtimeFlowRemoteException.fmt.txt"), re5.getMessage()));
                                            continue;
                                        }
                                        try {
                                            if (eventRequest.isSyncRequest()) {
                                                if (barrier == null) {
                                                    barrier = new Barrier();
                                                }
                                                barrier.addBarrier();
                                                this._tp.runTask(runtimeFlow, barrier);
                                            } else {
                                                this._tp.runTask(runtimeFlow);
                                            }
                                        }
                                        catch (Throwable t) {
                                            if (this._logger == null) continue;
                                            this._logger.error(MessageFormat.format(rb.getString("EventManager.flowException.fmt.txt"), t.getClass().getName() + ": " + t.getMessage()));
                                            continue;
                                        }
                                        SessionContextInterface runAsSessionContext = runAsContext.getSessionContext();
                                        if (runAsSessionContext != null && (o = sessionMap.get(runAsSessionContext)) instanceof Integer) {
                                            Integer usageCount = (Integer)o;
                                            int i = usageCount;
                                            sessionMap.put(runAsSessionContext, ++i);
                                        }
                                        bProcessed = true;
                                        if (!eventRequest.isResponseRequired()) continue;
                                        bRouteToNextHandler = false;
                                        continue block86;
                                    }
                                }
                            }
                        }
                        if (!bProcessed && !bSentErrorResponse) {
                            if (this._logger != null) {
                                this._logger.error(MessageFormat.format(rb.getString("EventManager.noHandlingAgent.fmt.txt"), eventName));
                            }
                            this.sendErrorResponse(70, rb.getString("EventManager.noHandlingAgent.txt"), eventRequest);
                        } else if (!bSentErrorResponse && (eventRequest.isAckRequired() || eventRequest.isReplyRequired() && !eventRequest.isResponseRequired())) {
                            if (this._logger != null && this._logger.isDebugEnabled()) {
                                this._logger.debug(rb.getString("EventManager.sendAck.txt"));
                            }
                            StringBuffer response = new StringBuffer();
                            if (eventRequest.isAckRequired()) {
                                response.append("<?xml version=\"1.0\" encoding=\"UTF-8\" ?>");
                                response.append("<sas-event:SASEventBrokerResponse");
                                response.append(" xmlns:sas-event=\"http://www.sas.com/xml/namespace/services.events-1.1\"");
                                response.append(" sas-event:event=\"" + eventName + '\"');
                                response.append(" sas-event:type=\"acknowledgement\"");
                                if (eventRequest.getIdentity() != null) {
                                    response.append(" sas-event:identity=\"" + eventRequest.getIdentity() + '\"');
                                }
                                if (eventRequest.getSentAt() != null) {
                                    response.append(" sas-event:sentAt=\"" + eventRequest.getSentAt() + '\"');
                                }
                                response.append(" sas-event:receivedAt=\"" + receivedTime + '\"');
                                response.append("/>");
                            }
                            ResponseAgent responseAgent = eventRequest.getResponseAgent();
                            try {
                                responseAgent.init();
                                responseAgent.sendResponse(response.toString());
                                responseAgent.term();
                            }
                            catch (ResponseException re6) {
                                if (this._logger == null) break block201;
                                this._logger.error(MessageFormat.format(rb.getString("EventManager.ackResponseException.fmt.txt"), re6.getMessage()));
                            }
                        }
                    }
                }
                this._eventContainer._rwLock.unlock();
                if (eventRequest.isSyncRequest()) {
                    if (this._logger != null && this._logger.isDebugEnabled()) {
                        this._logger.debug(rb.getString("EventManager.waitCompletion.txt"));
                    }
                    if (barrier != null) {
                        barrier.barrierWait();
                    }
                    if (this._logger != null && this._logger.isDebugEnabled()) {
                        this._logger.debug(rb.getString("EventManager.postCompletion.txt"));
                    }
                    EventRequest eventRequest2 = eventRequest;
                    synchronized (eventRequest2) {
                        eventRequest.setSyncComplete();
                        eventRequest.notify();
                    }
                }
                this.cleanup(eventRequest);
            }
            if (stop && eventRequest == null) break;
        }
        if (this._logger != null && this._logger.isInfoEnabled()) {
            this._logger.info(MessageFormat.format(rb.getString("EventManager.exit.fmt.txt"), Thread.currentThread().getName()));
        }
        this._logger = null;
        this._applicationMonitorLogger = null;
    }

    private void parseEvent(EventRequest eventRequest) throws ParseException, ChainedException {
        eventRequest.setEventName("");
        eventRequest.setPriority(5);
        SecurityContext originatorContext = new SecurityContext();
        eventRequest.setSecurityContext(originatorContext);
        Message message = new Message();
        message.setMessageName("start");
        message.setSecurityContext(originatorContext);
        eventRequest.setMessage(message);
        boolean bSAXOverride = false;
        try {
            if (System.getProperty("com.sas.services.events.broker.ParseEventsUsingSAX") != null) {
                bSAXOverride = true;
            }
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
        if (bSAXOverride) {
            this.parseSAX(eventRequest);
        } else {
            this.parseDOM(eventRequest);
        }
    }

    private void parseDOM(EventRequest eventRequest) throws ParseException, ChainedException {
        block81: {
            Document doc = this.getDocument(eventRequest.getEvent());
            Message message = eventRequest.getMessage();
            try {
                float nVersion;
                boolean bUnstructured = false;
                Element root = doc.getDocumentElement();
                if (!"Event".equals(root.getLocalName()) || !NS_URI.equals(root.getNamespaceURI())) {
                    bUnstructured = true;
                }
                String eventName = null;
                if (!bUnstructured && (eventName = root.getAttributeNS(NS_URI, "name")).length() == 0) {
                    bUnstructured = true;
                }
                if (eventRequest.isUnstructured()) {
                    DocumentFragment body = doc.createDocumentFragment();
                    body.appendChild(root);
                    message.setBody(body);
                    break block81;
                }
                eventRequest.setEventName(eventName);
                message.setEventName(eventName);
                NodeList nodeList = root.getElementsByTagNameNS(NS_URI, "Header");
                if (nodeList.getLength() == 0) {
                    throw new ParseException(rb.getString("EventManager.parseEventHeaderRequired.ex.txt"));
                }
                if (nodeList.getLength() > 1) {
                    throw new ParseException(rb.getString("EventManager.parseEventMultipleHeader.ex.txt"));
                }
                Element header = (Element)nodeList.item(0);
                if (!"Event".equals(header.getParentNode().getLocalName())) {
                    throw new ParseException(rb.getString("EventManager.parseEventStructure.ex.txt"));
                }
                nodeList = header.getElementsByTagNameNS(NS_URI, "Version");
                if (nodeList.getLength() == 0) {
                    throw new ParseException(rb.getString("EventManager.parseEventVersionRequired.ex.txt"));
                }
                if (nodeList.getLength() > 1) {
                    throw new ParseException(rb.getString("EventManager.parseEventMultipleVersion.ex.txt"));
                }
                Element version = (Element)nodeList.item(0);
                if (!"Header".equals(version.getParentNode().getLocalName())) {
                    throw new ParseException(rb.getString("EventManager.parseEventStructure.ex.txt"));
                }
                nodeList = version.getChildNodes();
                if (nodeList.getLength() != 1) {
                    throw new ParseException(rb.getString("EventManager.parseEventVersionTextExpected.ex.txt"));
                }
                Node node = nodeList.item(0);
                if (node.getNodeType() != 3) {
                    throw new ParseException(rb.getString("EventManager.parseEventVersionTextExpected.ex.txt"));
                }
                try {
                    nVersion = Float.parseFloat(node.getNodeValue());
                }
                catch (NumberFormatException e) {
                    throw new ParseException(rb.getString("EventManager.parseEventInvalidVersion.ex.txt"));
                }
                if ((double)nVersion != 1.0) {
                    throw new ParseException(rb.getString("EventManager.parseEventInvalidVersion.ex.txt"));
                }
                boolean bIdentityProcessed = false;
                boolean bCredentialsProcessed = false;
                boolean bPriorityProcessed = false;
                boolean bSentFromProcessed = false;
                boolean bSentAtProcessed = false;
                boolean bResponseProcessed = false;
                boolean bPropertiesProcessed = false;
                nodeList = header.getChildNodes();
                int len = nodeList.getLength();
                for (int i = 0; i < len; ++i) {
                    NamedNodeMap nodeMap;
                    NodeList propList;
                    node = nodeList.item(i);
                    if (node.getNodeType() != 1) continue;
                    if (!NS_URI.equals(node.getNamespaceURI())) {
                        throw new ParseException(rb.getString("EventManager.parseEventStructure.ex.txt"));
                    }
                    if ("Identity".equals(node.getLocalName())) {
                        if (bIdentityProcessed) {
                            throw new ParseException(rb.getString("EventManager.parseEventMultipleIdentity.ex.txt"));
                        }
                        propList = node.getChildNodes();
                        if (propList.getLength() > 1) {
                            throw new ParseException(rb.getString("EventManager.parseEventStructure.ex.txt"));
                        }
                        if (propList.getLength() == 1) {
                            node = propList.item(0);
                            if (node.getNodeType() != 3) {
                                throw new ParseException(rb.getString("EventManager.parseEventIdentityTextExpected.ex.txt"));
                            }
                            eventRequest.setIdentity(node.getNodeValue());
                        }
                        bIdentityProcessed = true;
                        continue;
                    }
                    if ("Credentials".equals(node.getLocalName())) {
                        String sessionContextLockId;
                        SessionContextInterface sc;
                        String sessionContextId;
                        if (bCredentialsProcessed) {
                            throw new ParseException(rb.getString("EventManager.parseEventMultipleCredentials.ex.txt"));
                        }
                        SecurityContext originatorContext = message.getSecurityContext();
                        nodeMap = node.getAttributes();
                        if ((node = nodeMap.getNamedItemNS(NS_URI, "name")) != null) {
                            originatorContext.setUserName(node.getNodeValue());
                        }
                        if ((node = nodeMap.getNamedItemNS(NS_URI, "password")) != null) {
                            originatorContext.setUserPW(node.getNodeValue());
                        }
                        if ((node = nodeMap.getNamedItemNS(NS_URI, "domain")) != null) {
                            originatorContext.setDomain(node.getNodeValue());
                        }
                        if ((node = nodeMap.getNamedItemNS(NS_URI, "sessionContextId")) != null && (sessionContextId = node.getNodeValue()).length() > 0) {
                            if (this._sessionService == null) {
                                throw new ParseException(rb.getString("EventManager.parseEventNoSessionService.ex.txt"));
                            }
                            sc = null;
                            try {
                                sc = this._sessionService.getSessionContext(sessionContextId);
                            }
                            catch (Throwable t) {
                                throw new ChainedException(t, null);
                            }
                            if (sc == null) {
                                throw new ParseException(rb.getString("EventManager.parseEventInvalidSCId.ex.txt"));
                            }
                            originatorContext.setSessionContext(sc);
                            try {
                                originatorContext.setUserContext(sc.getUserContext());
                            }
                            catch (Throwable t) {
                                throw new ChainedException(t, null);
                            }
                            Map sessionMap = eventRequest.getSessionContextUsage();
                            sessionMap.put(sc, new Integer(0));
                        }
                        if ((node = nodeMap.getNamedItemNS(NS_URI, "sessionContextLockId")) != null && (sessionContextLockId = node.getNodeValue()).length() > 0) {
                            sc = originatorContext.getSessionContext();
                            if (sc == null) {
                                throw new ParseException(rb.getString("EventManager.parseEventInvalidSCId.ex.txt"));
                            }
                            Object lock = null;
                            try {
                                lock = sc.getAttribute(sessionContextLockId);
                            }
                            catch (Throwable t) {
                                throw new ChainedException(t, null);
                            }
                            if (lock == null) {
                                throw new ParseException(rb.getString("EventManager.parseEventInvalidSCLockId.ex.txt"));
                            }
                            originatorContext.setSessionContextLock(lock);
                        }
                        bCredentialsProcessed = true;
                        continue;
                    }
                    if ("Priority".equals(node.getLocalName())) {
                        if (bPriorityProcessed) {
                            throw new ParseException(rb.getString("EventManager.parseEventMultiplePriority.ex.txt"));
                        }
                        propList = node.getChildNodes();
                        if (propList.getLength() > 1) {
                            throw new ParseException(rb.getString("EventManager.parseEventStructure.ex.txt"));
                        }
                        if (propList.getLength() == 1) {
                            int nPriority;
                            node = propList.item(0);
                            if (node.getNodeType() != 3) {
                                throw new ParseException(rb.getString("EventManager.parseEventPriorityTextExpected.ex.txt"));
                            }
                            try {
                                nPriority = Integer.parseInt(node.getNodeValue());
                            }
                            catch (NumberFormatException e) {
                                if (this._logger != null && this._logger.isWarnEnabled()) {
                                    this._logger.warn(rb.getString("EventManager.parseEventInvalidPriority.ex.txt"));
                                }
                                nPriority = 5;
                            }
                            if (nPriority < 1) {
                                nPriority = 1;
                            } else if (nPriority > 10) {
                                nPriority = 10;
                            }
                            eventRequest.setPriority(nPriority);
                        }
                        bPriorityProcessed = true;
                        continue;
                    }
                    if ("SentFrom".equals(node.getLocalName())) {
                        if (bSentFromProcessed) {
                            throw new ParseException("EventManager.parseEventMultipleSentFrom.ex.txt");
                        }
                        propList = node.getChildNodes();
                        if (propList.getLength() > 1) {
                            throw new ParseException(rb.getString("EventManager.parseEventStructure.ex.txt"));
                        }
                        if (propList.getLength() == 1) {
                            node = propList.item(0);
                            if (node.getNodeType() != 3) {
                                throw new ParseException(rb.getString("EventManager.parseEventSentFromTextExpected.ex.txt"));
                            }
                            eventRequest.setSentFrom(node.getNodeValue());
                        }
                        bSentFromProcessed = true;
                        continue;
                    }
                    if ("SentAt".equals(node.getLocalName())) {
                        if (bSentAtProcessed) {
                            throw new ParseException("EventManager.parseEventMultipleSentAt.ex.txt");
                        }
                        propList = node.getChildNodes();
                        if (propList.getLength() > 1) {
                            throw new ParseException(rb.getString("EventManager.parseEventStructure.ex.txt"));
                        }
                        if (propList.getLength() == 1) {
                            node = propList.item(0);
                            if (node.getNodeType() != 3) {
                                throw new ParseException(rb.getString("EventManager.parseEventSentAtTextExpected.ex.txt"));
                            }
                            eventRequest.setSentAt(node.getNodeValue());
                        }
                        bSentAtProcessed = true;
                        continue;
                    }
                    if ("Response".equals(node.getLocalName())) {
                        if (bResponseProcessed) {
                            throw new ParseException("EventManager.parseEventMultipleResponse.ex.txt");
                        }
                        String responseType = "none";
                        nodeMap = node.getAttributes();
                        if ((node = nodeMap.getNamedItemNS(NS_URI, "type")) != null) {
                            responseType = node.getNodeValue();
                        }
                        if (responseType.equalsIgnoreCase("ack")) {
                            eventRequest.setAckRequired();
                        } else if (responseType.equalsIgnoreCase("result")) {
                            eventRequest.setResponseRequired();
                        } else if (!responseType.equalsIgnoreCase("none")) {
                            throw new ParseException(rb.getString("EventManager.parseEventInvalidRespType.ex.txt"));
                        }
                        bResponseProcessed = true;
                        continue;
                    }
                    if ("Properties".equals(node.getLocalName())) {
                        if (bPropertiesProcessed) {
                            throw new ParseException(rb.getString("EventManager.parseEventMultipleProps.ex.txt"));
                        }
                        HashMap<String, String> properties = new HashMap<String, String>();
                        propList = node.getChildNodes();
                        int nProperties = propList.getLength();
                        for (int j = 0; j < nProperties; ++j) {
                            node = propList.item(j);
                            if (node.getNodeType() != 1) continue;
                            String strPropName = "";
                            String strNS = node.getNamespaceURI();
                            if (strNS != null) {
                                strPropName = strNS + ':';
                            }
                            strPropName = strPropName + node.getLocalName();
                            NodeList childList = node.getChildNodes();
                            if (childList.getLength() != 1) {
                                throw new ParseException(MessageFormat.format(rb.getString("EventManager.parsePropValueExpected.ex.fmt.txt"), strPropName));
                            }
                            node = childList.item(0);
                            if (node.getNodeType() != 3) {
                                throw new ParseException(MessageFormat.format(rb.getString("EventManager.parsePropValueExpected.ex.fmt.txt"), strPropName));
                            }
                            String strPropValue = node.getNodeValue();
                            properties.put(strPropName, strPropValue);
                        }
                        if (!properties.isEmpty()) {
                            message.setProperties(properties);
                        }
                        bPropertiesProcessed = true;
                        continue;
                    }
                    if ("Version".equals(node.getLocalName())) continue;
                    throw new ParseException(MessageFormat.format(rb.getString("EventManager.parseEventInvalidHeader.ex.fmt.txt"), node.getLocalName()));
                }
                nodeList = root.getElementsByTagNameNS(NS_URI, "Body");
                if (nodeList.getLength() == 0) {
                    throw new ParseException(rb.getString("EventManager.parseEventBodyRequired.ex.txt"));
                }
                if (nodeList.getLength() > 1) {
                    throw new ParseException(rb.getString("EventManager.parseEventMultipleBody.ex.txt"));
                }
                node = nodeList.item(0);
                if (!"Event".equals(node.getParentNode().getLocalName())) {
                    throw new ParseException(rb.getString("EventManager.parseEventStructure.ex.txt"));
                }
                nodeList = node.getChildNodes();
                len = nodeList.getLength();
                DocumentFragment body = doc.createDocumentFragment();
                Vector<Node> nodes = new Vector<Node>();
                for (int i = 0; i < len; ++i) {
                    node = nodeList.item(i);
                    if (node == null || node.getNodeType() != 1 && node.getNodeType() != 3) continue;
                    nodes.add(node);
                }
                Iterator nodeIter = nodes.iterator();
                while (nodeIter.hasNext()) {
                    body.appendChild((Node)nodeIter.next());
                }
                message.setBody(body);
            }
            catch (DOMException de) {
                throw new ChainedException((Throwable)de, null);
            }
        }
    }

    private void parseSAX(EventRequest eventRequest) throws ParseException, ChainedException {
        myContentHandler contentHandler;
        Message message;
        block63: {
            InputSource is;
            BufferedReader reader;
            SAXParser parser;
            block62: {
                boolean bNamespacePrefixSupport;
                SAXParserFactory factory;
                block61: {
                    message = eventRequest.getMessage();
                    factory = SAXParserFactory.newInstance();
                    factory.setNamespaceAware(true);
                    bNamespacePrefixSupport = true;
                    try {
                        factory.setFeature("http://xml.org/sax/features/namespace-prefixes", true);
                    }
                    catch (SAXNotSupportedException snse) {
                        bNamespacePrefixSupport = false;
                        if (this._logger != null && this._logger.isWarnEnabled()) {
                            this._logger.warn(rb.getString("EventManager.parseEventNamespacePrefixFeatureNotSupported.txt"));
                        }
                    }
                    catch (SAXNotRecognizedException snre) {
                        bNamespacePrefixSupport = false;
                        if (this._logger != null && this._logger.isWarnEnabled()) {
                            this._logger.warn(rb.getString("EventManager.parseEventNamespacePrefixFeatureNotRecognized.txt"));
                        }
                    }
                    catch (ParserConfigurationException pce) {
                        bNamespacePrefixSupport = false;
                        if (this._logger == null || !this._logger.isWarnEnabled()) break block61;
                        this._logger.warn(MessageFormat.format(rb.getString("EventManager.parseEventNamespacePrefixFeatureParserConfigException.fmt.txt"), pce.getMessage()));
                    }
                }
                factory.setValidating(true);
                parser = null;
                try {
                    parser = factory.newSAXParser();
                }
                catch (ParserConfigurationException pce) {
                    throw new ChainedException((Throwable)pce, null);
                }
                catch (SAXException se) {
                    throw new ChainedException((Throwable)se, null);
                }
                reader = new BufferedReader(new StringReader(eventRequest.getEvent()));
                is = new InputSource(reader);
                myContentHandler lh = contentHandler = new myContentHandler(this._logger, bNamespacePrefixSupport);
                try {
                    parser.setProperty("http://xml.org/sax/properties/lexical-handler", lh);
                }
                catch (SAXNotRecognizedException snre) {
                    if (this._logger != null && this._logger.isWarnEnabled()) {
                        this._logger.warn(rb.getString("EventManager.parseEventLexicalPropertyNotRecognized.txt"));
                    }
                }
                catch (SAXNotSupportedException snse) {
                    if (this._logger == null || !this._logger.isWarnEnabled()) break block62;
                    this._logger.warn(rb.getString("EventManager.parseEventLexicalPropertyNotSupported.txt"));
                }
            }
            try {
                parser.parse(is, (DefaultHandler)contentHandler);
            }
            catch (SAXException se) {
                if (contentHandler.isContentUnstructured()) {
                    eventRequest.setUnstructured();
                    message.setBody(eventRequest.getEvent());
                    break block63;
                }
                Exception e = se.getException();
                if (e instanceof ParseException) {
                    ParseException pe = (ParseException)((Object)e);
                    throw pe;
                }
                throw new ChainedException((Throwable)se, null);
            }
            catch (IOException ioe) {
                throw new ChainedException((Throwable)ioe, null);
            }
            finally {
                try {
                    ((Reader)reader).close();
                }
                catch (IOException se) {}
            }
        }
        if (!eventRequest.isUnstructured()) {
            String responseType;
            String sentAt;
            int priority;
            String sessionContextLockId;
            String sessionContextId;
            String domain;
            String pass;
            String eventName = contentHandler.getEventName();
            eventRequest.setEventName(eventName);
            message.setEventName(eventName);
            if (!contentHandler.isHeaderAvailable()) {
                throw new ParseException(rb.getString("EventManager.parseEventHeaderRequired.ex.txt"));
            }
            if (!contentHandler.isVersionAvailable()) {
                throw new ParseException(rb.getString("EventManager.parseEventVersionRequired.ex.txt"));
            }
            float version = contentHandler.getVersion();
            if ((double)version != 1.0) {
                throw new ParseException(rb.getString("EventManager.parseEventInvalidVersion.ex.txt"));
            }
            String identity = contentHandler.getIdentity();
            if (identity != null) {
                eventRequest.setIdentity(identity);
            }
            SecurityContext originatorContext = message.getSecurityContext();
            String userId = contentHandler.getUserId();
            if (userId != null) {
                originatorContext.setUserName(userId);
            }
            if ((pass = contentHandler.getPassword()) != null) {
                originatorContext.setUserPW(pass);
            }
            if ((domain = contentHandler.getDomain()) != null) {
                originatorContext.setDomain(domain);
            }
            if ((sessionContextId = contentHandler.getSessionContextId()) != null && sessionContextId.length() > 0) {
                if (this._sessionService == null) {
                    throw new ParseException(rb.getString("EventManager.parseEventNoSessionService.ex.txt"));
                }
                SessionContextInterface sc = null;
                try {
                    sc = this._sessionService.getSessionContext(sessionContextId);
                }
                catch (Throwable t) {
                    throw new ChainedException(t, null);
                }
                if (sc == null) {
                    throw new ParseException(rb.getString("EventManager.parseEventInvalidSCId.ex.txt"));
                }
                originatorContext.setSessionContext(sc);
                try {
                    originatorContext.setUserContext(sc.getUserContext());
                }
                catch (Throwable t) {
                    throw new ChainedException(t, null);
                }
                Map sessionMap = eventRequest.getSessionContextUsage();
                sessionMap.put(sc, new Integer(0));
            }
            if ((sessionContextLockId = contentHandler.getSessionContextLockId()) != null && sessionContextLockId.length() > 0) {
                SessionContextInterface sc = originatorContext.getSessionContext();
                if (sc == null) {
                    throw new ParseException(rb.getString("EventManager.parseEventInvalidSCId.ex.txt"));
                }
                Object lock = null;
                try {
                    lock = sc.getAttribute(sessionContextLockId);
                }
                catch (Throwable t) {
                    throw new ChainedException(t, null);
                }
                if (lock == null) {
                    throw new ParseException(rb.getString("EventManager.parseEventInvalidSCLockId.ex.txt"));
                }
                originatorContext.setSessionContextLock(lock);
            }
            if ((priority = contentHandler.getPriority()) < 1) {
                priority = 1;
            } else if (priority > 10) {
                priority = 10;
            }
            eventRequest.setPriority(priority);
            String sentFrom = contentHandler.getSentFrom();
            if (sentFrom != null) {
                eventRequest.setSentFrom(sentFrom);
            }
            if ((sentAt = contentHandler.getSentAt()) != null) {
                eventRequest.setSentAt(sentAt);
            }
            if ((responseType = contentHandler.getResponseType()) == null) {
                responseType = "none";
            }
            if (responseType.equalsIgnoreCase("ack")) {
                eventRequest.setAckRequired();
            } else if (responseType.equalsIgnoreCase("result")) {
                eventRequest.setResponseRequired();
            } else if (!responseType.equalsIgnoreCase("none")) {
                throw new ParseException(rb.getString("EventManager.parseEventInvalidRespType.ex.txt"));
            }
            Map properties = contentHandler.getProperties();
            if (!properties.isEmpty()) {
                message.setProperties(properties);
            }
            if (!contentHandler.isBodyAvailable()) {
                throw new ParseException(rb.getString("EventManager.parseEventBodyRequired.ex.txt"));
            }
            message.setBody(contentHandler.getBody());
        }
    }

    private Document getDocument(String event) throws ChainedException {
        Document doc = null;
        try {
            doc = XMLUtil.convertStringToDocument((String)event);
        }
        catch (Throwable t) {
            throw new ChainedException(t, null);
        }
        return doc;
    }

    private void sendErrorResponse(int errorCode, String errorMessage, EventRequest eventRequest) {
        block5: {
            if (this._applicationMonitorLogger != null && this._applicationMonitorLogger.isLoggingEnabled()) {
                this._applicationMonitorLogger.log(ApplicationMonitorResources.COLUMN_ACTION, ApplicationMonitorResources.ACTION_EVENT_PROCESSING_ERROR, ApplicationMonitorResources.COLUMN_EVENT_NAME, eventRequest.getEventName(), ApplicationMonitorResources.COLUMN_HANDLER_NAME, "", ApplicationMonitorResources.COLUMN_INFORMATION, errorMessage);
            }
            if (eventRequest.isAckRequired() || eventRequest.isReplyRequired() || eventRequest.isResponseRequired()) {
                if (this._logger != null && this._logger.isDebugEnabled()) {
                    this._logger.debug(rb.getString("EventManager.sendNegativeResponse.txt"));
                }
                StringBuffer response = new StringBuffer();
                response.append("<?xml version=\"1.0\" encoding=\"UTF-8\" ?>");
                response.append("<sas-event:SASEventBrokerResponse");
                response.append(" xmlns:sas-event=\"http://www.sas.com/xml/namespace/services.events-1.1\"");
                SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss'Z'");
                TimeZone utc = TimeZone.getTimeZone("UTC");
                formatter.setTimeZone(utc);
                String time = formatter.format(new Date());
                response.append(" sas-event:type=\"error\"");
                response.append(" sas-event:generatedAt=\"" + time + '\"');
                response.append(" sas-event:errorCode=\"" + errorCode + '\"');
                response.append(" sas-event:errorMessage=\"" + XMLUtil.normalize((String)errorMessage) + '\"');
                response.append("/>");
                ResponseAgent responseAgent = eventRequest.getResponseAgent();
                try {
                    responseAgent.init();
                    responseAgent.sendResponse(response.toString());
                    responseAgent.term();
                }
                catch (ResponseException re) {
                    if (this._logger == null) break block5;
                    this._logger.error(MessageFormat.format(rb.getString("EventManager.responseException.fmt.txt"), re.getMessage()));
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void cleanup(EventRequest eventRequest) {
        Map sessionMap;
        Map map = sessionMap = eventRequest.getSessionContextUsage();
        synchronized (map) {
            Iterator iter = sessionMap.entrySet().iterator();
            Map.Entry mapEntry = null;
            while (iter.hasNext()) {
                SessionContextInterface sc;
                block7: {
                    Integer usageCount;
                    int i;
                    mapEntry = iter.next();
                    sc = (SessionContextInterface)mapEntry.getKey();
                    Object o = mapEntry.getValue();
                    if (!(o instanceof Integer) || (i = (usageCount = (Integer)o).intValue()) != 0) continue;
                    try {
                        Object sendersLock;
                        SessionContextInterface sendersSessionContext = eventRequest.getSecurityContext().getSessionContext();
                        if (sc == sendersSessionContext && (sendersLock = eventRequest.getSecurityContext().getSessionContextLock()) != null) {
                            sc.unlock(sendersLock);
                        }
                        sc.destroy();
                    }
                    catch (Throwable t) {
                        if (this._logger == null) break block7;
                        this._logger.warn(MessageFormat.format(rb.getString("EventManager.destroySCException.fmt.txt"), t.getClass().getName() + ": " + t.getMessage()));
                    }
                }
                sessionMap.remove(sc);
            }
        }
    }

    @SASScope
    class myContentHandler
    extends DefaultHandler
    implements LexicalHandler {
        private Logger _logger;
        private boolean _bNamespacePrefixSupport;
        private List _curElementName = new LinkedList();
        private List _curElementNS = new LinkedList();
        private boolean _bUnstructured = false;
        private boolean _bFirstElement = true;
        private static final int STATE_PARSE_HEADERS = 1;
        private static final int STATE_PARSE_BODY = 2;
        private static final int STATE_PARSE_PROPERTIES = 4;
        private int _state = 0;
        private String _eventName;
        private float _version;
        private String _identity;
        private String _userId;
        private String _password;
        private String _domain;
        private String _sessionContextId;
        private String _sessionContextLockId;
        private int _priority = 5;
        private String _sentFrom;
        private String _sentAt;
        private String _responseType;
        private Map _properties = new HashMap();
        private StringBuffer _body = new StringBuffer();
        private boolean _processedHeader = false;
        private boolean _processedVersion = false;
        private boolean _processedIdentity = false;
        private boolean _processedCredentials = false;
        private boolean _processedPriority = false;
        private boolean _processedSentFrom = false;
        private boolean _processedSentAt = false;
        private boolean _processedResponseType = false;
        private boolean _processedProperties = false;
        private boolean _processedBody = false;
        private boolean _processingCDATASection = false;

        public myContentHandler(Logger logger, boolean bNamespacePrefixSupport) {
            this._logger = logger;
            this._bNamespacePrefixSupport = bNamespacePrefixSupport;
        }

        public final boolean isContentUnstructured() {
            return this._bUnstructured;
        }

        public final boolean isHeaderAvailable() {
            return this._processedHeader;
        }

        public final boolean isVersionAvailable() {
            return this._processedVersion;
        }

        public final boolean isBodyAvailable() {
            return this._processedBody;
        }

        public final String getEventName() {
            return this._eventName;
        }

        public final float getVersion() {
            return this._version;
        }

        public final String getIdentity() {
            return this._identity;
        }

        public final String getUserId() {
            return this._userId;
        }

        public final String getPassword() {
            return this._password;
        }

        public final String getDomain() {
            return this._domain;
        }

        public final String getSessionContextId() {
            return this._sessionContextId;
        }

        public final String getSessionContextLockId() {
            return this._sessionContextLockId;
        }

        public final int getPriority() {
            return this._priority;
        }

        public final String getSentFrom() {
            return this._sentFrom;
        }

        public final String getSentAt() {
            return this._sentAt;
        }

        public final String getResponseType() {
            return this._responseType;
        }

        public final Map getProperties() {
            return this._properties;
        }

        public final String getBody() {
            return this._body.toString();
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public void startElement(String uri, String local, String qName, Attributes attrs) throws SAXException {
            this._curElementName.add(0, local);
            this._curElementNS.add(0, uri);
            if (this._bFirstElement) {
                if (!"Event".equals(local) || !EventManager.NS_URI.equals(uri)) {
                    this._bUnstructured = true;
                    throw new SAXException("");
                }
                this._eventName = attrs.getValue(EventManager.NS_URI, "name");
                if (this._eventName == null || this._eventName.length() == 0) {
                    this._bUnstructured = true;
                    throw new SAXException("");
                }
                this._bFirstElement = false;
                return;
            }
            if ((this._state & 4) != 0) return;
            if ((this._state & 2) != 0) {
                String elementName = null;
                elementName = this._bNamespacePrefixSupport ? qName : (uri == null ? qName : local);
                this._body.append('<' + elementName);
                int len = attrs.getLength();
                for (int i = 0; i < len; ++i) {
                    String attrName = null;
                    attrName = this._bNamespacePrefixSupport ? attrs.getQName(i) : (attrs.getURI(i) == null ? attrs.getQName(i) : attrs.getLocalName(i));
                    String attrValue = attrs.getValue(i);
                    this._body.append(' ' + attrName + "=\"" + attrValue + '\"');
                }
                this._body.append(">");
                return;
            } else {
                if (!EventManager.NS_URI.equals(uri)) throw new SAXException((Exception)new ParseException(rb.getString("EventManager.parseEventStructure.ex.txt")));
                String parentElementName = null;
                String parentElementNS = null;
                if (this._curElementName.size() > 1) {
                    parentElementName = (String)this._curElementName.get(1);
                }
                if (this._curElementNS.size() > 1) {
                    parentElementNS = (String)this._curElementNS.get(1);
                }
                if ("Header".equals(local)) {
                    if (this._processedHeader) {
                        throw new SAXException((Exception)new ParseException(rb.getString("EventManager.parseEventMultipleHeader.ex.txt")));
                    }
                    if (!"Event".equals(parentElementName) || !EventManager.NS_URI.equals(parentElementNS)) {
                        throw new SAXException((Exception)new ParseException(rb.getString("EventManager.parseEventStructure.ex.txt")));
                    }
                    this._processedHeader = true;
                    ++this._state;
                    return;
                } else if ("Version".equals(local)) {
                    if (this._processedVersion) {
                        throw new SAXException((Exception)new ParseException(rb.getString("EventManager.parseEventMultipleVersion.ex.txt")));
                    }
                    if (!"Header".equals(parentElementName) || !EventManager.NS_URI.equals(parentElementNS)) {
                        throw new SAXException((Exception)new ParseException(rb.getString("EventManager.parseEventStructure.ex.txt")));
                    }
                    this._processedVersion = true;
                    return;
                } else if ("Identity".equals(local)) {
                    if (this._processedIdentity) {
                        throw new SAXException((Exception)new ParseException(rb.getString("EventManager.parseEventMultipleIdentity.ex.txt")));
                    }
                    if (!"Header".equals(parentElementName) || !EventManager.NS_URI.equals(parentElementNS)) {
                        throw new SAXException((Exception)new ParseException(rb.getString("EventManager.parseEventStructure.ex.txt")));
                    }
                    this._processedIdentity = true;
                    return;
                } else if ("Credentials".equals(local)) {
                    if (this._processedCredentials) {
                        throw new SAXException((Exception)new ParseException(rb.getString("EventManager.parseEventMultipleCredentials.ex.txt")));
                    }
                    if (!"Header".equals(parentElementName) || !EventManager.NS_URI.equals(parentElementNS)) {
                        throw new SAXException((Exception)new ParseException(rb.getString("EventManager.parseEventStructure.ex.txt")));
                    }
                    this._userId = attrs.getValue(EventManager.NS_URI, "name");
                    this._password = attrs.getValue(EventManager.NS_URI, "password");
                    this._domain = attrs.getValue(EventManager.NS_URI, "domain");
                    this._sessionContextId = attrs.getValue(EventManager.NS_URI, "sessionContextId");
                    this._sessionContextLockId = attrs.getValue(EventManager.NS_URI, "sessionContextLockId");
                    this._processedCredentials = true;
                    return;
                } else if ("Priority".equals(local)) {
                    if (this._processedPriority) {
                        throw new SAXException((Exception)new ParseException(rb.getString("EventManager.parseEventMultiplePriority.ex.txt")));
                    }
                    if (!"Header".equals(parentElementName) || !EventManager.NS_URI.equals(parentElementNS)) {
                        throw new SAXException((Exception)new ParseException(rb.getString("EventManager.parseEventStructure.ex.txt")));
                    }
                    this._processedPriority = true;
                    return;
                } else if ("SentFrom".equals(local)) {
                    if (this._processedSentFrom) {
                        throw new SAXException((Exception)new ParseException(rb.getString("EventManager.parseEventMultipleSentFrom.ex.txt")));
                    }
                    if (!"Header".equals(parentElementName) || !EventManager.NS_URI.equals(parentElementNS)) {
                        throw new SAXException((Exception)new ParseException(rb.getString("EventManager.parseEventStructure.ex.txt")));
                    }
                    this._processedSentFrom = true;
                    return;
                } else if ("SentAt".equals(local)) {
                    if (this._processedSentAt) {
                        throw new SAXException((Exception)new ParseException(rb.getString("EventManager.parseEventMultipleSentAt.ex.txt")));
                    }
                    if (!"Header".equals(parentElementName) || !EventManager.NS_URI.equals(parentElementNS)) {
                        throw new SAXException((Exception)new ParseException(rb.getString("EventManager.parseEventStructure.ex.txt")));
                    }
                    this._processedSentAt = true;
                    return;
                } else if ("Response".equals(local)) {
                    if (this._processedResponseType) {
                        throw new SAXException((Exception)new ParseException(rb.getString("EventManager.parseEventMultipleResponse.ex.txt")));
                    }
                    if (!"Header".equals(parentElementName) || !EventManager.NS_URI.equals(parentElementNS)) {
                        throw new SAXException((Exception)new ParseException(rb.getString("EventManager.parseEventStructure.ex.txt")));
                    }
                    this._responseType = attrs.getValue(EventManager.NS_URI, "type");
                    this._processedResponseType = true;
                    return;
                } else if ("Properties".equals(local)) {
                    if (this._processedProperties) {
                        throw new SAXException((Exception)new ParseException(rb.getString("EventManager.parseEventMultipleProps.ex.txt")));
                    }
                    if (!"Header".equals(parentElementName) || !EventManager.NS_URI.equals(parentElementNS)) {
                        throw new SAXException((Exception)new ParseException(rb.getString("EventManager.parseEventStructure.ex.txt")));
                    }
                    this._processedProperties = true;
                    this._state += 4;
                    return;
                } else if ("Body".equals(local)) {
                    if (this._processedBody) {
                        throw new SAXException((Exception)new ParseException(rb.getString("EventManager.parseEventMultipleBody.ex.txt")));
                    }
                    if (!"Event".equals(parentElementName) || !EventManager.NS_URI.equals(parentElementNS)) {
                        throw new SAXException((Exception)new ParseException(rb.getString("EventManager.parseEventStructure.ex.txt")));
                    }
                    this._state += 2;
                    this._processedBody = true;
                    return;
                } else {
                    if ((this._state &= 1) == 0) throw new SAXException((Exception)new ParseException(rb.getString("EventManager.parseEventStructure.ex.txt")));
                    throw new SAXException((Exception)new ParseException(MessageFormat.format(rb.getString("EventManager.parseEventInvalidHeader.ex.fmt.txt"), local)));
                }
            }
        }

        @Override
        public void endElement(String uri, String local, String qName) throws SAXException {
            this._curElementName.remove(0);
            this._curElementNS.remove(0);
            if ("Header".equals(local) && EventManager.NS_URI.equals(uri)) {
                this._state &= 0xFFFFFFFE;
            } else if ("Properties".equals(local) && EventManager.NS_URI.equals(uri)) {
                this._state &= 0xFFFFFFFB;
            } else if ("Body".equals(local) && EventManager.NS_URI.equals(uri)) {
                this._state &= 0xFFFFFFFD;
            } else if ((this._state & 2) != 0) {
                String elementName = null;
                elementName = this._bNamespacePrefixSupport ? qName : (uri == null ? qName : local);
                this._body.append("</" + elementName + '>');
            }
        }

        @Override
        public void characters(char[] text, int start, int length) throws SAXException {
            String value = new String(text, start, length);
            String elementName = null;
            String elementNS = null;
            if (this._curElementName.size() > 0) {
                elementName = (String)this._curElementName.get(0);
            }
            if (this._curElementNS.size() > 0) {
                elementNS = (String)this._curElementNS.get(0);
            }
            if ((this._state & 4) != 0) {
                if ("Properties".equals(elementName) && EventManager.NS_URI.equals(elementNS)) {
                    return;
                }
                String name = "";
                if (elementNS != null && elementNS.length() > 0) {
                    name = elementNS + ':';
                }
                name = name + elementName;
                this._properties.put(name, value);
            } else if ((this._state & 2) != 0) {
                this._body.append(value);
            } else if ("Version".equals(elementName) && EventManager.NS_URI.equals(elementNS)) {
                try {
                    this._version = Float.parseFloat(value);
                }
                catch (NumberFormatException e) {
                    throw new SAXException((Exception)new ParseException(rb.getString("EventManager.parseEventInvalidVersion.ex.txt")));
                }
            } else if ("Identity".equals(elementName) && EventManager.NS_URI.equals(elementNS)) {
                this._identity = value;
            } else if ("Priority".equals(elementName) && EventManager.NS_URI.equals(elementNS)) {
                try {
                    this._priority = Integer.parseInt(value);
                }
                catch (NumberFormatException e) {
                    if (this._logger != null && this._logger.isWarnEnabled()) {
                        this._logger.warn(rb.getString("EventManager.parseEventInvalidPriority.ex.txt"));
                    }
                    this._priority = 5;
                }
            } else if ("SentFrom".equals(elementName) && EventManager.NS_URI.equals(elementNS)) {
                this._sentFrom = value;
            } else if ("SentAt".equals(elementName) && EventManager.NS_URI.equals(elementNS)) {
                this._sentAt = value;
            }
        }

        @Override
        public void startCDATA() throws SAXException {
            if ((this._state & 2) != 0) {
                this._processingCDATASection = true;
                this._body.append("<![CDATA[");
            }
        }

        @Override
        public void endCDATA() throws SAXException {
            if (this._processingCDATASection) {
                this._body.append("]]>");
                this._processingCDATASection = false;
            }
        }

        @Override
        public void startDTD(String name, String publicId, String systemId) throws SAXException {
        }

        @Override
        public void endDTD() throws SAXException {
        }

        @Override
        public void startEntity(String name) throws SAXException {
        }

        @Override
        public void endEntity(String name) throws SAXException {
        }

        @Override
        public void comment(char[] ch, int start, int length) throws SAXException {
        }
    }
}

