/*
 * Decompiled with CFR 0.152.
 */
package com.sas.services.events.broker;

import com.sas.codepolicy.SASScope;
import com.sas.metadata.remote.Property;
import com.sas.metadata.remote.ServiceComponent;
import com.sas.services.AbstractServiceComponentConfig;
import com.sas.services.ServiceAggregateConfig;
import com.sas.services.ServiceComponentConfigInterface;
import com.sas.services.ServiceException;
import com.sas.services.ServiceProfile;
import com.sas.services.deployment.ServiceDeployment;
import com.sas.services.events.broker.EventBrokerService;
import com.sas.services.events.broker.EventBrokerServiceComponentConfig;
import com.sas.services.events.broker.EventBrokerServiceInterface;
import com.sas.services.events.broker.RB;
import com.sas.services.information.InformationServiceInterface;
import com.sas.services.security.AuthenticationServiceInterface;
import com.sas.services.session.SessionServiceInterface;
import com.sas.services.user.UserServiceInterface;
import com.sas.services.util.XMLUtil;
import com.sas.text.Message;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import java.util.ResourceBundle;
import org.w3c.dom.Document;

@SASScope
final class EventBrokerServiceProfile
extends ServiceProfile {
    private static final String USER_INTERFACE_CLASSNAME = "com.sas.console.plugins.services.events.broker.ServiceInitializationDataView";

    EventBrokerServiceProfile() {
        super((ServiceComponentConfigInterface)new EventBrokerServiceComponentConfig(), 3, new String[]{AuthenticationServiceInterface.class.getName(), InformationServiceInterface.class.getName(), UserServiceInterface.class.getName(), SessionServiceInterface.class.getName()}, EventBrokerServiceInterface.class.getName(), EventBrokerService.class.getName(), USER_INTERFACE_CLASSNAME, false);
    }

    public AbstractServiceComponentConfig createServiceComponentConfig(String configName, Document document) throws ServiceException {
        EventBrokerServiceComponentConfig config = new EventBrokerServiceComponentConfig();
        config.setConfigName(configName);
        return config;
    }

    public void exportServiceConfig(File file, ServiceAggregateConfig serviceAggregateConfig, boolean isExportingBaseConfig, List appConfigNames) throws ServiceException {
        EventBrokerServiceComponentConfig eventBrokerConfig = new EventBrokerServiceComponentConfig();
        eventBrokerConfig.writeServiceConfigToFile(file, serviceAggregateConfig.getServiceComponent());
    }

    public void mergeServiceConfig(File file, ServiceDeployment serviceDeployment, ServiceComponent serviceComponent, Property applicationConfigProperty) throws ServiceException {
        EventBrokerServiceComponentConfig eventBrokerConfig = new EventBrokerServiceComponentConfig();
        String serviceComponentName = null;
        FileInputStream fis = null;
        try {
            serviceComponentName = serviceComponent.getName();
            fis = new FileInputStream(file);
            eventBrokerConfig.mergeConfig(serviceComponent, XMLUtil.convertStreamToDocument((InputStream)fis));
        }
        catch (IOException e) {
            throw new ServiceException((Throwable)e, Message.format((ResourceBundle)RB.getResources(), (String)"EBSP.mergeConfig.ex.fmt.txt", (Object)file.getAbsolutePath(), (Object)serviceComponentName));
        }
        finally {
            if (fis != null) {
                try {
                    fis.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    protected String getDefaultFilename() {
        return RB.getStringResource("EBSP.serviceConfigFilename.txt");
    }

    public String getServiceDisplayName() {
        return RB.getStringResource("EBSP.serviceName.txt");
    }

    public String getServiceDisplayDescription() {
        return RB.getStringResource("EBSP.serviceDesc.txt");
    }
}

