/*
 * Decompiled with CFR 0.152.
 */
package com.sas.services.events.broker;

import com.sas.codepolicy.SASScope;
import com.sas.services.ServiceException;
import com.sas.services.events.broker.EventBrokerService;
import com.sas.services.events.broker.RB;
import com.sas.services.events.broker.flowengine.ListenerDispatch;
import com.sas.services.events.broker.flowengine.RuntimeFlow;
import com.sas.services.events.broker.util.ActiveTaskElement;
import com.sas.services.events.broker.util.EventContainer;
import com.sas.services.events.broker.util.MutexStateException;
import com.sas.services.events.broker.util.TaskRunnable;
import com.sas.services.events.broker.util.ThreadPool;
import com.sas.services.util.AbstractMBean;
import com.sas.text.Message;
import java.rmi.RemoteException;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import javax.management.MBeanParameterInfo;

@SASScope
public class EventBrokerServiceMBean
extends AbstractMBean {
    private static final String MBEAN_DESCRIPTION = RB.getStringResource("EventBrokerServiceMBean.mBeanDesc.txt");
    private static final String GETDESCRIPTION_METHOD_DESCRIPTION = RB.getStringResource("EventBrokerServiceMBean.getDescriptionOperationDesc.txt");
    private static final String GETDESCRIPTION_METHOD_NAME = "getDescription";
    private static final String GETHOST_METHOD_DESCRIPTION = RB.getStringResource("EventBrokerServiceMBean.getHostOperationDesc.txt");
    private static final String GETHOST_METHOD_NAME = "getHost";
    private static final String UPDATE_METHOD_DESCRIPTION = RB.getStringResource("EventBrokerServiceMBean.updateOperationDesc.txt");
    private static final String UPDATE_METHOD_NAME = "reconfigure";
    private static final String CANPROCESS_METHOD_DESCRIPTION = RB.getStringResource("EventBrokerServiceMBean.canProcessOperationDesc.txt");
    private static final String CANPROCESS_METHOD_NAME = "canProcess";
    private static final String EVENTNAME_PARM_NAME = RB.getStringResource("EventBrokerServiceMBean.canProcessEventName.txt");
    private static final String EVENTNAME_PARM_DESCRIPTION = RB.getStringResource("EventBrokerServiceMBean.canProcessEventNameDesc.txt");
    private static final String EVENTTYPE_PARM_NAME = RB.getStringResource("EventBrokerServiceMBean.canProcessEventType.txt");
    private static final String EVENTTYPE_PARM_DESCRIPTION = RB.getStringResource("EventBrokerServiceMBean.canProcessEventTypeDesc.txt");
    private static final String DISPLAYTHREADS_METHOD_DESCRIPTION = RB.getStringResource("EventBrokerServiceMBean.displayThreadsOperationDesc.txt");
    private static final String DISPLAYTHREADS_METHOD_NAME = "displayThreads";
    private static final String KILLTHREAD_METHOD_DESCRIPTION = RB.getStringResource("EventBrokerServiceMBean.killThreadOperationDesc.txt");
    private static final String KILLTHREAD_METHOD_NAME = "killThread";
    private static final String THREADNAME_PARM_NAME = RB.getStringResource("EventBrokerServiceMBean.killThreadName.txt");
    private static final String THREADNAME_PARM_DESCRIPTION = RB.getStringResource("EventBrokerServiceMBean.killThreadNameDesc.txt");
    private static final String SHUTDOWN_METHOD_DESCRIPTION = RB.getStringResource("EventBrokerServiceMBean.shutdownDesc.txt");
    private static final String SHUTDOWN_METHOD_NAME = "shutdown";
    private static final String QUIESCE_METHOD_DESCRIPTION = RB.getStringResource("EventBrokerServiceMBean.quiesceDesc.txt");
    private static final String QUIESCE_METHOD_NAME = "quiesce";
    private static final String VOID_TYPE_NAME = "void";
    private static final String STRING_TYPE_NAME = String.class.getName();
    private static final String BOOLEAN_TYPE_NAME = Boolean.TYPE.getName();
    private static final String INT_TYPE_NAME = Integer.class.getName();
    private EventBrokerService _targetService;

    public EventBrokerServiceMBean(EventBrokerService targetService) {
        super(MBEAN_DESCRIPTION);
        if (targetService == null) {
            throw new IllegalArgumentException();
        }
        this._targetService = targetService;
        this.addMBeanOperation(SHUTDOWN_METHOD_NAME, SHUTDOWN_METHOD_DESCRIPTION, null, VOID_TYPE_NAME, 1);
        this.addMBeanOperation(QUIESCE_METHOD_NAME, QUIESCE_METHOD_DESCRIPTION, null, VOID_TYPE_NAME, 1);
        this.addMBeanOperation(KILLTHREAD_METHOD_NAME, KILLTHREAD_METHOD_DESCRIPTION, new MBeanParameterInfo[]{new MBeanParameterInfo(THREADNAME_PARM_NAME, STRING_TYPE_NAME, THREADNAME_PARM_DESCRIPTION)}, VOID_TYPE_NAME, 1);
        this.addMBeanOperation(DISPLAYTHREADS_METHOD_NAME, DISPLAYTHREADS_METHOD_DESCRIPTION, null, STRING_TYPE_NAME, 0);
        this.addMBeanOperation(CANPROCESS_METHOD_NAME, CANPROCESS_METHOD_DESCRIPTION, new MBeanParameterInfo[]{new MBeanParameterInfo(EVENTNAME_PARM_NAME, STRING_TYPE_NAME, EVENTNAME_PARM_DESCRIPTION), new MBeanParameterInfo(EVENTTYPE_PARM_NAME, INT_TYPE_NAME, EVENTTYPE_PARM_DESCRIPTION)}, BOOLEAN_TYPE_NAME, 0);
        this.addMBeanOperation(UPDATE_METHOD_NAME, UPDATE_METHOD_DESCRIPTION, null, VOID_TYPE_NAME, 1);
        this.addMBeanOperation(GETHOST_METHOD_NAME, GETHOST_METHOD_DESCRIPTION, null, STRING_TYPE_NAME, 0);
        this.addMBeanOperation(GETDESCRIPTION_METHOD_NAME, GETDESCRIPTION_METHOD_DESCRIPTION, null, STRING_TYPE_NAME, 0);
    }

    protected Object getTargetObject() {
        return this;
    }

    public String getDescription() throws RemoteException {
        return this._targetService.getDescription();
    }

    public String getHost() throws RemoteException {
        return this._targetService.getHost();
    }

    public void reconfigure() throws ServiceException, RemoteException {
        this._targetService.reconfigure();
    }

    public boolean canProcess(String eventName, Integer eventType) throws RemoteException {
        if (eventName == null || eventType == null) {
            throw new IllegalArgumentException();
        }
        boolean bCanProcess = this._targetService.canProcess(eventName, eventType);
        return bCanProcess;
    }

    public String displayThreads() {
        ActiveThreadDescription atd;
        StringBuffer activeThreads = new StringBuffer();
        HashSet<ActiveThreadDescription> activeProcessThreads = new HashSet<ActiveThreadDescription>();
        HashSet<ActiveThreadDescription> activeListenerThreads = new HashSet<ActiveThreadDescription>();
        ThreadPool threadPool = this._targetService.getThreadPool();
        if (threadPool != null) {
            Set activeTasks = threadPool.getActiveTasks();
            for (ActiveTaskElement ate : activeTasks) {
                ActiveThreadDescription atd2;
                Thread t = ate.getThread();
                TaskRunnable task = ate.getTask();
                if (task instanceof RuntimeFlow) {
                    RuntimeFlow runtimeFlow = (RuntimeFlow)task;
                    atd2 = new ActiveThreadDescription(t.getName(), "ProcessFlow", runtimeFlow.getFlowName(), runtimeFlow.getStartTime(), runtimeFlow.getEventName());
                    activeProcessThreads.add(atd2);
                    continue;
                }
                if (!(task instanceof ListenerDispatch)) continue;
                ListenerDispatch listener = (ListenerDispatch)task;
                atd2 = new ActiveThreadDescription(t.getName(), "DynamicListener", listener.getListenerName(), listener.getStartTime(), listener.getEventName());
                activeListenerThreads.add(atd2);
            }
        }
        Iterator iter = activeProcessThreads.iterator();
        while (iter.hasNext()) {
            if (activeThreads.length() > 0) {
                activeThreads.append(",\r\n");
            }
            atd = (ActiveThreadDescription)iter.next();
            activeThreads.append(atd.toString());
        }
        iter = activeListenerThreads.iterator();
        while (iter.hasNext()) {
            if (activeThreads.length() > 0) {
                activeThreads.append(",\r\n");
            }
            atd = (ActiveThreadDescription)iter.next();
            activeThreads.append(atd.toString());
        }
        return activeThreads.toString();
    }

    public void killThread(String threadName) {
        if (threadName == null) {
            throw new IllegalArgumentException();
        }
        ThreadPool threadPool = this._targetService.getThreadPool();
        if (threadPool != null) {
            for (ActiveTaskElement ate : threadPool.getActiveTasks()) {
                Thread t = ate.getThread();
                if (!threadName.equals("*") && !threadName.equals(t.getName())) continue;
                t.interrupt();
                if (threadName.equals("*")) continue;
                break;
            }
        }
    }

    public void quiesce() throws ServiceException, RemoteException {
        EventContainer eventContainer = this._targetService.getEventContainer();
        try {
            eventContainer._mutex.lock();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        eventContainer._stop = true;
        try {
            eventContainer._mutex.unlock();
        }
        catch (MutexStateException mutexStateException) {
            // empty catch block
        }
        this._targetService.destroy();
    }

    public void shutdown() throws ServiceException, RemoteException {
        EventContainer eventContainer = this._targetService.getEventContainer();
        try {
            eventContainer._mutex.lock();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        eventContainer._stop = true;
        eventContainer._drain = true;
        try {
            eventContainer._mutex.unlock();
        }
        catch (MutexStateException mutexStateException) {
            // empty catch block
        }
        this._targetService.destroy();
    }

    @SASScope
    class ActiveThreadDescription {
        String _threadName;
        String _threadType;
        String _entityName;
        String _startTime;
        String _eventName;

        public ActiveThreadDescription(String threadName, String threadType, String entityName, String startTime, String eventName) {
            this._threadName = threadName;
            this._threadType = threadType;
            this._entityName = entityName;
            this._startTime = startTime;
            this._eventName = eventName;
        }

        public String toString() {
            return Message.format((String)RB.getStringResource("EventBrokerServiceMBean.displayThreadsOperation.fmt.txt"), (Object)this._threadName, (Object)this._threadType, (Object)this._entityName, (Object)this._startTime, (Object)this._eventName);
        }
    }
}

