/*
 * Decompiled with CFR 0.152.
 */
package com.sas.services.events.broker;

import com.sas.codepolicy.BinaryCompatibilityOnly;
import com.sas.codepolicy.SASScope;
import com.sas.services.AbstractServiceFactory;
import com.sas.services.RemoteServiceInterface;
import com.sas.services.ServiceConfigurationInterface;
import com.sas.services.ServiceException;
import com.sas.services.ServiceProfile;
import com.sas.services.discovery.DiscoveryServiceInterface;
import com.sas.services.events.broker.EventBrokerService;
import com.sas.services.events.broker.EventBrokerServiceInterface;
import com.sas.services.events.broker.EventBrokerServiceProfile;
import com.sas.services.events.broker.RB;
import java.rmi.RemoteException;
import org.apache.logging.log4j.LogManager;

@SASScope(value="ALL")
@BinaryCompatibilityOnly
public class EventBrokerServiceFactory
extends AbstractServiceFactory {
    public EventBrokerServiceFactory() {
        super((ServiceProfile)new EventBrokerServiceProfile());
    }

    public final RemoteServiceInterface getService(ServiceConfigurationInterface serviceConfiguration, DiscoveryServiceInterface discoveryService) throws ServiceException {
        EventBrokerService service = null;
        try {
            service = new EventBrokerService(serviceConfiguration, discoveryService);
        }
        catch (RemoteException e) {
            String msg = RB.getStringResource("EventBrokerServiceFactory.getService.ex.txt");
            LogManager.getLogger(EventBrokerServiceFactory.class).error(msg, (Throwable)e);
            throw new ServiceException((Throwable)e, msg);
        }
        catch (RuntimeException e) {
            LogManager.getLogger(EventBrokerServiceFactory.class).error(RB.getStringResource("EventBrokerServiceFactory.getService.ex.txt"), (Throwable)e);
            throw e;
        }
        return service;
    }

    public static final EventBrokerServiceInterface createService(ServiceConfigurationInterface serviceConfiguration, DiscoveryServiceInterface discoveryService) throws ServiceException {
        return (EventBrokerServiceInterface)new EventBrokerServiceFactory().getService(serviceConfiguration, discoveryService);
    }
}

