/*
 * Decompiled with CFR 0.152.
 */
package com.sas.services.events.broker;

import com.sas.codepolicy.BinaryCompatibilityOnly;
import com.sas.codepolicy.SASScope;
import com.sas.services.events.broker.RB;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.net.InetAddress;
import java.net.Socket;
import java.net.UnknownHostException;
import java.text.MessageFormat;
import java.util.Locale;
import java.util.ResourceBundle;

@SASScope(value="ALL")
@BinaryCompatibilityOnly
public class EventBrokerServiceAdminClient {
    private static final String RB_KEY = "EventBrokerServiceAdminClient.";
    private static ResourceBundle rb = RB.getResources();

    public static void main(String[] args) {
        boolean shutdown = false;
        boolean quiesce = false;
        boolean update = false;
        boolean displaythreads = false;
        boolean killthread = false;
        String host = null;
        int port = 0;
        String thread = null;
        if (args.length > 0) {
            int i;
            if (args[0].equalsIgnoreCase("shutdown")) {
                i = 1;
                while (i + 1 < args.length) {
                    if (args[i].equalsIgnoreCase("-host")) {
                        host = args[i + 1];
                    } else if (args[i].equalsIgnoreCase("-port")) {
                        try {
                            port = Integer.parseInt(args[i + 1]);
                        }
                        catch (NumberFormatException e) {
                            System.err.println(rb.getString("EventBrokerServiceAdminClient.badPort.txt"));
                            System.exit(-1);
                        }
                    }
                    i += 2;
                }
                if (host == null) {
                    host = "localhost";
                }
                if (port == 0) {
                    System.err.println(rb.getString("EventBrokerServiceAdminClient.portRequired.txt"));
                    System.exit(-1);
                }
                shutdown = true;
            } else if (args[0].equalsIgnoreCase("quiesce")) {
                i = 1;
                while (i + 1 < args.length) {
                    if (args[i].equalsIgnoreCase("-host")) {
                        host = args[i + 1];
                    } else if (args[i].equalsIgnoreCase("-port")) {
                        try {
                            port = Integer.parseInt(args[i + 1]);
                        }
                        catch (NumberFormatException e) {
                            System.err.println(rb.getString("EventBrokerServiceAdminClient.badPort.txt"));
                            System.exit(-1);
                        }
                    }
                    i += 2;
                }
                if (host == null) {
                    host = "localhost";
                }
                if (port == 0) {
                    System.err.println(rb.getString("EventBrokerServiceAdminClient.portRequired.txt"));
                    System.exit(-1);
                }
                quiesce = true;
            } else if (args[0].equalsIgnoreCase("update")) {
                i = 1;
                while (i + 1 < args.length) {
                    if (args[i].equalsIgnoreCase("-host")) {
                        host = args[i + 1];
                    } else if (args[i].equalsIgnoreCase("-port")) {
                        try {
                            port = Integer.parseInt(args[i + 1]);
                        }
                        catch (NumberFormatException e) {
                            System.err.println(rb.getString("EventBrokerServiceAdminClient.badPort.txt"));
                            System.exit(-1);
                        }
                    }
                    i += 2;
                }
                if (host == null) {
                    host = "localhost";
                }
                if (port == 0) {
                    System.err.println(rb.getString("EventBrokerServiceAdminClient.portRequired.txt"));
                    System.exit(-1);
                }
                update = true;
            } else if (args[0].equalsIgnoreCase("displaythreads")) {
                i = 1;
                while (i + 1 < args.length) {
                    if (args[i].equalsIgnoreCase("-host")) {
                        host = args[i + 1];
                    } else if (args[i].equalsIgnoreCase("-port")) {
                        try {
                            port = Integer.parseInt(args[i + 1]);
                        }
                        catch (NumberFormatException e) {
                            System.err.println(rb.getString("EventBrokerServiceAdminClient.badPort.txt"));
                            System.exit(-1);
                        }
                    }
                    i += 2;
                }
                if (host == null) {
                    host = "localhost";
                }
                if (port == 0) {
                    System.err.println(rb.getString("EventBrokerServiceAdminClient.portRequired.txt"));
                    System.exit(-1);
                }
                displaythreads = true;
            } else if (args[0].equalsIgnoreCase("killthread")) {
                i = 1;
                while (i + 1 < args.length) {
                    if (args[i].equalsIgnoreCase("-host")) {
                        host = args[i + 1];
                    } else if (args[i].equalsIgnoreCase("-port")) {
                        try {
                            port = Integer.parseInt(args[i + 1]);
                        }
                        catch (NumberFormatException e) {
                            System.err.println(rb.getString("EventBrokerServiceAdminClient.badPort.txt"));
                            System.exit(-1);
                        }
                    } else if (args[i].equalsIgnoreCase("-thread")) {
                        thread = args[i + 1];
                    }
                    i += 2;
                }
                if (host == null) {
                    host = "localhost";
                }
                if (port == 0) {
                    System.err.println(rb.getString("EventBrokerServiceAdminClient.portRequired.txt"));
                    System.exit(-1);
                }
                if (thread == null) {
                    System.err.println(rb.getString("EventBrokerServiceAdminClient.threadRequired.txt"));
                    System.exit(-1);
                }
                killthread = true;
            }
        }
        EventBrokerServiceAdminClient admin = new EventBrokerServiceAdminClient();
        if (shutdown) {
            admin.shutdown(host, port);
        } else if (quiesce) {
            admin.quiesce(host, port);
        } else if (update) {
            admin.update(host, port);
        } else if (displaythreads) {
            admin.displaythreads(host, port);
        } else if (killthread) {
            admin.killthread(host, port, thread);
        } else {
            System.out.println(rb.getString("EventBrokerServiceAdminClient.usage.txt"));
            System.out.println("       shutdown       -host hostName -port portNumber");
            System.out.println("       quiesce        -host hostName -port portNumber");
            System.out.println("       update         -host hostName -port portNumber");
            System.out.println("       displaythreads -host hostName -port portNumber");
            System.out.println("       killthread     -host hostName -port portNumber -thread threadName");
        }
        System.exit(0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void shutdown(String host, int port) {
        System.out.println(MessageFormat.format(rb.getString("EventBrokerServiceAdminClient.shutdown.command.fmt.txt"), host, port));
        Socket socket = null;
        try {
            InetAddress address = InetAddress.getByName(host);
            socket = new Socket(address, port);
            OutputStream os = socket.getOutputStream();
            InputStream is = socket.getInputStream();
            BufferedWriter writer = new BufferedWriter(new OutputStreamWriter(os, "UTF-8"));
            BufferedReader reader = new BufferedReader(new InputStreamReader(is, "UTF-8"));
            String command = "shutdown";
            writer.write(command, 0, command.length());
            writer.newLine();
            Locale locale = Locale.getDefault();
            String language = locale.getLanguage();
            String country = locale.getCountry();
            writer.write(language, 0, language.length());
            writer.newLine();
            writer.write(country, 0, country.length());
            writer.newLine();
            writer.flush();
            System.out.println(rb.getString("EventBrokerServiceAdminClient.result.txt"));
            String reply = reader.readLine();
            if (reply != null) {
                System.out.println(reply);
            } else {
                System.out.println(rb.getString("EventBrokerServiceAdminClient.noResult.txt"));
            }
        }
        catch (UnknownHostException ae) {
            System.err.println(MessageFormat.format(rb.getString("EventBrokerServiceAdminClient.unknownHostException.fmt.txt"), ae.getMessage()));
        }
        catch (IOException ioe) {
            System.err.println(MessageFormat.format(rb.getString("EventBrokerServiceAdminClient.ioException.fmt.txt"), ioe.getMessage()));
        }
        finally {
            try {
                if (socket != null) {
                    socket.close();
                }
            }
            catch (IOException ae) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void quiesce(String host, int port) {
        System.out.println(MessageFormat.format(rb.getString("EventBrokerServiceAdminClient.quiesce.command.fmt.txt"), host, port));
        Socket socket = null;
        try {
            InetAddress address = InetAddress.getByName(host);
            socket = new Socket(address, port);
            OutputStream os = socket.getOutputStream();
            InputStream is = socket.getInputStream();
            BufferedWriter writer = new BufferedWriter(new OutputStreamWriter(os, "UTF-8"));
            BufferedReader reader = new BufferedReader(new InputStreamReader(is, "UTF-8"));
            String command = "quiesce";
            writer.write(command, 0, command.length());
            writer.newLine();
            Locale locale = Locale.getDefault();
            String language = locale.getLanguage();
            String country = locale.getCountry();
            writer.write(language, 0, language.length());
            writer.newLine();
            writer.write(country, 0, country.length());
            writer.newLine();
            writer.flush();
            System.out.println(rb.getString("EventBrokerServiceAdminClient.result.txt"));
            String reply = reader.readLine();
            if (reply != null) {
                System.out.println(reply);
            } else {
                System.out.println(rb.getString("EventBrokerServiceAdminClient.noResult.txt"));
            }
        }
        catch (UnknownHostException ae) {
            System.err.println(MessageFormat.format(rb.getString("EventBrokerServiceAdminClient.unknownHostException.fmt.txt"), ae.getMessage()));
        }
        catch (IOException ioe) {
            System.err.println(MessageFormat.format(rb.getString("EventBrokerServiceAdminClient.ioException.fmt.txt"), ioe.getMessage()));
        }
        finally {
            try {
                if (socket != null) {
                    socket.close();
                }
            }
            catch (IOException ae) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void update(String host, int port) {
        System.out.println(MessageFormat.format(rb.getString("EventBrokerServiceAdminClient.update.command.fmt.txt"), host, port));
        Socket socket = null;
        try {
            InetAddress address = InetAddress.getByName(host);
            socket = new Socket(address, port);
            OutputStream os = socket.getOutputStream();
            InputStream is = socket.getInputStream();
            BufferedWriter writer = new BufferedWriter(new OutputStreamWriter(os, "UTF-8"));
            BufferedReader reader = new BufferedReader(new InputStreamReader(is, "UTF-8"));
            String command = "update";
            writer.write(command, 0, command.length());
            writer.newLine();
            Locale locale = Locale.getDefault();
            String language = locale.getLanguage();
            String country = locale.getCountry();
            writer.write(language, 0, language.length());
            writer.newLine();
            writer.write(country, 0, country.length());
            writer.newLine();
            writer.flush();
            System.out.println(rb.getString("EventBrokerServiceAdminClient.result.txt"));
            String reply = reader.readLine();
            if (reply != null) {
                System.out.println(reply);
            } else {
                System.out.println(rb.getString("EventBrokerServiceAdminClient.noResult.txt"));
            }
        }
        catch (UnknownHostException ae) {
            System.err.println(MessageFormat.format(rb.getString("EventBrokerServiceAdminClient.unknownHostException.fmt.txt"), ae.getMessage()));
        }
        catch (IOException ioe) {
            System.err.println(MessageFormat.format(rb.getString("EventBrokerServiceAdminClient.ioException.fmt.txt"), ioe.getMessage()));
        }
        finally {
            try {
                if (socket != null) {
                    socket.close();
                }
            }
            catch (IOException ae) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void displaythreads(String host, int port) {
        System.out.println(MessageFormat.format(rb.getString("EventBrokerServiceAdminClient.displayThreads.command.fmt.txt"), host, port));
        Socket socket = null;
        try {
            InetAddress address = InetAddress.getByName(host);
            socket = new Socket(address, port);
            OutputStream os = socket.getOutputStream();
            InputStream is = socket.getInputStream();
            BufferedWriter writer = new BufferedWriter(new OutputStreamWriter(os, "UTF-8"));
            BufferedReader reader = new BufferedReader(new InputStreamReader(is, "UTF-8"));
            String command = "displaythreads";
            writer.write(command, 0, command.length());
            writer.newLine();
            Locale locale = Locale.getDefault();
            String language = locale.getLanguage();
            String country = locale.getCountry();
            writer.write(language, 0, language.length());
            writer.newLine();
            writer.write(country, 0, country.length());
            writer.newLine();
            writer.flush();
            System.out.println(rb.getString("EventBrokerServiceAdminClient.result.txt"));
            String reply = reader.readLine();
            if (reply != null) {
                while (reply != null) {
                    System.out.println(reply);
                    reply = reader.readLine();
                }
            } else {
                System.out.println(rb.getString("EventBrokerServiceAdminClient.noResult.txt"));
            }
        }
        catch (UnknownHostException ae) {
            System.err.println(MessageFormat.format(rb.getString("EventBrokerServiceAdminClient.unknownHostException.fmt.txt"), ae.getMessage()));
        }
        catch (IOException ioe) {
            System.err.println(MessageFormat.format(rb.getString("EventBrokerServiceAdminClient.ioException.fmt.txt"), ioe.getMessage()));
        }
        finally {
            try {
                if (socket != null) {
                    socket.close();
                }
            }
            catch (IOException ae) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void killthread(String host, int port, String threadName) {
        System.out.println(MessageFormat.format(rb.getString("EventBrokerServiceAdminClient.killThread.command.fmt.txt"), host, port, threadName));
        Socket socket = null;
        try {
            InetAddress address = InetAddress.getByName(host);
            socket = new Socket(address, port);
            OutputStream os = socket.getOutputStream();
            InputStream is = socket.getInputStream();
            BufferedWriter writer = new BufferedWriter(new OutputStreamWriter(os, "UTF-8"));
            BufferedReader reader = new BufferedReader(new InputStreamReader(is, "UTF-8"));
            String command = "killthread";
            writer.write(command, 0, command.length());
            writer.newLine();
            Locale locale = Locale.getDefault();
            String language = locale.getLanguage();
            String country = locale.getCountry();
            writer.write(language, 0, language.length());
            writer.newLine();
            writer.write(country, 0, country.length());
            writer.newLine();
            writer.write(threadName, 0, threadName.length());
            writer.newLine();
            writer.flush();
            System.out.println(rb.getString("EventBrokerServiceAdminClient.result.txt"));
            String reply = reader.readLine();
            if (reply != null) {
                System.out.println(reply);
            } else {
                System.out.println(rb.getString("EventBrokerServiceAdminClient.noResult.txt"));
            }
        }
        catch (UnknownHostException ae) {
            System.err.println(MessageFormat.format(rb.getString("EventBrokerServiceAdminClient.unknownHostException.fmt.txt"), ae.getMessage()));
        }
        catch (IOException ioe) {
            System.err.println(MessageFormat.format(rb.getString("EventBrokerServiceAdminClient.ioException.fmt.txt"), ioe.getMessage()));
        }
        finally {
            try {
                if (socket != null) {
                    socket.close();
                }
            }
            catch (IOException ae) {}
        }
    }
}

