/*
 * Decompiled with CFR 0.152.
 */
package com.sas.services.events.broker;

import com.sas.codepolicy.BinaryCompatibilityOnly;
import com.sas.codepolicy.SASScope;
import com.sas.iom.SASIOMDefs.GenericError;
import com.sas.meta.SASOMI.IOMI;
import com.sas.metadata.AssociationList;
import com.sas.metadata.CMetadata;
import com.sas.metadata.DeployedComponent;
import com.sas.metadata.Directory;
import com.sas.metadata.MdException;
import com.sas.metadata.MdObjectFactory;
import com.sas.metadata.MdObjectStore;
import com.sas.metadata.MdStore;
import com.sas.metadata.MetadataUtil;
import com.sas.metadata.Property;
import com.sas.metadata.PropertySet;
import com.sas.metadata.Root;
import com.sas.metadata.ServiceComponent;
import com.sas.metadata.ServiceType;
import com.sas.metadata.TCPIPConnection;
import com.sas.metadata.TextStore;
import com.sas.metadata.Transformation;
import com.sas.metadata.TransformationActivity;
import com.sas.metadata.TransformationStep;
import com.sas.metadata.remote.MdFactory;
import com.sas.metadata.remote.MdOMRConnection;
import com.sas.metadata.remote.MdOMRConnectionImpl;
import com.sas.net.rmi.RemoteObjectExporterInterface;
import com.sas.net.rmi.UnicastRemoteObjectExporter;
import com.sas.net.ssl.SSLRMIConfiguration;
import com.sas.net.ssl.SSLRMISocketFactories;
import com.sas.services.AbstractRemoteService;
import com.sas.services.InitializationException;
import com.sas.services.RemoteServiceInterface;
import com.sas.services.ServiceConfigurationInterface;
import com.sas.services.ServiceException;
import com.sas.services.deployment.MetadataSourceConfigurationInterface;
import com.sas.services.deployment.MetadataSourceInterface;
import com.sas.services.deployment.OMRMetadataSource;
import com.sas.services.deployment.ServiceLoader;
import com.sas.services.deployment.URLMetadataSource;
import com.sas.services.discovery.DiscoveryService;
import com.sas.services.discovery.DiscoveryServiceInterface;
import com.sas.services.discovery.LocalDiscoveryServiceInterface;
import com.sas.services.discovery.ServiceDiscoveryConfigurationInterface;
import com.sas.services.discovery.ServiceTemplate;
import com.sas.services.discovery.Services;
import com.sas.services.events.ApplicationMonitorResources;
import com.sas.services.events.broker.AdminServer;
import com.sas.services.events.broker.EventBrokerServiceInterface;
import com.sas.services.events.broker.EventBrokerServiceMBean;
import com.sas.services.events.broker.EventBrokerServiceProxy;
import com.sas.services.events.broker.EventManager;
import com.sas.services.events.broker.EventResponseHandlerInterface;
import com.sas.services.events.broker.InvalidEventTypeException;
import com.sas.services.events.broker.ListenerInterface;
import com.sas.services.events.broker.MonitorConfigurationElement;
import com.sas.services.events.broker.RB;
import com.sas.services.events.broker.flowengine.FlowNode;
import com.sas.services.events.broker.flowengine.NodeInput;
import com.sas.services.events.broker.flowengine.NodeOutput;
import com.sas.services.events.broker.flowengine.ProcessFlow;
import com.sas.services.events.broker.monitor.LocalResponseAgent;
import com.sas.services.events.broker.monitor.Monitor;
import com.sas.services.events.broker.monitor.MonitorException;
import com.sas.services.events.broker.monitor.MonitorThread;
import com.sas.services.events.broker.monitor.RMIResponseAgent;
import com.sas.services.events.broker.util.Event;
import com.sas.services.events.broker.util.EventContainer;
import com.sas.services.events.broker.util.EventRequest;
import com.sas.services.events.broker.util.EventsConfiguration;
import com.sas.services.events.broker.util.MutexStateException;
import com.sas.services.events.broker.util.ThreadPool;
import com.sas.services.logging.util.LoggerMonitor2;
import com.sas.services.util.GetPropertyAction;
import com.sas.services.util.IOUtil;
import com.sas.services.util.JMXAgent;
import com.sas.services.util.Names;
import com.sas.services.util.XMLUtil;
import com.sas.text.Message;
import com.sas.util.SasPasswordEncodingException;
import com.sas.util.SasPasswordString;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.net.InetAddress;
import java.net.MalformedURLException;
import java.net.ServerSocket;
import java.net.URL;
import java.net.UnknownHostException;
import java.rmi.Remote;
import java.rmi.RemoteException;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.ResourceBundle;
import java.util.Set;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.UnsupportedLookAndFeelException;
import javax.swing.border.Border;
import javax.swing.border.CompoundBorder;
import javax.swing.border.TitledBorder;
import javax.swing.event.CaretEvent;
import javax.swing.event.CaretListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.filechooser.FileFilter;
import javax.swing.plaf.basic.BasicPasswordFieldUI;
import javax.swing.plaf.basic.BasicTextFieldUI;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.PlainDocument;
import javax.xml.transform.TransformerException;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.omg.CORBA.StringHolder;

@SASScope(value="ALL")
@BinaryCompatibilityOnly
public class EventBrokerService
extends AbstractRemoteService
implements EventBrokerServiceInterface,
Runnable {
    private static final String CHARACTER_ENCODING = "utf-8";
    @SASScope
    private boolean _bInitialized;
    @SASScope
    private Throwable _initException;
    private Logger _logger;
    private LoggerMonitor2 _applicationMonitorLogger;
    private String _brokerUser = "";
    private String _brokerPass = "";
    private static final String SCTEMPLATE = "ServiceComponentTemplate.xml";
    private static final String MESSAGE_FORMAT_XML_SELECT_TEMPLATE = "<XMLSelect Search=\"*{0}\"/>{1}";
    private static final String GETMETADATA_XSL = "GetMetadata.xsl";
    private static final String MESSAGE_FORMAT_GETMETADATA = "<GetMetadataObjects><ReposId>{0}</ReposId><Type>ServiceComponent</Type><Objects/><ns>SAS</ns><Flags>{1}</Flags><Options>{2}</Options></GetMetadataObjects>";
    private static final String DEFAULT_EVENT = "DEFAULT_EVENT";
    private static final String ADMIN_PORT = "ADMIN_PORT";
    private static final String TP_MAX_THREADS = "THREADPOOL_MAX_THREADS";
    private static final String TP_MIN_SPARE_THREADS = "THREADPOOL_MIN_SPARE_THREADS";
    private static final String TP_MAX_SPARE_THREADS = "THREADPOOL_MAX_SPARE_THREADS";
    private static final String EVENT_MGR_THREADS = "EVENTMGR_THREADS";
    private static final String EVENT_MGR_MAX_EVENTS = "EVENTMGR_MAX_EVENTS";
    private String _desc;
    private String _defaultEvent;
    private int _maxQueuedEvents;
    private int _eventMgrThreads;
    private int _tpMaxThreads;
    private int _tpMaxSpares;
    private int _tpMinSpares;
    private int _adminPort;
    private String _rmiTransportName;
    private String _rmiDefaultEvent;
    private ServerSocket _adminSocket;
    private Set _monitors = new HashSet();
    private EventsConfiguration _eventsConfig;
    private ThreadPool _tp;
    private EventContainer _eventContainer;
    private String _mbean_register_name = null;
    private static final String RB_KEY = "EventBrokerService.";
    static ResourceBundle rb = RB.getResources();

    @SASScope
    EventBrokerService() {
        super((DiscoveryServiceInterface)DiscoveryService.defaultInstance());
    }

    @SASScope(value="ALL")
    public EventBrokerService(ServiceConfigurationInterface serviceConfiguration) throws RemoteException, ServiceException {
        this(serviceConfiguration, (DiscoveryServiceInterface)DiscoveryService.defaultInstance());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public EventBrokerService(ServiceConfigurationInterface serviceConfiguration, DiscoveryServiceInterface discoveryService) throws RemoteException, ServiceException {
        super(discoveryService);
        if (serviceConfiguration == null) {
            throw new IllegalArgumentException();
        }
        SSLRMISocketFactories sslRMISocketFactories = SSLRMISocketFactories.getInstance();
        Class<?> theClass = this.getClass();
        this.setRemoteableExporter((RemoteObjectExporterInterface)new UnicastRemoteObjectExporter((Remote)this, sslRMISocketFactories.getPortForClass(0, theClass), sslRMISocketFactories.getRMIClientSocketFactoryForClass(theClass), sslRMISocketFactories.getRMIServerSocketFactoryForClass(theClass), true));
        this._logger = LogManager.getLogger((String)this.getClass().getName());
        this._applicationMonitorLogger = new LoggerMonitor2(LogManager.getLogger((String)"ApplicationMonitor.EventBrokerService"));
        this.configure(serviceConfiguration);
        this._mbean_register_name = Names.getObjectName((String)"EventBrokerService", (RemoteServiceInterface)this);
        JMXAgent agent = JMXAgent.getInstance();
        if (agent != null && agent.isMBeanEnabled(this._mbean_register_name)) {
            EventBrokerServiceMBean mbean = new EventBrokerServiceMBean(this);
            agent.registerMBean((Object)mbean, this._mbean_register_name);
        }
        Thread t = new Thread(this);
        t.setDaemon(true);
        t.setName(this.getClass().getName() + "_main_" + t.getName());
        t.start();
        EventBrokerService eventBrokerService = this;
        synchronized (eventBrokerService) {
            while (true) {
                try {
                    this.wait();
                }
                catch (InterruptedException interruptedException) {
                    continue;
                }
                break;
            }
        }
        if (this._initException != null) {
            throw new InitializationException(this._initException, rb.getString("EventBrokerService.initializationException.ex.txt"));
        }
        this.bindToDiscoveryService();
        this._bInitialized = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @SASScope
    public void run() {
        int i;
        Object itMonitors;
        MonitorThread[] monitorThreads = new MonitorThread[this._monitors.size()];
        Thread[] workerThreads = new Thread[this._eventMgrThreads];
        try {
            if (this._applicationMonitorLogger.isLoggingEnabled()) {
                this._applicationMonitorLogger.log(ApplicationMonitorResources.COLUMN_ACTION, ApplicationMonitorResources.ACTION_SERVICE_STARTING, ApplicationMonitorResources.COLUMN_EVENT_NAME, "", ApplicationMonitorResources.COLUMN_HANDLER_NAME, "", ApplicationMonitorResources.COLUMN_INFORMATION, "");
            }
            if (this._logger.isDebugEnabled()) {
                this._logger.debug(rb.getString("EventBrokerService.startBrokerThread.txt"));
            }
            if (this._logger.isInfoEnabled()) {
                this._logger.info(rb.getString("EventBrokerService.initThreadPool.txt"));
            }
            this._tp = new ThreadPool(this._tpMaxThreads, this._tpMaxSpares, this._tpMinSpares);
            this._tp.init();
            this._eventContainer = new EventContainer(this._maxQueuedEvents, this._eventsConfig, this._tp);
            this._eventContainer.setBrokerUser(this._brokerUser);
            this._eventContainer.setBrokerPass(this._brokerPass);
            this._eventContainer.setOwningBroker(this);
            if (this._logger.isInfoEnabled()) {
                this._logger.info(MessageFormat.format(rb.getString("EventBrokerService.createEventManagerThreads.fmt.txt"), new Integer(this._eventMgrThreads)));
            }
            for (int i2 = 0; i2 < this._eventMgrThreads; ++i2) {
                workerThreads[i2] = new Thread(new EventManager(this._eventContainer));
                workerThreads[i2].setDaemon(true);
                workerThreads[i2].setName(this.getClass().getName() + "_worker_" + workerThreads[i2].getName());
                workerThreads[i2].start();
                if (!this._logger.isInfoEnabled()) continue;
                this._logger.info(MessageFormat.format(rb.getString("EventBrokerService.startEventManagerThread.fmt.txt"), workerThreads[i2].getName()));
            }
            if (this._logger.isInfoEnabled()) {
                this._logger.info(MessageFormat.format(rb.getString("EventBrokerService.createMonitorThreads.fmt.txt"), new Integer(this._monitors.size())));
            }
            itMonitors = this._monitors.iterator();
            int i3 = 0;
            while (itMonitors.hasNext()) {
                MonitorConfigurationElement mce = (MonitorConfigurationElement)itMonitors.next();
                try {
                    String soap_enablement;
                    Map props;
                    String monitorType = mce.getType();
                    if (monitorType.equals("HTTP") && (props = mce.getProperties()).containsKey("soap_enablement") && (soap_enablement = (String)props.get("soap_enablement")).equals("1")) {
                        monitorType = "HTTPSoap";
                    }
                    String className = "com.sas.services.events.broker.monitor." + monitorType + "Monitor";
                    if (this._logger.isInfoEnabled()) {
                        this._logger.info(MessageFormat.format(rb.getString("EventBrokerService.startMonitor.fmt.txt"), mce.getName()));
                    }
                    Monitor monitorInstance = (Monitor)Class.forName(className).newInstance();
                    monitorInstance.init(mce.getName(), mce.getProperties(), this._eventContainer);
                    monitorThreads[i3] = new MonitorThread(monitorInstance);
                    monitorThreads[i3].setName(className + '_' + monitorThreads[i3].getName());
                    monitorThreads[i3].start();
                    if (this._logger.isInfoEnabled()) {
                        this._logger.info(MessageFormat.format(rb.getString("EventBrokerService.startMonitorThread.fmt.txt"), mce.getName(), monitorThreads[i3].getName()));
                    }
                }
                catch (MonitorException me) {
                    this._logger.error(MessageFormat.format(rb.getString("EventBrokerService.initMonitor.MonitorException.fmt.txt"), mce.getName()));
                    monitorThreads[i3] = null;
                }
                catch (ClassNotFoundException nfe) {
                    this._logger.error(MessageFormat.format(rb.getString("EventBrokerService.initMonitor.ClassNotFoundException.fmt.txt"), mce.getName()));
                    monitorThreads[i3] = null;
                }
                catch (InstantiationException ie) {
                    this._logger.error(MessageFormat.format(rb.getString("EventBrokerService.initMonitor.InstantiationException.fmt.txt"), mce.getName()));
                    monitorThreads[i3] = null;
                }
                catch (IllegalAccessException iae) {
                    this._logger.error(MessageFormat.format(rb.getString("EventBrokerService.initMonitor.IllegalAccessException.fmt.txt"), mce.getName()));
                    monitorThreads[i3] = null;
                }
                catch (NoClassDefFoundError ncdfe) {
                    this._logger.error(MessageFormat.format(rb.getString("EventBrokerService.initMonitor.NoClassDefFoundErrorException.fmt.txt"), mce.getName()));
                    monitorThreads[i3] = null;
                }
                catch (Throwable t) {
                    this._logger.error(MessageFormat.format(rb.getString("EventBrokerService.initMonitor.Exception.fmt.txt"), mce.getName()));
                    monitorThreads[i3] = null;
                }
                ++i3;
            }
            this._adminSocket = new ServerSocket(this._adminPort);
        }
        catch (Throwable t) {
            this._initException = t;
        }
        finally {
            itMonitors = this;
            synchronized (itMonitors) {
                this.notify();
            }
        }
        if (this._initException == null) {
            if (this._logger.isInfoEnabled()) {
                this._logger.info(MessageFormat.format(rb.getString("EventBrokerService.adminPort.fmt.txt"), new Integer(this._adminPort)));
                this._logger.info(rb.getString("EventBrokerService.init.complete.txt"));
            }
            if (this._applicationMonitorLogger.isLoggingEnabled()) {
                this._applicationMonitorLogger.log(ApplicationMonitorResources.COLUMN_ACTION, ApplicationMonitorResources.ACTION_SERVICE_STARTED, ApplicationMonitorResources.COLUMN_EVENT_NAME, "", ApplicationMonitorResources.COLUMN_HANDLER_NAME, "", ApplicationMonitorResources.COLUMN_INFORMATION, MessageFormat.format(rb.getString("EventBrokerService.adminPort.fmt.txt"), new Integer(this._adminPort)));
            }
            AdminServer adminServer = new AdminServer(this, this._adminSocket, this._eventContainer);
            adminServer.start();
        }
        if (this._applicationMonitorLogger.isLoggingEnabled()) {
            this._applicationMonitorLogger.log(ApplicationMonitorResources.COLUMN_ACTION, ApplicationMonitorResources.ACTION_SERVICE_ENDING, ApplicationMonitorResources.COLUMN_EVENT_NAME, "", ApplicationMonitorResources.COLUMN_HANDLER_NAME, "", ApplicationMonitorResources.COLUMN_INFORMATION, "");
        }
        if (this._logger.isInfoEnabled()) {
            this._logger.info(rb.getString("EventBrokerService.shutdown.txt"));
        }
        for (i = 0; i < this._monitors.size(); ++i) {
            if (monitorThreads[i] == null) continue;
            MonitorThread mt = monitorThreads[i];
            if (this._logger.isInfoEnabled()) {
                this._logger.info(MessageFormat.format(rb.getString("EventBrokerService.interruptMonitor.fmt.txt"), mt.getName()));
            }
            mt.interrupt();
            try {
                if (this._logger.isInfoEnabled()) {
                    this._logger.info(rb.getString("EventBrokerService.waitMonitorExit.txt"));
                }
                mt.join();
                if (!this._logger.isInfoEnabled()) continue;
                this._logger.info(rb.getString("EventBrokerService.monitorExited.txt"));
                continue;
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        this._eventContainer._workerCV.condBroadcast();
        if (this._logger.isInfoEnabled()) {
            this._logger.info(rb.getString("EventBrokerService.waitWorkersExit.txt"));
        }
        for (i = 0; i < workerThreads.length; ++i) {
            try {
                Thread t = workerThreads[i];
                t.join();
                continue;
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        if (this._logger.isInfoEnabled()) {
            this._logger.info(rb.getString("EventBrokerService.workersExited.txt"));
        }
        this._eventContainer.releaseEventListeners();
        if (this._logger.isInfoEnabled()) {
            this._logger.info(rb.getString("EventBrokerService.termThreadPool.txt"));
        }
        this._tp.term();
        try {
            super.destroy();
        }
        catch (ServiceException se) {
            this._logger.error(rb.getString("EventBrokerService.serviceException.destroy.ex.txt"), (Throwable)se);
        }
        catch (RemoteException re) {
            this._logger.error(rb.getString("EventBrokerService.remoteException.destroy.ex.txt"), (Throwable)re);
        }
        if (this._applicationMonitorLogger.isLoggingEnabled()) {
            this._applicationMonitorLogger.log(ApplicationMonitorResources.COLUMN_ACTION, ApplicationMonitorResources.ACTION_SERVICE_ENDED, ApplicationMonitorResources.COLUMN_EVENT_NAME, "", ApplicationMonitorResources.COLUMN_HANDLER_NAME, "", ApplicationMonitorResources.COLUMN_INFORMATION, "");
        }
        if (this._logger.isInfoEnabled()) {
            this._logger.info(rb.getString("EventBrokerService.exitBrokerThread.txt"));
        }
        this._bInitialized = false;
        EventBrokerService eventBrokerService = this;
        synchronized (eventBrokerService) {
            this.notify();
        }
    }

    @SASScope
    public void configure(ServiceConfigurationInterface serviceConfiguration) throws InitializationException, RemoteException, ServiceException {
        if (serviceConfiguration == null) {
            throw new IllegalArgumentException();
        }
        super.configure(serviceConfiguration);
        this.init(serviceConfiguration);
    }

    public void reconfigure(ServiceConfigurationInterface serviceConfiguration) throws ServiceException, RemoteException {
        if (serviceConfiguration == null) {
            throw new IllegalArgumentException();
        }
        super.reconfigure(serviceConfiguration);
        this.init(serviceConfiguration);
        this._eventContainer._rwLock.writeLock();
        this._eventContainer.setEventConfiguration(this._eventsConfig);
        this._eventContainer._rwLock.unlock();
    }

    public void reconfigure() throws ServiceException, RemoteException {
        ServiceConfigurationInterface serviceConfiguration = this.getServiceConfiguration();
        this.reconfigure(serviceConfiguration);
        ServiceConfigurationInterface serviceConfig = serviceConfiguration.getServiceConfiguration(ServiceConfigurationInterface.CONFIGURATION_METADATA_SOURCE);
        if (serviceConfig instanceof MetadataSourceConfigurationInterface) {
            MetadataSourceConfigurationInterface metadataSourceConfig = (MetadataSourceConfigurationInterface)serviceConfig;
            MetadataSourceInterface metadataSource = metadataSourceConfig.getMetadataSource();
            metadataSource.destroy();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void init(ServiceConfigurationInterface serviceConfiguration) throws InitializationException, RemoteException, ServiceException {
        if (serviceConfiguration == null) {
            throw new IllegalArgumentException();
        }
        MdObjectStore objectStore = null;
        try {
            ServiceConfigurationInterface serviceConfig = serviceConfiguration.getServiceConfiguration(ServiceConfigurationInterface.CONFIGURATION_SERVICE_DISCOVERY);
            String brokerId = null;
            if (!(serviceConfig instanceof ServiceDiscoveryConfigurationInterface)) {
                throw new InitializationException(rb.getString("EventBrokerService.invalidServiceDiscoveryConfig.ex.txt"));
            }
            ServiceDiscoveryConfigurationInterface serviceDiscoveryConfig = (ServiceDiscoveryConfigurationInterface)serviceConfig;
            brokerId = serviceDiscoveryConfig.getRepositoryId();
            serviceConfig = serviceConfiguration.getServiceConfiguration(ServiceConfigurationInterface.CONFIGURATION_METADATA_SOURCE);
            String metadataXML = null;
            if (serviceConfig instanceof MetadataSourceConfigurationInterface) {
                MetadataSourceConfigurationInterface metadataSourceConfig = (MetadataSourceConfigurationInterface)serviceConfig;
                MetadataSourceInterface metadataSource = metadataSourceConfig.getMetadataSource();
                if (metadataSource instanceof OMRMetadataSource) {
                    MdOMRConnectionImpl connectionImpl;
                    Map credentials;
                    com.sas.metadata.remote.MdObjectStore mdObjectStore;
                    MdFactory mdFactory;
                    OMRMetadataSource omrMetadataSource = (OMRMetadataSource)metadataSource;
                    if (this._logger.isDebugEnabled()) {
                        this._logger.debug(MessageFormat.format(rb.getString("EventBrokerService.beginConfig.fmt.txt"), "OMR", omrMetadataSource.toString()));
                    }
                    if ((mdFactory = (mdObjectStore = omrMetadataSource.getMdObjectStore()).getFactory()) == null) {
                        throw new ServiceException(RB.getStringResource("EventBrokerService.noMdFactory.ex.txt"));
                    }
                    MdOMRConnection connection = mdFactory.getConnection();
                    if (connection instanceof MdOMRConnectionImpl && (credentials = (connectionImpl = (MdOMRConnectionImpl)connection).getCredentialMap()) != null) {
                        if (credentials.containsKey("Username")) {
                            this._brokerUser = (String)credentials.get("Username");
                        }
                        if (credentials.containsKey("Password")) {
                            this._brokerPass = (String)credentials.get("Password");
                        }
                    }
                    IOMI omi = connection.getCMRHandle();
                    StringBuffer sb = new StringBuffer();
                    sb.append("[@");
                    sb.append("Id='" + brokerId + '\'');
                    sb.append("]");
                    String xmlSelect = sb.toString();
                    String xmlTemplate = IOUtil.getStringFromResourceUsingEncoding(EventBrokerService.class, (String)SCTEMPLATE, (String)CHARACTER_ENCODING);
                    xmlTemplate = XMLUtil.stripXMLDeclaration((String)xmlTemplate);
                    String xmlOptions = Message.format((String)MESSAGE_FORMAT_XML_SELECT_TEMPLATE, (Object)xmlSelect, (Object)xmlTemplate);
                    String inXml = Message.format((String)MESSAGE_FORMAT_GETMETADATA, (Object)omrMetadataSource.getRepositoryId(), (Object)Integer.toString(8580), (Object)xmlOptions);
                    if (this._logger.isDebugEnabled()) {
                        this._logger.debug(MessageFormat.format(rb.getString("EventBrokerService.omrGetMetadataRequest.fmt.txt"), inXml));
                    }
                    StringHolder holder = new StringHolder();
                    int rc = 0;
                    try {
                        rc = omi.DoRequest(inXml, holder);
                    }
                    catch (GenericError ge) {
                        throw new InitializationException((Throwable)ge, rb.getString("EventBrokerService.doRequestGenericError.ex.txt"));
                    }
                    if (rc != 0) {
                        throw new InitializationException(MessageFormat.format(rb.getString("EventBrokerService.doRequestFailed.ex.fmt.txt"), new Integer(rc)));
                    }
                    metadataXML = holder.value;
                    if (this._logger.isDebugEnabled()) {
                        this._logger.debug(MessageFormat.format(rb.getString("EventBrokerService.omrGetMetadataResult.fmt.txt"), metadataXML));
                    }
                    String xsl = IOUtil.getStringFromResourceUsingEncoding(EventBrokerService.class, (String)GETMETADATA_XSL, (String)CHARACTER_ENCODING);
                    if (this._logger.isDebugEnabled()) {
                        this._logger.debug(MessageFormat.format(rb.getString("EventBrokerService.getMetadataTransform.fmt.txt"), xsl));
                    }
                    try {
                        metadataXML = XMLUtil.applyXSL((String)metadataXML, (String)xsl);
                    }
                    catch (TransformerException te) {
                        throw new InitializationException((Throwable)te, rb.getString("EventBrokerService.transformationException.ex.txt"));
                    }
                    if (this._logger.isDebugEnabled()) {
                        this._logger.debug(MessageFormat.format(rb.getString("EventBrokerService.xsltOutput.fmt.txt"), metadataXML));
                    }
                } else {
                    URLMetadataSource urlMetadataSource = (URLMetadataSource)metadataSource;
                    if (this._logger.isDebugEnabled()) {
                        this._logger.debug(MessageFormat.format(rb.getString("EventBrokerService.beginConfig.fmt.txt"), "URL", urlMetadataSource.toString()));
                    }
                    metadataXML = urlMetadataSource.getMetadata();
                }
            } else {
                throw new InitializationException(rb.getString("EventBrokerService.invalidMetadataSourceConfig.ex.txt"));
            }
            objectStore = MdObjectFactory.createObjectStore();
            ServiceComponent myServiceComponent = null;
            try {
                MetadataUtil.populateStoreFromString((MdStore)objectStore, (String)metadataXML, (int)1, (boolean)false);
                Map map = objectStore.getDetailObjectMap();
                Iterator objsIter = map.values().iterator();
                block9: while (objsIter.hasNext() && myServiceComponent == null) {
                    ServiceComponent serviceComponent;
                    String id;
                    Object o2 = objsIter.next();
                    if (!(o2 instanceof ServiceComponent) || !brokerId.equals(id = (serviceComponent = (ServiceComponent)o2).getId())) continue;
                    for (Object o2 : serviceComponent.getServiceTypes()) {
                        ServiceType serviceType;
                        if (!(o2 instanceof ServiceType) || !"com.sas.services.events.broker.EventBrokerServiceInterface".equals((serviceType = (ServiceType)o2).getInterfaceName())) continue;
                        myServiceComponent = serviceComponent;
                        continue block9;
                    }
                }
            }
            catch (MdException mde) {
                throw new InitializationException((Throwable)mde, rb.getString("EventBrokerService.mdException.ex.txt"));
            }
            if (myServiceComponent == null) {
                throw new InitializationException(MessageFormat.format(rb.getString("EventBrokerService.noBroker.ex.fmt.txt"), brokerId));
            }
            this.parseConfig(myServiceComponent);
        }
        finally {
            if (objectStore != null) {
                objectStore.dispose();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SASScope
    public void destroy() throws ServiceException, RemoteException {
        if (this._bInitialized) {
            JMXAgent agent;
            if (this._adminSocket != null) {
                try {
                    this._adminSocket.close();
                    EventBrokerService eventBrokerService = this;
                    synchronized (eventBrokerService) {
                        this.wait(300000L);
                    }
                }
                catch (IOException ioe) {
                    this._logger.error(rb.getString("EventBrokerService.destroy.IOException.ex.txt"), (Throwable)ioe);
                }
                catch (InterruptedException ioe) {
                    // empty catch block
                }
                this._adminSocket = null;
            }
            if ((agent = JMXAgent.getInstance()) != null && this._mbean_register_name != null && agent.isMBeanEnabled(this._mbean_register_name)) {
                agent.unregisterMBean(this._mbean_register_name);
            }
        }
    }

    @SASScope
    private void parseConfig(ServiceComponent serviceComponent) throws InitializationException {
        if (!this._bInitialized) {
            this._desc = serviceComponent.getDesc();
            this._eventMgrThreads = 10;
            this._maxQueuedEvents = 100;
            this._tpMaxThreads = 100;
            this._tpMaxSpares = 25;
            this._tpMinSpares = 10;
            this._rmiDefaultEvent = "";
            this._rmiTransportName = "";
        }
        AssociationList list = null;
        try {
            list = serviceComponent.getProperties();
        }
        catch (MdException mde) {
            throw new InitializationException(mde.getMessage());
        }
        int size = list.size();
        for (int i = 0; i < size; ++i) {
            Property property = (Property)list.elementAt(i);
            if (property.getPropertyName().equals(DEFAULT_EVENT)) {
                this._defaultEvent = property.getDefaultValue();
                continue;
            }
            if (property.getPropertyName().equals(EVENT_MGR_THREADS)) {
                if (this._bInitialized) continue;
                try {
                    this._eventMgrThreads = Integer.parseInt(property.getDefaultValue());
                }
                catch (NumberFormatException nfe) {
                    throw new InitializationException(MessageFormat.format(rb.getString("EventBrokerService.invalidProperty.ex.fmt.txt"), EVENT_MGR_THREADS));
                }
                if (this._eventMgrThreads > 0) continue;
                this._eventMgrThreads = 10;
                continue;
            }
            if (property.getPropertyName().equals(EVENT_MGR_MAX_EVENTS)) {
                if (this._bInitialized) continue;
                try {
                    this._maxQueuedEvents = Integer.parseInt(property.getDefaultValue());
                }
                catch (NumberFormatException nfe) {
                    throw new InitializationException(MessageFormat.format(rb.getString("EventBrokerService.invalidProperty.ex.fmt.txt"), EVENT_MGR_MAX_EVENTS));
                }
                if (this._maxQueuedEvents > 0) continue;
                this._maxQueuedEvents = 100;
                continue;
            }
            if (property.getPropertyName().equals(TP_MAX_THREADS)) {
                if (this._bInitialized) continue;
                try {
                    this._tpMaxThreads = Integer.parseInt(property.getDefaultValue());
                }
                catch (NumberFormatException nfe) {
                    throw new InitializationException(MessageFormat.format(rb.getString("EventBrokerService.invalidProperty.ex.fmt.txt"), TP_MAX_THREADS));
                }
                if (this._tpMaxThreads > 0) continue;
                this._tpMaxThreads = 100;
                continue;
            }
            if (property.getPropertyName().equals(TP_MAX_SPARE_THREADS)) {
                if (this._bInitialized) continue;
                try {
                    this._tpMaxSpares = Integer.parseInt(property.getDefaultValue());
                }
                catch (NumberFormatException nfe) {
                    throw new InitializationException(MessageFormat.format(rb.getString("EventBrokerService.invalidProperty.ex.fmt.txt"), TP_MAX_SPARE_THREADS));
                }
                if (this._tpMaxSpares > 0) continue;
                this._tpMaxSpares = 25;
                continue;
            }
            if (property.getPropertyName().equals(TP_MIN_SPARE_THREADS)) {
                if (this._bInitialized) continue;
                try {
                    this._tpMinSpares = Integer.parseInt(property.getDefaultValue());
                }
                catch (NumberFormatException nfe) {
                    throw new InitializationException(MessageFormat.format(rb.getString("EventBrokerService.invalidProperty.ex.fmt.txt"), TP_MIN_SPARE_THREADS));
                }
                if (this._tpMinSpares > 0) continue;
                this._tpMinSpares = 10;
                continue;
            }
            if (!property.getPropertyName().equals(ADMIN_PORT) || this._bInitialized) continue;
            try {
                this._adminPort = Integer.parseInt(property.getDefaultValue());
            }
            catch (NumberFormatException nfe) {
                throw new InitializationException(MessageFormat.format(rb.getString("EventBrokerService.invalidProperty.ex.fmt.txt"), ADMIN_PORT));
            }
            if (this._adminPort > 0) continue;
            throw new InitializationException(MessageFormat.format(rb.getString("EventBrokerService.invalidProperty.ex.fmt.txt"), ADMIN_PORT));
        }
        if (this._logger.isDebugEnabled()) {
            this._logger.debug(rb.getString("EventBrokerService.properties.txt"));
            if (!this._bInitialized) {
                this._logger.debug(MessageFormat.format(rb.getString("EventBrokerService.properties.desc.fmt.txt"), this._desc));
            }
            this._logger.debug(MessageFormat.format(rb.getString("EventBrokerService.properties.defaultEvent.fmt.txt"), this._defaultEvent));
            if (!this._bInitialized) {
                this._logger.debug(MessageFormat.format(rb.getString("EventBrokerService.properties.adminPort.fmt.txt"), new Integer(this._adminPort)));
                this._logger.debug(MessageFormat.format(rb.getString("EventBrokerService.properties.eventMgrThreads.fmt.txt"), new Integer(this._eventMgrThreads)));
                this._logger.debug(MessageFormat.format(rb.getString("EventBrokerService.properties.eventMgrEvents.fmt.txt"), new Integer(this._maxQueuedEvents)));
                this._logger.debug(MessageFormat.format(rb.getString("EventBrokerService.properties.tpMaxThreads.fmt.txt"), new Integer(this._tpMaxThreads)));
                this._logger.debug(MessageFormat.format(rb.getString("EventBrokerService.properties.tpMinSpareThreads.fmt.txt"), new Integer(this._tpMinSpares)));
                this._logger.debug(MessageFormat.format(rb.getString("EventBrokerService.properties.tpMaxSpareThreads.fmt.txt"), new Integer(this._tpMaxSpares)));
            }
        }
        if (!this._bInitialized) {
            try {
                list = serviceComponent.getInitProcesses();
            }
            catch (MdException mde) {
                throw new InitializationException(mde.getMessage());
            }
            size = list.size();
            if (size > 0) {
                Transformation transformation = (Transformation)list.elementAt(0);
                try {
                    list = transformation.getTransformationSources();
                }
                catch (MdException mde) {
                    throw new InitializationException(mde.getMessage());
                }
                size = list.size();
                for (int i = 0; i < size; ++i) {
                    CMetadata metadataObject = (CMetadata)list.elementAt(i);
                    if (!(metadataObject instanceof PropertySet)) continue;
                    PropertySet propertySet = (PropertySet)metadataObject;
                    String monitorName = propertySet.getName();
                    String monitorType = propertySet.getSetRole();
                    AssociationList propertiesList = null;
                    try {
                        propertiesList = propertySet.getProperties();
                    }
                    catch (MdException mde) {
                        throw new InitializationException(mde.getMessage());
                    }
                    HashMap<String, String> mapProperties = new HashMap<String, String>(5);
                    int propertiesSize = propertiesList.size();
                    for (int j = 0; j < propertiesSize; ++j) {
                        Property property = (Property)propertiesList.elementAt(j);
                        String propertyName = property.getPropertyName().toLowerCase();
                        String propertyValue = property.getDefaultValue();
                        if (property.getDefaultValue().length() <= 0) continue;
                        mapProperties.put(propertyName, propertyValue);
                    }
                    if (!monitorType.equals("RMI")) {
                        Root owningObject = null;
                        try {
                            owningObject = propertySet.getOwningObject();
                            if (owningObject != null) {
                                if (owningObject instanceof TCPIPConnection) {
                                    TCPIPConnection connection = (TCPIPConnection)owningObject;
                                    if (connection.getHostName().length() > 0) {
                                        mapProperties.put("host", connection.getHostName());
                                    }
                                    mapProperties.put("port", String.valueOf(connection.getPort()));
                                } else if (owningObject instanceof Directory) {
                                    mapProperties.put("dir", ((Directory)owningObject).getDirectoryName());
                                }
                            }
                        }
                        catch (MdException mde) {
                            throw new InitializationException(mde.getMessage());
                        }
                    }
                    if (monitorType.equals("RMI")) {
                        this._rmiTransportName = monitorName;
                        if (mapProperties.containsKey("default_event")) {
                            this._rmiDefaultEvent = (String)mapProperties.get("default_event");
                        }
                    } else {
                        this._monitors.add(new MonitorConfigurationElement(monitorName, monitorType, mapProperties));
                    }
                    if (!this._logger.isDebugEnabled()) continue;
                    this._logger.debug(rb.getString("EventBrokerService.monitor.configuration.txt"));
                    this._logger.debug(MessageFormat.format(rb.getString("EventBrokerService.monitor.name.fmt.txt"), monitorName));
                    this._logger.debug(MessageFormat.format(rb.getString("EventBrokerService.monitor.type.fmt.txt"), monitorType));
                    Iterator itKeys = mapProperties.entrySet().iterator();
                    Map.Entry mapEntry = null;
                    String key = null;
                    while (itKeys.hasNext()) {
                        mapEntry = itKeys.next();
                        key = (String)mapEntry.getKey();
                        if ("password".equals(key)) continue;
                        this._logger.debug(MessageFormat.format(rb.getString("EventBrokerService.monitor.nameValue.fmt.txt"), key, mapEntry.getValue()));
                    }
                }
            }
        }
        this._eventsConfig = new EventsConfiguration(this._defaultEvent);
        AssociationList eventsList = null;
        try {
            eventsList = serviceComponent.getRegisteredEvents();
        }
        catch (MdException mde) {
            throw new InitializationException(mde.getMessage());
        }
        int eventsListSz = eventsList.size();
        for (int i = 0; i < eventsListSz; ++i) {
            com.sas.metadata.Event objEvent = (com.sas.metadata.Event)eventsList.elementAt(i);
            String eventId = objEvent.getFQID();
            String eventName = objEvent.getName();
            String eventDesc = objEvent.getDesc();
            Event event = new Event(eventId, eventName, eventDesc);
            AssociationList propertiesList = null;
            try {
                propertiesList = objEvent.getProperties();
            }
            catch (MdException mde) {
                throw new InitializationException(mde.getMessage());
            }
            for (Property property : propertiesList) {
                if (property.getPropertyName().equals("EVENT_TYPE")) {
                    if (property.getDefaultValue().equals("1")) {
                        event.setType(1);
                        continue;
                    }
                    event.setType(0);
                    continue;
                }
                if (property.getPropertyName().equals("SECURITY_AUTH")) {
                    if (property.getDefaultValue().equals("1")) {
                        event.setSecurity(true);
                        continue;
                    }
                    event.setSecurity(false);
                    continue;
                }
                if (property.getPropertyName().equals("RUN_AS_IDENTITY")) {
                    if (property.getDefaultValue().equals("1")) {
                        event.setRunAsIdentity(1);
                        continue;
                    }
                    if (property.getDefaultValue().equals("2")) {
                        event.setRunAsIdentity(2);
                        continue;
                    }
                    if (property.getDefaultValue().equals("3")) {
                        event.setRunAsIdentity(3);
                        continue;
                    }
                    event.setRunAsIdentity(0);
                    continue;
                }
                if (property.getPropertyName().equals("USER_SPECIFIED_IDENTITY")) {
                    event.setUserId(property.getDefaultValue());
                    continue;
                }
                if (property.getPropertyName().equals("PASSWORD_SPECIFIED_IDENTITY")) {
                    String password = property.getDefaultValue();
                    try {
                        password = SasPasswordString.decode((String)password);
                    }
                    catch (SasPasswordEncodingException propertyValue) {
                        // empty catch block
                    }
                    event.setPassword(password);
                    continue;
                }
                if (!property.getPropertyName().equals("DOMAIN_SPECIFIED_IDENTITY")) continue;
                event.setDomain(property.getDefaultValue());
            }
            this._eventsConfig.addEvent(event);
            if (this._logger.isDebugEnabled()) {
                this._logger.debug(MessageFormat.format(rb.getString("EventBrokerService.event.configuration.fmt.txt"), eventId));
                this._logger.debug(MessageFormat.format(rb.getString("EventBrokerService.event.name.fmt.txt"), eventName));
                this._logger.debug(MessageFormat.format(rb.getString("EventBrokerService.event.desc.fmt.txt"), eventDesc));
                this._logger.debug(MessageFormat.format(rb.getString("EventBrokerService.event.type.fmt.txt"), new Integer(event.getType())));
                this._logger.debug(MessageFormat.format(rb.getString("EventBrokerService.event.secured.fmt.txt"), event.isSecured()));
                this._logger.debug(MessageFormat.format(rb.getString("EventBrokerService.event.runAsIdentity.fmt.txt"), new Integer(event.getRunAsIdentity())));
            }
            AssociationList TAList = null;
            try {
                TAList = objEvent.getTriggeredTransforms();
            }
            catch (MdException mde) {
                throw new InitializationException(mde.getMessage());
            }
            int TAListSz = TAList.size();
            block62: for (int j = 0; j < TAListSz; ++j) {
                TransformationActivity objTA = (TransformationActivity)TAList.elementAt(j);
                String flowId = objTA.getFQID();
                String flowName = objTA.getName();
                String flowDesc = objTA.getDesc();
                ProcessFlow processFlow = new ProcessFlow(flowId, flowName, flowDesc);
                event.addFlow(processFlow);
                int executionModel = 0;
                propertiesList = null;
                try {
                    propertiesList = objTA.getProperties();
                }
                catch (MdException mde) {
                    throw new InitializationException(mde.getMessage());
                }
                for (Property property : propertiesList) {
                    if (!property.getPropertyName().equals("EXECUTION_MODEL") || !property.getDefaultValue().equals("1")) continue;
                    processFlow.setAsyncMode();
                    executionModel = 1;
                }
                if (this._logger.isDebugEnabled()) {
                    this._logger.debug(MessageFormat.format(rb.getString("EventBrokerService.event.flow.configuration.fmt.txt"), flowId));
                    this._logger.debug(MessageFormat.format(rb.getString("EventBrokerService.event.flow.name.fmt.txt"), flowName));
                    this._logger.debug(MessageFormat.format(rb.getString("EventBrokerService.event.flow.desc.fmt.txt"), flowDesc));
                    this._logger.debug(MessageFormat.format(rb.getString("EventBrokerService.event.flow.executionModel.fmt.txt"), new Integer(executionModel)));
                }
                AssociationList stepsList = null;
                try {
                    stepsList = objTA.getSteps();
                }
                catch (MdException mde) {
                    throw new InitializationException(mde.getMessage());
                }
                boolean bFoundStart = false;
                int stepsListSz = stepsList.size();
                for (int k = 0; k < stepsListSz; ++k) {
                    HashSet<NodeInput> inputSet = new HashSet<NodeInput>();
                    HashSet<NodeOutput> outputSet = new HashSet<NodeOutput>();
                    HashMap<String, String> attributeMap = new HashMap<String, String>();
                    HashSet<String> predSet = new HashSet<String>();
                    HashSet<String> succSet = new HashSet<String>();
                    boolean bStart = false;
                    TransformationStep objTS = (TransformationStep)stepsList.elementAt(k);
                    String nodeId = objTS.getFQID();
                    String nodeName = objTS.getName();
                    String nodeDesc = objTS.getDesc();
                    AssociationList TList = null;
                    try {
                        TList = objTS.getTransformations();
                    }
                    catch (MdException mde) {
                        throw new InitializationException(mde.getMessage());
                    }
                    if (TList.size() == 0) {
                        this._logger.error(MessageFormat.format(rb.getString("EventBrokerService.parse.noTransformation.fmt.txt"), nodeName, nodeId));
                        throw new InitializationException(rb.getString("EventBrokerService.parse.ex.txt"));
                    }
                    Transformation objT = (Transformation)TList.elementAt(0);
                    AssociationList CLList = null;
                    try {
                        CLList = objT.getComputeLocations();
                    }
                    catch (MdException mde) {
                        throw new InitializationException(mde.getMessage());
                    }
                    if (CLList.size() == 0) {
                        this._logger.error(MessageFormat.format(rb.getString("EventBrokerService.parse.noComputeLocation.fmt.txt"), objT.getName(), objT.getFQID()));
                        throw new InitializationException(rb.getString("EventBrokerService.parse.ex.txt"));
                    }
                    DeployedComponent dc = (DeployedComponent)CLList.elementAt(0);
                    String nodeClassName = dc.getClassIdentifier();
                    if (this._logger.isDebugEnabled()) {
                        this._logger.debug(MessageFormat.format(rb.getString("EventBrokerService.event.flow.node.configuration.fmt.txt"), nodeId));
                        this._logger.debug(MessageFormat.format(rb.getString("EventBrokerService.event.flow.node.name.fmt.txt"), nodeName));
                        this._logger.debug(MessageFormat.format(rb.getString("EventBrokerService.event.flow.node.desc.fmt.txt"), nodeDesc));
                        this._logger.debug(MessageFormat.format(rb.getString("EventBrokerService.event.flow.node.class.fmt.txt"), nodeClassName));
                    }
                    AssociationList sourceList = null;
                    try {
                        sourceList = objT.getTransformationSources();
                    }
                    catch (MdException mde) {
                        throw new InitializationException(mde.getMessage());
                    }
                    int sourceListSz = sourceList.size();
                    for (int n = 0; n < sourceListSz; ++n) {
                        Property required;
                        String strRequired;
                        TextStore input = (TextStore)sourceList.elementAt(n);
                        String inputId = input.getFQID();
                        String inputName = input.getName();
                        String inputDesc = input.getDesc();
                        String inputFormat = input.getStoredText();
                        propertiesList = null;
                        try {
                            propertiesList = input.getProperties();
                        }
                        catch (MdException mde) {
                            throw new InitializationException(mde.getMessage());
                        }
                        boolean bRequired = true;
                        if (propertiesList.size() > 0 && (strRequired = (required = (Property)propertiesList.elementAt(0)).getDefaultValue()).equals("0")) {
                            bRequired = false;
                        }
                        AssociationList TTList = null;
                        try {
                            TTList = input.getTargetTransformations(false);
                        }
                        catch (MdException mde) {
                            throw new InitializationException(mde.getMessage());
                        }
                        if (TTList.size() == 0) {
                            this._logger.error(MessageFormat.format(rb.getString("EventBrokerService.parse.noTargetTransformation.fmt.txt"), input.getName(), input.getFQID()));
                            continue;
                        }
                        for (Transformation objT2 : TTList) {
                            AssociationList stepsList2 = null;
                            try {
                                stepsList2 = objT2.getSteps(false);
                            }
                            catch (MdException mde) {
                                throw new InitializationException(mde.getMessage());
                            }
                            if (stepsList2.size() == 0) {
                                this._logger.error(MessageFormat.format(rb.getString("EventBrokerService.parse.noTransformationStep.fmt.txt"), objT.getName(), objT.getFQID()));
                                throw new InitializationException(rb.getString("EventBrokerService.parse.ex.txt"));
                            }
                            TransformationStep objTS2 = (TransformationStep)stepsList2.elementAt(0);
                            String sourceNodeName = objTS2.getName();
                            NodeInput nodeInput = new NodeInput(inputId, inputName, inputDesc, inputFormat, bRequired, sourceNodeName);
                            inputSet.add(nodeInput);
                            if (this._logger.isDebugEnabled()) {
                                this._logger.debug(MessageFormat.format(rb.getString("EventBrokerService.event.flow.node.input.fmt.txt"), inputId));
                                this._logger.debug(MessageFormat.format(rb.getString("EventBrokerService.event.flow.node.input.name.fmt.txt"), inputName));
                                this._logger.debug(MessageFormat.format(rb.getString("EventBrokerService.event.flow.node.input.desc.fmt.txt"), inputDesc));
                                this._logger.debug(MessageFormat.format(rb.getString("EventBrokerService.event.flow.node.input.req.fmt.txt"), new Boolean(bRequired)));
                                this._logger.debug(MessageFormat.format(rb.getString("EventBrokerService.event.flow.node.input.source.fmt.txt"), sourceNodeName));
                            }
                            predSet.add(objTS2.getFQID());
                        }
                    }
                    AssociationList targetList = null;
                    try {
                        targetList = objT.getTransformationTargets();
                    }
                    catch (MdException mde) {
                        throw new InitializationException(mde.getMessage());
                    }
                    int targetListSz = targetList.size();
                    for (int n = 0; n < targetListSz; ++n) {
                        TextStore output = (TextStore)targetList.elementAt(n);
                        String outputId = output.getFQID();
                        String outputName = output.getName();
                        String outputDesc = output.getDesc();
                        String outputFormat = output.getStoredText();
                        NodeOutput nodeOutput = new NodeOutput(outputId, outputName, outputDesc, outputFormat);
                        outputSet.add(nodeOutput);
                        if (this._logger.isDebugEnabled()) {
                            this._logger.debug(MessageFormat.format(rb.getString("EventBrokerService.event.flow.node.output.fmt.txt"), outputId));
                            this._logger.debug(MessageFormat.format(rb.getString("EventBrokerService.event.flow.node.output.name.fmt.txt"), outputName));
                            this._logger.debug(MessageFormat.format(rb.getString("EventBrokerService.event.flow.node.output.desc.fmt.txt"), outputDesc));
                        }
                        AssociationList STList = null;
                        try {
                            STList = output.getSourceTransformations(false);
                        }
                        catch (MdException mde) {
                            throw new InitializationException(mde.getMessage());
                        }
                        if (STList.size() == 0) {
                            this._logger.error(MessageFormat.format(rb.getString("EventBrokerService.parse.noSourceTransformation.fmt.txt"), output.getName(), output.getFQID()));
                            continue;
                        }
                        for (Transformation objT2 : STList) {
                            AssociationList stepsList2 = null;
                            try {
                                stepsList2 = objT2.getSteps(false);
                            }
                            catch (MdException mde) {
                                throw new InitializationException(mde.getMessage());
                            }
                            if (stepsList2.size() == 0) {
                                this._logger.error(MessageFormat.format(rb.getString("EventBrokerService.parse.noTransformationStep.fmt.txt"), objT.getName(), objT.getFQID()));
                                throw new InitializationException(rb.getString("EventBrokerService.parse.ex.txt"));
                            }
                            TransformationStep objTS2 = (TransformationStep)stepsList2.elementAt(0);
                            succSet.add(objTS2.getFQID());
                        }
                    }
                    propertiesList = null;
                    try {
                        propertiesList = objT.getProperties();
                    }
                    catch (MdException mde) {
                        throw new InitializationException(mde.getMessage());
                    }
                    int propertiesListSz = propertiesList.size();
                    for (int n = 0; n < propertiesListSz; ++n) {
                        Property property = (Property)propertiesList.elementAt(n);
                        attributeMap.put(property.getPropertyName(), property.getDefaultValue());
                        this._logger.debug(MessageFormat.format(rb.getString("EventBrokerService.event.flow.node.attribute.fmt.txt"), property.getPropertyName(), property.getDefaultValue()));
                    }
                    if (predSet.isEmpty()) {
                        if (bFoundStart) {
                            this._logger.error(MessageFormat.format(rb.getString("EventBrokerService.parse.ambiguous.start.fmt.txt"), processFlow.getName(), processFlow.getId()));
                            this._logger.error(rb.getString("EventBrokerService.event.flow.discarded.txt"));
                            event.removeFlow(processFlow);
                            continue block62;
                        }
                        bStart = true;
                        bFoundStart = true;
                    }
                    FlowNode flowNode = new FlowNode(nodeId, nodeName, nodeDesc, nodeClassName, bStart, inputSet, outputSet, attributeMap, predSet, succSet);
                    processFlow.addNode(flowNode);
                    try {
                        flowNode.instantiate();
                        continue;
                    }
                    catch (Throwable t) {
                        this._logger.error(MessageFormat.format(rb.getString("EventBrokerService.event.flow.instantiate.exception.fmt.txt"), t.getClass().getName() + ": " + t.getMessage()));
                    }
                }
                if (bFoundStart) continue;
                this._logger.error(MessageFormat.format(rb.getString("EventBrokerService.parse.noStart.fmt.txt"), processFlow.getName(), processFlow.getId()));
                this._logger.error(rb.getString("EventBrokerService.event.flow.discarded.txt"));
                event.removeFlow(processFlow);
            }
        }
    }

    final ThreadPool getThreadPool() {
        return this._tp;
    }

    final EventContainer getEventContainer() {
        return this._eventContainer;
    }

    @Override
    @SASScope
    public String getHost() throws RemoteException {
        if (!this._bInitialized) {
            throw new IllegalStateException(rb.getString("EventBrokerService.notInitialized.ex.txt"));
        }
        String hostName = "";
        try {
            hostName = InetAddress.getLocalHost().getHostName();
        }
        catch (UnknownHostException unknownHostException) {
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
        return hostName;
    }

    @Override
    @SASScope
    public String getDescription() throws RemoteException {
        if (!this._bInitialized) {
            throw new IllegalStateException(rb.getString("EventBrokerService.notInitialized.ex.txt"));
        }
        return this._desc;
    }

    @Override
    @SASScope
    public String getConfiguration() throws RemoteException {
        if (!this._bInitialized) {
            throw new IllegalStateException(rb.getString("EventBrokerService.notInitialized.ex.txt"));
        }
        return "";
    }

    @Override
    @SASScope
    public boolean canProcess(String eventName, int eventType) throws RemoteException {
        if (!this._bInitialized) {
            throw new IllegalStateException(rb.getString("EventBrokerService.notInitialized.ex.txt"));
        }
        boolean canProcess = false;
        this._eventContainer._rwLock.readLock();
        boolean eventConfigured = this._eventContainer.isEventConfigured(eventName, eventType == 1);
        boolean eventListenedFor = this._eventContainer.isEventListenedFor(eventName, eventType == 1);
        if (eventConfigured || eventListenedFor) {
            canProcess = true;
        }
        this._eventContainer._rwLock.unlock();
        return canProcess;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @SASScope
    public String sendSyncEvent(String event) throws RemoteException {
        if (!this._bInitialized) {
            throw new IllegalStateException(rb.getString("EventBrokerService.notInitialized.ex.txt"));
        }
        String response = "";
        if (this._logger.isDebugEnabled()) {
            this._logger.debug(MessageFormat.format(rb.getString("EventBrokerService.receivedSyncEvent.fmt.txt"), this._rmiTransportName));
        }
        LocalResponseAgent responseAgent = new LocalResponseAgent();
        EventRequest eventRequest = new EventRequest(event, responseAgent);
        eventRequest.setSyncRequest();
        if (this._rmiDefaultEvent != null) {
            eventRequest.setDefaultEvent(this._rmiDefaultEvent);
        }
        try {
            this._eventContainer._mutex.lock();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        while (this._eventContainer.isFull()) {
            try {
                this._eventContainer._monitorCV.condWait(this._eventContainer._mutex);
            }
            catch (InterruptedException interruptedException) {}
        }
        this._eventContainer.add(eventRequest);
        try {
            this._eventContainer._mutex.unlock();
        }
        catch (MutexStateException mutexStateException) {
            // empty catch block
        }
        this._eventContainer._workerCV.condSignal();
        EventRequest eventRequest2 = eventRequest;
        synchronized (eventRequest2) {
            while (!eventRequest.isSyncComplete()) {
                if (this._logger.isDebugEnabled()) {
                    this._logger.debug(rb.getString("EventBrokerService.waitSyncCompletion.txt"));
                }
                try {
                    eventRequest.wait();
                }
                catch (InterruptedException interruptedException) {}
            }
            if (this._logger.isDebugEnabled()) {
                this._logger.debug(rb.getString("EventBrokerService.syncComplete.txt"));
            }
        }
        response = responseAgent.getResponse();
        return response;
    }

    @Override
    @SASScope
    public void sendAsyncEvent(String event, EventResponseHandlerInterface responseHandler) throws RemoteException {
        if (!this._bInitialized) {
            throw new IllegalStateException(rb.getString("EventBrokerService.notInitialized.ex.txt"));
        }
        if (this._logger.isDebugEnabled()) {
            this._logger.debug(MessageFormat.format(rb.getString("EventBrokerService.receivedAsyncEvent.fmt.txt"), this._rmiTransportName));
        }
        RMIResponseAgent responseAgent = new RMIResponseAgent(responseHandler);
        EventRequest eventRequest = new EventRequest(event, responseAgent);
        if (this._rmiDefaultEvent != null) {
            eventRequest.setDefaultEvent(this._rmiDefaultEvent);
        }
        try {
            this._eventContainer._mutex.lock();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        while (this._eventContainer.isFull()) {
            try {
                this._eventContainer._monitorCV.condWait(this._eventContainer._mutex);
            }
            catch (InterruptedException interruptedException) {}
        }
        this._eventContainer.add(eventRequest);
        try {
            this._eventContainer._mutex.unlock();
        }
        catch (MutexStateException mutexStateException) {
            // empty catch block
        }
        this._eventContainer._workerCV.condSignal();
    }

    @Override
    @SASScope
    public void addEventListener(String eventName, int eventType, ListenerInterface listener) throws RemoteException, InvalidEventTypeException {
        if (!this._bInitialized) {
            throw new IllegalStateException(rb.getString("EventBrokerService.notInitialized.ex.txt"));
        }
        this._eventContainer._rwLock.writeLock();
        if (this._logger.isDebugEnabled()) {
            this._logger.debug(MessageFormat.format(rb.getString("EventBrokerService.addListener.fmt.txt"), eventName));
        }
        if (eventType != 0 && eventType != 1) {
            this._eventContainer._rwLock.unlock();
            throw new InvalidEventTypeException(rb.getString("EventBrokerService.eventType.notSupported.txt"));
        }
        if (eventType == 1 && this._eventContainer.isEventListenedFor(eventName, true, false)) {
            this._eventContainer._rwLock.unlock();
            throw new InvalidEventTypeException(rb.getString("EventBrokerService.eventType.RRduplicate.txt"));
        }
        this._eventContainer.addEventListener(eventName, eventType, listener);
        this._eventContainer._rwLock.unlock();
    }

    @Override
    @SASScope
    public boolean removeEventListener(String eventName, int eventType, ListenerInterface listener) throws RemoteException {
        if (!this._bInitialized) {
            throw new IllegalStateException(rb.getString("EventBrokerService.notInitialized.ex.txt"));
        }
        this._eventContainer._rwLock.writeLock();
        if (this._logger.isDebugEnabled()) {
            this._logger.debug(MessageFormat.format(rb.getString("EventBrokerService.removeListener.fmt.txt"), eventName));
        }
        boolean bRemoved = this._eventContainer.removeEventListener(eventName, eventType, listener);
        this._eventContainer._rwLock.unlock();
        return bRemoved;
    }

    @SASScope
    public final RemoteServiceInterface getServiceProxy() {
        EventBrokerServiceProxy proxy = null;
        try {
            proxy = new EventBrokerServiceProxy(this);
        }
        catch (InitializationException e) {
            proxy = null;
        }
        return proxy;
    }

    @SASScope(value="ALL")
    public static void main(String[] args) {
        String fileName = null;
        if (args.length > 0) {
            fileName = args[0];
        }
        EventBrokerService broker = new EventBrokerService();
        try {
            try {
                SSLRMIConfiguration sslRMIConfiguration = new SSLRMIConfiguration((Properties)null);
                SSLRMISocketFactories.getInstance().setConfiguration(sslRMIConfiguration);
            }
            catch (IllegalArgumentException sslRMIConfiguration) {
                // empty catch block
            }
            broker.bootstrap(fileName);
        }
        catch (Throwable t) {
            t.printStackTrace();
            System.exit(-1);
        }
    }

    @SASScope
    protected void bootstrap(final String fileName) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                BootstrapFrame frame = new BootstrapFrame(rb.getString("EventBrokerService.bootstrap.frame.title.txt"), fileName);
                frame.init();
                frame.setVisible(true);
            }
        });
    }

    @SASScope
    private class BootstrapFrame
    extends JFrame {
        private static final long serialVersionUID = 1563523480020839661L;
        private static final String METADATA_SOURCE_FILE_EXTENSION = "config";
        private static final String PROPERTY_TYPE_OMR = "OMR";
        private static final String PROPERTY_TYPE_URL = "URL";
        private static final String PROPERTY_NAME_DEPLOYMENT_NAME = "software_component";
        private static final String PROPERTY_NAME_GROUP_NAME = "deployment_group_";
        private static final String PROPERTY_NAME_URL = "url";
        private static final String PROPERTY_NAME_HOST = "omr_host";
        private static final String PROPERTY_NAME_PORT = "omr_port";
        private static final String PROPERTY_NAME_USER = "omr_user";
        private static final String PROPERTY_NAME_PASS = "omr_password";
        private static final String PROPERTY_NAME_REPOS = "omr_repository";
        private static final String USER_HOME_DIR = "user.home";
        private static final String APP_FILE_NAME = "app.seb";
        private static final String MRU_PROPERTY_NAME = "MRU";
        private static final int MRU_MAX_ITEMS = 4;
        List _mruList;
        private static final int MRU_MENU_INDEX = 7;
        JMenu _fileMenu;
        JTextArea _console;
        MetadataSourceInfo _currentMetadataSourceInfo;

        public BootstrapFrame(String title, String fileName) {
            super(title);
            this._mruList = new ArrayList(4);
            if (fileName != null) {
                this._mruList.add(0, fileName);
            }
        }

        @Override
        protected void frameInit() {
            super.frameInit();
            this.setDefaultCloseOperation(3);
            this.addWindowListener(new WindowAdapter(){

                @Override
                public void windowClosing(WindowEvent e) {
                    BootstrapFrame.this.exit();
                }
            });
        }

        void init() {
            try {
                UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
                SwingUtilities.updateComponentTreeUI(this);
            }
            catch (UnsupportedLookAndFeelException unsupportedLookAndFeelException) {
            }
            catch (ClassNotFoundException classNotFoundException) {
            }
            catch (InstantiationException instantiationException) {
            }
            catch (IllegalAccessException illegalAccessException) {
                // empty catch block
            }
            this.makeConsole();
            this.initMRUList();
            this.makeMenus();
            this.pack();
            this.center();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void exit() {
            if (this._mruList.size() > 0) {
                OutputStream os = null;
                try {
                    StringBuffer userDir = new StringBuffer();
                    userDir.append((String)AccessController.doPrivileged(new GetPropertyAction(USER_HOME_DIR)));
                    userDir.append(File.separator);
                    userDir.append(APP_FILE_NAME);
                    File file = new File(userDir.toString());
                    os = new FileOutputStream(file, false);
                    Properties props = new Properties();
                    int i = 1;
                    for (String mru : this._mruList) {
                        props.setProperty(MRU_PROPERTY_NAME + i++, mru);
                    }
                    props.store(os, "SAS Foundation Services (sas.svc.events application) Properties file: !!!!! DO NOT EDIT !!!!!");
                }
                catch (SecurityException securityException) {
                }
                catch (FileNotFoundException fileNotFoundException) {
                }
                catch (IOException iOException) {
                }
                finally {
                    if (os != null) {
                        try {
                            os.close();
                        }
                        catch (IOException iOException) {}
                    }
                }
            }
            this.checkForUnsavedMetadataSource();
            LocalDiscoveryServiceInterface discoveryService = DiscoveryService.defaultInstance();
            try {
                discoveryService.destroy();
            }
            catch (ServiceException serviceException) {
            }
            catch (RemoteException remoteException) {
                // empty catch block
            }
            System.exit(0);
        }

        private void makeConsole() {
            this._console = new JTextArea();
            this._console.setLineWrap(false);
            this._console.setBackground(Color.BLACK);
            this._console.setForeground(Color.WHITE);
            this._console.setCaretColor(Color.WHITE);
            this._console.setCursor(Cursor.getPredefinedCursor(2));
            this._console.setSelectedTextColor(Color.BLACK);
            this._console.setSelectionColor(Color.WHITE);
            this._console.setEditable(true);
            JScrollPane scrollPane = new JScrollPane();
            scrollPane.setPreferredSize(new Dimension(500, 600));
            scrollPane.getViewport().add(this._console);
            this.getContentPane().add(scrollPane);
            final PrintStream ps = new PrintStream(System.out, true){

                @Override
                public void println(String s) {
                    BootstrapFrame.this.writeLineToConsole(s);
                }

                @Override
                public void println(char[] s) {
                    BootstrapFrame.this.writeLineToConsole(String.valueOf(s));
                }

                @Override
                public void println(char c) {
                    BootstrapFrame.this.writeLineToConsole(String.valueOf(c));
                }

                @Override
                public void println() {
                    BootstrapFrame.this.writeLineToConsole("");
                }

                @Override
                public void print(String s) {
                    BootstrapFrame.this.writeToConsole(s);
                }

                @Override
                public void print(char[] s) {
                    BootstrapFrame.this.writeToConsole(String.valueOf(s));
                }

                @Override
                public void print(char c) {
                    BootstrapFrame.this.writeToConsole(String.valueOf(c));
                }

                @Override
                public void write(byte[] buf, int off, int len) {
                    String s = new String(buf, off, len);
                    BootstrapFrame.this.writeToConsole(s);
                }
            };
            AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    System.setErr(ps);
                    System.setOut(ps);
                    return null;
                }
            });
        }

        void writeLineToConsole(String s) {
            this.writeToConsole(s + "\r\n");
        }

        void writeToConsole(final String s) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    BootstrapFrame.this._console.append(s);
                }
            });
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void initMRUList() {
            int i;
            block25: {
                InputStream is = null;
                try {
                    StringBuffer userDir = new StringBuffer();
                    userDir.append((String)AccessController.doPrivileged(new GetPropertyAction(USER_HOME_DIR)));
                    userDir.append(File.separator);
                    userDir.append(APP_FILE_NAME);
                    File file = new File(userDir.toString());
                    if (!file.exists()) break block25;
                    is = new FileInputStream(file);
                    Properties props = new Properties();
                    props.load(is);
                    for (int i2 = 1; i2 <= 4; ++i2) {
                        if (this._mruList.size() == 4) {
                            break;
                        }
                        String prop = MRU_PROPERTY_NAME + i2;
                        String fileName = props.getProperty(prop);
                        if (fileName == null || this._mruList.contains(fileName)) continue;
                        this._mruList.add(fileName);
                    }
                }
                catch (SecurityException se) {
                    this.writeLineToConsole(MessageFormat.format(rb.getString("EventBrokerService.bootstrap.initMRUList.SecurityException.ex.fmt.txt"), se.getMessage()));
                }
                catch (FileNotFoundException fnfe) {
                    this.writeLineToConsole(MessageFormat.format(rb.getString("EventBrokerService.bootstrap.initMRUList.FileNotFoundException.ex.fmt.txt"), fnfe.getMessage()));
                }
                catch (IOException ioe) {
                    this.writeLineToConsole(MessageFormat.format(rb.getString("EventBrokerService.bootstrap.initMRUList.IOException.ex.fmt.txt"), ioe.getMessage()));
                }
                finally {
                    if (is != null) {
                        try {
                            is.close();
                        }
                        catch (IOException se) {}
                    }
                }
            }
            boolean bReorder = false;
            int sz = this._mruList.size();
            for (i = 0; i < sz; ++i) {
                String fileName = (String)this._mruList.get(i);
                File file = new File(fileName);
                MetadataSourceInfo metadataSourceInfo = this.readMetadataSourceConfigFile(file);
                if (metadataSourceInfo != null) {
                    this._currentMetadataSourceInfo = metadataSourceInfo;
                    this.setTitle(rb.getString("EventBrokerService.bootstrap.frame.title.txt") + " - " + file.getName());
                    if (i == 0) break;
                    bReorder = true;
                    break;
                }
                this.writeLineToConsole(MessageFormat.format(rb.getString("EventBrokerService.bootstrap.initMRUList.readMetadataSource.ex.fmt.txt"), fileName));
            }
            if (bReorder) {
                String fileName = (String)this._mruList.remove(i);
                this._mruList.add(0, fileName);
            }
        }

        private void makeMenus() {
            JMenu menu;
            JMenuBar menuBar = new JMenuBar();
            this.setJMenuBar(menuBar);
            this._fileMenu = menu = new JMenu(rb.getString("EventBrokerService.bootstrap.frame.menu.file.txt"));
            menu.setMnemonic(70);
            menuBar.add(menu);
            JMenuItem menuItem = new JMenuItem(rb.getString("EventBrokerService.bootstrap.frame.menu.new.txt"), 78);
            menuItem.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    BootstrapFrame.this.newMetadataSourceAction();
                }
            });
            menu.add(menuItem);
            JMenu subMenu = new JMenu(rb.getString("EventBrokerService.bootstrap.frame.menu.open.txt"));
            subMenu.setMnemonic(79);
            menu.add(subMenu);
            menuItem = new JMenuItem(rb.getString("EventBrokerService.bootstrap.frame.menu.open.current.txt"), 67);
            menuItem.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    BootstrapFrame.this.openMetadataSourceAction(null);
                }
            });
            subMenu.add(menuItem);
            menuItem = new JMenuItem(rb.getString("EventBrokerService.bootstrap.frame.menu.open.file.txt"), 70);
            menuItem.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    BootstrapFrame.this.openMetadataSourceFromFileAction();
                }
            });
            subMenu.add(menuItem);
            menu.addSeparator();
            menuItem = new JMenuItem(rb.getString("EventBrokerService.bootstrap.frame.menu.save.txt"), 83);
            menuItem.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    BootstrapFrame.this.saveMetadataSourceAction();
                }
            });
            menu.add(menuItem);
            menuItem = new JMenuItem(rb.getString("EventBrokerService.bootstrap.frame.menu.saveAs.txt"), 65);
            menuItem.setDisplayedMnemonicIndex(21);
            menuItem.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    BootstrapFrame.this.saveAsMetadataSourceAction();
                }
            });
            menu.add(menuItem);
            menuItem = new JMenuItem(rb.getString("EventBrokerService.bootstrap.frame.menu.saveConsole.txt"), 67);
            menuItem.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    BootstrapFrame.this.saveConsoleAction();
                }
            });
            menu.add(menuItem);
            menu.addSeparator();
            if (this._mruList.size() > 0) {
                int i = 1;
                for (String mru : this._mruList) {
                    File file = new File(mru);
                    menuItem = new JMenuItem(i + file.getName());
                    menuItem.setMnemonic(new Integer(i).toString().charAt(0));
                    menuItem.addActionListener(new MRUActionListener(mru));
                    menu.add(menuItem);
                    ++i;
                }
                if (i > 1) {
                    menu.addSeparator();
                }
            }
            menuItem = new JMenuItem(rb.getString("EventBrokerService.bootstrap.frame.menu.exit.txt"), 88);
            menuItem.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    BootstrapFrame.this.exit();
                }
            });
            menu.add(menuItem);
            menu = new JMenu(rb.getString("EventBrokerService.bootstrap.frame.menu.edit.txt"));
            menu.setMnemonic(69);
            menuBar.add(menu);
            menuItem = new JMenuItem(rb.getString("EventBrokerService.bootstrap.frame.menu.cut.txt"), 84);
            menuItem.setAccelerator(KeyStroke.getKeyStroke(88, 2));
            menuItem.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    BootstrapFrame.this.cutAction();
                }
            });
            menuItem.setEnabled(false);
            this._console.addCaretListener(new ConsoleCaretListener(menuItem));
            menu.add(menuItem);
            menuItem = new JMenuItem(rb.getString("EventBrokerService.bootstrap.frame.menu.copy.txt"), 67);
            menuItem.setAccelerator(KeyStroke.getKeyStroke(67, 2));
            menuItem.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    BootstrapFrame.this.copyAction();
                }
            });
            menuItem.setEnabled(false);
            this._console.addCaretListener(new ConsoleCaretListener(menuItem));
            menu.add(menuItem);
            menuItem = new JMenuItem(rb.getString("EventBrokerService.bootstrap.frame.menu.paste.txt"), 80);
            menuItem.setAccelerator(KeyStroke.getKeyStroke(86, 2));
            menuItem.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    BootstrapFrame.this.pasteAction();
                }
            });
            menu.add(menuItem);
            menu.addSeparator();
            menuItem = new JMenuItem(rb.getString("EventBrokerService.bootstrap.frame.menu.selectAll.txt"), 65);
            menuItem.setAccelerator(KeyStroke.getKeyStroke(65, 2));
            menuItem.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    BootstrapFrame.this.selectAllAction();
                }
            });
            menu.add(menuItem);
            menu = new JMenu(rb.getString("EventBrokerService.bootstrap.frame.menu.deploy.txt"));
            menu.setMnemonic(68);
            menuBar.add(menu);
            menuItem = new JMenuItem(rb.getString("EventBrokerService.bootstrap.frame.menu.deploy.txt"), 68);
            menuItem.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    BootstrapFrame.this.deployAction();
                }
            });
            menu.add(menuItem);
            menuItem = new JMenuItem(rb.getString("EventBrokerService.bootstrap.frame.menu.redeploy.txt"), 82);
            menuItem.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    BootstrapFrame.this.redeployAction();
                }
            });
            menu.add(menuItem);
            menu = new JMenu(rb.getString("EventBrokerService.bootstrap.frame.menu.help.txt"));
            menu.setMnemonic(72);
            menuBar.add(menu);
            menuItem = new JMenuItem(rb.getString("EventBrokerService.bootstrap.frame.menu.about.txt"), 65);
            menuItem.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    BootstrapFrame.this.aboutAction();
                }
            });
            menu.add(menuItem);
        }

        void newMetadataSourceAction() {
            this.checkForUnsavedMetadataSource();
            MetadataSourceInfo metadataSourceInfo = new MetadataSourceInfo();
            metadataSourceInfo.setNew(true);
            MetadataSourceDialog dialog = new MetadataSourceDialog(this, rb.getString("EventBrokerService.bootstrap.dialog.title.txt") + " - " + rb.getString("EventBrokerService.bootstrap.frame.new.subtitle.txt"), metadataSourceInfo);
            dialog.showit();
            if (metadataSourceInfo.getReturnCode() == 0) {
                this._currentMetadataSourceInfo = metadataSourceInfo;
                this.setTitle(rb.getString("EventBrokerService.bootstrap.frame.title.txt") + " - *" + rb.getString("EventBrokerService.bootstrap.frame.new.subtitle.txt"));
            }
        }

        void openMetadataSourceAction(MetadataSourceInfo metadataSourceInfo) {
            if (metadataSourceInfo == null) {
                if (this._currentMetadataSourceInfo != null) {
                    String filename = rb.getString("EventBrokerService.bootstrap.frame.new.subtitle.txt");
                    if (this._currentMetadataSourceInfo.getFile() != null) {
                        filename = this._currentMetadataSourceInfo.getFile().getName();
                    }
                    MetadataSourceDialog dialog = new MetadataSourceDialog(this, rb.getString("EventBrokerService.bootstrap.dialog.title.txt") + " - " + filename, this._currentMetadataSourceInfo);
                    dialog.showit();
                    if (this._currentMetadataSourceInfo.getReturnCode() == 0 && this._currentMetadataSourceInfo.hasDataChanged() && !this._currentMetadataSourceInfo.isNew()) {
                        this.setTitle(rb.getString("EventBrokerService.bootstrap.frame.title.txt") + " - *" + this._currentMetadataSourceInfo.getFile().getName());
                    }
                } else {
                    this.newMetadataSourceAction();
                }
            } else {
                File newFile;
                File currentFile = null;
                if (this._currentMetadataSourceInfo != null) {
                    currentFile = this._currentMetadataSourceInfo.getFile();
                }
                if ((newFile = metadataSourceInfo.getFile()).equals(currentFile)) {
                    metadataSourceInfo = this._currentMetadataSourceInfo;
                } else {
                    this.checkForUnsavedMetadataSource();
                }
                MetadataSourceDialog dialog = new MetadataSourceDialog(this, rb.getString("EventBrokerService.bootstrap.dialog.title.txt") + " - " + metadataSourceInfo.getFile().getName(), metadataSourceInfo);
                dialog.showit();
                if (metadataSourceInfo.getReturnCode() == 0) {
                    this._currentMetadataSourceInfo = metadataSourceInfo;
                    String separator = null;
                    separator = this._currentMetadataSourceInfo.hasDataChanged() ? " - *" : " - ";
                    this.setTitle(rb.getString("EventBrokerService.bootstrap.frame.title.txt") + separator + this._currentMetadataSourceInfo.getFile().getName());
                    this.updateMRUList(this._currentMetadataSourceInfo.getFile());
                }
            }
        }

        void openMetadataSourceFromFileAction() {
            JFileChooser chooser = new JFileChooser();
            String dir = null;
            try {
                dir = (String)AccessController.doPrivileged(new GetPropertyAction(USER_HOME_DIR));
            }
            catch (Throwable t) {
                dir = ".";
            }
            chooser.setDialogTitle(rb.getString("EventBrokerService.bootstrap.filechooser.dialog.open.title.txt"));
            chooser.setApproveButtonToolTipText(rb.getString("EventBrokerService.bootstrap.filechooser.dialog.open.tooltip.txt"));
            chooser.setCurrentDirectory(new File(dir));
            chooser.removeChoosableFileFilter(chooser.getAcceptAllFileFilter());
            chooser.setFileFilter(new FileFilter(){

                @Override
                public String getDescription() {
                    return BootstrapFrame.METADATA_SOURCE_FILE_EXTENSION;
                }

                @Override
                public boolean accept(File f) {
                    if (f == null) {
                        return false;
                    }
                    if (f.isDirectory()) {
                        return true;
                    }
                    return f.getName().toLowerCase().endsWith(BootstrapFrame.METADATA_SOURCE_FILE_EXTENSION);
                }
            });
            if (chooser.showOpenDialog(this) != 0) {
                return;
            }
            File file = chooser.getSelectedFile();
            MetadataSourceInfo metadataSourceInfo = this.readMetadataSourceConfigFile(file);
            if (metadataSourceInfo != null) {
                this.openMetadataSourceAction(metadataSourceInfo);
            }
        }

        void checkForUnsavedMetadataSource() {
            if (this._currentMetadataSourceInfo != null && this._currentMetadataSourceInfo.hasDataChanged()) {
                Object[] options;
                String title = rb.getString("EventBrokerService.bootstrap.save.dialog.title.txt");
                String message = rb.getString("EventBrokerService.bootstrap.save.dialog.message.txt");
                int choice = JOptionPane.showOptionDialog(this, message, title, 0, 3, null, options = new Object[]{rb.getString("EventBrokerService.bootstrap.save.dialog.yes.txt"), rb.getString("EventBrokerService.bootstrap.save.dialog.no.txt")}, options[0]);
                if (choice == 0) {
                    this.saveMetadataSourceAction();
                }
            }
        }

        void saveMetadataSourceAction() {
            if (this._currentMetadataSourceInfo != null && this._currentMetadataSourceInfo.hasDataChanged()) {
                if (this._currentMetadataSourceInfo.isNew()) {
                    this.saveAsMetadataSourceAction();
                } else {
                    File file = this._currentMetadataSourceInfo.getFile();
                    if (this.saveMetadataSourceConfigFile(file)) {
                        this._currentMetadataSourceInfo.setState(0);
                        this.setTitle(rb.getString("EventBrokerService.bootstrap.frame.title.txt") + " - " + file.getName());
                    }
                }
            }
        }

        void saveAsMetadataSourceAction() {
            if (this._currentMetadataSourceInfo != null) {
                if (!this._currentMetadataSourceInfo.isNew()) {
                    this.checkForUnsavedMetadataSource();
                }
                JFileChooser chooser = new JFileChooser();
                String dir = null;
                try {
                    dir = (String)AccessController.doPrivileged(new GetPropertyAction(USER_HOME_DIR));
                }
                catch (Throwable t) {
                    dir = ".";
                }
                chooser.setDialogTitle(rb.getString("EventBrokerService.bootstrap.filechooser.dialog.save.title.txt"));
                chooser.setApproveButtonToolTipText(rb.getString("EventBrokerService.bootstrap.filechooser.dialog.save.tooltip.txt"));
                chooser.setCurrentDirectory(new File(dir));
                chooser.removeChoosableFileFilter(chooser.getAcceptAllFileFilter());
                chooser.setFileFilter(new FileFilter(){

                    @Override
                    public String getDescription() {
                        return BootstrapFrame.METADATA_SOURCE_FILE_EXTENSION;
                    }

                    @Override
                    public boolean accept(File f) {
                        if (f == null) {
                            return false;
                        }
                        if (f.isDirectory()) {
                            return true;
                        }
                        return f.getName().toLowerCase().endsWith(BootstrapFrame.METADATA_SOURCE_FILE_EXTENSION);
                    }
                });
                if (chooser.showSaveDialog(this) != 0) {
                    return;
                }
                File file = chooser.getSelectedFile();
                String fileName = file.getName();
                if (!fileName.endsWith(".config")) {
                    String path = file.getAbsolutePath();
                    file = new File(path + '.' + METADATA_SOURCE_FILE_EXTENSION);
                }
                if (this.saveMetadataSourceConfigFile(file)) {
                    this._currentMetadataSourceInfo.setState(0);
                    this._currentMetadataSourceInfo.setFile(file);
                    this.setTitle(rb.getString("EventBrokerService.bootstrap.frame.title.txt") + " - " + file.getName());
                    this.updateMRUList(file);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void saveConsoleAction() {
            JFileChooser chooser = new JFileChooser();
            String dir = null;
            try {
                dir = (String)AccessController.doPrivileged(new GetPropertyAction(USER_HOME_DIR));
            }
            catch (Throwable t) {
                dir = ".";
            }
            chooser.setDialogTitle(rb.getString("EventBrokerService.bootstrap.filechooser.dialog.saveConsole.title.txt"));
            chooser.setApproveButtonToolTipText(rb.getString("EventBrokerService.bootstrap.filechooser.dialog.saveConsole.tooltip.txt"));
            chooser.setCurrentDirectory(new File(dir));
            if (chooser.showSaveDialog(this) != 0) {
                return;
            }
            File file = chooser.getSelectedFile();
            BufferedWriter bw = null;
            try {
                bw = new BufferedWriter(new FileWriter(file));
                bw.write(this._console.getText());
            }
            catch (IOException ioe) {
                this.writeLineToConsole(MessageFormat.format(rb.getString("EventBrokerService.bootstrap.saveConsole.IOException.ex.fmt.txt"), file.getAbsolutePath(), ioe.getMessage()));
            }
            finally {
                if (bw != null) {
                    try {
                        bw.close();
                    }
                    catch (IOException iOException) {}
                }
            }
        }

        void cutAction() {
            this._console.cut();
        }

        void copyAction() {
            this._console.copy();
        }

        void pasteAction() {
            this._console.paste();
        }

        void selectAllAction() {
            this._console.selectAll();
        }

        void deployAction() {
            Thread t = new Thread(new DeployRunnable());
            t.start();
        }

        void redeployAction() {
            LocalDiscoveryServiceInterface discoveryService = DiscoveryService.defaultInstance();
            try {
                discoveryService.destroy();
            }
            catch (ServiceException se) {
                this.writeLineToConsole(MessageFormat.format(rb.getString("EventBrokerService.bootstrap.redeploy.ServiceException.ex.fmt.txt"), se.getMessage()));
            }
            catch (RemoteException re) {
                this.writeLineToConsole(MessageFormat.format(rb.getString("EventBrokerService.bootstrap.redeploy.RemoteException.ex.fmt.txt"), re.getMessage()));
            }
            this.deployAction();
        }

        void aboutAction() {
            String title = rb.getString("EventBrokerService.bootstrap.about.dialog.title.txt");
            JLabel message1 = new JLabel(rb.getString("EventBrokerService.bootstrap.about.dialog.message.part1.txt"));
            message1.setFont(new Font("SansSerif", 1, 12));
            String message2 = rb.getString("EventBrokerService.bootstrap.about.dialog.message.part2.txt");
            JOptionPane.showMessageDialog(this, new Object[]{message1, message2}, title, -1);
        }

        void updateMRUList(File file) {
            block7: {
                int sz;
                String fileName;
                block6: {
                    String curFileName;
                    File curFile;
                    int i;
                    fileName = file.getAbsolutePath();
                    sz = this._mruList.size();
                    for (i = 0; i < sz && !file.equals(curFile = new File(curFileName = (String)this._mruList.get(i))); ++i) {
                    }
                    if (i >= sz) break block6;
                    if (i == 0) break block7;
                    this._mruList.remove(i);
                    this._mruList.add(0, fileName);
                    JMenuItem menuItem = this._fileMenu.getItem(7 + i);
                    this._fileMenu.remove(menuItem);
                    int mnemonic = 1;
                    menuItem.setText(mnemonic + file.getName());
                    menuItem.setMnemonic(new Integer(mnemonic++).toString().charAt(0));
                    this._fileMenu.insert(menuItem, 7);
                    for (int j = 1; j <= i; ++j) {
                        menuItem = this._fileMenu.getItem(7 + j);
                        String tmpFileName = (String)this._mruList.get(j);
                        File tmpFile = new File(tmpFileName);
                        menuItem.setText(mnemonic + tmpFile.getName());
                        menuItem.setMnemonic(new Integer(mnemonic++).toString().charAt(0));
                    }
                    break block7;
                }
                if (this._mruList.size() == 4) {
                    this._mruList.remove(3);
                    this._fileMenu.remove(10);
                }
                this._mruList.add(0, fileName);
                int mnemonic = 1;
                JMenuItem menuItem = new JMenuItem(mnemonic + file.getName());
                menuItem.setMnemonic(new Integer(mnemonic++).toString().charAt(0));
                menuItem.addActionListener(new MRUActionListener(fileName));
                this._fileMenu.insert(menuItem, 7);
                sz = this._mruList.size();
                if (sz == 1) {
                    this._fileMenu.insertSeparator(8);
                } else {
                    for (int j = 1; j < this._mruList.size() && (menuItem = this._fileMenu.getItem(7 + j)) != null; ++j) {
                        String tmpFileName = (String)this._mruList.get(j);
                        File tmpFile = new File(tmpFileName);
                        menuItem.setText(mnemonic + tmpFile.getName());
                        menuItem.setMnemonic(new Integer(mnemonic++).toString().charAt(0));
                    }
                }
            }
        }

        MetadataSourceInfo readMetadataSourceConfigFile(File file) {
            MetadataSourceInfo metadataSourceInfo = null;
            try {
                String groupName;
                Properties props = new Properties();
                props.load(new FileInputStream(file));
                String url = props.getProperty(PROPERTY_NAME_URL);
                String host = props.getProperty(PROPERTY_NAME_HOST);
                String port = props.getProperty(PROPERTY_NAME_PORT);
                String user = props.getProperty(PROPERTY_NAME_USER);
                String pass = props.getProperty(PROPERTY_NAME_PASS);
                String repos = props.getProperty(PROPERTY_NAME_REPOS);
                String deploymentName = props.getProperty(PROPERTY_NAME_DEPLOYMENT_NAME);
                HashSet<String> groupNames = new HashSet<String>();
                int i = 1;
                while ((groupName = props.getProperty(PROPERTY_NAME_GROUP_NAME + i++)) != null) {
                    groupNames.add(groupName);
                }
                boolean bSuccess = true;
                String type = null;
                if (host != null) {
                    type = PROPERTY_TYPE_OMR;
                    if (port == null) {
                        this.writeLineToConsole(MessageFormat.format(rb.getString("EventBrokerService.bootstrap.readMetadataSource.missingPort.fmt.txt"), file.getAbsolutePath()));
                        bSuccess = false;
                    }
                    if (user == null) {
                        this.writeLineToConsole(MessageFormat.format(rb.getString("EventBrokerService.bootstrap.readMetadataSource.missingUser.fmt.txt"), file.getAbsolutePath()));
                        bSuccess = false;
                    }
                    if (pass == null) {
                        this.writeLineToConsole(MessageFormat.format(rb.getString("EventBrokerService.bootstrap.readMetadataSource.missingPass.fmt.txt"), file.getAbsolutePath()));
                        bSuccess = false;
                    }
                    if (repos == null) {
                        this.writeLineToConsole(MessageFormat.format(rb.getString("EventBrokerService.bootstrap.readMetadataSource.missingRepos.fmt.txt"), file.getAbsolutePath()));
                        bSuccess = false;
                    }
                } else {
                    type = PROPERTY_TYPE_URL;
                    if (url == null) {
                        this.writeLineToConsole(MessageFormat.format(rb.getString("EventBrokerService.bootstrap.readMetadataSource.missingHostURL.fmt.txt"), file.getAbsolutePath()));
                        bSuccess = false;
                    }
                }
                if (deploymentName == null) {
                    this.writeLineToConsole(MessageFormat.format(rb.getString("EventBrokerService.bootstrap.readMetadataSource.missingDeploymentName.fmt.txt"), file.getAbsolutePath()));
                    bSuccess = false;
                }
                if (bSuccess) {
                    metadataSourceInfo = new MetadataSourceInfo(type, url, host, port, user, pass, repos, deploymentName, groupNames);
                    metadataSourceInfo.setFile(file);
                }
            }
            catch (IOException ioe) {
                this.writeLineToConsole(MessageFormat.format(rb.getString("EventBrokerService.bootstrap.readMetadataSource.IOException.ex.fmt.txt"), file.getAbsolutePath(), ioe.getMessage()));
            }
            return metadataSourceInfo;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private boolean saveMetadataSourceConfigFile(File file) {
            boolean bSuccess = true;
            FileOutputStream os = null;
            try {
                os = new FileOutputStream(file, false);
                Properties props = new Properties();
                String deploymentName = this._currentMetadataSourceInfo.getDeploymentName();
                props.setProperty(PROPERTY_NAME_DEPLOYMENT_NAME, deploymentName);
                Set groupNames = this._currentMetadataSourceInfo.getGroupNames();
                Iterator groupNamesIter = groupNames.iterator();
                int i = 1;
                while (groupNamesIter.hasNext()) {
                    String groupName = (String)groupNamesIter.next();
                    props.setProperty(PROPERTY_NAME_GROUP_NAME + i, groupName);
                    ++i;
                }
                String type = this._currentMetadataSourceInfo.getType();
                if (type.equals(PROPERTY_TYPE_URL)) {
                    String url = this._currentMetadataSourceInfo.getURL();
                    props.setProperty(PROPERTY_NAME_URL, url);
                } else {
                    String host = this._currentMetadataSourceInfo.getHost();
                    props.setProperty(PROPERTY_NAME_HOST, host);
                    String port = this._currentMetadataSourceInfo.getPort();
                    props.setProperty(PROPERTY_NAME_PORT, port);
                    String user = this._currentMetadataSourceInfo.getUser();
                    props.setProperty(PROPERTY_NAME_USER, user);
                    String pass = this._currentMetadataSourceInfo.getPass();
                    props.setProperty(PROPERTY_NAME_PASS, pass);
                    String repos = this._currentMetadataSourceInfo.getRepos();
                    props.setProperty(PROPERTY_NAME_REPOS, repos);
                }
                props.store(os, "SAS Foundation Services properties file: !!!!! DO NOT EDIT !!!!!");
            }
            catch (SecurityException se) {
                this.writeLineToConsole(MessageFormat.format(rb.getString("EventBrokerService.bootstrap.saveMetadataSource.SecurityException.ex.fmt.txt"), file.getAbsolutePath(), se.getMessage()));
                bSuccess = false;
            }
            catch (FileNotFoundException fnfe) {
                this.writeLineToConsole(MessageFormat.format(rb.getString("EventBrokerService.bootstrap.saveMetadataSource.FileNotFoundException.ex.fmt.txt"), file.getAbsolutePath(), fnfe.getMessage()));
                bSuccess = false;
            }
            catch (IOException ioe) {
                this.writeLineToConsole(MessageFormat.format(rb.getString("EventBrokerService.bootstrap.saveMetadataSource.IOException.ex.fmt.txt"), file.getAbsolutePath(), ioe.getMessage()));
                bSuccess = false;
            }
            finally {
                if (os != null) {
                    try {
                        ((OutputStream)os).close();
                    }
                    catch (IOException se) {}
                }
            }
            return bSuccess;
        }

        private void center() {
            Dimension mySize = this.getSize();
            Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
            this.setLocation((screenSize.width >> 1) - (mySize.width >> 1), (screenSize.height >> 1) - (mySize.height >> 1));
        }

        @SASScope
        private class cBasicPasswordFieldUI
        extends BasicPasswordFieldUI {
            private cBasicPasswordFieldUI() {
            }

            public Color getDefaultBgColor() {
                String key = super.getPropertyPrefix() + ".background";
                return UIManager.getColor(key);
            }
        }

        @SASScope
        private class cBasicTextFieldUI
        extends BasicTextFieldUI {
            private cBasicTextFieldUI() {
            }

            public Color getDefaultBgColor() {
                String key = super.getPropertyPrefix() + ".background";
                return UIManager.getColor(key);
            }
        }

        @SASScope
        private class IntTextField
        extends JTextField {
            private static final long serialVersionUID = 3258407352716637232L;

            public IntTextField() {
                this.setHorizontalAlignment(4);
            }

            @Override
            protected Document createDefaultModel() {
                return new PlainDocument(){
                    private static final long serialVersionUID = 3258413923899225143L;

                    @Override
                    public void insertString(int iText, String sText, AttributeSet a) throws BadLocationException {
                        if (sText == null || sText.length() == 0) {
                            return;
                        }
                        char[] caSource = sText.toCharArray();
                        char[] caResult = new char[caSource.length];
                        boolean bError = false;
                        int iResult = 0;
                        for (int iSource = 0; iSource < caSource.length; ++iSource) {
                            if (Character.isDigit(caSource[iSource])) {
                                caResult[iResult++] = caSource[iSource];
                                continue;
                            }
                            bError = true;
                        }
                        if (bError) {
                            Toolkit.getDefaultToolkit().beep();
                        }
                        super.insertString(iText, new String(caResult, 0, iResult), a);
                    }
                };
            }
        }

        @SASScope
        private class MetadataSourceInfo {
            private String _type = "OMR";
            private String _url = "";
            private String _host = "";
            private String _port = "";
            private String _user = "";
            private String _pass = "";
            private String _repos = "";
            private String _deploymentName = "";
            private Set _groupNames = new HashSet();
            private int _returnCode;
            private File _file;
            static final int METADATA_SOURCE_STATE_NEW = 1;
            static final int METADATA_SOURCE_STATE_CHANGED = 2;
            private int _state;

            public MetadataSourceInfo() {
            }

            public MetadataSourceInfo(String type, String url, String host, String port, String user, String pass, String repos, String deploymentName, Set groupNames) {
                this._type = type;
                this._url = url;
                this._host = host;
                this._port = port;
                this._user = user;
                this._pass = pass;
                this._repos = repos;
                this._deploymentName = deploymentName;
                this._groupNames = groupNames;
            }

            public final void setType(String type) {
                this._type = type;
            }

            public final String getType() {
                return this._type;
            }

            public final void setURL(String url) {
                this._url = url;
            }

            public final String getURL() {
                return this._url;
            }

            public final void setHost(String host) {
                this._host = host;
            }

            public final String getHost() {
                return this._host;
            }

            public final void setPort(String port) {
                this._port = port;
            }

            public final String getPort() {
                return this._port;
            }

            public final void setUser(String user) {
                this._user = user;
            }

            public final String getUser() {
                return this._user;
            }

            public final void setPass(String pass) {
                this._pass = pass;
            }

            public final String getPass() {
                return this._pass;
            }

            public final void setRepos(String repos) {
                this._repos = repos;
            }

            public final String getRepos() {
                return this._repos;
            }

            public final void setDeploymentName(String deploymentName) {
                this._deploymentName = deploymentName;
            }

            public final String getDeploymentName() {
                return this._deploymentName;
            }

            public final void setGroupNames(Set groupNames) {
                this._groupNames = groupNames;
            }

            public final Set getGroupNames() {
                return this._groupNames;
            }

            public final void setReturnCode(int returnCode) {
                this._returnCode = returnCode;
            }

            public final int getReturnCode() {
                return this._returnCode;
            }

            public final void setState(int state) {
                this._state = state;
            }

            public final int getState() {
                return this._state;
            }

            public void setNew(boolean bNew) {
                this._state = bNew ? (this._state |= 1) : (this._state &= 0xFFFFFFFE);
            }

            public boolean isNew() {
                boolean bNew = false;
                if ((this._state & 1) != 0) {
                    bNew = true;
                }
                return bNew;
            }

            public void setDataChanged(boolean bChanged) {
                this._state = bChanged ? (this._state |= 2) : (this._state &= 0xFFFFFFFD);
            }

            public boolean hasDataChanged() {
                boolean bChanged = false;
                if ((this._state & 2) != 0) {
                    bChanged = true;
                }
                return bChanged;
            }

            public final void setFile(File file) {
                this._file = file;
            }

            public final File getFile() {
                return this._file;
            }
        }

        @SASScope
        private class MetadataSourceDialog
        extends JDialog {
            private static final long serialVersionUID = 3258688793316899129L;
            static final int OK = 0;
            static final int CANCEL = 1;
            JLabel _URLLbl;
            JTextField _URLText;
            JLabel _hostLbl;
            JTextField _hostText;
            JLabel _portLbl;
            IntTextField _portText;
            JLabel _userLbl;
            JTextField _userText;
            JLabel _passLbl;
            JPasswordField _passText;
            JLabel _reposLbl;
            JTextField _reposText;
            JRadioButton _radURL;
            JRadioButton _radOMR;
            JLabel _deploymentNameLbl;
            JTextField _deploymentNameText;
            JLabel _groupNamesLbl;
            JList _groupNamesList;
            JScrollPane _groupNamesListScroll;
            DefaultListModel _groupNamesListModel;
            JButton _groupNamesAddBtn;
            JButton _groupNamesEditBtn;
            JButton _groupNamesRemoveBtn;
            JButton _btnOK;
            JButton _btnCancel;
            cKeyHandler _keyHandler;
            MetadataSourceInfo _metadataSourceInfo;

            public MetadataSourceDialog() {
                this._keyHandler = new cKeyHandler();
                throw new IllegalArgumentException();
            }

            public MetadataSourceDialog(Frame frame, String title, MetadataSourceInfo metadataSourceInfo) {
                super(frame, title, true);
                this._keyHandler = new cKeyHandler();
                this._metadataSourceInfo = metadataSourceInfo;
                this.setResizable(true);
            }

            public void showit() {
                this.initialize();
                this.layoutWidgets();
                this.pack();
                this.doDataExchange(false);
                this.setVisible(true);
            }

            private void initialize() {
                String labelWithMnemonic;
                this._metadataSourceInfo.setReturnCode(1);
                this._URLText = new JTextField();
                this._URLText.setToolTipText(rb.getString("EventBrokerService.bootstrap.dialog.url.tooltip.txt"));
                this._URLText.setColumns(20);
                this._URLText.setUI(new cBasicTextFieldUI());
                String label = labelWithMnemonic = rb.getString("EventBrokerService.bootstrap.dialog.url.label.txt");
                this._URLLbl = new JLabel(label);
                this._URLLbl.setLabelFor(this._URLText);
                this._URLLbl.setDisplayedMnemonic(rb.getString("EventBrokerService.bootstrap.dialog.url.label.txt").charAt(0));
                this._hostText = new JTextField();
                this._hostText.setToolTipText(rb.getString("EventBrokerService.bootstrap.dialog.host.tooltip.txt"));
                this._hostText.setUI(new cBasicTextFieldUI());
                label = labelWithMnemonic = rb.getString("EventBrokerService.bootstrap.dialog.host.label.txt");
                this._hostLbl = new JLabel(label);
                this._hostLbl.setLabelFor(this._hostText);
                this._hostLbl.setDisplayedMnemonic(rb.getString("EventBrokerService.bootstrap.dialog.host.label.txt").charAt(0));
                this._portText = new IntTextField();
                this._portText.setToolTipText(rb.getString("EventBrokerService.bootstrap.dialog.port.tooltip.txt"));
                this._portText.setUI(new cBasicTextFieldUI());
                label = labelWithMnemonic = rb.getString("EventBrokerService.bootstrap.dialog.port.label.txt");
                this._portLbl = new JLabel(label);
                this._portLbl.setLabelFor(this._portText);
                this._portLbl.setDisplayedMnemonic(rb.getString("EventBrokerService.bootstrap.dialog.port.label.txt").charAt(0));
                this._userText = new JTextField();
                this._userText.setToolTipText(rb.getString("EventBrokerService.bootstrap.dialog.user.tooltip.txt"));
                this._userText.setUI(new cBasicTextFieldUI());
                label = labelWithMnemonic = rb.getString("EventBrokerService.bootstrap.dialog.user.label.txt");
                this._userLbl = new JLabel(label);
                this._userLbl.setLabelFor(this._userText);
                this._userLbl.setDisplayedMnemonic(rb.getString("EventBrokerService.bootstrap.dialog.user.label.txt").charAt(4));
                this._passText = new JPasswordField();
                this._passText.setToolTipText(rb.getString("EventBrokerService.bootstrap.dialog.pass.tooltip.txt"));
                this._passText.setUI(new cBasicPasswordFieldUI());
                label = labelWithMnemonic = rb.getString("EventBrokerService.bootstrap.dialog.pass.label.txt");
                this._passLbl = new JLabel(label);
                this._passLbl.setLabelFor(this._passText);
                this._passLbl.setDisplayedMnemonic(rb.getString("EventBrokerService.bootstrap.dialog.pass.label.txt").charAt(4));
                this._reposText = new JTextField();
                this._reposText.setToolTipText(rb.getString("EventBrokerService.bootstrap.dialog.repos.tooltip.txt"));
                this._reposText.setUI(new cBasicTextFieldUI());
                label = labelWithMnemonic = rb.getString("EventBrokerService.bootstrap.dialog.repos.label.txt");
                this._reposLbl = new JLabel(label);
                this._reposLbl.setLabelFor(this._reposText);
                this._reposLbl.setDisplayedMnemonic(rb.getString("EventBrokerService.bootstrap.dialog.repos.label.txt").charAt(6));
                ButtonGroup group = new ButtonGroup();
                label = labelWithMnemonic = rb.getString("EventBrokerService.bootstrap.dialog.URLGroup.txt");
                this._radURL = new JRadioButton(label);
                this._radURL.setMnemonic(rb.getString("EventBrokerService.bootstrap.dialog.URLGroup.txt").charAt(0));
                this._radURL.setFont(new Font("SansSerif", 1, 12));
                this._radURL.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        MetadataSourceDialog.this._URLText.setEnabled(true);
                        MetadataSourceDialog.this._URLText.setBackground(((cBasicTextFieldUI)MetadataSourceDialog.this._URLText.getUI()).getDefaultBgColor());
                        MetadataSourceDialog.this._hostText.setEnabled(false);
                        MetadataSourceDialog.this._hostText.setBackground(null);
                        MetadataSourceDialog.this._portText.setEnabled(false);
                        MetadataSourceDialog.this._portText.setBackground(null);
                        MetadataSourceDialog.this._userText.setEnabled(false);
                        MetadataSourceDialog.this._userText.setBackground(null);
                        MetadataSourceDialog.this._passText.setEnabled(false);
                        MetadataSourceDialog.this._passText.setBackground(null);
                        MetadataSourceDialog.this._reposText.setEnabled(false);
                        MetadataSourceDialog.this._reposText.setBackground(null);
                        MetadataSourceDialog.this._metadataSourceInfo.setDataChanged(true);
                    }
                });
                group.add(this._radURL);
                label = labelWithMnemonic = rb.getString("EventBrokerService.bootstrap.dialog.OMRGroup.txt");
                this._radOMR = new JRadioButton(label);
                this._radOMR.setMnemonic(rb.getString("EventBrokerService.bootstrap.dialog.OMRGroup.txt").charAt(13));
                this._radOMR.setFont(new Font("SansSerif", 1, 12));
                this._radOMR.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        MetadataSourceDialog.this._hostText.setEnabled(true);
                        MetadataSourceDialog.this._hostText.setBackground(((cBasicTextFieldUI)MetadataSourceDialog.this._hostText.getUI()).getDefaultBgColor());
                        MetadataSourceDialog.this._portText.setEnabled(true);
                        MetadataSourceDialog.this._portText.setBackground(((cBasicTextFieldUI)MetadataSourceDialog.this._portText.getUI()).getDefaultBgColor());
                        MetadataSourceDialog.this._userText.setEnabled(true);
                        MetadataSourceDialog.this._userText.setBackground(((cBasicTextFieldUI)MetadataSourceDialog.this._userText.getUI()).getDefaultBgColor());
                        MetadataSourceDialog.this._passText.setEnabled(true);
                        MetadataSourceDialog.this._passText.setBackground(((cBasicPasswordFieldUI)MetadataSourceDialog.this._passText.getUI()).getDefaultBgColor());
                        MetadataSourceDialog.this._reposText.setEnabled(true);
                        MetadataSourceDialog.this._reposText.setBackground(((cBasicTextFieldUI)MetadataSourceDialog.this._reposText.getUI()).getDefaultBgColor());
                        MetadataSourceDialog.this._URLText.setEnabled(false);
                        MetadataSourceDialog.this._URLText.setBackground(null);
                        MetadataSourceDialog.this._metadataSourceInfo.setDataChanged(true);
                    }
                });
                group.add(this._radOMR);
                this._deploymentNameText = new JTextField();
                this._deploymentNameText.setToolTipText(rb.getString("EventBrokerService.bootstrap.dialog.serviceDeployment.tooltip.txt"));
                label = labelWithMnemonic = rb.getString("EventBrokerService.bootstrap.dialog.serviceDeployment.label.txt");
                this._deploymentNameLbl = new JLabel(label);
                this._deploymentNameLbl.setLabelFor(this._deploymentNameText);
                this._deploymentNameLbl.setDisplayedMnemonic(rb.getString("EventBrokerService.bootstrap.dialog.serviceDeployment.label.txt").charAt(0));
                this._groupNamesListModel = new DefaultListModel();
                this._groupNamesList = new JList(this._groupNamesListModel);
                this._groupNamesList.setToolTipText(rb.getString("EventBrokerService.bootstrap.dialog.deploymentGroup.tooltip.txt"));
                label = labelWithMnemonic = rb.getString("EventBrokerService.bootstrap.dialog.deploymentGroup.label.txt");
                this._groupNamesLbl = new JLabel(label);
                this._groupNamesLbl.setLabelFor(this._groupNamesList);
                this._groupNamesLbl.setDisplayedMnemonic(rb.getString("EventBrokerService.bootstrap.dialog.deploymentGroup.label.txt").charAt(0));
                this._groupNamesListScroll = new JScrollPane();
                this._groupNamesListScroll.setPreferredSize(new Dimension(150, 50));
                this._groupNamesListScroll.getViewport().add(this._groupNamesList);
                Dimension dim = new Dimension(76, 27);
                this._groupNamesAddBtn = new JButton(rb.getString("EventBrokerService.bootstrap.dialog.deploymentGroup.add.button.txt"));
                this._groupNamesAddBtn.setToolTipText(rb.getString("EventBrokerService.bootstrap.dialog.deploymentGroup.add.button.tooltip.txt"));
                this._groupNamesAddBtn.setPreferredSize(dim);
                this._groupNamesAddBtn.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        String title = rb.getString("EventBrokerService.bootstrap.dialog.addGroupName.title.txt");
                        String message = rb.getString("EventBrokerService.bootstrap.dialog.addGroupName.message.txt");
                        String groupName = JOptionPane.showInputDialog(MetadataSourceDialog.this, message, title, -1);
                        if (groupName != null && groupName.length() > 0) {
                            MetadataSourceDialog.this._groupNamesListModel.addElement(groupName);
                        }
                    }
                });
                this._groupNamesEditBtn = new JButton(rb.getString("EventBrokerService.bootstrap.dialog.deploymentGroup.edit.button.txt"));
                this._groupNamesEditBtn.setEnabled(false);
                this._groupNamesEditBtn.setToolTipText(rb.getString("EventBrokerService.bootstrap.dialog.deploymentGroup.edit.button.tooltip.txt"));
                this._groupNamesEditBtn.setPreferredSize(dim);
                this._groupNamesEditBtn.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        int index = MetadataSourceDialog.this._groupNamesList.getSelectedIndex();
                        if (index >= 0) {
                            String groupName = (String)MetadataSourceDialog.this._groupNamesListModel.get(index);
                            String title = rb.getString("EventBrokerService.bootstrap.dialog.editGroupName.title.txt");
                            String message = rb.getString("EventBrokerService.bootstrap.dialog.editGroupName.message.txt");
                            groupName = (String)JOptionPane.showInputDialog(MetadataSourceDialog.this, message, title, -1, null, null, groupName);
                            if (groupName != null && groupName.length() > 0) {
                                MetadataSourceDialog.this._groupNamesListModel.set(index, groupName);
                            }
                        }
                    }
                });
                this._groupNamesRemoveBtn = new JButton(rb.getString("EventBrokerService.bootstrap.dialog.deploymentGroup.remove.button.txt"));
                this._groupNamesRemoveBtn.setEnabled(false);
                this._groupNamesRemoveBtn.setToolTipText(rb.getString("EventBrokerService.bootstrap.dialog.deploymentGroup.remove.button.tooltip.txt"));
                this._groupNamesRemoveBtn.setPreferredSize(dim);
                this._groupNamesRemoveBtn.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        int maxIndex;
                        int minIndex = MetadataSourceDialog.this._groupNamesList.getMinSelectionIndex();
                        for (int i = maxIndex = MetadataSourceDialog.this._groupNamesList.getMaxSelectionIndex(); i >= minIndex; --i) {
                            if (!MetadataSourceDialog.this._groupNamesList.isSelectedIndex(i)) continue;
                            MetadataSourceDialog.this._groupNamesListModel.remove(i);
                        }
                    }
                });
                this._groupNamesList.addListSelectionListener(new ListSelectionListener(){

                    @Override
                    public void valueChanged(ListSelectionEvent e) {
                        if (!e.getValueIsAdjusting()) {
                            int[] selectedIndices = MetadataSourceDialog.this._groupNamesList.getSelectedIndices();
                            boolean bEnableEdit = false;
                            if (selectedIndices.length == 1) {
                                bEnableEdit = true;
                            }
                            MetadataSourceDialog.this._groupNamesEditBtn.setEnabled(bEnableEdit);
                            boolean bEnableRemove = false;
                            if (selectedIndices.length >= 1) {
                                bEnableRemove = true;
                            }
                            MetadataSourceDialog.this._groupNamesRemoveBtn.setEnabled(bEnableRemove);
                        }
                    }
                });
                this._btnOK = new JButton(rb.getString("EventBrokerService.bootstrap.dialog.OK.button.txt"));
                this._btnOK.setPreferredSize(dim);
                this.getRootPane().setDefaultButton(this._btnOK);
                this._btnOK.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        MetadataSourceDialog.this.onOK();
                    }
                });
                this._btnCancel = new JButton(rb.getString("EventBrokerService.bootstrap.dialog.Cancel.button.txt"));
                this._btnCancel.setPreferredSize(dim);
                this._btnCancel.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        MetadataSourceDialog.this.onCancel();
                    }
                });
            }

            private void layoutWidgets() {
                JPanel mainPanel = new JPanel();
                mainPanel.setLayout(new GridBagLayout());
                Border outerBorder = BorderFactory.createEmptyBorder(7, 7, 7, 7);
                Border innerBorder = BorderFactory.createRaisedBevelBorder();
                CompoundBorder mainBorder = BorderFactory.createCompoundBorder(outerBorder, innerBorder);
                mainPanel.setBorder(mainBorder);
                JPanel metadataSourcePanel = new JPanel();
                metadataSourcePanel.setLayout(new GridBagLayout());
                metadataSourcePanel.setBorder(new TitledBorder(BorderFactory.createEtchedBorder(), rb.getString("EventBrokerService.bootstrap.dialog.source.border.txt")));
                metadataSourcePanel.add((Component)this._radURL, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 18, 0, new Insets(0, 12, 0, 0), 0, 0));
                metadataSourcePanel.add((Component)this._URLLbl, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 24, 0, 0), 0, 0));
                metadataSourcePanel.add((Component)this._URLText, new GridBagConstraints(1, 1, 0, 1, 1.0, 0.0, 17, 2, new Insets(0, 12, 0, 12), 0, 0));
                metadataSourcePanel.add((Component)this._radOMR, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 18, 0, new Insets(12, 12, 0, 0), 0, 0));
                metadataSourcePanel.add((Component)this._hostLbl, new GridBagConstraints(0, 3, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 24, 0, 0), 0, 0));
                metadataSourcePanel.add((Component)this._hostText, new GridBagConstraints(1, 3, 0, 1, 1.0, 0.0, 17, 2, new Insets(0, 12, 0, 12), 0, 0));
                metadataSourcePanel.add((Component)this._portLbl, new GridBagConstraints(0, 4, 1, 1, 0.0, 0.0, 17, 0, new Insets(12, 24, 0, 0), 0, 0));
                metadataSourcePanel.add((Component)this._portText, new GridBagConstraints(1, 4, 0, 1, 1.0, 0.0, 17, 2, new Insets(12, 12, 0, 12), 0, 0));
                metadataSourcePanel.add((Component)this._userLbl, new GridBagConstraints(0, 5, 1, 1, 0.0, 0.0, 17, 0, new Insets(12, 24, 0, 0), 0, 0));
                metadataSourcePanel.add((Component)this._userText, new GridBagConstraints(1, 5, 0, 1, 1.0, 0.0, 17, 2, new Insets(12, 12, 0, 12), 0, 0));
                metadataSourcePanel.add((Component)this._passLbl, new GridBagConstraints(0, 6, 1, 1, 0.0, 0.0, 17, 0, new Insets(12, 24, 0, 0), 0, 0));
                metadataSourcePanel.add((Component)this._passText, new GridBagConstraints(1, 6, 0, 1, 1.0, 0.0, 17, 2, new Insets(12, 12, 0, 12), 0, 0));
                metadataSourcePanel.add((Component)this._reposLbl, new GridBagConstraints(0, 7, 1, 1, 0.0, 0.0, 17, 0, new Insets(12, 24, 12, 0), 0, 0));
                metadataSourcePanel.add((Component)this._reposText, new GridBagConstraints(1, 7, 0, 1, 1.0, 0.0, 17, 2, new Insets(12, 12, 12, 12), 0, 0));
                JPanel deploymentPanel = new JPanel();
                deploymentPanel.setLayout(new GridBagLayout());
                deploymentPanel.setBorder(new TitledBorder(BorderFactory.createEtchedBorder(), rb.getString("EventBrokerService.bootstrap.dialog.deployment.border.txt")));
                deploymentPanel.add((Component)this._deploymentNameLbl, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(12, 12, 0, 0), 0, 0));
                deploymentPanel.add((Component)this._deploymentNameText, new GridBagConstraints(1, 0, 0, 1, 1.0, 0.0, 17, 2, new Insets(12, 12, 0, 12), 0, 0));
                JPanel groupNamesPanel = new JPanel();
                groupNamesPanel.setLayout(new GridBagLayout());
                groupNamesPanel.setBorder(new TitledBorder(BorderFactory.createEtchedBorder()));
                groupNamesPanel.add((Component)this._groupNamesLbl, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(12, 12, 0, 12), 0, 0));
                groupNamesPanel.add((Component)this._groupNamesListScroll, new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 17, 1, new Insets(6, 12, 12, 12), 0, 0));
                JPanel groupNamesBtnPanel = new JPanel();
                groupNamesBtnPanel.setLayout(new GridBagLayout());
                groupNamesBtnPanel.add((Component)this._groupNamesAddBtn, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 12, 0, 12), 0, 0));
                groupNamesBtnPanel.add((Component)this._groupNamesEditBtn, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(6, 12, 0, 12), 0, 0));
                groupNamesBtnPanel.add((Component)this._groupNamesRemoveBtn, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 17, 0, new Insets(6, 12, 0, 12), 0, 0));
                groupNamesPanel.add((Component)groupNamesBtnPanel, new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(6, 12, 12, 12), 0, 0));
                deploymentPanel.add((Component)groupNamesPanel, new GridBagConstraints(0, 1, 0, 1, 1.0, 1.0, 17, 1, new Insets(12, 12, 12, 12), 0, 0));
                mainPanel.add((Component)metadataSourcePanel, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 17, 2, new Insets(7, 1, 7, 1), 0, 0));
                mainPanel.add((Component)deploymentPanel, new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 17, 1, new Insets(7, 1, 7, 1), 0, 0));
                this.getContentPane().add((Component)mainPanel, "Center");
                this.addKeyListeners(mainPanel, this._keyHandler);
                JPanel buttonsPanel = new JPanel();
                buttonsPanel.setBorder(BorderFactory.createEmptyBorder(7, 7, 7, 7));
                buttonsPanel.add(this._btnOK);
                buttonsPanel.add(this._btnCancel);
                this.getContentPane().add((Component)buttonsPanel, "South");
            }

            private boolean doDataExchange(boolean bSaveToModel) {
                if (bSaveToModel) {
                    if (this._metadataSourceInfo.hasDataChanged()) {
                        if (this._radURL.isSelected()) {
                            this._metadataSourceInfo.setType(BootstrapFrame.PROPERTY_TYPE_URL);
                        } else {
                            this._metadataSourceInfo.setType(BootstrapFrame.PROPERTY_TYPE_OMR);
                        }
                        this._metadataSourceInfo.setURL(this._URLText.getText().trim());
                        this._metadataSourceInfo.setHost(this._hostText.getText().trim());
                        this._metadataSourceInfo.setPort(this._portText.getText().trim());
                        this._metadataSourceInfo.setUser(this._userText.getText().trim());
                        String password = String.valueOf(this._passText.getPassword());
                        if (password != null && !SasPasswordString.isEncoded((String)password)) {
                            try {
                                password = SasPasswordString.encode((String)password);
                            }
                            catch (SasPasswordEncodingException sasPasswordEncodingException) {
                                // empty catch block
                            }
                        }
                        this._metadataSourceInfo.setPass(password);
                        this._metadataSourceInfo.setRepos(this._reposText.getText().trim());
                        this._metadataSourceInfo.setDeploymentName(this._deploymentNameText.getText().trim());
                        HashSet<String> groupNames = new HashSet<String>();
                        int sz = this._groupNamesListModel.getSize();
                        for (int i = 0; i < sz; ++i) {
                            String groupName = (String)this._groupNamesListModel.get(i);
                            groupNames.add(groupName);
                        }
                        this._metadataSourceInfo.setGroupNames(groupNames);
                    }
                } else {
                    if (this._metadataSourceInfo.getType().equals(BootstrapFrame.PROPERTY_TYPE_OMR)) {
                        this._radURL.setSelected(false);
                        this._radOMR.setSelected(true);
                        this._hostText.setEnabled(true);
                        this._hostText.setBackground(((cBasicTextFieldUI)this._hostText.getUI()).getDefaultBgColor());
                        this._portText.setEnabled(true);
                        this._portText.setBackground(((cBasicTextFieldUI)this._portText.getUI()).getDefaultBgColor());
                        this._userText.setEnabled(true);
                        this._userText.setBackground(((cBasicTextFieldUI)this._userText.getUI()).getDefaultBgColor());
                        this._passText.setEnabled(true);
                        this._passText.setBackground(((cBasicPasswordFieldUI)this._passText.getUI()).getDefaultBgColor());
                        this._reposText.setEnabled(true);
                        this._reposText.setBackground(((cBasicTextFieldUI)this._reposText.getUI()).getDefaultBgColor());
                        this._URLText.setEnabled(false);
                        this._URLText.setBackground(null);
                    } else {
                        this._radURL.setSelected(true);
                        this._radOMR.setSelected(false);
                        this._URLText.setEnabled(true);
                        this._URLText.setBackground(((cBasicTextFieldUI)this._URLText.getUI()).getDefaultBgColor());
                        this._hostText.setEnabled(false);
                        this._hostText.setBackground(null);
                        this._portText.setEnabled(false);
                        this._portText.setBackground(null);
                        this._userText.setEnabled(false);
                        this._userText.setBackground(null);
                        this._passText.setEnabled(false);
                        this._passText.setBackground(null);
                        this._reposText.setEnabled(false);
                        this._reposText.setBackground(null);
                    }
                    String s = this._metadataSourceInfo.getURL();
                    if (s != null) {
                        this._URLText.setText(s);
                    }
                    if ((s = this._metadataSourceInfo.getHost()) != null) {
                        this._hostText.setText(s);
                    }
                    if ((s = this._metadataSourceInfo.getPort()) != null) {
                        this._portText.setText(s);
                    }
                    if ((s = this._metadataSourceInfo.getUser()) != null) {
                        this._userText.setText(s);
                    }
                    if ((s = this._metadataSourceInfo.getPass()) != null) {
                        String password = s;
                        try {
                            password = SasPasswordString.decode((String)password);
                        }
                        catch (SasPasswordEncodingException sz) {
                            // empty catch block
                        }
                        this._passText.setText(password);
                    }
                    if ((s = this._metadataSourceInfo.getRepos()) != null) {
                        this._reposText.setText(s);
                    }
                    if ((s = this._metadataSourceInfo.getDeploymentName()) != null) {
                        this._deploymentNameText.setText(s);
                    }
                    Set groupNames = this._metadataSourceInfo.getGroupNames();
                    for (String groupName : groupNames) {
                        this._groupNamesListModel.addElement(groupName);
                    }
                    this._URLText.getDocument().addDocumentListener(new DocumentListener(){

                        @Override
                        public void changedUpdate(DocumentEvent e) {
                            MetadataSourceDialog.this._metadataSourceInfo.setDataChanged(true);
                        }

                        @Override
                        public void insertUpdate(DocumentEvent e) {
                            MetadataSourceDialog.this._metadataSourceInfo.setDataChanged(true);
                        }

                        @Override
                        public void removeUpdate(DocumentEvent e) {
                            MetadataSourceDialog.this._metadataSourceInfo.setDataChanged(true);
                        }
                    });
                    this._hostText.getDocument().addDocumentListener(new DocumentListener(){

                        @Override
                        public void changedUpdate(DocumentEvent e) {
                            MetadataSourceDialog.this._metadataSourceInfo.setDataChanged(true);
                        }

                        @Override
                        public void insertUpdate(DocumentEvent e) {
                            MetadataSourceDialog.this._metadataSourceInfo.setDataChanged(true);
                        }

                        @Override
                        public void removeUpdate(DocumentEvent e) {
                            MetadataSourceDialog.this._metadataSourceInfo.setDataChanged(true);
                        }
                    });
                    this._portText.getDocument().addDocumentListener(new DocumentListener(){

                        @Override
                        public void changedUpdate(DocumentEvent e) {
                            MetadataSourceDialog.this._metadataSourceInfo.setDataChanged(true);
                        }

                        @Override
                        public void insertUpdate(DocumentEvent e) {
                            MetadataSourceDialog.this._metadataSourceInfo.setDataChanged(true);
                        }

                        @Override
                        public void removeUpdate(DocumentEvent e) {
                            MetadataSourceDialog.this._metadataSourceInfo.setDataChanged(true);
                        }
                    });
                    this._userText.getDocument().addDocumentListener(new DocumentListener(){

                        @Override
                        public void changedUpdate(DocumentEvent e) {
                            MetadataSourceDialog.this._metadataSourceInfo.setDataChanged(true);
                        }

                        @Override
                        public void insertUpdate(DocumentEvent e) {
                            MetadataSourceDialog.this._metadataSourceInfo.setDataChanged(true);
                        }

                        @Override
                        public void removeUpdate(DocumentEvent e) {
                            MetadataSourceDialog.this._metadataSourceInfo.setDataChanged(true);
                        }
                    });
                    this._passText.getDocument().addDocumentListener(new DocumentListener(){

                        @Override
                        public void changedUpdate(DocumentEvent e) {
                            MetadataSourceDialog.this._metadataSourceInfo.setDataChanged(true);
                        }

                        @Override
                        public void insertUpdate(DocumentEvent e) {
                            MetadataSourceDialog.this._metadataSourceInfo.setDataChanged(true);
                        }

                        @Override
                        public void removeUpdate(DocumentEvent e) {
                            MetadataSourceDialog.this._metadataSourceInfo.setDataChanged(true);
                        }
                    });
                    this._reposText.getDocument().addDocumentListener(new DocumentListener(){

                        @Override
                        public void changedUpdate(DocumentEvent e) {
                            MetadataSourceDialog.this._metadataSourceInfo.setDataChanged(true);
                        }

                        @Override
                        public void insertUpdate(DocumentEvent e) {
                            MetadataSourceDialog.this._metadataSourceInfo.setDataChanged(true);
                        }

                        @Override
                        public void removeUpdate(DocumentEvent e) {
                            MetadataSourceDialog.this._metadataSourceInfo.setDataChanged(true);
                        }
                    });
                    this._deploymentNameText.getDocument().addDocumentListener(new DocumentListener(){

                        @Override
                        public void changedUpdate(DocumentEvent e) {
                            MetadataSourceDialog.this._metadataSourceInfo.setDataChanged(true);
                        }

                        @Override
                        public void insertUpdate(DocumentEvent e) {
                            MetadataSourceDialog.this._metadataSourceInfo.setDataChanged(true);
                        }

                        @Override
                        public void removeUpdate(DocumentEvent e) {
                            MetadataSourceDialog.this._metadataSourceInfo.setDataChanged(true);
                        }
                    });
                    this._groupNamesListModel.addListDataListener(new ListDataListener(){

                        @Override
                        public void intervalAdded(ListDataEvent e) {
                            MetadataSourceDialog.this._metadataSourceInfo.setDataChanged(true);
                        }

                        @Override
                        public void intervalRemoved(ListDataEvent e) {
                            MetadataSourceDialog.this._metadataSourceInfo.setDataChanged(true);
                        }

                        @Override
                        public void contentsChanged(ListDataEvent e) {
                            MetadataSourceDialog.this._metadataSourceInfo.setDataChanged(true);
                        }
                    });
                }
                return true;
            }

            private boolean validateData() {
                if (this._radURL.isSelected()) {
                    if (this._URLText.getText().trim().length() <= 0) {
                        this._URLText.requestFocus();
                        Toolkit.getDefaultToolkit().beep();
                        JOptionPane.showMessageDialog(this, rb.getString("EventBrokerService.bootstrap.invalid.URL.txt"), rb.getString("EventBrokerService.bootstrap.invalid.title.txt"), 0);
                        return false;
                    }
                } else {
                    if (this._hostText.getText().trim().length() <= 0) {
                        this._hostText.requestFocus();
                        Toolkit.getDefaultToolkit().beep();
                        JOptionPane.showMessageDialog(this, rb.getString("EventBrokerService.bootstrap.invalid.host.txt"), rb.getString("EventBrokerService.bootstrap.invalid.title.txt"), 0);
                        return false;
                    }
                    if (this._portText.getText().trim().length() <= 0) {
                        this._portText.requestFocus();
                        Toolkit.getDefaultToolkit().beep();
                        JOptionPane.showMessageDialog(this, rb.getString("EventBrokerService.bootstrap.invalid.port.txt"), rb.getString("EventBrokerService.bootstrap.invalid.title.txt"), 0);
                        return false;
                    }
                    if (this._userText.getText().trim().length() <= 0) {
                        this._userText.requestFocus();
                        Toolkit.getDefaultToolkit().beep();
                        JOptionPane.showMessageDialog(this, rb.getString("EventBrokerService.bootstrap.invalid.user.txt"), rb.getString("EventBrokerService.bootstrap.invalid.title.txt"), 0);
                        return false;
                    }
                    if (this._passText.getPassword().length <= 0) {
                        this._passText.requestFocus();
                        Toolkit.getDefaultToolkit().beep();
                        JOptionPane.showMessageDialog(this, rb.getString("EventBrokerService.bootstrap.invalid.password.txt"), rb.getString("EventBrokerService.bootstrap.invalid.title.txt"), 0);
                        return false;
                    }
                    if (this._reposText.getText().length() <= 0) {
                        this._reposText.requestFocus();
                        Toolkit.getDefaultToolkit().beep();
                        JOptionPane.showMessageDialog(this, rb.getString("EventBrokerService.bootstrap.invalid.repos.txt"), rb.getString("EventBrokerService.bootstrap.invalid.title.txt"), 0);
                        return false;
                    }
                }
                if (this._deploymentNameText.getText().length() <= 0) {
                    this._deploymentNameText.requestFocus();
                    Toolkit.getDefaultToolkit().beep();
                    JOptionPane.showMessageDialog(this, rb.getString("EventBrokerService.bootstrap.invalid.deployment.txt"), rb.getString("EventBrokerService.bootstrap.invalid.title.txt"), 0);
                    return false;
                }
                return true;
            }

            void onOK() {
                if (this.validateData()) {
                    this.doDataExchange(true);
                    this._metadataSourceInfo.setReturnCode(0);
                    this.dispose();
                }
            }

            void onCancel() {
                this._metadataSourceInfo.setReturnCode(1);
                this.dispose();
            }

            private void addKeyListeners(Container container, cKeyHandler keyHandler) {
                Component[] components = container.getComponents();
                int length = components.length;
                for (int i = 0; i < length; ++i) {
                    components[i].addKeyListener(keyHandler);
                    if (!(components[i] instanceof Container)) continue;
                    this.addKeyListeners((Container)components[i], keyHandler);
                }
            }

            @SASScope
            protected class cKeyHandler
            extends KeyAdapter {
                protected cKeyHandler() {
                }

                @Override
                public void keyPressed(KeyEvent e) {
                    int eKeyCode = e.getKeyCode();
                    switch (eKeyCode) {
                        case 27: {
                            MetadataSourceDialog.this.onCancel();
                            break;
                        }
                        case 10: {
                            break;
                        }
                    }
                }
            }
        }

        @SASScope
        class ConsoleCaretListener
        implements CaretListener {
            private JMenuItem _menuItem;

            public ConsoleCaretListener(JMenuItem menuItem) {
                if (menuItem == null) {
                    throw new IllegalArgumentException();
                }
                this._menuItem = menuItem;
            }

            @Override
            public void caretUpdate(CaretEvent e) {
                int dot = e.getDot();
                int mark = e.getMark();
                boolean bEnabled = false;
                if (dot != mark) {
                    bEnabled = true;
                }
                this._menuItem.setEnabled(bEnabled);
            }
        }

        @SASScope
        class MRUActionListener
        implements ActionListener {
            String _fileName;

            public MRUActionListener(String fileName) {
                if (fileName == null) {
                    throw new IllegalArgumentException();
                }
                this._fileName = fileName;
            }

            @Override
            public void actionPerformed(ActionEvent e) {
                File file = new File(this._fileName);
                MetadataSourceInfo metadataSourceInfo = BootstrapFrame.this.readMetadataSourceConfigFile(file);
                if (metadataSourceInfo != null) {
                    BootstrapFrame.this.openMetadataSourceAction(metadataSourceInfo);
                }
            }
        }

        @SASScope
        class DeployRunnable
        implements Runnable {
            DeployRunnable() {
            }

            @Override
            public void run() {
                if (BootstrapFrame.this._currentMetadataSourceInfo != null) {
                    BootstrapFrame.this.writeLineToConsole(rb.getString("EventBrokerService.bootstrap.deploy.action.txt"));
                    URLMetadataSource metadataSource = null;
                    LocalDiscoveryServiceInterface discoveryService = DiscoveryService.defaultInstance();
                    String deploymentName = BootstrapFrame.this._currentMetadataSourceInfo.getDeploymentName();
                    Set groupNames = BootstrapFrame.this._currentMetadataSourceInfo.getGroupNames();
                    if (BootstrapFrame.this._currentMetadataSourceInfo.getType().equals(BootstrapFrame.PROPERTY_TYPE_URL)) {
                        URL metadataURL = null;
                        try {
                            metadataURL = new URL(BootstrapFrame.this._currentMetadataSourceInfo.getURL());
                        }
                        catch (MalformedURLException me) {
                            BootstrapFrame.this.writeLineToConsole(MessageFormat.format(rb.getString("EventBrokerService.bootstrap.deploy.MalFormedURLException.ex.fmt.txt"), me.getMessage()));
                            return;
                        }
                        try {
                            metadataSource = new URLMetadataSource(metadataURL, deploymentName, groupNames);
                        }
                        catch (InitializationException ie) {
                            BootstrapFrame.this.writeLineToConsole(MessageFormat.format(rb.getString("EventBrokerService.bootstrap.deploy.URLMetadataSource.InitalizationException.ex.fmt.txt"), ie.getMessage()));
                            return;
                        }
                    }
                    String host = BootstrapFrame.this._currentMetadataSourceInfo.getHost();
                    String port = BootstrapFrame.this._currentMetadataSourceInfo.getPort();
                    String user = BootstrapFrame.this._currentMetadataSourceInfo.getUser();
                    String pass = BootstrapFrame.this._currentMetadataSourceInfo.getPass();
                    String repos = BootstrapFrame.this._currentMetadataSourceInfo.getRepos();
                    try {
                        metadataSource = new OMRMetadataSource(host, port, user, pass, repos, deploymentName, groupNames);
                    }
                    catch (InitializationException ie) {
                        BootstrapFrame.this.writeLineToConsole(MessageFormat.format(rb.getString("EventBrokerService.bootstrap.deploy.OMRMetadataSource.InitalizationException.ex.fmt.txt"), ie.getMessage()));
                        return;
                    }
                    try {
                        ServiceLoader.deployServices((MetadataSourceInterface)metadataSource, (DiscoveryServiceInterface)discoveryService);
                    }
                    catch (ServiceException se) {
                        BootstrapFrame.this.writeLineToConsole(MessageFormat.format(rb.getString("EventBrokerService.bootstrap.deploy.ServiceException.ex.fmt.txt"), se.getMessage()));
                        return;
                    }
                    try {
                        Services services = DiscoveryService.defaultInstance().findServices(new ServiceTemplate(new Class[]{EventBrokerServiceInterface.class}, null), Integer.MAX_VALUE, null);
                        BootstrapFrame.this.writeLineToConsole(MessageFormat.format(rb.getString("EventBrokerService.bootstrap.deploy.success.fmt.txt"), new Integer(services.size())));
                    }
                    catch (ServiceException se) {
                        BootstrapFrame.this.writeLineToConsole(MessageFormat.format(rb.getString("EventBrokerService.bootstrap.deploy.failure.ex.fmt.txt"), se.getMessage()));
                        try {
                            discoveryService.destroy();
                        }
                        catch (Throwable throwable) {
                        }
                    }
                    catch (RemoteException re) {
                        BootstrapFrame.this.writeLineToConsole(MessageFormat.format(rb.getString("EventBrokerService.bootstrap.deploy.failure.ex.fmt.txt"), re.getMessage()));
                        try {
                            discoveryService.destroy();
                        }
                        catch (Throwable throwable) {}
                    }
                } else {
                    BootstrapFrame.this.newMetadataSourceAction();
                    if (BootstrapFrame.this._currentMetadataSourceInfo != null) {
                        BootstrapFrame.this.deployAction();
                    }
                }
            }
        }
    }
}

