/*
 * Decompiled with CFR 0.152.
 */
package com.sas.services.events.broker;

import com.sas.codepolicy.SASScope;
import com.sas.services.events.ApplicationMonitorResources;
import com.sas.services.events.broker.AdminCommandProcessor;
import com.sas.services.events.broker.EventBrokerService;
import com.sas.services.events.broker.RB;
import com.sas.services.events.broker.util.ActiveTaskElement;
import com.sas.services.events.broker.util.EventContainer;
import com.sas.services.events.broker.util.MutexStateException;
import com.sas.services.events.broker.util.ThreadPool;
import com.sas.services.logging.util.LoggerMonitor2;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketException;
import java.text.MessageFormat;
import java.util.Locale;
import java.util.ResourceBundle;
import java.util.Set;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@SASScope
public class AdminServer {
    private EventBrokerService _service;
    private ServerSocket _adminSocket;
    private EventContainer _eventContainer;
    private Logger _logger = null;
    private LoggerMonitor2 _applicationMonitorLogger;
    private boolean bAutomaticQuiesce = false;
    public static final String COMMAND_QUIESCE = "quiesce";
    public static final String COMMAND_SHUTDOWN = "shutdown";
    public static final String COMMAND_UPDATE = "update";
    public static final String COMMAND_DISPLAYTHREADS = "displaythreads";
    public static final String COMMAND_KILLTHREAD = "killthread";
    private static final String RB_KEY = "AdminServer.";
    private static ResourceBundle rb = RB.getResources();

    public AdminServer(EventBrokerService service, ServerSocket adminSocket, EventContainer eventContainer) {
        this._service = service;
        this._adminSocket = adminSocket;
        this._eventContainer = eventContainer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start() {
        this._logger = LogManager.getLogger((String)this.getClass().getName());
        this._applicationMonitorLogger = new LoggerMonitor2(LogManager.getLogger((String)"ApplicationMonitor.EventBrokerService"));
        Socket socket = null;
        try {
            while (true) {
                socket = this._adminSocket.accept();
                if (this._logger != null && this._logger.isInfoEnabled()) {
                    this._logger.info(MessageFormat.format(rb.getString("AdminServer.connection.fmt.txt"), socket.toString()));
                }
                BufferedReader reader = new BufferedReader(new InputStreamReader(socket.getInputStream(), "UTF-8"));
                BufferedWriter writer = new BufferedWriter(new OutputStreamWriter(socket.getOutputStream(), "UTF-8"));
                String command = reader.readLine();
                Locale locale = AdminServer.getClientLocale(reader);
                if (this._applicationMonitorLogger != null && this._applicationMonitorLogger.isLoggingEnabled()) {
                    this._applicationMonitorLogger.log(ApplicationMonitorResources.COLUMN_ACTION, ApplicationMonitorResources.ACTION_ADMIN_REQUEST, ApplicationMonitorResources.COLUMN_EVENT_NAME, "", ApplicationMonitorResources.COLUMN_HANDLER_NAME, "", ApplicationMonitorResources.COLUMN_INFORMATION, command);
                }
                if (this._logger != null && this._logger.isInfoEnabled()) {
                    this._logger.info(MessageFormat.format(rb.getString("AdminServer.requestedCommand.fmt.txt"), command));
                }
                if (command.equals(COMMAND_QUIESCE)) {
                    this.quiesce();
                    writer.write(RB.getStringResource("AdminServer.success.txt", locale));
                    writer.newLine();
                    writer.flush();
                    socket.close();
                    socket = null;
                    break;
                }
                if (command.equals(COMMAND_SHUTDOWN)) {
                    this.shutdown();
                    writer.write(RB.getStringResource("AdminServer.success.txt", locale));
                    writer.newLine();
                    writer.flush();
                    socket.close();
                    socket = null;
                    break;
                }
                if (command.equals(COMMAND_UPDATE) || command.equals(COMMAND_DISPLAYTHREADS) || command.equals(COMMAND_KILLTHREAD)) {
                    Thread t = new Thread(new AdminCommandProcessor(command, socket, reader, writer, this._service, this._eventContainer, locale));
                    t.setName(this.getClass().getName() + "_commandProcessor_" + t.getName());
                    t.start();
                    continue;
                }
                if (this._logger != null) {
                    this._logger.error(MessageFormat.format(rb.getString("AdminServer.unknownCommand.fmt.txt"), command));
                }
                writer.write(RB.getStringResource("AdminServer.commandUnrecognized.txt", locale));
                writer.flush();
                socket.close();
                socket = null;
            }
        }
        catch (SocketException se) {
            if (this._logger != null && this._logger.isInfoEnabled()) {
                this._logger.info(MessageFormat.format(rb.getString("AdminServer.socketException.fmt.txt"), se.getMessage()));
            }
            this.bAutomaticQuiesce = true;
        }
        catch (IOException e) {
            if (this._logger != null) {
                this._logger.error(MessageFormat.format(rb.getString("AdminServer.ioException.fmt.txt"), e.getMessage()));
            }
            this.bAutomaticQuiesce = true;
        }
        catch (Throwable t) {
            if (this._logger != null) {
                this._logger.error(MessageFormat.format(rb.getString("AdminServer.exception.fmt.txt"), t.getClass().getName() + ": " + t.getMessage()));
            }
            this.bAutomaticQuiesce = true;
        }
        finally {
            if (this.bAutomaticQuiesce) {
                this.quiesce();
            }
            if (this._adminSocket != null) {
                try {
                    this._adminSocket.close();
                }
                catch (Throwable se) {}
            }
            if (socket != null) {
                try {
                    socket.close();
                }
                catch (Throwable se) {}
            }
            this._logger = null;
        }
    }

    private void quiesce() {
        try {
            this._eventContainer._mutex.lock();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        this._eventContainer._stop = true;
        try {
            this._eventContainer._mutex.unlock();
        }
        catch (MutexStateException mutexStateException) {
            // empty catch block
        }
    }

    private void shutdown() {
        try {
            this._eventContainer._mutex.lock();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        this._eventContainer._stop = true;
        this._eventContainer._drain = true;
        try {
            this._eventContainer._mutex.unlock();
        }
        catch (MutexStateException mutexStateException) {
            // empty catch block
        }
        ThreadPool tp = this._eventContainer.getThreadPool();
        Set activeTasks = tp.getActiveTasks();
        for (ActiveTaskElement ate : activeTasks) {
            Thread t = ate.getThread();
            if (this._logger != null && this._logger.isDebugEnabled()) {
                this._logger.debug(MessageFormat.format(rb.getString("AdminServer.interruptThread.fmt.txt"), t.getName()));
            }
            t.interrupt();
        }
    }

    public static Locale getClientLocale(BufferedReader reader) {
        Locale locale;
        try {
            String language = reader.readLine();
            String country = reader.readLine();
            locale = new Locale(language, country);
        }
        catch (IOException ioe) {
            locale = Locale.getDefault();
        }
        return locale;
    }
}

