/*
 * Decompiled with CFR 0.152.
 */
package com.sas.services.events.broker;

import com.sas.codepolicy.SASScope;
import com.sas.net.rmi.ActivatableExporter;
import com.sas.net.rmi.RemoteObjectExporterInterface;
import com.sas.net.ssl.SSLRMISocketFactories;
import com.sas.services.AbstractRemoteService;
import com.sas.services.ServiceConfigurationInterface;
import com.sas.services.ServiceException;
import com.sas.services.discovery.DiscoveryService;
import com.sas.services.discovery.DiscoveryServiceInterface;
import com.sas.services.events.broker.EventBrokerService;
import com.sas.services.events.broker.EventBrokerServiceInterface;
import com.sas.services.events.broker.EventResponseHandlerInterface;
import com.sas.services.events.broker.InvalidEventTypeException;
import com.sas.services.events.broker.ListenerInterface;
import com.sas.services.events.broker.RB;
import java.rmi.MarshalledObject;
import java.rmi.Remote;
import java.rmi.RemoteException;
import java.rmi.activation.ActivationID;
import java.util.ResourceBundle;

@SASScope
public class ActivatableEventBrokerService
extends AbstractRemoteService
implements EventBrokerServiceInterface {
    private EventBrokerService _eventBrokerService = null;
    private static final String RB_KEY = "ActivatableEventBrokerService.";
    private static ResourceBundle rb = RB.getResources();

    public ActivatableEventBrokerService(ActivationID id, MarshalledObject data) {
        super((DiscoveryServiceInterface)DiscoveryService.defaultInstance());
        try {
            this.setEventBrokerService(id, data);
        }
        catch (ServiceException e) {
            return;
        }
    }

    private void setEventBrokerService(ActivationID id, MarshalledObject data) throws ServiceException {
        try {
            Object object;
            if (data != null && (object = data.get()) instanceof ServiceConfigurationInterface) {
                ServiceConfigurationInterface serviceConfiguration = (ServiceConfigurationInterface)object;
                this._eventBrokerService = new EventBrokerService(serviceConfiguration);
                SSLRMISocketFactories sslRMISocketFactories = SSLRMISocketFactories.getInstance();
                Class<?> theClass = this.getClass();
                this.setRemoteableExporter((RemoteObjectExporterInterface)new ActivatableExporter((Remote)this, 0, sslRMISocketFactories.getRMIClientSocketFactoryForClass(theClass), sslRMISocketFactories.getRMIServerSocketFactoryForClass(theClass), true, id));
                this.configure(serviceConfiguration);
            }
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
        if (this._eventBrokerService == null) {
            System.out.println(rb.getString("ActivatableEventBrokerService.noActivate.txt"));
            throw new ServiceException();
        }
    }

    public void configure(ServiceConfigurationInterface serviceConfiguration) throws RemoteException, ServiceException {
        super.configure(serviceConfiguration);
    }

    public void destroy() throws ServiceException, RemoteException {
        super.destroy();
        this._eventBrokerService.destroy();
    }

    @Override
    public String getHost() throws RemoteException {
        return this._eventBrokerService.getHost();
    }

    @Override
    public String getDescription() throws RemoteException {
        return this._eventBrokerService.getDescription();
    }

    @Override
    public String getConfiguration() throws RemoteException {
        return this._eventBrokerService.getConfiguration();
    }

    @Override
    public boolean canProcess(String eventName, int eventType) throws RemoteException {
        return this._eventBrokerService.canProcess(eventName, eventType);
    }

    @Override
    public String sendSyncEvent(String event) throws RemoteException {
        return this._eventBrokerService.sendSyncEvent(event);
    }

    @Override
    public void sendAsyncEvent(String event, EventResponseHandlerInterface responseHandler) throws RemoteException {
        this._eventBrokerService.sendAsyncEvent(event, responseHandler);
    }

    @Override
    public void addEventListener(String eventName, int eventType, ListenerInterface listener) throws RemoteException, InvalidEventTypeException {
        this._eventBrokerService.addEventListener(eventName, eventType, listener);
    }

    @Override
    public boolean removeEventListener(String eventName, int eventType, ListenerInterface listener) throws RemoteException {
        return this._eventBrokerService.removeEventListener(eventName, eventType, listener);
    }
}

